#include "memSlob.h"
#include <stdexcept>

#define DEBUG(A,B) cout << A << ": " << B << endl;

using namespace std;
using namespace stu;

node::node(){
	len=0;
	objectType=-5;
/*	isBase=false;
	isRef=false;*/
	parent=NULL;
	next=NULL;
	prev=NULL;
	data=NULL;
	isHead=false;
}

node::~node(){

/*	cerr << "Will destroy a node..." << endl;*/
	//at the deletion of previous is when this destructor is called
//	cout << "Deleting node..." << endl;
/*	if (next!=NULL) delete next;*/
	if (data!=NULL){ 
		if (objectType==COLLECTION_LEVEL) delete (node*)data;
		if (objectType==BASE_LEVEL) delete (unsigned char*)data;
		if (objectType==OBJECT_LEVEL){ //then its a whole mslob
			stuVector<node*> *structs=(stuVector<node*>*)data;
			for (uint i; i<structs->length(); i++)
				if ((*structs)[i]!=NULL) delete (*structs)[i];
		}
		//do not delete data if isRef...
	}
/*	cerr << "Destroyed!!!!" << endl;*/
}

//default constructor to an empty memSlob
memSlob::memSlob():root(new node()),elements(0),myslob(NULL){
	
// 	stuVector<node*> *structs=new stuVector<node*>(1);
// 	(*structs)[0]=new node();
// 	(*structs)[0]->len=0; 
// 	(*structs)[0]->objectType=0; 
// 	(*structs)[0]->isBase=false; 
// 	(*structs)[0]->isRef=false; 
// 	(*structs)[0]->next=NULL; 
// 	(*structs)[0]->prev=NULL; 
// 	(*structs)[0]->data=NULL;
// 	(*structs)[0]->isHead=true; 
	
	root->len=0; //no children
	root->objectType=COLLECTION_LEVEL;
	root->next=NULL;
	root->prev=NULL;
	root->parent=NULL;
	root->data=NULL;
	root->isHead=false;
	
// 	mslobs->next->len=1; //for its primary structure that was created automatically
// 	mslobs->next->objectType=OBJECT_LEVEL;
// 	mslobs->next->isBase=false;
// 	mslobs->next->isRef=false;
// 	mslobs->next->next=NULL;
// 	mslobs->next->prev=NULL;
// 	mslobs->next->data=(void*)structs;
// 	mslobs->next->isHead=false;
// 	mslobs->next->parent=NULL;
// 	(*structs)[0]->parent=mslobs->next;
	
	// global=new Locator(root,COLLECTION_LEVEL,myslob,NULL);
}

memSlob::memSlob(mSlob *ms):root(new node()),elements(0),myslob(ms){
	
// 	stuVector<node*> *structs=new stuVector<node*>(1);
// 	(*structs)[0]=new node();
// 	(*structs)[0]->len=0; 
// 	(*structs)[0]->objectType=0; 
// 	(*structs)[0]->isBase=false; 
// 	(*structs)[0]->isRef=false; 
// 	(*structs)[0]->next=NULL; 
// 	(*structs)[0]->prev=NULL; 
// 	(*structs)[0]->data=NULL;
// 	(*structs)[0]->isHead=true; 
// 	
// 	mslobs->len=1; //number of mslobs without counting this one
// 	mslobs->objectType=COLLECTION_LEVEL;
// 	mslobs->isBase=false;
// 	mslobs->isRef=false;
// 	mslobs->next=new node();
// 	mslobs->prev=NULL;
// 	mslobs->data=NULL;
// 	mslobs->isHead=true;
// 	mslobs->parent=NULL;
// 
// 	mslobs->next->len=1; //for its primary structure that was created automatically
// 	mslobs->next->objectType=OBJECT_LEVEL;
// 	mslobs->next->isBase=false;
// 	mslobs->next->isRef=false;
// 	mslobs->next->next=NULL;
// 	mslobs->next->prev=NULL;
// 	mslobs->next->data=(void*)structs;
// 	mslobs->next->isHead=false;
// 	mslobs->next->parent=NULL;
// 	(*structs)[0]->parent=mslobs->next;

	root->len=0; //no children
	root->objectType=COLLECTION_LEVEL;
	root->parent=NULL;
	root->next=NULL;
	root->prev=NULL;
	root->data=NULL;
	root->isHead=false;
	
	//global=new Locator(root,COLLECTION_LEVEL,myslob,NULL);
}

//copy constructor
memSlob::memSlob(const memSlob& s)
{
	//create a copy of a memSlob
}

//default destructor
memSlob::~memSlob()
{
/*	cerr << "will destroy memSlob ********************************************************" << endl;*/
	node* temp=(node*)root->data; //at least one level under the root with COLLECTION or OBJECT
	while (temp!=NULL){
		node* temp2=temp;
		temp=temp->next;
		delete temp2;
	}		
	delete root;
/*	cerr << "Deleted memSlob ---------------------------------------------------------------" << endl;*/
}
/*
Locator memSlob::locateGlobal() 
{
	return *global;
}*/



/*
locatePrivate is used to locate subobjects no matter the struct (primary or secondary).
If the resulting object is the base in a secondary, an extra call makes sure that the actual object locator it points to is returned
*/
Locator memSlob::locateRef(const Locator& loc, uint idx) //locates object from loc level
{
	//check index range
	if( idx < 0 || idx >= loc.getElements() ){
		throw runtime_error("Invalid index, error at locatePRIVATE memslob.");
	}
	
	if (loc.getObjectType()== OBJECT_LEVEL){ //then locatemSlob
		stuVector<node*>* structs=(stuVector<node*>*)loc.getmemLoc()->data;
		return Locator((*structs)[idx],idx,myslob,const_cast<Locator*>(&loc));
	}
	//construct and return locator for result
	node* temp=(node*)(loc.getmemLoc()->data);
	
	//special case of struct heads and global head
	if (temp->isHead){
		temp=temp->next;
	}
	
	for (uint i=0; i<idx; i++) temp=temp->next;
	
	//now standing at correct node, build locator
	return Locator(temp,temp->objectType,myslob,const_cast<Locator*>(&loc));
	
}

Locator memSlob::DeReference(const Locator& loc){
	if (loc.getObjectType()==REFERENCE_LEVEL){
		node* result=(node*)loc.getmemLoc()->data;
		Locator dataLoc(result,result->objectType,myslob,const_cast<Locator*>(&loc));		
		return dataLoc; //return locator to "real" data in primary struct
	}else
		return  loc; //non-base object or base object through primary structure
}

//public locate, given a locator (object or struct), it generates a locator for its idx^th subobject
Locator memSlob::locate(const Locator& loc, uint idx) {
	
	//call private locate
	Locator temp(loc.locateRef(idx));

	return temp.DeReference();
}

imSlobstream memSlob::getStream(Locator& l){
	if (l.getObjectType( ) == COLLECTION_LEVEL || l.getObjectType( ) == OBJECT_LEVEL || l.getObjectType( ) == REFERENCE_LEVEL)
		throw runtime_error("Cannot read stream of global or mSlob locator");
	else
		return imSlobstream(myslob,l);	
}

//method for inserting base objects only. required insertion in primary structure
Locator memSlob::insert(unsigned char data[], uint size, Locator& loc, uint idx) //insert object at position idx of object loc	
{
	//cout << "Inserting into MemLoc, data with size: " << size << endl;
	node* newbase=new node();
	newbase->len=size; 
	newbase->objectType=BASE_LEVEL;
	newbase->next=NULL; 
	newbase->prev=NULL; 
	newbase->data=new unsigned char[size];
	memcpy(newbase->data,data,size);
	//newbase->data=(void*)data;	
	newbase->parent=NULL;
	
	node* temp=NULL;
	node *head=NULL;
	
	temp=(node*)(loc.getmemLoc()->data);
	if (temp==NULL) //first ever insertion
		loc.getmemLoc()->data=(void*)newbase;
	else{
		if (temp->isHead){ //heads only come as first elements of object directly under structure vector
			head=temp;
			temp=temp->next;
		}
		
		if (idx==0){ //insert as first element
			newbase->next=temp;
			newbase->prev=temp->prev;
			if (newbase->prev!=NULL) newbase->prev->next=newbase;
			temp->prev=newbase;	
			loc.getmemLoc()->data=(void*)newbase;
		}else{
			//move to stop previous to insertion
			for (uint i=0; i<(idx-1); i++) temp=temp->next;
			newbase->prev=temp;
			newbase->next=temp->next;
			temp->next=newbase;
			if (newbase->next!=NULL) newbase->next->prev=newbase;
		}
	}
	
	//create Locator object to be returned. 
	Locator returner(newbase,BASE_LEVEL,myslob,&loc);		
		
	//update parent's count
	//loc.setElements(loc.getElements()+1);	
/*	loc.getmemLoc()->len++;*/
	
	return returner;
}

//insert empty object into position idx of loc. non-base object inserter
Locator memSlob::insert(Locator& loc, uint idx, int oType) 
{
	node* newbase;
/*	cout << "Inserting into: "; loc.debug();*/
	if (oType==COLLECTION_LEVEL){ //then we are adding a new collection level
		if (loc.getObjectType()!=COLLECTION_LEVEL)
			throw runtime_error("Invalid objectType of Locator: New collections can only be added to collection levels. ");
		newbase=new node();
		newbase->len=0; 
		newbase->objectType=COLLECTION_LEVEL; 
		newbase->next=NULL; 
		newbase->prev=NULL; 
		newbase->data=NULL;	
		newbase->isHead=false;
		newbase->parent=NULL;
		//node will be inserted later
		
	}else if (oType==OBJECT_LEVEL){ //then we are adding a new mslob
		//cerr << "In here: "; loc.debug();
		if (loc.getObjectType()!=COLLECTION_LEVEL)
			throw runtime_error("Invalid objectType of Locator: Objects can only be added to collection levels. ");
/*		stuVector<node*> *structs=new stuVector<node*>(1);
		(*structs)[0]=new node();
		(*structs)[0]->len=0; 
		(*structs)[0]->objectType=0; 
		(*structs)[0]->next=NULL; 
		(*structs)[0]->prev=NULL; 
		(*structs)[0]->data=NULL;
		(*structs)[0]->isHead=true; */
		
		newbase=new node();
		newbase->len=0; 
		newbase->objectType=OBJECT_LEVEL; 
		newbase->next=NULL; 
		newbase->prev=NULL; 
		newbase->data=NULL;	
		/*		newbase->data=(void*)structs;	*/
		newbase->isHead=false;
		newbase->parent=NULL;
/*		(*structs)[0]->parent=newbase;*/
		
	}else if (oType==NONE_LEVEL){ //then we are adding a new struct: idx, or a normal subobject (under some struct)
		if (loc.getObjectType()==OBJECT_LEVEL){
			if (idx==0 && loc.getElements()>0)
				throw runtime_error("Cannot add primary structure to object already containing one.");
			
/*			cout << "Adding struct, the biatch has this number of elements: " << loc.getElements() << endl;*/
			stuVector<node*>* structs;
			if (loc.getElements()==0){ //then create vector
				structs=new stuVector<node*>(1);
				loc.getmemLoc()->data=structs;
			}
			else{ //vector already there, retrieve
				structs=(stuVector<node*>*)loc.getmemLoc()->data;
				uint newlen=structs->length();
				structs->resize(newlen+1);
				for (uint i=newlen; i>idx; i--)
					(*structs)[i]=(*structs)[i-1];
			}
			
			(*structs)[idx]=new node();
			(*structs)[idx]->len=0; 
			(*structs)[idx]->objectType=idx; 
			(*structs)[idx]->next=NULL; 
			(*structs)[idx]->prev=NULL; 
			(*structs)[idx]->data=NULL;	
			(*structs)[idx]->isHead=true;
			(*structs)[idx]->parent=loc.getmemLoc();
					
			loc.getmemLoc()->data=structs;
			stuVector<node*>* structs2;
			structs2=(stuVector<node*>*)loc.getmemLoc()->data;
// 			cout << "The one stored has this number of children: " << structs2->length() << endl;
			
			//loc.setElements(loc.getElements()+1);
			return Locator((*structs)[idx],idx,myslob,&loc);
		}else{ //then we are adding a normal subobject
			newbase=new node();
			newbase->len=0; 
			newbase->objectType=loc.getObjectType(); 
			newbase->next=NULL; 
			newbase->prev=NULL; 
			newbase->data=NULL;	
			newbase->isHead=false;
			newbase->parent=NULL;
			//item will be inserted later
		}
	}	
	
	node *temp=NULL;
	node *head=NULL;
	
/*	if (loc.getObjectType()==COLLECTION_LEVEL){ //then we are adding a new mslob
		structid=OBJECT_LEVEL;
		temp=(node*)(loc.getmemLoc()->next); //skip the global head, there is always another node for sure
		for (uint i=0; i<idx; i++) temp=temp->next;
		newbase->next=temp;
		newbase->prev=temp->prev;
		if (newbase->prev!=NULL) newbase->prev->next=newbase;
		if (temp!=NULL) temp->prev=newbase;
	}
	else{ */
		//inserting normal data
		temp=(node*)(loc.getmemLoc()->data);
		if (temp==NULL){ //first ever insertion
			loc.getmemLoc()->data=(void*)newbase;
 			//cout << "First ever insertion" << endl;
		}
		else{
			if (temp->isHead){
				head=temp;
				temp=temp->next;
// 				cout << "Its a head!" << endl;
			}
			
			if (idx==0){ //insert as first element
				newbase->next=temp;
				newbase->prev=temp->prev;
				if (temp->prev!=NULL)
					newbase->prev->next=newbase;
				temp->prev=newbase;	
				loc.getmemLoc()->data=(void*)newbase;
				//cerr << "Inserted in idx 0" << endl;
			}else{
				//move to stop previous to insertion
				for (uint i=0; i<(idx-1); i++) temp=temp->next;
				newbase->prev=temp;
				newbase->next=temp->next;
				temp->next=newbase;
				if (newbase->next!=NULL) newbase->next->prev=newbase;
				//cerr << "Inserted somewhere at " << idx << endl;
			}
		}
		newbase->parent=loc.getmemLoc();
		
//	}
	//create Locator object to be returned.
	Locator returner(newbase,newbase->objectType,myslob,&loc);
						
	//update parent's count
	//loc.setElements(loc.getElements()+1);
/*	loc.getmemLoc()->len++;*/
	
	return returner;
}
	
Locator memSlob::insert(const Locator& loc1, Locator& loc2, uint idx) //insert object in loc1 into spot idx of loc2, returns loc1
{
	
	if (loc2.getObjectType()<1){ 
		throw runtime_error("Cannot add references in non secondary locators.");
	}
	
	node* newbase=new node();
	newbase->len=0;
	newbase->objectType=REFERENCE_LEVEL; 
	newbase->next=NULL; 
	newbase->prev=NULL; 
	newbase->data=loc1.getmemLoc();	
	newbase->parent=NULL;
	
	node* temp=NULL;
	node *head=NULL;
	
	temp=(node*)(loc2.getmemLoc()->data);
	if (temp==NULL){ //first ever insertion
		loc2.getmemLoc()->data=(void*)newbase;
// 		cout << "Temp is null" << endl;
	}
	else{
		if (temp->isHead){
			head=temp;
			temp=temp->next;
// 			cout << "Inserting, skipped head" << endl;
		}
		
		if (idx==0){ //insert as first element
			newbase->next=temp;
			newbase->prev=temp->prev;
			if (newbase->prev!=NULL) newbase->prev->next=newbase;
			temp->prev=newbase;	
			loc2.getmemLoc()->data=(void*)newbase;
// 			cout << "Inserted first element" << endl;
		}else{
			//move to spot previous to insertion
			uint i=0;
			for (i=0; i<(idx-1); i++) temp=temp->next;
			newbase->prev=temp;
			newbase->next=temp->next;
			temp->next=newbase;
			if (newbase->next!=NULL) newbase->next->prev=newbase;
// 			cout << "Inserted as element " << i+1 << endl;
		}
	}
		
		
	//create Locator object to be returned. 
	Locator returner(newbase,REFERENCE_LEVEL,myslob,&loc2);		
		
// 	cout << "This locator: "; returner.debug();
// 	cout << "References: "; loc1.debug();
				
	//update parent's count
	//loc2.setElements(loc2.getElements()+1);	
/*	loc2.getmemLoc()->len++;*/
	
	return returner;
}

bool memSlob::strongRemove(Locator& loc, uint idx)
{
	if (loc.getObjectType()>0){
		throw runtime_error("Cannot strong remove objects from secondary structures.");
	}
	//locate object to remove...
	Locator temp(loc.locateRef(idx));
	
/*	cout << "Object to remove: "; temp.debug();*/
	
	//first remove all of temp's children, this also should remove any references to these children
	while (temp.getElements()>0)
		if (!temp.remove(0))
			return false;
	
	//now remove all references to temp, if temp is in primary struct
	if (loc.getObjectType()==0 || loc.getParent().getObjectType()==0){ //then its primary structure
		
		Locator dad(loc.getParent());
		while (dad.getObjectType()!=OBJECT_LEVEL){
			dad=dad.getParent();
			if (dad.isEmpty()) 
				throw runtime_error("Reached the root, should not have.");
		}
		
		stuVector<node*> *structs=(stuVector<node*>*)dad.getmemLoc()->data;
// 		cout << "The dad has " << structs->length() << " structs. " << endl;
// 		cout << "The dad:"; dad.debug();
// 		Locator caca1(dad.locate(0));
// 		Locator caca2(dad.locate(1));
// 		Locator caca21(caca2.locate(0));
// 		cout << "Caca1:"; caca1.debug();
// 		cout << "Caca2:"; caca2.debug();
// 		cout << "Caca21:"; caca21.debug();
		
		for (uint i=1; i<structs->length(); i++){ //skip primary struct
// 			if ((*structs)[i]->isHead)
// 				cout <<"Head of struct" << endl;
// 			else
// 				cout <<"NOT the Head of struct" << endl;
			Locator nstrct(dad.locateRef(i));
			removeReferences(temp,nstrct);
			//uint rmvd=removeReferences(temp.getmemLoc(),(static_cast<node*>((*structs)[i]->data))); //node in struct is always head, skip
		}
	}
	
	//done. now remove the actual element located by temp
	if (loc.getObjectType()==OBJECT_LEVEL){ //then we are removing a struct
 		stuVector<node*> *structs=(stuVector<node*>*)loc.getmemLoc()->data;
 		if (idx==0){ //then removing primary struct, so remove all structs
// 			for (uint i=0; i<loc.getElements(); i++){
// 				delete (*structs)[i];
// 				(*structs)[i]=NULL;
// 			}
// 			//delete struct vector
// 			delete structs;
// 			structs=NULL;
// 			loc.getmemLoc()->len=0;
// 			loc.getmemLoc()->data=NULL;
// 			loc.setElements(0);
			for (uint i=loc.count()-1; i>0; i-- )
				loc.remove(i); //remove each secondary
			
			loc.getmemLoc()->data=NULL;
			delete structs;
			structs=NULL;
		}else{ //removing single secondary struct
			delete (*structs)[idx];	
			for (uint i=idx; i<loc.getElements()-1; i++)
				(*structs)[i]=(*structs)[i+1];
			structs->resize(structs->length()-1);
		}
	}else{
		if ((node*)loc.getmemLoc()->data==temp.getmemLoc()) //then its first object
			loc.getmemLoc()->data=(void*)temp.getmemLoc()->next;
		else
			temp.getmemLoc()->prev->next=temp.getmemLoc()->next;
		
		if (temp.getmemLoc()->next!=NULL)
			temp.getmemLoc()->next->prev=temp.getmemLoc()->prev;
		
/*		if (temp.getIsBase())
			delete (unsigned char*)temp.getmemLoc()->data;*/
		
		delete temp.getmemLoc();
		
		//loc.setElements(loc.getElements()-1);
	}
	return true;
}

//remove all references to p in lst
void memSlob::removeReferences(Locator p, Locator lst){
// 	if (lst==NULL){
// 		cout << "LST is NULL!" << endl;
// 	}else
// 		cout << "LST is NOT NULL!" << endl;
// 		
	if (lst.getObjectType()>0){ //non-bottom object in secondary struct
		for(uint i=0; i<lst.count(); i++) {
			Locator child(lst.locateRef(i));	
			if (child.getObjectType()==REFERENCE_LEVEL){
				if (static_cast<node*>(child.getmemLoc()->data)==p.getmemLoc()){//then remove
					if (!lst.remove(i))
						throw runtime_error("Error with required removal of dangling reference.");
/*					else
						cout << "Removed a reference!" << endl;*/
				}
			}
			else
				removeReferences(p,child); //recursively go into children
		}
	}
/*	else{
		cout << "The locator I got: "; lst.debug();
		throw runtime_error("Expecting a secondary sequence for removal of references.");
	}*/
}


bool memSlob::weakRemove(Locator& loc, uint idx){
	
	if (loc.getObjectType()==0 || loc.getObjectType()==COLLECTION_LEVEL || loc.getObjectType()==OBJECT_LEVEL || (loc.getObjectType()==BASE_LEVEL && loc.getParent().getObjectType()==0)){
		//cout << "Remove error: weakRemoves can be performed only on objects in secondary structures. To remove objects from primary structure use strongRemove." << endl;
		return false;
	}
		
	//call private locate	
	Locator temp(loc.locateRef(idx));
	
/*	cout << "Will weakly remove: "; temp.debug();*/
	
	//first remove all of temp's children
	while (temp.getElements()>0)
		if (!temp.remove(0))
			return false;
	
	//done now remove the actual element located by temp
	if ((node*)loc.getmemLoc()->data==temp.getmemLoc()) //then its first object
		loc.getmemLoc()->data=(void*)temp.getmemLoc()->next;
	else
		temp.getmemLoc()->prev->next=temp.getmemLoc()->next;
	
	if (temp.getmemLoc()->next!=NULL)
		temp.getmemLoc()->next->prev=temp.getmemLoc()->prev;
	
	delete temp.getmemLoc();
	temp.setmemLoc(NULL);
	
	//loc.setElements(loc.getElements()-1);
	
	return true;
}

Locator memSlob::append(unsigned char data[], uint size, Locator& loc)
{
	return insert(data,size,loc,loc.getElements());
}

void memSlob::resequence()
{
	return;
}

uint memSlob::recLength(node* p) const{
	if (p==NULL)
		return 0;
	else if (p->objectType==BASE_LEVEL)//base
		return (p->len);
	else//nonbase 
		return (recLength((node*)p->data)+recLength(p->next));
}

uint memSlob::length(const Locator& loc)
{
	return recLength(loc.getmemLoc());
}

uint memSlob::count(const Locator& loc) //number of subobjects of loc
{
	return loc.getElements();
}

uint  memSlob::fragmentation() //gives the percentage of fragmentation in the memSlob. A fully sequenced memSlob should return 0
{
	return 0; //inmem mSlobs do not fragment
}

bool memSlob::beginBatch(){
	return true;
}

bool memSlob::commitBatch(){
	return true;
}
