#ifndef IMSLOBSTREAM_H
#define IMSLOBSTREAM_H

#include <iostream>
#include <oci.h>

#include "Locator.h"
#include "mSlob.h"

using namespace std;
//using namespace oracle::occi;

/** Implementation class for Oracle mSLOB stream reader.
	the stream allows streaming read access to 
	\author Mark McKenney
	\date 2006-02-28
	\version 0.1
	\date 2006-10-02
	\version 0.2 AP - Changes to allow Locator to call its own reader (make currObj a pointer)
*/

const uint DUMMY_SIZE=4;
class Locator;
class mSlob;
struct OCILobWrapper;
//class memSlob;

class imSlobstream
{
	private:
		mSlob* S;
		OCILobWrapper* BLB;
		Locator* currObj;
		//Locator currSubObj;
		uint currObjPos;
		uint currObjIndex;
		const static Locator ZeroLocator;
		void get( unsigned char* const c, const uint size, uint & numBytesRead, const Locator& loc, uint & currObjToRead );
	
	public:
	
		
		imSlobstream( );
		imSlobstream( mSlob * );
		imSlobstream( mSlob * ss, Locator & loc );
		// opens mSlob for reading at locator loc
		imSlobstream( mSlob * ss,  Locator & loc, uint index );
		// opens mSlob for reading at locator loc and positions the read head at the indexth object
		
		~imSlobstream( );
		
		imSlobstream& open( mSlob * ss );
 		imSlobstream& open( mSlob * ss, Locator & loc);
		// open an istream on a mSlob
		// opens for reading at locator loc
		void close( );
		
		
		imSlobstream& get( unsigned char* const c, const  uint size, uint & numBytesRead );
		// extracts a single object from the stream and returns it in the character array.
		// size bytes are read unless EOO is reached.  numBytesRead is set as the number
		// of bytes acutally read into the character array
		// if get is called on a stream that is at the end of its current object, no bytes
		// will be read
		// EndOfObj will be true if the end of the object was encountered
		
		imSlobstream& read( unsigned char* const c, const  uint size, uint & numBytesRead);
		// alias for get
		
		imSlobstream& ignoreObject( uint i );
		// skip over the next i objects in the stream
		
		imSlobstream& ignore( uint i );
		// skip over the next i bytes in the stream
		
		imSlobstream& seek( uint i );
		// position the stream at object i
		
		imSlobstream& seek( uint offset, ios_base::seekdir dir );
		// position the stream at offset objects from the 
		// beginning, end, or current read point
		//# ios_base::beg (offset from the beginning of the stream's buffer).
		//# ios_base::cur (offset from the current position in the stream's buffer).
		//# ios_base::end (offset from the end of the stream's buffer).
		
		imSlobstream& peek( unsigned char* const c, const uint size, const uint offset, uint & numBytesRead);
		// get next object without actually extracting from the stream
		// returns EOF if there are no more objects
		// offset indicates how many bytes should be skipped before reading 
		
		
		bool sync( );
		// synchronize the stream with the underlying mSlob
		// returns true if successful, false if at the end of the stream
		
		imSlobstream& operator= ( imSlobstream & );
		
};

#endif

