
#include <oci.h>
#include "imSlobstream.h"

#define DEBUG(A,B) cout << A << ": " << B << endl;

using namespace std;
//using namespace oracle::occi;

const Locator imSlobstream::ZeroLocator = Locator(false);

imSlobstream::imSlobstream( ): S( NULL ), BLB( NULL ), currObj( NULL ), currObjPos( 0 ), currObjIndex( 0 )
{	}

imSlobstream::imSlobstream( mSlob * ss ): S( ss ), currObj(  new Locator(ss->locate(ss->locateGlobal(),0)) )
{
	if (S->mem==NULL) BLB=(OCILobWrapper*)S->store;
	else BLB=NULL;
	currObjPos = 0;
	currObjIndex = 0;
}

imSlobstream::imSlobstream( mSlob * ss, Locator & loc ): S( ss ), currObj( new Locator( loc )  )
{
	//loc.debug();
	if (S->mem==NULL) BLB=(OCILobWrapper*)S->store;
	else BLB=NULL;
	currObjPos = 0;
	currObjIndex = 0;
}

imSlobstream::imSlobstream( mSlob * ss, Locator & loc, uint index ): S( ss ), currObj( new Locator( loc ) )
{
	if (S->mem==NULL) BLB=(OCILobWrapper*)S->store;
	else BLB=NULL;
	currObjPos = 0;
	currObjIndex = index;
}

imSlobstream::~imSlobstream()
{	
	if (currObj!=NULL) 
		delete currObj;
}

imSlobstream& imSlobstream::open( mSlob * ss )
{
	S = ss;
	if (S->mem==NULL) BLB=(OCILobWrapper*)S->store;
	else BLB=NULL;
	if( currObj != NULL )
		delete currObj;
	currObj = new Locator( S->locate(S->locateGlobal(),0) );
	currObjPos = 0;
	return *this;
}

imSlobstream& imSlobstream::open( mSlob * ss, Locator & loc)
{
	S = ss;
	//loc.debug();
	if (S->mem==NULL) BLB=(OCILobWrapper*)S->store;
	else BLB=NULL;
//	currObj = new Locator(S->locate( loc, 0 ));
	if( currObj != NULL )
		delete currObj;
	currObj = new Locator( loc );
	currObjPos = 0;
	return *this;
}

void imSlobstream::close( )
{
	S = NULL;
	currObjPos = 0;
}

imSlobstream& imSlobstream::get( unsigned char* const c, const uint size, uint & numBytesRead )
{
	numBytesRead = 0;
	uint zero=0; //is this intended?
	get( c, size, numBytesRead, *currObj, zero );
	return *this ;
}


void imSlobstream::get( unsigned char* const c, const uint size,  uint & numBytesRead, 
				const Locator & loc, uint & currObjToRead )
{
	if( numBytesRead >= size )
		return;
	
	//cout << " LocCount: " << loc.elements << endl;
	
	// if the object is a base level object, simply copy its data into the buffer
	// of course, make sure there is enough room in the buffer

	//cerr<<"NOTINBASEOBJ.  locator: "<<*(loc.getLocatorNode())<<endl;
	if( loc.getObjectType() == BASE_LEVEL )
	{
		//cerr<<"INBASEOBJ"<<endl;
		//cout << "Found base currObjToRead: " << currObjToRead << " currObjIndex: " << currObjIndex << endl;
		if( currObjToRead < currObjIndex )
		{
			currObjToRead++;
			return;
		}
		
		uint len;	
		uint startReadPos;
		
		// get the length of the object
		len = S->length( loc ) - currObjPos;
		
		//cout << "SLength: " << S->length( loc ) << " currobjpos: " << currObjPos << " Will read: " << len << endl;
		
		// if we left off in the middle of an object, 
		// set the current read position to reflect it
		// otherwise, start at the beginning of the object
		if( currObjPos != 0 )
			startReadPos = currObjPos + loc.getStart() + DUMMY_SIZE;
		else{
			if (loc.getmemLoc()==NULL) startReadPos = loc.getStart() + DUMMY_SIZE;
			else startReadPos=loc.getStart(); //always 0
		}
			
		// return if we are already at the end of the object
		if( len == 0 )
		{
			return;
		}
		// handle the case if we reach the end of the buffer in mid-object
		// or at the end of the object
		if( numBytesRead + len > size)
		{
			currObjIndex = currObjToRead;
			len = size - numBytesRead;
			currObjPos = currObjPos + len;
		}
		else if( numBytesRead + len <= size )
		{
			// this read will read until the end of the object, so 
			// the next read after the one below will be on the next
			// object.  Therefore, we shift the locators and read position
			// to point to the next object
			currObjToRead++;
			currObjIndex = currObjToRead;
			currObjPos = 0;	
		}
		
// 		cout << "Len: " << len << " startreadpos: " << startReadPos << endl;
		
		// read the data from the blob
		//unsigned char data[ len ];
		
//		uint nread=BLB->read( len, data, len, startReadPos );
		if (S->mem==NULL){ //then its a store mSlob
			//uint nread=BLB->read( len, &(c[ numBytesRead ]), len, startReadPos );
/*			uint nread=*/
			S->readData( &(c[ numBytesRead ]), len, startReadPos );
		}
		else{ //loc is working on a memSlob
			memcpy(&(c[ numBytesRead ]),(unsigned char*)loc.getmemLoc()->data+startReadPos, len);
		}
/*		for (uint k=0; k<nread; k++)
			cout << data[k];
		cout << endl;*/
// 		
		// write the data to the new char array
		//memcpy( &(c[ numBytesRead ]), data, len );
		
		// update the number of bytes read
		numBytesRead += len;
		
		//currObjPos += len;
		
		return;
	}
	else// else the object is not a base type, so we recursively find its base objects
	if( loc.getElements() == 0 )	  //if the object is empty, then it has no data, so we can simply return
	{
		return;
	}
	else{
	// if the object is not empty, then recursively read each object
		for( uint i = 0; i < loc.getElements() && numBytesRead < size;  i++ )
		{
			//cout << "WIll Read Index: " << i << " of ";
			//loc.debug();
			Locator currSubObj(loc.locate( i ));
			
			//cout << "ToREAD: ";
			//currSubObj.debug(); 
	
	//		get(c, size, numBytesRead, S->locate( loc, i ), currObjToRead );
			get(c, size, numBytesRead, currSubObj, currObjToRead );
			// if we read the complete object, set the currObjPosition to 0
	// 		if( currObjPos == (S->locate( loc, i )).end )
	// 			currObjPos = 0;
		}
	}
}


imSlobstream& imSlobstream::read( unsigned char* const c, const  uint size, uint & numBytesRead )
{
	numBytesRead = 0;
	get( c, size, numBytesRead );
	return( *this );
}

imSlobstream& imSlobstream::ignoreObject( uint i )
{
	
	return *this;
}

imSlobstream& imSlobstream::ignore( uint i )
{
	
	return *this;
}

imSlobstream& imSlobstream::seek( uint i )
{
	
	return *this;
}

imSlobstream& imSlobstream::seek( uint offset, ios_base::seekdir dir )
{
	
	return *this;
}

imSlobstream& imSlobstream::peek( unsigned char* const c, const uint size, const uint offset, uint & numBytesRead )
{
	
	return *this;
}

bool imSlobstream::sync( )
{
	BLB=(OCILobWrapper*)S->store;
	return true;	
}

imSlobstream& imSlobstream::operator= ( imSlobstream & rhs )
{
	S = rhs.S;
	BLB = rhs.BLB;
	if( currObj != NULL )
		delete currObj;
	currObj = new Locator( *rhs.currObj );
	currObjPos = rhs.currObjPos;
	currObjIndex = rhs.currObjIndex;
	return *this;
}
