#include "SequenceIndex.h"
#include <iostream>	
#include <stdexcept>
		
#define DEBUG(A,B) cout << A << ": " << B << endl;

SequenceIndex::SequenceIndex()
{
	ranges=NULL;
	length=0;
}
		
/*constructor to build a seqidx object loaded from a sequence of bytes
	structured as an array where even index values are start of range and
	odd index values are end of range
-size refers to the length of data (in bytes|unsigned char), so actual number of range indicators= size/offset_size
*/
SequenceIndex::SequenceIndex(unsigned char *data, uint size)
{
	//uint temp=*((uint*)data);
	ranges=new uint[(size/ADDRESS_SIZE)];
	memcpy((unsigned char*)ranges,data,size);
	length=size/ADDRESS_SIZE;	
}

//get the logical address offset bytes from the end of the sequence
uint SequenceIndex::logicalFromBack(uint offset)
{
	//offset should never be 0, needs to move something!
	
	uint left=offset;
	uint loc=length-1;
	while (loc>0)
	{
		if ((ranges[loc]-(left-1))<ranges[loc-1])
		{
			left-=((ranges[loc]-ranges[loc-1])+1);
			loc-=2;
		}else
		{	
			return (ranges[loc]-(left-1)); 
		}

	}
	
	return 0; //should throw error, offset>data size
}

//get the logical address offset bytes from the end of the sequence
uint SequenceIndex::logicalFromFront(uint offset)
{
	//offset can be 0, it would mean the first byte
	
	uint left=offset;
	uint loc=0;
	while (loc<length)
	{
		if ((ranges[loc]+left)<=ranges[loc+1])
		{
			return (ranges[loc]+left); 
		}else
		{	
			left-=((ranges[loc+1]-ranges[loc])+1);
			loc+=2;
		}

	}
	
	return 0; //should throw error, offset>data size
}

//return the physical address of the byte (logically) located offset bytes after phaddr
uint SequenceIndex::logicalAdd(uint phaddr, uint offset)
{
	uint left=offset;
	uint loc=0;
	
	//cout << "phaddr: " << phaddr << " offset: " << offset << endl;

	//first find phaddr
	for (loc=0; loc<length; loc+=2)
		if (ranges[loc]<=phaddr && ranges[loc+1]>=phaddr)
			break;

	//cout << "RANGES LOC: " << ranges[loc] << endl;
	//now offset from there
	while (loc<length)
	{
		if ((phaddr+left)>ranges[loc+1])
		{
			left-=((ranges[loc+1]-phaddr)+1);
			loc+=2;
			phaddr=ranges[loc];
		}else
		{	
			return (phaddr+left); 
		}

	}
	throw runtime_error("Error en logicalAdd!");
	return 0; //should throw error, offset>data size	
}

//return the physical address of the byte (logically) located offset bytes before phaddr
uint SequenceIndex::logicalSubtract(uint phaddr, uint offset)
{
// 	int left=static_cast<int>(offset);
// 	uint loc=0;
// 	
// 	//cout << "phaddr: " << phaddr << " offset: " << offset << endl;
// 
// 	//first find phaddr
// 	for (loc=0; loc<length; loc+=2)
// 		if (ranges[loc]<=phaddr && ranges[loc+1]>=phaddr)
// 			break;
// 
// 	cout << "RANGES LOC: " << ranges[loc] << endl;
// 	//now offset from there
// 	while (loc>=0)
// 	{
// 		if (phaddr==ranges[loc])
// 		{
// 			if (left>0) left--;
// 			loc-=2;
// 			phaddr=ranges[loc+1];
// 		}else if ((phaddr-left)<ranges[loc])
// 		{
// 			left-=((phaddr-ranges[loc])-1);
// 			loc-=2;
// 			phaddr=ranges[loc+1];
// 		}else
// 		{	
// 			return (phaddr-left); 
// 		}
// 
// 	}
// 	throw runtime_error("Error en substractAdd!");
	return 0; //should throw error, offset>data size	
}

/*return physical address of "next" byte. 
	given seqidx ranges [a-b[, [c-d[:
	nextPhysical(a) = a
	nextPhysical(b) = c
	nextPhysical(x) = x, where x somewhere in the a-b or c-d range 
*/
uint SequenceIndex::nextPhysical(uint ph)
{
	return ph;
	
	for (uint i=0; i<length; i+=2)
	{
		if (ph>=ranges[i] && ph<ranges[i+1]) //a or x
			return ph;
	}

	for (uint i=0; i<length; i+=2)
	{
		if (ph==ranges[i+1]) //b
			if (i<length-2)
				return ranges[i+2];
	}

	return 0; //should throw error
}

/*return physical address of "previous" byte. 
	given seqidx ranges [a-b[, [c-d[:
prevPhysical(b) = b
prevPhysical(c) = b
prevPhysical(x) = x-1, where x somewhere in the a-b or c-d range 
*/
uint SequenceIndex::prevPhysical(uint ph)
{
	return ph;
	
	for (uint i=0; i<length; i+=2)
	{
		if (ph==ranges[i+1]) //b
			return ph;
	}

	for (uint i=0; i<length; i+=2)
	{
		if (ph==ranges[i]) //c
			if (i>0) return ranges[i-1];
	}
	
	for (uint i=0; i<length; i+=2)
	{
		if (ph>ranges[i] && ph<ranges[i+1]) //x
			return ph-1;
	}

	return 0; //should throw error
}
	
//insert at logstart, size number of bytes actually stored at phstart
bool SequenceIndex::insert(uint logstart, uint phstart, uint size)
{
	if (length==0) //first anything
	{		
		ranges=new uint[2];
		ranges[0]=logstart;
		ranges[1]=phstart+size-1;
		length=2;
		return true;
	}
	
	//cout << "Inserting: " << logstart << " ph: " << phstart << " size: " << size << endl;
	
	//find logstart which is actually a physical address, then split there and put the new piece in between
	for (uint i=0; i<length; i+=2)
	{
		if (ranges[i]<logstart && ranges[i+1]>logstart) //then its within range, cut!	
		{
			//new seqidx will have two more pairs (one is split into three), instantiate
			uint* newone = new uint[length+4];
			//memcpy(newone,ranges,(i+1)*ADDRESS_SIZE); //copy first half
			for (uint k=0; k<=i; k++)
				newone[k]=ranges[k];
			newone[i+1]=logstart-1; //change end of first half range
			newone[i+2]=phstart; //start of new set
			newone[i+3]=phstart+size-1; //end of new set
			newone[i+4]=logstart; //place where cut
			//memcpy(newone + (ADDRESS_SIZE * (i+5)),ranges + (ADDRESS_SIZE * (i+1)),(length-(i+1))*ADDRESS_SIZE); //copy second half
			for (uint k=i+1; k<length; k++)
				newone[k+4]=ranges[k];
			delete ranges;						
			ranges=newone;
			length+=4;
			return true;
		}
		else if (ranges[i]==logstart) //then its at the beginning of a range, put ahead
		{
			//new seqidx will have one more pair, instantiate
			uint* newone = new uint[length+2];
			//memcpy(newone,ranges,(i)*ADDRESS_SIZE); //copy first half
			for (uint k=0; k<i; k++)
				newone[k]=ranges[k];
			newone[i]=phstart; //start of new set
			newone[i+1]=phstart+size-1; //end of new set
			//memcpy(newone + ADDRESS_SIZE * (i+3),ranges + ADDRESS_SIZE * (i),(length-i)*ADDRESS_SIZE); //copy second half
			for (uint k=i; k<length; k++)
				newone[k+2]=ranges[k];
			delete ranges;						
			ranges=newone;
			length+=2;
			return true;			
		}
	}
	for (uint i=0; i<length; i+=2)
	{
		if (ranges[i+1]==logstart) //then its at the end of a range, put after
		{
			//new seqidx will have one more pair, instantiate
			uint* newone = new uint[length+2];
			//memcpy(newone,ranges,(i+2)*ADDRESS_SIZE); //copy first half
			for (uint k=0; k<i+2; k++)
				newone[k]=ranges[k];
			newone[i+2]=phstart; //start of new set
			newone[i+3]=phstart+size-1; //end of new set
			for (uint k=i+2; k<length; k++)
				newone[k+2]=ranges[k];
			delete ranges;						
			ranges=newone;
			length+=2;
			return true;			
		}
	}		
	//never found, error?
	return false;
}

//append size number of bytes actually stored at phstart
bool SequenceIndex::append(uint phstart, uint size)
{
		//new seqidx will have one more pair, instantiate
		uint* newone = new uint[length+2];
		memcpy(newone,ranges,length); //copy current
		newone[length]=phstart; //start of new set
		newone[length+1]=phstart+size-1; //end of new set
		delete ranges;						
		ranges=newone;
		length+=2;
		return true;					
}

//remove size number of bytes start at phstart, go logically
bool SequenceIndex::remove(uint phstart, uint size)
{
	//cout << "Remove: " << phstart << " NEXT: " << nextPhysical(phstart) << " SIZE: " << size << endl;
	phstart=nextPhysical(phstart); //so its never an end boundary
	
	for (uint i=0; i<length; i+=2)
	{
		if (phstart>=ranges[i] && phstart<ranges[i+1]) //then it is here
		{
			if (phstart==ranges[i] && phstart+size-1<ranges[i+1]) //easy delete within one range, no extra ranges
			{	
				ranges[i]=phstart+size-1;
				return true;
			}
			else if (phstart>ranges[i] && phstart+size-1==ranges[i+1]) //easy delete within one range, no extra ranges
			{	
				ranges[i+1]=phstart-1;
				return true;
			}
			else if (phstart==ranges[i] && phstart+size-1==ranges[i+1]) //easy remove whole range!
			{
				uint* newone = new uint[length-2];
				for (uint k=0; k<i; k++)
					newone[k]=ranges[k];
				for (uint k=i+2; k<length; k++)
					newone[k-2]=ranges[k];
				delete ranges;						
				ranges=newone;
				length-=2;
				return true;
			}
			else if (phstart>ranges[i] && phstart+size-1<ranges[i+1]) //delete within one range, one extra range
			{
				uint* newone = new uint[length+2];
				//memcpy(newone,ranges,(i+1)*ADDRESS_SIZE); //copy first half
				for (uint k=0; k<i+1; k++)
					newone[k]=ranges[k];
				newone[i+1]=phstart-1; //place of cut removal
				newone[i+2]=phstart+size; //end of cut
				//memcpy(newone + ADDRESS_SIZE * (i+4),ranges + ADDRESS_SIZE * (i+1),(length-(i+1))*ADDRESS_SIZE); //copy second half
				for (uint k=i+1; k<length; k++)
					newone[k+2]=ranges[k];
				delete ranges;						
				ranges=newone;
				length+=2;
				return true;
			}
			else if (phstart>=ranges[i] && phstart+size-1>ranges[i+1]) //over boundary delete, remove x range entries
			{
				//delete ranges, pieces until size==0
				uint j=i+2;
				if (phstart==ranges[i])  //[i,i+1[ range will be deleted, j will mark next range after [i-2,i-1[
				{
					size-=((ranges[i+1]-ranges[i])+1);
				}
				else //modify current range to end at phstart
				{
					size-=((ranges[i+1]-phstart)+1);
					ranges[i+1]=phstart-1;
					i=i+2; //avoid this range to be deleted as it was already modified
				}
				
				while (size>0)
				{
					if (j>=length) 
					{
						throw runtime_error("Error in removal in Sinx...");
					}
					
					if (size>((ranges[j+1]-ranges[j])+1)) //then this whole one cut too
					{
						size-=((ranges[j+1]-ranges[j])+1);	
						j+=2;
						
					}
					else if (size==((ranges[j+1]-ranges[j])+1)) //then this whole one cut too, will only happen once too
					{
						size-=((ranges[j+1]-ranges[j])+1);	
						j+=2;
						
						size=0;
						uint* newone = new uint[length-(j-i)];
						//memcpy(newone,ranges,(i+1)*ADDRESS_SIZE); //copy first half
						for (uint k=0; k<i; k++)
							newone[k]=ranges[k];
						//memcpy(newone + ADDRESS_SIZE * (i+1),ranges + ADDRESS_SIZE * j,(length-j)*ADDRESS_SIZE); //copy second half
						for (uint k=j; k<length; k++)
						{
							newone[k-(j-i)]=ranges[k];
						}
						delete ranges;						
						ranges=newone;
						length-=(j-i);
						return true;
					}
					else //then only cut a piece of current range and done, this wil only happen once!
					{
						ranges[j]=ranges[j]+size;
						size=0;
						uint* newone = new uint[length-(j-i)];
						//memcpy(newone,ranges,(i+1)*ADDRESS_SIZE); //copy first half
						for (uint k=0; k<i; k++)
							newone[k]=ranges[k];
						//memcpy(newone + ADDRESS_SIZE * (i+1),ranges + ADDRESS_SIZE * j,(length-j)*ADDRESS_SIZE); //copy second half
						for (uint k=j; k<length; k++)
						{
							newone[k-(j-i)]=ranges[k];
						}
						delete ranges;						
						ranges=newone;
						length-=(j-i);
						return true;
					}
				}
			}
		}
	}
	return false; //error, never found phstart
} 

//remove all logical references to data starting at phstart til phend.
bool SequenceIndex::removeLogical(uint phstart, uint phend)
{
	phstart=nextPhysical(phstart); //in case its end of range
		
	for (uint i=0; i<length; i+=2)
	{
		if (phstart>=ranges[i] && phstart<ranges[i+1]) //then it is here
		{
			/*NOTE: phend will NEVER be at the range start because the Slob only removes whole objects. 
			For phend to be the start means that the object was modified, which would cause the count 
			(that originally starts at phend) to be modified, thus eliminated and so .Notice how this code assumes Slob semantics*/
			
			//find phend, at middle or at the range end
			for (uint j=i+1; j<length; j+=2) //counting on range ends
			{
				if (phend==ranges[j-1]) 
				{
					throw runtime_error("Error at removelogical");
				}
					
				if (phend>ranges[j-1] && phend<=ranges[j]) //then found
				{
					if (i+1==j) //then its a single range removal
					{
						if (phstart==ranges[i] && phend==ranges[j]) //delete whole range
						{
							uint* newone = new uint[length-2];
							for (uint k=0; k<i; k++)
								newone[k]=ranges[k];
							for (uint k=i+2; k<length; k++)
								newone[k-2]=ranges[k];							
							delete ranges;						
							ranges=newone;
							length-=2;
						}
						else if (phstart==ranges[i]) //shift range to start late
							ranges[i]=phend+1;
						else if  (phend==ranges[j]) //shift range to end early
							ranges[j]=phstart-1;
						else //cut into two ranges
						{
							uint* newone = new uint[length+2];
							memcpy(newone,ranges,(i+1)*ADDRESS_SIZE); //copy first half
							newone[i+1]=phstart-1; //end of current range, start of deletion
							newone[i+2]=phend+1; //start of next range, end of deletion
							memcpy(&newone[i+3],&ranges[j],(length-j)*ADDRESS_SIZE); //copy second half
							delete ranges;						
							ranges=newone;
							length+=2;
						}
						return true;
					}
					else //removal spans more than one range
					{
						if (ranges[i]==phstart) //then delete whole i,i+1 range
							i-=2;
						else
							ranges[i+1]=phstart-1; //end of first included range, start of deletion
							
						if (ranges[j]==phend) //then delete whole j-1,j range
							j+=2;
						else
							ranges[j-1]=phend+1;
												
						//cut ranges from i+2, to j-2
						uint* newone = new uint[length-((j-1)-(i+2))];
						memcpy(newone,ranges,(i+2)*ADDRESS_SIZE); //copy first half, include phstart
						memcpy(&newone[i+2],&ranges[j-1],(length-(j-1))*ADDRESS_SIZE); //copy second half
						delete ranges;						
						ranges=newone;
						length-=((j-1)-(i+2));
						return true;
					}
				}
			}			
		}
	}
	
	return false; //error?
}

//replace whatever is starting at logstart, size number of bytes with what is now stored at phstart
bool SequenceIndex::replace(uint logstart, uint phstart, uint size)
{
	logstart=nextPhysical(logstart);
/*	this->debug();
	cout << "SINX Replace: " << logstart << " for " << phstart << " of size " << size << endl;*/
	for (uint i=0; i<length; i+=2)
	{
		if (logstart>=ranges[i] && logstart<ranges[i+1]) //then start is in range
		{
			if (logstart==ranges[i] && (logstart+size)-1==ranges[i+1]) //easy replace one range
			{	
				ranges[i]=phstart;
				ranges[i+1]=(phstart+size)-1;
				return true;
			}
			else if (logstart==ranges[i] && (logstart+size)-1<ranges[i+1]) //start and stay within one range
			{
				uint* newone = new uint[length+2];
				for (uint k=0; k<i; k++)
					newone[k]=ranges[k];
				newone[i]=phstart;
				newone[i+1]=phstart+size-1;
				newone[i+2]=logstart+size-1;
				for (uint k=i+1; k<length; k++)
					newone[k+2]=ranges[k];
				delete ranges;						
				ranges=newone;
				length+=2;
				return true;
			}
			else if (logstart>ranges[i] && logstart+size-1==ranges[i+1]) //within and end within one range, cut
			{
				uint* newone = new uint[length+2];
				for (uint k=0; k<=i; k++)
					newone[k]=ranges[k];
				newone[i+1]=ranges[i+1]-size;
				newone[i+2]=phstart;
				newone[i+3]=phstart+size-1;
				for (uint k=i+2; k<length; k++)
					newone[k+2]=ranges[k];
				delete ranges;						
				ranges=newone;
				length+=2;
				return true;
			}
			else if (logstart>ranges[i] && logstart+size-1<ranges[i+1]) //within one range, cut
			{
				uint* newone = new uint[length+4];
				for (uint k=0; k<=i; k++)
					newone[k]=ranges[k];
				newone[i+1]=logstart-1;
				newone[i+2]=phstart;
				newone[i+3]=phstart+size-1;
				newone[i+4]=logstart+size;
				for (uint k=i+1; k<length; k++)
					newone[k+4]=ranges[k];
				delete ranges;						
				ranges=newone;
				length+=4;
				return true;
			}
			else if (logstart>=ranges[i] && logstart+size>ranges[i+1]) //over boundary delete, remove x range entries
			{
				//entered unfinished code!!!
				throw runtime_error("Should not have entered here. Lost case of REPLACE in sinx!");
			}			
		}
	}
	return false;
}

//returns true if x is logically inside the range between phstart and phend
bool SequenceIndex::inRange(uint x, uint phstart, uint phend){ 
	
	int afterstart=-1;
	
/*	cout << "InRange: " << x << " of " << phstart << "-" << phend << endl;*/
	for (uint i=0; i<length; i+=2)
	{
		if (phstart>=ranges[i] && phstart<ranges[i+1])
			afterstart=i;
		
		if (x>=ranges[i] && x<ranges[i+1]){
			if (afterstart>=0) //found start
				if (afterstart==(long)i) //then within same loop
				{
					if ((long)x>=afterstart)
						return true;
				}else
					return true; //x found after start and before end...
		}
		
		if (phend>=ranges[i] && phend<ranges[i+1])
			return false; //found end without finding x

// 		if (!afterstart && phstart>=ranges[i] && phstart<ranges[i+1]){ //then start is in range
// 			afterstart=true; //signal that start was found
// 			if (phstart>=ranges[i] && phstart<ranges[i+1] && x>=phstart) //if x is in range and it is greater than phstart
// 				xfound=true; //signal that x was found after start, now find end
// 		}else if (x>=ranges[i] && x<ranges[i+1]){ //then x is in a range different than start
// 			if (!afterstart) return false; //found x before start
// 			xfound=true;
// 			if (phend>=ranges[i] && phend<ranges[i+1] && x<=phend) //if x is in range and it is less than phend
// 				return true; //signal that all is great
// 		}
// 		
// 		if (phend>=ranges[i] && phend<ranges[i+1]) { //then end is in range
// 			if (!afterstart || !xfound) return false; //found end before start, so x can never be between start-end
// 			else return true; //end found after start and x
// 		}
	}
	return false;
}


//sets bytes to the array of bytes representing Seqidx, returns size of byte array
uint SequenceIndex::getBytes(unsigned char bytes[])
{
	//debug();
	memcpy(bytes,(unsigned char*)ranges,length*ADDRESS_SIZE);
	return (length*ADDRESS_SIZE);
}
		
//actual number of bytes between addresses (might be more than phend-phstart cause of shifting)
uint SequenceIndex::byteCount(uint phstart, uint phend)
{
	uint count=0;
	
	phstart=nextPhysical(phstart);
	//phend=prevPhysical(phend);
	
	for (uint i=0; i<length; i+=2)
	{
		if (phstart>=ranges[i] && phstart<ranges[i+1] &&
			phend>=ranges[i] && phend<ranges[i+1]) //within one range, return difference
			return phend-phstart;

		if (phstart>=ranges[i] && phstart<ranges[i+1])
		{
			for (uint j=i+1; j<length; j+=2)
			{
				if (phend>=ranges[j-1] && phend<ranges[j]) //end found in range, count partially
				{
					count+=((phend+1)-ranges[j-1]);
					return count;
				}
				else
					count+=((ranges[j]-ranges[j-1])+1); //count whole range
			}			
			return 0; //should throw error
		}
	}
	
	return 0; //nothing found
}

uint SequenceIndex::byteCount() //length of sinx in bytes, sum of differences of ranges; 
{
	uint count=0;
	for (uint i=0; i<length; i+=2)
	{
		count+=((ranges[i+1]-ranges[i])+1);
	}
	
	return count;
}

uint SequenceIndex::rangeCount()
{
	return (length/2);
}

void SequenceIndex::debug()
{
	//print to test
	for (uint i=0; i<length; i+=2)
	{
		cout << "[" << ranges[i] << "|" << ranges[i+1] << "]..";
	}
	cout << "--(" << length << ")--" << endl;
	
}

