#ifndef LOCATORTABLE_H
#define LOCATORTABLE_H

#include <vector>
#include "LocatorNode.h"
#include "Locator.h"
#include "mSlob.h"
#include "orphanedLocatorList.h"

class orphanedLocatorList;
using namespace std;

class LocatorTable
{
	public:
		typedef unsigned long long int ullint; 
	private:
		struct LocatorTree
		{
			ullint storageID;
			uint numLocated;
			LocatorNode* root;
			orphanedLocatorList *oll;
			
			LocatorTree( );
			LocatorTree( ullint ID, LocatorNode* newNode );
			LocatorTree& operator=( LocatorTree & RHS );
		};
		vector<LocatorTree*> locTrees;
		
		static LocatorTable* locTable;	// pointer to the only copy of loctable
										// that will exist	
		
		LocatorTable( ); //constructor
			
	public:
		static Locator* locateGlobalObject( void *storagePtr);	// pointer to storage 
		static void unlocateGlobalObject( void *storagePtr ); 
};
#endif
