#include "LocatorTable.h"


LocatorTable::LocatorTree::LocatorTree( ):
storageID( 0 ), numLocated( 0 ), root( NULL )
{
	 oll = new orphanedLocatorList(); 
}

LocatorTable::LocatorTree::LocatorTree( ullint ID, LocatorNode* newNode ): 
storageID( ID ), numLocated( 1 ), root( newNode )
{
// 	cout << "Called it for: "; newNode->debug();
	 oll = new orphanedLocatorList(); 
}

LocatorTable::LocatorTree& LocatorTable::LocatorTree::operator=( LocatorTable::LocatorTree & RHS )
{
	*oll = *(RHS.oll);
	storageID = RHS.storageID;
	root = RHS.root;
	numLocated = RHS.numLocated;
	return *this;
}

LocatorTable* LocatorTable::locTable = NULL;

LocatorTable::LocatorTable( )
{	}

Locator* LocatorTable::locateGlobalObject( void * storagePtr )
{
	if( locTable == NULL )
	{
		locTable = new LocatorTable;
	}
	
	ullint storageValue = reinterpret_cast<ullint>( storagePtr );
	
	// find the correct locator tree.  if not there, then insert
	// a new root node
	bool foundTree = false;
	for( uint i = 0; i < locTable->locTrees.size( ); i++ )
	{ 
		if( storageValue == locTable->locTrees[i]->storageID )
		{
			foundTree = true;
			locTable->locTrees[i]->numLocated++;
			return new Locator( locTable->locTrees[i]->root );
		}
		else if( storageValue > locTable->locTrees[i]->storageID )
		{
			foundTree = true;
			vector<LocatorTree*>::iterator current = locTable->locTrees.begin( );
			current += i;
			locTable->locTrees.insert( current, new LocatorTree( storageValue, new LocatorNode( false ) ) );
			locTable->locTrees[i]->root->setOrphanList( locTable->locTrees[i]->oll );
			
			return new Locator( locTable->locTrees[i]->root); 
		}
	}
	// if we did not find the tree or if it should be the last tree on the list
	// then append it
	if( !foundTree )
	{
		uint i = locTable->locTrees.size( );
		locTable->locTrees.push_back( new LocatorTree( storageValue, new LocatorNode( false ) ) );
		locTable->locTrees[i]->root->setOrphanList( locTable->locTrees[i]->oll );
		return new Locator( locTable->locTrees[i]->root ); 
	}
	return NULL;
}

void LocatorTable::unlocateGlobalObject( void * storagePtr )
{
	if( locTable == NULL )
	{
		return;
	}
	
	ullint storageValue = reinterpret_cast<ullint>( storagePtr );
	
	// find the storage object's loc tree
	for( uint i = 0; i < locTable->locTrees.size( ); i++ )
	{ 
		if( storageValue == locTable->locTrees[i]->storageID )
		{
			locTable->locTrees[i]->numLocated--;
			if( locTable->locTrees[i]->numLocated == 0 )
			{
				vector<LocatorTree*>::iterator current = locTable->locTrees.begin( );
				current += i;
				locTable->locTrees.erase( current );
			}
			return;
		}
	}
	
	return;
}
