#ifndef LOCATORNODE_H
#define LOCATORNODE_H

#include <vector>
#include "mSlob.h"
#include "memSlob.h"
#include "Locator.h"
#include "imSlobstream.h"
#include "stuVector.h"
#include <stdexcept>
#include "constants.h"
#include "orphanedLocatorList.h"

using namespace std;
using namespace stu;

class mSlob;
class Locator;
class node;
class imSlobstream;

class LocatorNode
{		
	private:
		/*  Node stuff -- needed for building the locator tree  */
		LocatorNode* parent;  				//saves pointer to parent Locator used 
											//originally to locate this. If NULL then 
											//its global (no parent)
		
		vector<LocatorNode*> children;	//array of child locators that have been created
		
		/*******************************************************/
		orphanedLocatorList* oll;			// pointer to the orphaned locator list
											// for this object
		uint start; 						//start of object
		uint end;							//end of object
		uint elements; 						//number of subobjects
		uint myaddress;						//location of address defining this locator
		int objectType; 						//id of struct through which this object was accessed.
		bool valid; 						//identifies the locator as a valid locator
		mSlob* myslob; 						//saves pointer to mSlob to which this locator refers
		bool isBase; 						//used to indicate that current locator is a base object
		LocatorNode* ref;					//points to LNode to which this refers
		node *memloc; 						//used to refer to an object in a memSlob
		
		void makeRoomForInsert( uint idx );	// used to make room in the children array
		void shrinkRoomAfterDelete( uint idx );	// used to shrink children vector after delete
		bool childAlreadyLocated( uint idx );	// find if a child node has been located yet 
		friend LocatorNode* search(LocatorNode* d, LocatorNode* tree);
		
	public:
		
		LocatorNode( bool isMemLocator = true ); 						//default constructor
		//LocatorNode(void* storagePtr);	//not implemented
		~LocatorNode(); 					//default destructor
		
		/*  Locator stuff -- needed for locating the mSlob  */
		LocatorNode(uint s, uint e, uint count, uint m, int st, mSlob* ms, LocatorNode* par);
		LocatorNode(node *x, long strid, mSlob* ms, LocatorNode* par);
		
		
		bool operator==( const LocatorNode& rhs );
		LocatorNode& operator=( const LocatorNode & rhs ); 
		uint getElements( ) const;
		
		
		/*  functions that call mSlob functions, provided for simplicity  */
		LocatorNode* locate(uint idx); //locate object at loc level. loc also refers to a specific virtual SLOB
		
		LocatorNode* locateRef(uint idx); //locate object at loc level. stops before dereference
		
		LocatorNode* DeReference( ); //dereferences l if its a reference
		
		imSlobstream getStream(); 			//get stream at level of hierachy of object at l
		
		//insert object at position idx of object loc, returns locator to inserted base object
		LocatorNode* insert(unsigned char data[], uint size, uint idx); 
		
		//insert empty object into position idx of loc. non-base object inserter
		LocatorNode* insert(uint idx, int oType = OBJECT_LEVEL); 
		
		//insert object in loc into spot idx of this locator, returns locator to inserted object
		LocatorNode* insert(const LocatorNode* loc, uint idx);
		
		//append object as subobject of object loc  
		LocatorNode* append(unsigned char data[], uint size); 
		
		bool remove(uint idx);				//remove element at position idx
		bool removeAll();					//remove all subobjects from this Locator
		uint length() const;				//size of object at loc, in bytes
		uint count() const;					//number of subobjects of loc, same as elements		
		
		bool isEmpty( );
		
		bool operator>( LocatorNode& RHS );
		
		orphanedLocatorList* getOrphanList( );
		uint getStart( );
		uint getEnd( );
		uint getElements( );
		uint getMyAddress( );
		int getObjectType( );
		bool getValid( );
		mSlob* getMySlob( );
		bool getIsBase( );
		node* getMemLoc( );
		LocatorNode* getRef( );
		Locator getParent( );
		
		void setOrphanList( orphanedLocatorList* );
		void setStart( uint );
		void setEnd( uint );
		void setElements( uint );
		void setMyaddress( uint );
		void setObjectType( int );
		void setValid( bool );
		void setMySlob( mSlob* );
		void setIsBase( bool );
		void setMemLoc( node* );
		void setRef( LocatorNode* l);
		void setParent( LocatorNode* );
		
		bool beginBatch(); 
		bool commitBatch(); 

		void debug() const;	
		
		friend ostream& operator<<( ostream &out, LocatorNode & LN );
};


#endif
