#include "LocatorNode.h"
#include "Locator.h"

//utilities
LocatorNode* search(LocatorNode* d, LocatorNode* tree){
	if (*d==*tree)
		return tree;
	else{
		LocatorNode* temp;
		for (uint i=0; i<tree->children.size(); i++){
			if (tree->children[i]!=NULL){ //cout << "The child is null!" << endl;
				temp=search(d,tree->children[i]);
				if (temp!=NULL && *temp==*d)
					return temp;
			}
		}
	}
	return NULL; //not found
}

//private constructors
LocatorNode::LocatorNode( uint s, uint e, uint count, uint m, int st, mSlob* ms, LocatorNode * par ):
		start(s),end(e), elements(count), myaddress(m), objectType(st), valid(true), myslob(ms), isBase(false), ref(NULL), memloc(NULL)
{
	parent = par;
	
	if( parent != NULL )
	{
		oll = parent->getOrphanList( );
	}else
		throw runtime_error( "Parent cannot be set to NULL" );
	for( uint i = 0; i < elements; i++ )
		children.push_back( NULL );
}
		
LocatorNode::LocatorNode(node *x, long strid, mSlob* ms, LocatorNode* par):
		parent(par), start(0),end(0), myaddress(0), objectType(strid), valid(true), myslob(ms), isBase(x->objectType==BASE_LEVEL), ref(NULL), memloc(x)
{
	if( parent != NULL )
	{
		oll = parent->getOrphanList( );
	}else
		throw runtime_error( "Parent cannot be set to NULL" );
	if (memloc->objectType!=BASE_LEVEL) 
	{
		elements=memloc->len;
		for( uint i = 0; i < elements; i++ )
			children.push_back( NULL );
	}
	else 
	{
		elements=0;
		end=memloc->len-1;
	}

	
}

//initialize to first object of newly create mSlob 
LocatorNode::LocatorNode( bool isMemLocator ):
		start(0), end(0), elements(0), myaddress(0), objectType(COLLECTION_LEVEL), valid(true), isBase(false), ref(NULL)
{
	if( isMemLocator )
	{
		myslob =new mSlob();
		parent = NULL; //memloc is root, so there is no parent
		memloc = myslob->locateGlobal().getmemLoc();
		oll = myslob->locateGlobal().getLocatorNode()->getOrphanList( );
		/*		memloc = myslob->mem->root;*/
		/*		cout << "BUilt MemSlob" << endl;*/
	}
	else
	{
		parent = NULL;
		myslob = NULL;
		memloc = NULL;
		oll = NULL;
	}
}

bool LocatorNode::isEmpty( )
{
	return( parent == NULL && myslob == NULL && memloc == NULL );	
}


//default destructor
LocatorNode::~LocatorNode()
{ 
	// the locator tree will handle destruction
	//if (parent!=NULL) delete parent;
}

// bool LocatorNode::operator==( const LocatorNode &rhs )	{  
// 	return( rhs.elements == elements && rhs.start == start && rhs.end == end && objectType==rhs.objectType);
// }

bool LocatorNode::operator==( const LocatorNode& RHS )
{
	if( memloc == NULL  && RHS.memloc == NULL )
	{
		return( start == RHS.start );
	}
	else if( memloc != NULL && RHS.memloc != NULL ) 
	{
		return( memloc == RHS.memloc );
	}else {
		return false;
	}
	return false;
}


//We say No to deep copies
LocatorNode& LocatorNode::operator=( const LocatorNode &rhs ) { 
	cerr<<"We will not allow operator = to be performed on this type!!"<<endl;
	throw runtime_error("We will not allow operator = to be performed on this type!! Only on pointers to this type");
	return *this;
}

uint LocatorNode::getElements( ) const{ 
	return elements;
}

//functions that call mSlob functions, provided for simplicity

LocatorNode* LocatorNode::locateRef(uint idx) 
{ 
	if( idx >= elements )
	{
		cout << "Locate error: Invalid idx. Not enough elements to reach idx provided." << endl;
		throw runtime_error( "Locate error: Invalid idx. Not enough elements to reach idx provided.");
	}
	
/*	cout << "============================================================" << endl;
	cout << "=	Locating idx: " << idx << " of "; this->debug();*/
	if( !childAlreadyLocated( idx ) )
	{
/*		cout << "=	Not located yet. Will Locate" << endl;*/
		Locator temp = myslob->locateRef( Locator( this ), idx );
		children[idx] = temp.getLocatorNode( );
		children[idx]->parent = this;
		children[idx]->oll = oll;
	}
/*	cout << "=	Located as: "; children[idx]->debug();
	cout << "============================================================" << endl;*/
	return children[idx];	
} 

LocatorNode* LocatorNode::DeReference( ) 
{ 
	if (getObjectType()==REFERENCE_LEVEL){
		if (getRef()==NULL) //then look for it	
		{
			//first find it
			Locator temp(myslob->DeReference(Locator(this)));
			temp.getLocatorNode()->parent=this;
			temp.getLocatorNode()->oll=oll;
/*			cout << "theMSlob deferenced to: "; temp.debug();*/
			//now search in the LocatorNode tree to see if this was dereferenced previously
			LocatorNode* intree=search(temp.getLocatorNode(),myslob->locateGlobal().getLocatorNode());
			
			if (intree==NULL){ //not in tree, now look into orphan list, maybe there
/*				cout << "not found in tree...lets go to the orphan" << endl;*/
				if (oll->isInOrphanList(temp.getLocatorNode(),intree)){
					setRef(intree);
				}
				else{
				//now insert into orphan list
				oll->insertOrphan(temp.getLocatorNode());
				setRef(temp.getLocatorNode());
				}
			}else{
				setRef(intree); //found in LocatorNode tree
			}
		}
		
// 		cout << "============================================================" << endl;
// 		cout << "=	Dereferencing: "; this->debug();
// 		cout << "=	Resulted in "; getRef()->debug();
// 		cout << "============================================================" << endl;
		
		//ref has either been set on a previous dereference or it was just set above
		return getRef();
	}
	else return this;
} 

//locate object at this loc's level.
LocatorNode* LocatorNode::locate(uint idx) 
{ 
	LocatorNode* l=locateRef(idx);
/*	cout << "ref located: "; l->debug();*/
	LocatorNode* data=l->DeReference();
/*	cout << "dereferenced: "; data->debug();*/
	LocatorNode* original;
	
	//if element being located is already in orphan list
	if (l==data){ //then l is not a referenced, thus not really dereferenced above, see if it was referenced previously
		if (oll->isInOrphanList(data,original))
		{
			delete children[idx]; //delete old node, wont be used again
			children[idx]=original; //assign children pointer to element in orphan list
			oll->removeOrphan(data); //remove from orphan list
			original->setParent(this); //change parent to point here
			original->oll = oll;
		}
	}	
	return data;
} 

//get stream reader for this locator
imSlobstream LocatorNode::getStream()
{ 
	Locator temp( this );
	return myslob->getStream( temp ); 
} 

//insert base object at position idx of this locator, 
LocatorNode* LocatorNode::insert( unsigned char data[], uint size, uint idx ) 
{
//returns locator to inserted base object
	if( idx > elements )
	{
		cout << "Locate error: Invalid idx. Not enough elements to reach idx provided." << endl;
		throw runtime_error( "Locate error: Invalid idx. Not enough elements to reach idx provided.");
		exit( 1 );
	}

	makeRoomForInsert( idx );
	Locator temp( this );
/*	cout << "============================================================" << endl;
	cout << "=	Inserting data into idx: " << idx << " of "; this->debug();*/
	
	children[idx] = (myslob->insert( data, size, temp, idx )).getLocatorNode( );
	children[idx]->parent = this;
	children[idx]->oll = oll;
	elements++;
	
// 	cout << "=	Inserted as: "; children[idx]->debug();
// 	cout << "============================================================" << endl;

	return children[idx];
} 

//insert empty object into position idx of this locator. non-base object inserter
LocatorNode* LocatorNode::insert(uint idx, int oType) 
{ 	
	if( idx > elements )
	{
		cout << "Locate error: Invalid idx. Not enough elements to reach idx provided." << endl;
		throw runtime_error(  "Locate error: Invalid idx. Not enough elements to reach idx provided." );
		exit( 1 );
	}
	
	makeRoomForInsert( idx );
	Locator temp( this );
	
/*	cout << "============================================================" << endl;
	cout << "=	Inserting empty into idx: " << idx << " of "; this->debug();*/
	
	children[idx] = (myslob->insert( temp, idx, oType )).getLocatorNode( );
	children[idx]->parent = this;
	children[idx]->oll = oll;
	elements++;
	
// 	cout << "=	Inserted as: "; children[idx]->debug();
// 	cout << "============================================================" << endl;

	return children[idx];
} 

//insert object in loc into spot idx of this locator, returns locator to inserted object
LocatorNode* LocatorNode::insert( const LocatorNode* loc, uint idx )
{
	if( idx > elements )
	{
		cout << "Locate error: Invalid idx. Not enough elements to reach idx provided." << endl;
		throw runtime_error(  "Locate error: Invalid idx. Not enough elements to reach idx provided." );
		exit(1);
	}
	makeRoomForInsert( idx );
	Locator temp( this );
	Locator insertionLoc( const_cast<LocatorNode*>(loc) );
/*	cout << "============================================================" << endl;
	cout << "=	Inserting reference into idx: " << idx << " of "; this->debug();
	cout << "=	Reference to "; loc->debug();*/
	
		
	children[idx] = (myslob->insert( insertionLoc, temp, idx )).getLocatorNode( );
	children[idx]->parent = this;
	children[idx]->oll = oll;
	children[idx]->setRef(const_cast<LocatorNode*>(loc));
	elements++;
	
// 	cout << "=	Inserted as: "; children[idx]->debug();
// 	cout << "============================================================" << endl;

	return children[idx];
}

//append data as subobject of object loc
LocatorNode* LocatorNode::append( unsigned char data[], uint size ) 
{
	uint idx = elements;
	makeRoomForInsert( idx );
	Locator temp( this );
	
/*	cout << "============================================================" << endl;
	cout << "=	Appending data into idx: " << idx << " of "; this->debug();*/
	
	children[idx] = (myslob->insert( data, size, temp, idx )).getLocatorNode( );
	children[idx]->parent = this;
	children[idx]->oll = oll;
	elements++;
	
// 	cout << "=	Inserted as: "; children[idx]->debug();
// 	cout << "============================================================" << endl;

	return children[idx];
} 

bool LocatorNode::remove( uint idx )
{
	if( idx >= elements )
	{
		cout << "Locate error: Invalid idx. Not enough elements to reach idx provided." << endl;
		throw runtime_error(  "Locate error: Invalid idx. Not enough elements to reach idx provided." );
		exit(1);
	}
	
	Locator temp( this );
	if( myslob->remove(temp, idx) ) //remove element
	{
/*		for (uint i=0; i<elements; i++){
			cout << i+1 << ": "; Locator(children[i]).debug();
		}
		cout << "Shrinking the TREEEEEEEEEEEEEEE!" << endl;*/
		shrinkRoomAfterDelete( idx );
		elements--;
/*		for (uint i=0; i<elements; i++){
			cout << i+1 << ": "; Locator(children[i]).debug();
		}*/
		return true;
	}else
		throw runtime_error("Could not remove element.");	
}

bool LocatorNode::removeAll( )
{
	for( uint i=0; i<elements; i++ )
		if( !remove(0) )
			return false; //failed on at least one remove
	return true; //removed all
}

void LocatorNode::makeRoomForInsert( uint idx )
{
	vector<LocatorNode*>::iterator current = children.begin( );
	current += idx;
	children.insert( current, NULL );
}

void LocatorNode::shrinkRoomAfterDelete( uint idx )
{
	vector<LocatorNode*>::iterator current = children.begin( );
	current += idx;
	children.erase( current );	
}
		
bool LocatorNode::childAlreadyLocated( uint idx )
{
	//cerr<<"locating: "<<idx<<" -- "<<*this<<endl;
	if( idx >= children.size( ) )
	{
		// if the child nodes are not yet instantiated,
		// then instantiate them so we can perform 
		// the locate
		for( uint i = children.size( ); i < idx+1; i++ )
			children.push_back( NULL ); 
		return false;
	}
	else if( children[idx]!= NULL )
	{
		return true;
	}
	return false;
}
		
uint LocatorNode::length( ) const 
{ //size of object at loc, in bytes
	Locator temp( const_cast<LocatorNode*>( this ) );
	return myslob->length( temp );
} 

uint LocatorNode::count( ) const 
{ //number of subobjects of loc, same as elements
	Locator temp( const_cast<LocatorNode*>( this ) );
	return myslob->count( temp );
} 

bool LocatorNode::beginBatch( ) 
{
	return myslob->beginBatch( );
}

bool LocatorNode::commitBatch( ) 
{ 
	return myslob->commitBatch( ); 
}

void LocatorNode::debug( ) const
{
	if( memloc != NULL )
		cout << "InMem Locator " << memloc << " with len=" << memloc->len 
				<< " Elements: " << elements << " ObjectType: " << objectType << endl;
	else
		cout << "Strt: " << start << " -  End: " << end 
				<< " Elements: " << elements << " ObjectType: " << objectType << endl;
}



bool LocatorNode::operator>( LocatorNode& RHS )
{
	if( memloc == NULL && RHS.memloc == NULL )
	{
		return( start > RHS.start );
	} 
	else if( memloc != NULL && RHS.memloc != NULL ) 
	{
		return( memloc > RHS.memloc );
	}
	else {
		// one is a mem loc and the other isn't. cant really compare them
		throw runtime_error( "Cannot perform operation > on a locator and a memlocator\n" );
	}
	return false;
}

uint LocatorNode::getStart( )
{ return start; }

uint LocatorNode::getEnd( )
{ return end; }

uint LocatorNode::getElements( )
{ return elements; }

uint LocatorNode::getMyAddress( )
{ return myaddress; }

int LocatorNode::getObjectType( )
{ return objectType; }

bool LocatorNode::getValid( )
{ return valid; }

mSlob* LocatorNode::getMySlob( )
{ return myslob; }

bool LocatorNode::getIsBase( )
{ return isBase; }

node* LocatorNode::getMemLoc( )
{ return memloc; }

LocatorNode* LocatorNode::getRef( )
{ return ref; }

Locator LocatorNode::getParent( )
{ return Locator(parent); }

void LocatorNode::setStart( uint val )
{ start = val; }

void LocatorNode::setEnd( uint val )
{ end = val; }

void LocatorNode::setElements( uint val )
{ 
	elements = val; 
	if (memloc != NULL)
		memloc->len=val;
}

void LocatorNode::setMyaddress( uint val )
{ myaddress = val; }

void LocatorNode::setObjectType( int val )
{ objectType = val; }

void LocatorNode::setValid( bool val )
{ valid = val; }

void LocatorNode::setMySlob( mSlob* val )
{ myslob = val; }

void LocatorNode::setIsBase( bool val )
{ isBase = val; }

void LocatorNode::setMemLoc( node* val )
{ memloc = val; }

void LocatorNode::setRef( LocatorNode* l )
{ ref = l; }

void LocatorNode::setParent( LocatorNode* val )
{ parent = val; }

ostream& operator<<( ostream &out, LocatorNode & LN )
{
	out<<"children: "<<LN.children.size( )<<" elements: "<<LN.elements;
	return out;
}

orphanedLocatorList* LocatorNode::getOrphanList( )
{	return oll; }

void LocatorNode::setOrphanList( orphanedLocatorList* newOll )
{ oll = newOll; }
