#ifndef LOCATOR_H
#define LOCATOR_H

/** Implementation class for Locators of mSlob
	\author Alejandro Pauly, Mark McKenney (based on original Locator for Slob)
	\date 2005-11-22
	\version 0.1
	\date 2005-12-05
	\version 0.2
	\date 2006-06-29
	\version 0.3 - changed offsets to elements and offset_size to address_size
	\date 2006-09-29
	\version 0.4 - added reference to owning mSlob
 */

#include "mSlob.h"
#include "memSlob.h"
#include "imSlobstream.h"
#include "stuVector.h"
#include "LocatorNode.h"
#include "constants.h"

// class mSlob;
// class memSlob;
// class node;
// class imSlobstream;
class LocatorNode;

using namespace std;

//const uint ADDRESS_SIZE=4; //already defined in SequenceIndex.h

class Locator{
	
	private:
		LocatorNode* locNode;			// the locator node that actually
										// locates the object
		
 		Locator(uint s, uint e, uint count, uint m, int st, mSlob* ms, const Locator &par);
 		Locator(node *x, long strid, mSlob* ms, Locator* par);
		
	public:
		
		friend class mSlob;
		friend class memSlob;
		friend class LocatorNode;
		friend class imSlobstream;
		
		Locator( bool isMemLocator = true ); 						//default constructor
		Locator(const Locator& loc); 	//copy constructor
		Locator( LocatorNode * ); 		//constructor if locator node is known
		~Locator(); 					//default destructor
		//Locator(mSlob* myslob); 		//default constructor
		
		bool operator==( const Locator & rhs );
		Locator& operator=( const Locator & rhs ); 
		
		//functions that call mSlob functions, provided for simplicity
		//locate object at loc level. loc also refers to a specific virtual SLOB
		Locator locate(uint idx) const; 
		
		//get stream at level of hierachy of object at l
		imSlobstream getStream(); 
		
		//insert object at position idx of object loc, returns locator to inserted base object
		Locator insert(unsigned char data[], uint size, uint idx);
		
		//insert empty object into position idx of loc. non-base object inserter
		Locator insert(uint idx, int oType = OBJECT_LEVEL); 
		
		//insert object in loc into spot idx of this locator, returns locator to inserted object
		Locator insert(const Locator& loc, uint idx); 
		 
		 //append object as subobject of object loc
		Locator append(unsigned char data[], uint size);
		
		bool remove(uint idx); 				//remove element at position idx
		bool removeAll(); 					//remove all subobjects from this Locator
		uint length() const; 				//size of object at loc, in bytes
		uint count() const; 				//number of subobjects of loc, same as elements		
		
		bool isEmpty( );
		
		bool beginBatch(); 
		bool commitBatch(); 

		void debug() const;	
		uint getElements( ) const;
		
		//move to private when done debugging!
		mSlob* getMySlob( ) const;
		Locator locateRef(uint idx) const; 
	
	private:
		uint getStart( ) const;
		uint getEnd( ) const;
		uint getMyAddress( ) const;
		int getObjectType( ) const;
		bool getValid( ) const;
		//mSlob* getMySlob( ) const;
		bool getIsBase( ) const;
		node* getmemLoc( ) const;
		Locator getParent( ) const; //added by Ale
		
		void setStart( uint );
		void setEnd( uint );
		void setElements( uint );
		void setMyaddress( uint );
		void setObjectType( int );
		void setValid( bool );
		void setMySlob( mSlob* );
		void setIsBase( bool );
		void setmemLoc( node* );
		void setParent(Locator* par);

		LocatorNode* getLocatorNode( ) const;
		
		//Locator locateRef(uint idx) const; 
		Locator DeReference( ) const; 

		/*
	public:
		
		friend class mSlob;
		friend class imSlobstream;
		friend class memSlob;
		
		Locator(); //default constructor
		//Locator(mSlob* myslob); //default constructor
		Locator(const Locator& loc); //copy constructor
		
		~Locator(); //default destructor
		
		bool operator==( const Locator & rhs );
		Locator& operator=( const Locator & rhs ); 
		uint getElements( ) const;
		
		//functions that call mSlob functions, provided for simplicity
		Locator locate(uint idx) const; //locate object at loc level. loc also refers to a specific virtual SLOB
		imSlobstream getStream(); //get stream at level of hierachy of object at l
		Locator insert(unsigned char data[], uint size, uint idx); //insert object at position idx of object loc, returns locator to inserted base object
		Locator insert(uint idx); //insert empty object into position idx of loc. non-base object inserter
		Locator insert(const Locator& loc, uint idx); //insert object in loc into spot idx of this locator, returns locator to inserted object
		Locator append(unsigned char data[], uint size); //append object as subobject of object loc
		bool remove(uint idx); //remove element at position idx
		bool removeAll(); //remove all subobjects from this Locator
		uint length() const; //size of object at loc, in bytes
		uint count() const; //number of subobjects of loc, same as elements		
		
		bool beginBatch(); 
		bool commitBatch(); 

		void debug() const;	
		//move the following to private when done debugging

	
	private:
		Locator(uint s, uint e, uint count, uint m, long st, mSlob* ms, const Locator* par);
		
		Locator(node *x, long strid, mSlob* ms, Locator* par);
		
		uint start; //start of object
		uint end; //end of object
		uint elements; //number of subobjects
		uint myaddress; //location of address defining this locator
		long structid; //id of struct through which this object was accessed.
		bool valid; //identifies the locator as a valid locator
		mSlob* myslob; //saves pointer to mSlob to which this locator refers
		Locator* parent; //saves pointer to parent Locator used originally to locate this. If NULL then its global (no parent)
		bool isBase; //used to indicate that current locator is a base object
		
		node *memloc; //used to refer to an object in a memSlob
		*/
};

#endif
