#include "Locator.h"

Locator::Locator( bool isMemLocator ): locNode( new LocatorNode(isMemLocator) ) { }

Locator::Locator( LocatorNode * lnode ): locNode( lnode ) { }

Locator::Locator(const Locator& loc): locNode( loc.locNode )
{ }

Locator::Locator(uint s, uint e, uint count, uint m, int st, mSlob* ms, const Locator &par):
locNode( new LocatorNode(s, e, count, m, st, ms, par.getLocatorNode( ) ))
{	}

Locator::Locator(node *x, long strid, mSlob* ms, Locator* par):
locNode(new LocatorNode(x,strid,ms, (par!=NULL)?par->getLocatorNode():NULL))
{	}

Locator::~Locator(){ }
	
bool Locator::operator==( const Locator & rhs )	{  
	return( *locNode == *rhs.locNode );
}

Locator& Locator::operator=( const Locator & rhs ) { 
	locNode = rhs.locNode;
	return( *this ); 
}

//functions that call mSlob functions, provided for simplicity

 //locate object at this loc's level.
Locator Locator::locate(uint idx) const 
{
	Locator temp(locNode->locate( idx ) );
/*	cout << ">>>>>>>>>>>>Located: "; temp.debug();*/
	return temp;
} 

 //locate object at this loc's level.
Locator Locator::locateRef(uint idx) const 
{
	Locator temp(locNode->locateRef( idx ) );
	//cout << ">>>>>>>>>>>>Located: "; temp.debug();
	return temp;
} 

 //locate object at this loc's level.
Locator Locator::DeReference( ) const 
{
	Locator temp(locNode->DeReference( ) );
	//cout << ">>>>>>>>>>>>Located: "; temp.debug();
	return temp;
} 


/************** HERE *****************/

bool Locator::isEmpty( )
{
	return locNode->isEmpty( );	
}

imSlobstream Locator::getStream(){ //get stream reader for this locator
		return locNode->getStream( ); 
} 

Locator Locator::insert(unsigned char data[], uint size, uint idx) {//insert base object at position idx of this locator, 
	//returns locator to inserted base object
	return Locator( locNode->insert( data,size,idx ) );
} 

Locator Locator::insert(uint idx, int oType) { //insert empty object into position idx of this locator. non-base object inserter
	return Locator( locNode->insert( idx, oType ) );
} 

//insert object in loc into spot idx of this locator, returns locator to inserted object
Locator Locator::insert(const Locator& loc, uint idx){
	return Locator( locNode->insert( loc.getLocatorNode( ) ,idx) );
}

Locator Locator::append(unsigned char data[], uint size) {//append data as subobject of object loc
	return Locator( locNode->append( data,size ) );
} 

bool Locator::remove(uint idx){
	return locNode->remove( idx );
}

bool Locator::removeAll(){
	return locNode->removeAll( );
}

uint Locator::length() const { //size of object at loc, in bytes
	return locNode->length( );
} 

uint Locator::count() const { //number of subobjects of loc, same as elements		
	return locNode->count( );
} 

bool Locator::beginBatch() {
	return locNode->beginBatch();
}

bool Locator::commitBatch() { 
	return locNode->commitBatch(); 
}

void Locator::debug() const{
	locNode->debug( );
}



uint Locator::getStart( ) const
{ return locNode->getStart(); }

uint Locator::getEnd( ) const
{ return locNode->getEnd(); }

uint Locator::getElements( ) const
{ return locNode->getElements(); }

uint Locator::getMyAddress( ) const
{ return locNode->getMyAddress(); }

int Locator::getObjectType( ) const
{ return locNode->getObjectType(); }

bool Locator::getValid( ) const
{ return locNode->getValid(); }

mSlob* Locator::getMySlob( ) const
{ return locNode->getMySlob(); }

bool Locator::getIsBase( ) const
{ return locNode->getIsBase(); }

node* Locator::getmemLoc( ) const
{ return locNode->getMemLoc(); }

Locator Locator::getParent( ) const
{ return locNode->getParent(); }

void Locator::setStart( uint val )
{ locNode->setStart( val ); }

void Locator::setEnd( uint val )
{ locNode->setEnd( val ); }

void Locator::setElements( uint val )
{ locNode->setElements( val ); }

void Locator::setMyaddress( uint val )
{ locNode->setMyaddress( val ); }

void Locator::setObjectType( int val )
{ locNode->setObjectType( val ); }

void Locator::setValid( bool val )
{ locNode->setValid( val ); }

void Locator::setMySlob( mSlob* val )
{ locNode->setMySlob( val ); }

void Locator::setIsBase( bool val )
{ locNode->setIsBase( val ); }

void Locator::setmemLoc( node* val )
{ locNode->setMemLoc( val ); }

void Locator::setParent(Locator* par)
{ 	
	if (par==NULL)
		locNode->setParent(NULL);
	else
		locNode->setParent( par->getLocatorNode( ) );
}


LocatorNode* Locator::getLocatorNode( ) const
{
	return locNode;
}
