c=======================================================================
c
c	Parameter declarations for the Mesh-Spectral Archetype
c
c	Written by:  Greg Davis, 12/21/94
c
c	Modified by:  Berna Massingill, 6/??/95
c
c=======================================================================

c	Supported data types
	integer DOUBLEPRECISION_T, REAL_T, INTEGER_T
	parameter (DOUBLEPRECISION_T = 1)
	parameter (REAL_T = 2)
	parameter (INTEGER_T = 3)

c	Sizes of data types (relative to INTEGER)
	integer ISIZE, RSIZE, DPSIZE
	parameter (ISIZE = 1)
	parameter (RSIZE = 1)
	parameter (DPSIZE = 2)

c	Maximum local-section sizes.
	integer MAXISIZE, MAXRSIZE, MAXDPSIZE
	parameter (MAXISIZE=MAXLSIZE)
	parameter (MAXRSIZE=MAXLSIZE/RSIZE)
	parameter (MAXDPSIZE=MAXLSIZE/DPSIZE)

c	Process number of process to do I/O.
c	(NOTE that this should be the same process invoked by call
c	rather than processcall in subroutine spawn.)
	integer IOPROC
	parameter (IOPROC=1)

c	Unit for debug prints (one per process).
c	WARNING:  this might not work with -DTHREADS!
	integer IDBGUNITP
	parameter (IDBGUNITP=50)
c	Filename base for debug prints (one per process).
	character*(*) CDBGNAMEP
	parameter (CDBGNAMEP='arch_dbgout_')



