program header (input, output);

{by John Langford  johnlang@ugcs.caltech.edu}
{revisions by Berna Massingill  berna@cs.caltech.edu }

label 99;

const 	MAXGRIDS = 10; 
	MAXPROCS = 100; {warning -- this must not exceed archetype parameter MAXPROCS}
	MAXDISTRS = 10;

type alfa = record id: array[1..8] of char;
		len: integer end;
     thrint = array[1..3] of integer;
     thrbol = array[1..3] of boolean;
     files = array [0..80] of char;

var 	grids,distrs,i,j,nprocs,temp:	integer;
	grid: 	array[1..MAXGRIDS] of 
		record name: alfa; dims: thrint
		end;
	dim: 	array[1..3] of alfa;
	procgrid,ghostgrid: array[1..MAXDISTRS] of 
		record name: alfa; dims: thrint
		end;
	filename,subfile: files;
	outfile: text;
	wrap: 	array[1..MAXDISTRS] of thrbol;
	corner: array[1..MAXDISTRS] of boolean;
	tchar:	char;
	bounds:	boolean;
	extraline: array[1..72] of char;
	tcount:	integer;

procedure writename(n:alfa);
begin
	write(n.id:n.len);
end;

procedure bound(i,low,high: integer);
begin
	if i<low then begin
		writeln('>>Error: number greater than or equal to ',
			low:1,' expected');
		goto 99
	end
	else if (high>0) and (i>high) then begin 
		writeln('>>Error: number less than or equal to ',
			high:1,' expected');
		goto 99
	end
end;

procedure initialize;
begin 
	for i:=1 to MAXGRIDS do begin
		for j:=1 to 8 do begin
			grid[i].name.id[j]:=' ';
		end

	end;
	for i:=1 to MAXDISTRS do begin
		for j:=1 to 8 do begin
			procgrid[i].name.id[j]:=' ';
		end
	end;
	for i:=1 to 3 do 
		for j:=1 to 8 do begin
			dim[i].id[j]:=' ';
		end;
	tcount:=0;
end;

procedure maxstr(var name: alfa);
var k:integer;
begin
	k:=1;
	while k<9 do begin
		if name.id[k]=' ' then begin
			name.len:=k-1;
			k:=8;
		end;
	k:=k+1;
	end
end;

procedure readdim;
var j:integer;
begin
	for j:=1 to 3 do begin
		writeln('>>What is dimension ',j:1,' called?');
		readln(dim[j].id);
		maxstr(dim[j])
	end
end;

procedure readgrid(i:integer);
var j:integer;
begin
	with grid[i] do begin
		writeln('>>What is the name for grid ',i:1,'?');
		readln(name.id);
		maxstr(name);
		for j:=1 to 3 do begin
			write('>>For grid ');
			writename(name);
			write(' what is the size of the ');
			writename(dim[j]);
			writeln(' dimension of data?');
			readln(dims[j]);
			bound(dims[j],1,-1);
		end
	end
end;

procedure readndistr(i:integer);
var j:integer;
begin
	with procgrid[i] do begin
		writeln('>>What is the name for distribution ',i:1,'?');
		readln(name.id);
		maxstr(name);
		ghostgrid[i].name:=name;
		for j:=1 to 3 do begin
			write('>>For distribution ');
			writename(name);
			write(' what is the size of the ');
			writename(dim[j]);
			writeln(' dimension?');
			readln(dims[j]);
			bound(dims[j],1,-1);
		end;
		if(dims[1]*dims[2]*dims[3]>nprocs) then begin
			writeln('>>Error: dimensions too large for number of processes');
			goto 99;
		end
	end
end;

procedure readnghost(i: integer);
var j,k:integer;
begin
	with ghostgrid[i] do begin
		for j:=1 to 3 do begin
			write('>>For distribution ');
			writename(name);
			write(' what is the width of the ');
			writename(dim[j]);
			writeln(' ghost boundary?');
			readln(dims[j]);
			bound(dims[j],0,-1);
			for k:=1 to grids do 
				if (((grid[k].dims[j]/procgrid[i].dims[j])-dims[j])<0) then begin
					writeln('>>Error: ghost boundary size larger than local section dimension');
					goto 99
				end;
		end
	end
end;

procedure readnwrap(i: integer);
var 	j:	integer;
	t: 	char;
begin
	with ghostgrid[i] do begin
		for j:=1 to 3 do begin
			write('>>For distribution ');
			writename(name);
			write(' does the ');
			writename(dim[j]);
			writeln(' dimension wrap? (y/n)');
			readln(t);
			if t='y' then
				wrap[i,j]:=true
			else 
				wrap[i,j]:=false;
		end
	end
end;

procedure readncorner(i: integer);
var 	t: char;
begin
	with ghostgrid[i] do begin
		write('>>For distribution ');
		writename(name);
		writeln(' do you want corners included in');
		writeln('>>boundary exchanges? (y/n)');
		readln(t);
		if t='y' then
			corner[i]:=true
		else 
			corner[i]:=false;
		end
end;

procedure writedash;
begin
	writeln(outfile,'c----------------------------------------------------------------------')
end;

procedure writecspace;
begin
	writeln(outfile,'c                                                                      ')
end;

procedure writec5;
begin
	write(outfile,'c     ');	
end;

procedure write5dash;
begin
	write(outfile,'     -');
end;

procedure write6;
begin
	write(outfile,'      ');
end;

procedure writebar;
begin
	write(outfile,'_');
end;

procedure writenamef(n:alfa);
begin
	write(outfile,n.id:n.len);
end;

procedure writegrid(i:integer);
var j: integer;
begin
	with grid[i] do begin
		write6;
		write(outfile,'integer id_');
		writenamef(name);
		writeln(outfile);
		write6;
		write(outfile,'parameter (id_');
		writenamef(name);
		writeln(outfile,' = ',i:1,')');
		for j:=1 to 3 do begin
			write6;
			write(outfile,'integer n');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			writeln(outfile);
			write6;
			write(outfile,'parameter (n');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			writeln(outfile,' = ',dims[j]:1,')');
		end
	end
end;

procedure writepgrid(i:integer);
var j: integer;
begin
	with procgrid[i] do begin
		write6;
		write(outfile,'integer id_');
		writenamef(name);
		writeln(outfile);
		write6;
		write(outfile,'parameter (id_');
		writenamef(name);
		writeln(outfile,' = ',i:1,')');
		for j:=1 to 3 do begin
			write6;
			write(outfile,'integer nproc');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			writeln(outfile);
			write6;
			write(outfile,'parameter (nproc');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			writeln(outfile,' = ',dims[j]:1,')');
		end
	end
end;

procedure writenghost(i:integer);
var j:integer;
begin
	with ghostgrid[i] do begin
		for j:=1 to 3 do begin
		write6;
		write(outfile,'integer nghost');
		writenamef(dim[j]);
		writebar;
		writenamef(name);
		writeln(outfile);
		write6;
		write(outfile,'parameter (nghost');
		writenamef(dim[j]);
		writebar;
		writenamef(name);
		writeln(outfile,' = ',dims[j]:1,')');
		end
	end
end;

procedure writenwrap(i:integer);
var j:integer;
begin
	with ghostgrid[i] do begin
		for j:=1 to 3 do begin
			write6;
			write(outfile,'logical lwrap');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			writeln(outfile);
			write6;
			write(outfile,'parameter (lwrap');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			if (wrap[i,j]=true) then
				writeln(outfile,' = .TRUE.)')
			else
				writeln(outfile,' = .FALSE.)')
			end
		end
end;
 
procedure writencorner(i:integer);
begin
	with ghostgrid[i] do begin
		write6;
		write(outfile,'logical lcorner_');
		writenamef(name);
		writeln(outfile);
		write6;
		write(outfile,'parameter (lcorner_');
		writenamef(name);
		if (corner[i]=true) then
			writeln(outfile,' = .TRUE.)')
		else
			writeln(outfile,' = .FALSE.)');
		end
end;


procedure writelocalng(i,j: integer);
var k:integer;
begin
	with grid[i] do begin
		for k:=1 to 3 do begin
		write6;
		write(outfile,'integer n');
		writenamef(dim[k]);
		write(outfile,'lcl_');
		writenamef(name);
		writebar;
		writenamef(procgrid[j].name);
		writeln(outfile);
		write6;
		write(outfile,'parameter (n');
		writenamef(dim[k]);
		write(outfile,'lcl_');
		writenamef(name);
		writebar;
		writenamef(procgrid[j].name);
		writeln(outfile,' = ');
		write5dash;
		write6;
		write(outfile,'(n');
		writenamef(dim[k]);
		writebar;
		writenamef(name);
		write(outfile,' + nproc');
		writenamef(dim[k]);
		writebar ;
		writenamef(procgrid[j].name);
		write(outfile,' -1) / nproc');
		writenamef(dim[k]);
		writebar ;
		writenamef(procgrid[j].name);
		writeln(outfile,')');
		end
	end	
end;

procedure writelocalwg(i,j: integer);
var k:integer;
begin
	with grid[i] do begin
		for k:=1 to 3 do begin
		write6;
		write(outfile,'integer i');
		writenamef(dim[k]); 
		write(outfile,'lo_');
		writenamef(name);
		writebar;
		writenamef(procgrid[j].name);
		writeln(outfile);
		write6;
		write(outfile,'parameter (i');
		writenamef(dim[k]);
		write(outfile,'lo_');
		writenamef(name);
		writebar;
		writenamef(procgrid[j].name);
		write(outfile,' = 1-nghost');
		writenamef(dim[k]);
		writebar;
		writenamef(procgrid[j].name);
		writeln(outfile,')');
		write6;
		write(outfile,'integer i');
		writenamef(dim[k]);
		write(outfile,'hi_');
		writenamef(name);
		writebar;
		writenamef(procgrid[j].name);
		writeln(outfile);
		write6;
		write(outfile,'parameter (i');
		writenamef(dim[k]);
		write(outfile,'hi_');
		writenamef(name);
		writebar;
		writenamef(procgrid[j].name);
		write(outfile,' = n');
		writenamef(dim[k]);
		write(outfile,'lcl_');
		writenamef(name);
		writebar;
		writenamef(procgrid[j].name);
		write(outfile,' + nghost');
		writenamef(dim[k]);
		writebar;
		writenamef(procgrid[j].name);
		writeln(outfile,')');
		end;
	writeln(outfile);
	end
end;

procedure writelocalsec(i,j:integer);
var k:integer;
begin
	write6;
	write(outfile,'integer lclsize_');
	writenamef(grid[i].name);
	writebar ;
	writenamef(procgrid[j].name);
	writeln(outfile);
	write6;
	write(outfile,'parameter (lclsize_');
	writenamef(grid[i].name);
	writebar ;
	writenamef(procgrid[j].name);
	writeln(outfile,' =');
	for k:=1 to 3 do begin
		write5dash;
		write6;
		write(outfile,'(n');
		writenamef(dim[k]);
		write(outfile,'lcl_');
		writenamef(grid[i].name);
		writebar;
		writenamef(procgrid[j].name);
		write(outfile,' + 2*nghost');
		writenamef(dim[k]);
		writebar; 
		writenamef(procgrid[j].name);
		write(outfile,')');
		if k<>3 then 
			writeln(outfile,' * ')
		else
			writeln(outfile,')');
	end
end;

procedure writetempname(i:integer);
begin
	write(outfile,'i',i:1);
end;

procedure newtempdef;
begin
	tcount:=tcount+1;
	write6;
	write(outfile,'integer ');
	writetempname(tcount);
	writeln(outfile);
	write6;
	write(outfile,'parameter (');
	writetempname(tcount);
	write(outfile,' = ');
end;

procedure maxdef(i,j:integer);

procedure writediv(i,j:integer);
begin
	write(outfile,'(');
	writetempname(i);
	write(outfile,'/');
	writetempname(j);
	write(outfile,')');
end;

begin
	newtempdef;
	writeln(outfile);
	{ max(i,j) (j*(j/i)+i*(i/j)) / ((i/j)+(j/i)) }
	write5dash;
	write6;
	write(outfile,'(');
	writetempname(j);
	write(outfile,'*');
	writediv(j,i);
	write(outfile,' + ');
	writetempname(i);
	write(outfile,'*');
	writediv(i,j);
	writeln(outfile,') /');
	write5dash;
	write6;
	write(outfile,'(');
	writediv(i,j);
	write(outfile,' + ');
	writediv(j,i);
	writeln(outfile,') )');
end;

procedure writemaxsize(i:integer);
var	j:integer;
	tfirst:integer;
begin
	writecspace;
	writec5;
	write(outfile,'maximum size of local sections for ');
	writenamef(grid[i].name);
	writeln(outfile);
	writecspace;
	if distrs<>1 then begin
		tfirst:=tcount+1;
		for j:=1 to distrs do begin
			newtempdef;
			write(outfile,'lclsize_');
			writenamef(grid[i].name);
			writebar;
			writenamef(procgrid[j].name);
			writeln(outfile,')');
		end;
		maxdef(tfirst,tfirst+1);
		if distrs > 2 then begin
			for j:=3 to distrs do
				maxdef(tcount,tfirst+j-1);
		end;
		write6;
		write(outfile,'integer lclsize_');
		writenamef(grid[i].name);
		writeln(outfile);
		write6;
		write(outfile,'parameter (lclsize_');
		writenamef(grid[i].name);
		write(outfile,' = ');
		writetempname(tcount);
		writeln(outfile,')');
	end
	else begin
		write6;
		write(outfile,'integer lclsize_');
		writenamef(grid[i].name);
		writeln(outfile);
		write6;
		write(outfile,'parameter (lclsize_');
		writenamef(grid[i].name);
		write(outfile,' = lclsize_');
		writenamef(grid[i].name);
		writebar;
		writenamef(procgrid[1].name);
		writeln(outfile,')');
	end;
end;

procedure writelcl(i:integer);
begin
	write5dash;
	write6;
	write(outfile,'lclsize_');
	writenamef(grid[i].name);
end;

function stringing(var fi: files):integer;
var k:integer;
begin
	k:=1;
	while k<80 do begin
		if fi[k]=' ' then begin
			stringing:=k;
			k:=80;
		end;
		k:=k+1;
	end
end;

procedure writehead;
var tmp:integer;
begin
	write6;
	writeln(outfile,'subroutine wrapper(dg,pg,type,local,flag)');
	write6;
	writeln(outfile,'implicit none');
	write6;
	writeln(outfile,'include ''arch_uparms.h''');
	write6;
	writeln(outfile,'include ''arch_parms.h''');
	write6;
	write(outfile,'include ''');
	tmp:=stringing(filename);
	write(outfile,filename:tmp);
	writeln(outfile,'''');
	write6;
	writeln(outfile,'integer dg,pg,type');
	write6;
	writeln(outfile,'integer local(*)');
	write6;
	writeln(outfile,'integer ip(3), id(3),ig(3)');
	write6;
	writeln(outfile,'logical lw(3),corners,flag');
end;

procedure beggoto;
begin
	write(outfile,'goto (');
end;

procedure endgoto(flag:integer);
begin
	write(outfile,'), ');
	if (flag = 0) then
		writeln(outfile,'dg')
	else 	
		writeln(outfile,'pg');
end;

procedure writenum(flag,i:integer);
var space:integer;
begin
	if flag=0 then space:=MAXPROCS
	else space:= 1;
	write(outfile,i*space:1);
end;

procedure labeling(i:integer);
begin
	write(outfile,i:5,' ');
end;

procedure callpack;
begin
	write(outfile,'call pack3(');
end;

procedure callpackl;
begin
	write(outfile,'call pack3l(');
end;

procedure labelpackdg(i:integer);
var j:integer;
begin
	with grid[i] do begin
		labeling(i*MAXPROCS);
		callpack;
		for j:=1 to 3 do begin
			write(outfile,'n');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			write(outfile,', ');
		end;
		writeln(outfile,'id)');
	write6;
	writeln(outfile,'goto 9998');
	end
end;

procedure packpgrid(i:integer);
var j:integer;
begin
	labeling(i);
	callpack;
	with procgrid[i] do begin
		for j:=1 to 3 do begin
			write(outfile,'nproc');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			write(outfile,', ');
		end;
		writeln(outfile,'ip)');
	end
end;

procedure packghost(i:integer);
var j:integer;
begin
	write6;
	callpack;
	with ghostgrid[i] do begin
		for j:=1 to 3 do begin
			write(outfile,'nghost');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			write(outfile,', ');
		end;
		writeln(outfile,'ig)');
	end
end;

procedure packwrap(i:integer);
var j:integer;
begin
	write6;
	callpackl;
	with ghostgrid[i] do begin
		for j:=1 to 3 do begin
			write(outfile,'lwrap');
			writenamef(dim[j]);
			writebar;
			writenamef(name);
			write(outfile,', ');
		end;
		writeln(outfile,'lw)');
	end
end;

procedure packcorner(i:integer);
begin
	with ghostgrid[i] do begin
		write6;
		write(outfile,'corners = lcorner_');
		writenamef(name);
		writeln(outfile);
	end;
	write6;
	writeln(outfile,'goto 9999');
end;

procedure writeend;
begin
	labeling(9999);
	writeln(outfile,'if (flag) then ');
	write6;
	write6;
	writeln(outfile,'call set_mesh(ip, id, ig, lw, corners, type, dg)');
	write6;
	writeln(outfile,'else');
	write6;
	write6;
	writeln(outfile,'call redistribute_data(ip, ig, lw, corners, local, dg)');
	write6;
	writeln(outfile,'endif');
	write6;
	writeln(outfile,'end');
end;

begin
	initialize;
	writeln('>>Limit all identifiers to 3 characters please');
	readdim;
	writeln('>>How many data grids are there?');
	readln(grids);
	bound(grids,1,MAXGRIDS);
	for i:=1 to grids do
		 readgrid(i);
	writeln('>>How many processes are there?');
	readln(nprocs);
	bound(nprocs,1,MAXPROCS);
	writeln('>>How many different distributions are there?');
	readln(distrs);
	bound(distrs,1,MAXDISTRS);
	for i:=1 to distrs do begin
		readndistr(i);
		readnghost(i);
		readnwrap(i);
		readncorner(i);
	end;
	writeln('>>Do you want parameters for dimension bounds for local sections? (y/n)');
	writeln('>>(These are only useful when process grid dimensions divide');
	writeln('>>    data grid dimensions evenly.)');
	readln(tchar);
	if tchar='y' then
		bounds:=true
	else
		bounds:=false;
	writeln('>>What is the name of the header file to be created?');
	read(filename);
	read(tchar);
	writeln('>>Printing to ',filename);
	rewrite(outfile,filename);
	writedash;
	writecspace;
	writec5;
	writeln(outfile,'parameter declarations');
	writecspace;
	writedash;
	writeln(outfile);
	writedash;
	writecspace;
	writec5;
	writeln(outfile,'constants (always present)');
	writecspace;
	write6;
	writeln(outfile,'logical SETMESH, REDISTRIBUTEDATA');
	write6;
	writeln(outfile,'parameter (SETMESH=.TRUE.)');
	write6;
	writeln(outfile,'parameter (REDISTRIBUTEDATA=.FALSE.)');
	writeln(outfile);
	writedash;
	writecspace;
	writec5;
	writeln(outfile,'grid IDs, dimensions, number of processes (supplied by you)');
	writecspace;
	write6;
	writeln(outfile,'integer procs');
	write6;
	writeln(outfile,'parameter (procs = ',nprocs:1,')');
	writeln(outfile);
	for i:=1 to grids do
		writegrid(i);
	writeln(outfile);
	for j:=1 to distrs do begin
		writedash;
		writecspace;
		writec5;
		writenamef(procgrid[j].name);
		writeln(outfile,' distribution:');
		writecspace;
		writec5;
		write(outfile,'distribution ID, parameters for ');
		writenamef(procgrid[j].name);
		writeln(outfile);
		writec5;
		writeln(outfile,'(supplied by you)');
		writecspace;
		writepgrid(j);
		writenghost(j);
		writenwrap(j);
		writencorner(j);
		writecspace;
		writec5;
		write(outfile,'maximum local section dimensions for ');
		writenamef(procgrid[j].name);
		writeln(outfile,', without ghost boundary');
		writec5;
		writeln(outfile,'(computed)');
		writecspace;
		for i:=1 to grids do
			writelocalng(i,j);
		writecspace;
		if bounds then begin
			writec5;
			write(outfile,'local section dimension bounds for ');
			writenamef(procgrid[j].name);
			writeln(outfile,', with ghost boundary');
			writec5;
			writeln(outfile,'(computed)');
			writec5;
			writeln(outfile,'(only useful if process grid dimensions divide');
			writec5;
			writeln(outfile,'    data grid dimensions evenly)');
			writecspace;
			for i:=1 to grids do
				writelocalwg(i,j);
			writecspace;
		end;
		writec5;
		write(outfile,'1d sizes of local sections for ');
		writenamef(procgrid[j].name);
		writeln(outfile);
		writec5;
		writeln(outfile,'(computed)');
		writecspace;
		for i:=1 to grids do begin
			writelocalsec(i,j);
			writeln(outfile);
		end;
	end;
	writedash;
	writecspace;
	writec5; 
	writeln(outfile,'maximum and combined sizes');
	writec5;
	writeln(outfile,'(computed)');
	writecspace;
	writec5;
	writeln(outfile,'maximum computed using the formula:');
	writec5;
	writeln(outfile,'max(i,j) = (j*(j/i)+i*(i/j)) / ((i/j)+(j/i))');
	writecspace;
	writeln(outfile);
	for i:=1 to grids do 
		writemaxsize(i);
	writecspace;
	writec5;
	writeln(outfile,'1d size of combined local sections');
		writec5;
		writeln(outfile,'(computed)');
	writecspace;
	write6;
	writeln(outfile,'integer lclsize');
	write6;
	writeln(outfile,'parameter (lclsize = ');
	for i:=1 to grids do begin
		writelcl(i);
		if i<> grids then 
			writeln(outfile,' + ')
		else 
			writeln(outfile,' ) ');
	end;
	writeln('>>Enter additional lines for the header file; ''.'' to stop:');
	writeln(outfile);
	writedash;
	writecspace;
	writec5;
	writeln(outfile, 'additional declarations (supplied by you)');
	writecspace;
	repeat
		readln(extraline);
		if extraline[1]<>'.' then
			writeln(outfile,extraline);
	until extraline[1]='.';
	writeln(outfile);
	writedash;
	writeln('>>What is the name of the subroutine file to make?');
	read(subfile);
	writeln('>>Printing to ',subfile);
	rewrite(outfile,subfile);
	writehead;
	write6;
	beggoto;
	for i:=1 to grids do begin
		writenum(0,i);
		if i<> grids then 
			write(outfile,', ');
	end;
	endgoto(0);
	for i:=1 to grids do begin
		labelpackdg(i);
	end;
	labeling(9998);
	beggoto;
	for i:=1 to distrs do begin
		writenum(1,i);
		if i<> distrs then 
			write(outfile,', ');
	end;
	endgoto(1);	
	for i:=1 to distrs do begin
		packpgrid(i);
		packghost(i);
		packwrap(i);
		packcorner(i);
	end;		
	writeend;
	writeln('>>Done');
99:
end.
