c=======================================================================
c
c	Common block declarations for the Mesh-Spectral Archetype
c
c	Written by:  Greg Davis, 12/21/94
c
c	Modified by:  Berna Massingill, 6/??/95
c
c=======================================================================

	include 'arch_uparms.h'
	include 'arch_parms.h'

	PROCESS COMMON /processinfo/ ip,id,ig,lw,corners,nprocs,itype,
     $		indp,outdp,inr,outr,ini,outi,iprocnum,ldebug,idbgunit

c	The size of the process grid.  
c	Invariant:  for all i in 1..MAXGRIDS,
c		ip(1,i)*ip(2,i)*ip(3,i) <= nprocs
	integer ip(3,MAXGRIDS)

c	The size of the data grid.
	integer id(3,MAXGRIDS)

c	The size of the ghost boundaries.
	integer ig(3,MAXGRIDS)

c	Logical variables indicating if the dimensions wrap.
	logical lw(3,MAXGRIDS)

c	Logical variable indicating if the corners need to be updated.
c	with a mesh_exchange_bdry
	logical corners(MAXGRIDS)

c	The number of processes, not a function of the grid number.
	integer nprocs

c	The type of the grid.
	integer itype(MAXGRIDS)

c	In and out ports for interprocess communications.
c	These are shared between grid numbers.
	inport (integer n, double precision x(n)) indp(MAXPROCS)
	outport (integer n, double precision x(n)) outdp(MAXPROCS)
	inport (integer n, real x(n)) inr(MAXPROCS)
	outport (integer n, real x(n)) outr(MAXPROCS)
	inport (integer n, integer x(n)) ini(MAXPROCS)
	outport (integer n, integer x(n)) outi(MAXPROCS)

c	The local process number.
	integer iprocnum

c	Debug print stuff.
	logical ldebug
	integer idbgunit

	PROCESS COMMON /processbuffer/ buffer, 
     $		ibuff1,ibuff2,rbuff1,rbuff2,dpbuff1,dpbuff2

c	A buffer of size MAXLSIZE, with equivalences to allow
c	treating it as any type.

	integer buffer(MAXLSIZE)
	integer ibuffer(MAXISIZE)
	real rbuffer(MAXRSIZE)
	double precision dpbuffer(MAXDPSIZE)
	equivalence (ibuffer, buffer)
	equivalence (rbuffer, buffer)
	equivalence (dpbuffer, buffer)

c	Buffers for reduction and recursive doubling.

	integer ibuff1(MAXREDUCE), ibuff2(MAXREDUCE)
	real rbuff1(MAXREDUCE), rbuff2(MAXREDUCE)
	double precision dpbuff1(MAXREDUCE), dpbuff2(MAXREDUCE)



