C=======================================================================
C
C	user-set parameters for mesh-computation template
C
C=======================================================================

C
C	The mesh computation is based on the idea of a 3D grid of
C	processes.  Parameters XPROCS and YPROCS give the
C	dimensions of that grid.
C
	integer XPROCS, YPROCS
	parameter (XPROCS=2)
	parameter (YPROCS=2)

C
C	Arrays to be distributed among grid processes are assumed
C	to have dimensions NX by NY by NZ.  mesh_parms.h
C	defines parameters NXlsize and NYlsize as
C	dimensions for local sections of such arrays, based on
C	parameters NX and NY, and the process grid sizes defined
C	above.
C
C	CAUTION:
C
C	The dimensions of the process grid need not evenly divide
C	the dimensions of the grid.  (E.g., XPROCS need not divide
C	NX.)  However, to use the X dimension as an example:
C	The template assumes that the X-dimension of the grid
C	is broken up into XPROCS sections, of which all but the
C	last are of size NXlsize (= ceiling(NX/XPROCS)).  The
C	size of the last section is given by:
C		NX - (XPROCS-1)*NXlsize
C	You must avoid setting NX and XPROCS such that this 
C	quantity is non-positive.  (Example:  If NX=5 and XPROCS=4,
C	then NXlsize=2, and the above quantity is -1, which is not 
C	valid.)  
C
	PARAMETER (NX=8,NY=8)
C
C	In addition, distributed arrays may need "ghost boundaries"
C	to hold values from neighboring processes -- a ghost boundary
C	of size N is appropriate for array X if computation for a
C	particular cell (of X or some other array value) depends on
C	the values of X in N neighboring cells in each direction.
C	Parameter NGHOST gives the size of such ghost boundaries.
C	mesh_parms.h uses this parameter to define parameters
C	IXLO, IXHI, IYLO, and IYHI, which can be used
C	to dimension arrays with ghost boundaries -- e.g.,
C	X(IXLO:IXHI,IYLO:IYHI).
C
C	CAUTION:
C
C	The width of the ghost boundaries must not exceed the size
C	of the local sections.
C
 	PARAMETER (NGHOST=2)
