      program split

#ifdef COMPRESSED
#define OREAD c_pioopenread
#define OWRITE c_pioopenwrite
#define READ c_pioreadreal
#define WRITE c_piowritereal
#define IREAD c_pioreadint
#define IWRITE c_piowriteint
#define CLOSE c_pioclose
#else
#define OREAD pioopenread
#define OWRITE pioopenwrite
#define READ pioreadreal
#define WRITE piowritereal
#define IREAD pioreadint
#define IWRITE piowriteint
#define CLOSE pioclose
#endif

      include 'mesh_uparms.h'
      include 'mesh_parms.h'

      character*128 filename
      character*256 file
      character*128 argument
      integer NumberOfArrays
      real strip(NX)
      integer itype(4)
      integer fdin, fdout
      
      if (iargc() .ne. 2) then
         print *, 'Usage: [c]split NUMBER_OF_ARRAYS file_to_be_split'
         stop
      endif
      call getarg (1, argument)
      call getarg (2, filename)
      read (unit=argument,FMT='(I)') NumberOfArrays
      print *, 'Number of Arrays in File: ', NumberOfArrays
      ilen = len(filename)
      do while (filename(ilen:ilen) .eq. ' ')
         ilen = ilen - 1
      end do
      print *, 'File to be split: ', filename(1:ilen)


      iNXlsize = (nx+xprocs-1)/xprocs
      iNYlsize = (ny+yprocs-1)/yprocs

      do i = 1, XPROCS
         NXlocal = iNXlsize
         if (i .eq. xprocs) NXlocal = nx-(xprocs-1)*iNXlsize

         do j = 1, YPROCS

            call fname (GRIDTYPE, i, j, filename, file)
            NYlocal = iNYlsize
            if (j .eq. YPROCS) NYlocal = ny-(yprocs-1)*iNYlsize

            call OWRITE (fdout, file, 256)
            if (fdout .eq. -1) then
               print *, 'Could not open file ', file,
     $              ' for writing.'
               stop
            endif
            itype(1) = NX
            itype(2) = NY
            itype(3) = XPROCS
            itype(4) = YPROCS
            call IWRITE (fdout, itype, 4)
            if (fdout .eq. -1) then
               print *, 'Could not write to file ', filename
               stop
            endif
            
            call OREAD (fdin, filename, 128)
            if (fdin .eq. -1) then
               print *, 'Could not open file ', filename,
     $              'for reading'
               stop
            endif
            call IREAD (fdin, itype, 4)
            if ((itype(1) .ne. NX) .or. (itype(2) .ne. NY) .or.
     $           (itype(3) .ne. XPROCS) .or. (itype(4) .ne. YPROCS)) 
     $           then
               print *, filename, ' was created for: '
               print *, 'NX=', itype(1), ' NY=', itype(2),
     $              ' XPROCS=', itype(3), ' YPROCS=', itype(4)
               stop
            endif
            
C     seek to current strip.
C     skip (j-1)*iNYlsize strips.

            do ii = 1, NumberOfArrays

               do l = 1, (j-1)*iNYlsize
                  call READ (fdin, strip, nx)
                  if (fdin .eq. -1) then
                     print *, 'Error reading data from file ', 
     $                    filename
                     stop
                  endif
               end do

               do k = 1, NYlocal
                  call READ (fdin, strip, nx)
                  if (fdin .eq. -1) then
                     print *, 'Error reading data from file ',
     $                    filename
                     stop
                  endif

C     now write out the strip.
C     offset: i*iNXlsize

                  call WRITE (fdout, strip((i-1)*iNXlsize+1),
     $                 NXlocal)
                  if (fdout .eq. -1) then
                     print *, 'Error writing data to file ', file
                     stop
                  endif
               end do

C
C     Now skip to the next array:
C     offset: (YPROCS-j)*iNYlsize
               do l = 1, (YPROCS-j)*iNYlsize
                  call READ (fdin, strip, nx)
                  if (fdin .eq. -1) then
                     print *, 'Error reading data from file ', 
     $                    filename
                     stop
                  endif
               end do
            end do
            call CLOSE (fdout)
            call CLOSE (fdin)
         end do
      end do
      end


C=======================================================================
C
C	subroutine to generate filename
C
C=======================================================================

	subroutine fname(iptype, ipx, ipy, inname, outname)

C	precondition:
C		iptype is process type (HOSTTYPE or GRIDTYPE)
C		ipx, ipy are coordinates of process in process
C			grid (if iptype is GRIDTYPE) -- assumed to
C			be no more than 2 digits each
C		inname is a character string -- base for file name
C	postcondition:
C		outname is inname followed by:
C			'host' if iptype is HOSTTYPE,
C			process grid coordinates (ipx, ipy)
C				if iptype is GRIDTYPE

	include 'mesh_uparms.h'
	include 'mesh_parms.h'

	character*(*) inname
	character*(*) outname
	character*8 cbuff

	if (iptype .eq. HOSTTYPE) then
		outname = inname // 'host'
	else
		if (XPROCS .le. 9 .and. YPROCS .le. 9) then
			write (cbuff, '(3i1.1)') ipx,ipy
		else
			write (cbuff, '(3i2.2)') ipx,ipy
		endif
                call getrlen (inname, ilen)
		outname = inname(1:ilen) // cbuff
	endif

	return
	end

      subroutine getrlen (string,ilen)
      character*(*) string
c
c     subroutine gets length of that part of the string which has 
c     nonblank characters
c
      ilen = len(string)
      do while (string(ilen:ilen) .eq. ' ')
         ilen = ilen - 1
      end do
      return
      end
