/*
 * test.h
 *
 *  Created on: Dec 19, 2012
 *      Author: dung
 */
#include <iostream>
#include <fstream>
#include <map>
#include "Graph.h"
#include "coupling.h"
#include <time.h>
#include <stdio.h>
#include "maxInfluence.h"
#include <queue>
using namespace std;


void test_pids(Graph &g) {
	float f = 0.5;
	vector<int> pids = greedy2(g, f, "test.txt");

	vector<int> p;
	for (int i  = 0; i < pids.size(); i++)  {
		p.push_back(pids[i]);
		float in_frac = influence_propagate(g, p, g.vertex_ids());
		cout << (i+1) << "Required fraction " << f << " and fration of the solution " << in_frac << endl;
	}


	cout << g.vertex_ids().size() << endl;

	int a;
	cin >> a;
}

int propagate(Graph &g, vector<int> pids, int d) {
	int n = g.order();
	float eps = 0.0000001;
	vector<float> live(n, 0);
	for (int i=0; i < n; i++) {
		live[i] = g[i].threshold;
	}

	int nactive = 0;
	queue<int> q;
	for (int i=0; i < pids.size(); i++) {
		live[i] = -1;
		nactive++;
		q.push(pids[i]);
	}

	for (int h=0; h<d; h++) {
		int l = q.size();

		for (int i=0; i < l; i++) {
			int v = q.front();
			q.pop();

			vector<Edge*> out_edges = g.out_edges(v);
			for (int j = 0; j < out_edges.size(); j++) {
				Edge e = *out_edges[j];
				if (live[e.dest] > eps) {
					live[e.dest] = live[e.dest] - e.weight;
					if (live[e.dest] <= eps) {
						nactive++;
						q.push(e.dest);
					}
				}
			}
		}
	}

	return nactive;
}

void test_influence_lossless() {
	ofstream of;
	FILE* of1=fopen("Act_lossyeasiness_4hops.txt","r");

	string file = "out.txt";
	of.open(file.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< file << "\"."<<endl;
		exit(1);
	}

	int temp1,temp2,temp3;
	float temp4,temp5;

	int u;
	vector<int> pids;
	vector<int> pids_lossy;
	Graph *lossy = new Graph("SYN_lossy_easiness1v.txt", "SYN_lossy_easiness1e.txt");
	Graph *lossless = new Graph("SYN_losslessv.txt", "SYN_losslesse.txt");

	int i = 1;
	int d = 4;
	int n1 = lossy->order();
	int n2 = lossless->order();
	while(1)
	{
		fscanf(of1,"%d %d %d %f %f",&temp1,&temp2,&temp3,&temp4,&temp5);
		printf("%d %d %d %f %f\n",temp1,temp2,temp3,temp4,temp5);

		u = 3*temp2;
		pids.push_back(u);
		pids_lossy.push_back(temp2);
		pids.push_back(u);

		of << i++ << "\t" << propagate(*lossy, pids_lossy, d) << "\t" << propagate(*lossy, pids_lossy, d)/(1.0 * n1) << "\t" << propagate(*lossless, pids, d*2)/(1.0*n2) << endl;

		if(fgetc(of1)==EOF)
			break;
	}

	of.close();
	delete lossy;
	delete lossless;
}
