/*
 * measure.cpp
 *
 *  Created on: Feb 21, 2013
 *      Author: dung
 */

#include "measure.h"
#include "math.h"

double covariance(vector<double> x, vector<double> y) {
	if (x.size() != y.size()) {
		return 0;
	}

	double avgx, avgy;
	int n = x.size();
	for (int i = 0; i < n; i++) {
		avgx += x[i];
		avgy += y[i];
	}
	avgx = avgx / n;
	avgy = avgy / n;

	double total = 0;
	for (int i = 0; i < n; i++) {
		total = total + (x[i] - avgx)*(y[i] - avgy);
	}

	return total/n;
}

double correlation(vector<double> x, vector<double> y) {
	return covariance(x, y)/(sqrt(covariance(x, x)) * sqrt(covariance(y, y)));
}
