/*
 * maxInfluence.h
 *
 *  Created on: Dec 4, 2012
 *      Author: dung
 *  d- hops: Author: soham
 */

#include "maxInfluence_dhops.h"

struct bfs_node{
	int node_id;
	int hop_count;
	int pre_hop;
	bfs_node( int _node_id, int _hop_count, int _pre_hop) : node_id(_node_id), hop_count(_hop_count), pre_hop(_pre_hop) {}
};

struct live_change{
	int node_id;
	int hop;
	float live_hop;
	live_change( int _node_id, int _hop, float _live_hop) : node_id(_node_id), hop(_hop), live_hop(_live_hop) {}
};


struct hop_change{
	int node_id;
	int min_act_hop;
	hop_change( int _node_id, int _min_act_hop) : node_id(_node_id), min_act_hop(_min_act_hop) {}
};

struct node_sort {
	int id;
	double key;
	node_sort( int _node_id, int _key) : id(_node_id), key(_key) {}
};

bool comp (node_sort i, node_sort j){
	return (i.key > j.key);
}

bool rcomp (node_sort i, node_sort j){
	return (i.key < j.key);
}

using namespace std;





int influenceCount(Graph &g, vector<int> pids, int hops) {
	int n = g.order();
	float *live = new float[n];

	for (int i = 0; i < n; i++) {
		live[i] = g[i].threshold;
	}

	int nactive = 0;
	queue<int> qe;

	for (int i = 0; i<pids.size(); i++) {
		int u = pids[i];

		if(live[u]>0) {
			live[u] = -1;
			nactive++;
		}
		qe.push(u);
	}

	for(int i=1;i<=hops;i++) {
		int l = qe.size();
		for (int j = 0; j < l; j++) {
			int v = qe.front();
			qe.pop();

			vector<Edge*> out_edges = g.out_edges(v);
			for (int j = 0; j < out_edges.size(); j++) {
				Edge e = *out_edges[j];
				if(live[e.dest]>0) {
					live[e.dest] = live[e.dest] - e.weight;
					if (live[e.dest] <= 0) {
						nactive++;
						qe.push(e.dest);
					}
				}
			}
		}
	}

	delete [] live;
	return nactive;
}


vector<int> greedy(Graph &g, double fraction, int d, string file) {
	return greedy(g, fraction, d, g.vertex_ids(), file);
}

vector<int> greedy(Graph &g, double fraction, int d, vector<int> pool, string file) {

	int n = g.order();

	//Track the status of each node at each hop
	float** live;
	//bool **stored;
	live = new float*[n];

	for (int i=0; i<n; i++) {
		live[i] = new float[d+1];
	}


	int min_act_hop[n];

	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < d+1; j++) {
			live[i][j] = g[i].threshold;
		}
		min_act_hop[i] = d+1;
	}

	vector<int> pids;

	int nactive = 0;
	int new_active;
	//vector<int> pool = g.vertex_ids();

	ofstream of;
	//Loading vertex information
	of.open(file.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< file << "\"."<<endl;
		std::exit(1);
	}
	//of << "#Greedy algorithm on the graph of " << g.order() << " vertices and " << g.size() << " edges" << d << " hops" << endl;
	cout << endl << n*fraction - 1 << endl;
	clock_t startTime = clock();
	int total_max=0;

	while ( nactive < n*fraction - 1){
		int max = 0;
		int maxId = 0;

		//find the node which maximizes the number of new active nodes together with the existing seed-set
		for (int i = 0; i < pool.size(); i++) {
			new_active = 0;
			int node = pool[i];

			stack<live_change> liveRecover;
			stack<hop_change> hopRecover;

			queue<bfs_node> q;

			//store the information
			liveRecover.push(live_change(node, 0, live[node][0]));
			hopRecover.push(hop_change(node, min_act_hop[node]));

			//push into the queue
			q.push(bfs_node(node, 0, min_act_hop[node]));

			//the seed not yet active
			if(min_act_hop[node] > d)
				new_active++;

			min_act_hop[node] = 0;

			while (!q.empty()) {
				bfs_node bn = q.front();
				q.pop();
				int v = bn.node_id;
				int hop_c = bn.hop_count;
				int prehop = bn.pre_hop + 1;

				if(hop_c<d){
					vector<Edge*> out_edges = g.out_edges(v);
					for (int j = 0; j < out_edges.size(); j++)
					{
						Edge e = *out_edges[j];
						int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];
						for(int k=(hop_c+1); k<effective; k++)
						{
							liveRecover.push(live_change(e.dest, k, live[e.dest][k]));

							live[e.dest][k] = live[e.dest][k] - e.weight;

							if (live[e.dest][k] <= 0)
							{
								if (min_act_hop[e.dest] > d) //node not already activated
									new_active++;

								q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

								hopRecover.push(hop_change(e.dest, min_act_hop[e.dest]));
								min_act_hop[e.dest]= k;
								break;
							}
						}
					}
				}
			}

			//recover state of nodes
			while (!liveRecover.empty()) {
				live_change lc = liveRecover.top();
				liveRecover.pop();
				live[lc.node_id][lc.hop] = lc.live_hop;
				//stored[lc.node_id][lc.hop] = false;
			}

			while (!hopRecover.empty()) {
				hop_change hc = hopRecover.top();
				hopRecover.pop();
				min_act_hop[hc.node_id] = hc.min_act_hop;
			}

			if (new_active > max) {
				maxId = i;
				max = new_active;
			}
		}
		//Select maxid
		cout << "max" << max << endl;
		int u = pool[maxId];

		pool[maxId] = pool[pool.size() - 1];
		pool.pop_back();


		queue<bfs_node> q;
		pids.push_back(u);
		q.push(bfs_node(u, 0, min_act_hop[u]));

		if (min_act_hop[u] > d) {
			nactive++;
		}
		min_act_hop[u] = 0;

		//vector<int> influence;
		while (!q.empty()) {
			bfs_node bn = q.front();
			q.pop();

			int v = bn.node_id;
			int hop_c = bn.hop_count;
			int prehop = bn.pre_hop + 1;

			if(hop_c<d){
				vector<Edge*> out_edges = g.out_edges(v);
				for (int j = 0; j < out_edges.size(); j++)
				{
					Edge e = *out_edges[j];

					if(min_act_hop[e.dest]>(hop_c+1))		//node already influenced in later hop-> update
					{
						int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];

						for(int k=(hop_c+1); k<effective; k++)
						{
							live[e.dest][k] = live[e.dest][k] - e.weight;
							if (live[e.dest][k] <= 0)
							{
								if (min_act_hop[e.dest] > d) //node not already activated
									nactive++;

								q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

								min_act_hop[e.dest]=k;
								break;
							}
						}
					}
				}
			}
		}
		of << pids.size() << " " << u << " " << nactive << " " << max << " " << (nactive/(1.0 * n)) << " " << double( clock() - startTime ) / (double)CLOCKS_PER_SEC<< endl;
		cout << pids.size() << " " << u << " " << max << " "  << nactive << "/" << n << endl;;
		total_max+=max;
	}
	printf("\n\n total_max=%d", total_max);
	for (int i=0; i<n; i++) {
		delete [] live[i];
	}
	delete [] live;
	return pids;
}

vector<int> greedybatch(Graph &g, double fraction, int d, int batch, string file) {
	return greedybatch(g, fraction, d, batch, g.vertex_ids(), file);
}
vector<int> greedybatch(Graph &g, double fraction, int d, int batch, vector<int> pool, string file) {

	int n = g.order();

	//Track the status of each node at each hop
	float** live;
	//bool **stored;
	live = new float*[n];

	for (int i=0; i<n; i++) {
		live[i] = new float[d+1];
	}

	int min_act_hop[n];

	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < d+1; j++) {
			live[i][j] = g[i].threshold;
		}
		min_act_hop[i] = d+1;
	}

	vector<int> pids;

	int nactive = 0;
	int new_active;
	//vector<int> pool = g.vertex_ids();

	ofstream of;
	//Loading vertex information
	of.open(file.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< file << "\"."<<endl;
		std::exit(1);
	}
	//of << "#Greedy algorithm on the graph of " << g.order() << " vertices and " << g.size() << " edges" << d << " hops" << endl;
	cout << endl << n*fraction - 1 << endl;
	clock_t startTime = clock();
	int total_max=0;

	while ( nactive < n*fraction - 1){
		int max = 0;
		int maxId = 0;
		vector<node_sort> ns;

		//find the node which maximizes the number of new active nodes together with the existing seed-set
		for (int i = 0; i < pool.size(); i++) {
			new_active = 0;
			int node = pool[i];

			stack<live_change> liveRecover;
			stack<hop_change> hopRecover;

			queue<bfs_node> q;

			//store the information
			liveRecover.push(live_change(node, 0, live[node][0]));
			hopRecover.push(hop_change(node, min_act_hop[node]));

			//push into the queue
			q.push(bfs_node(node, 0, min_act_hop[node]));

			//the seed not yet active
			if(min_act_hop[node] > d)
				new_active++;

			min_act_hop[node] = 0;

			while (!q.empty()) {
				bfs_node bn = q.front();
				q.pop();
				int v = bn.node_id;
				int hop_c = bn.hop_count;
				int prehop = bn.pre_hop + 1;

				if(hop_c<d){
					vector<Edge*> out_edges = g.out_edges(v);
					for (int j = 0; j < out_edges.size(); j++)
					{
						Edge e = *out_edges[j];
						int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];
						for(int k=(hop_c+1); k<effective; k++)
						{
							liveRecover.push(live_change(e.dest, k, live[e.dest][k]));

							live[e.dest][k] = live[e.dest][k] - e.weight;

							if (live[e.dest][k] <= 0)
							{
								if (min_act_hop[e.dest] > d) //node not already activated
									new_active++;

								q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

								hopRecover.push(hop_change(e.dest, min_act_hop[e.dest]));
								min_act_hop[e.dest]= k;
								break;
							}
						}
					}
				}
			}

			//recover state of nodes
			while (!liveRecover.empty()) {
				live_change lc = liveRecover.top();
				liveRecover.pop();
				live[lc.node_id][lc.hop] = lc.live_hop;
				//stored[lc.node_id][lc.hop] = false;
			}

			while (!hopRecover.empty()) {
				hop_change hc = hopRecover.top();
				hopRecover.pop();
				min_act_hop[hc.node_id] = hc.min_act_hop;
			}

			if (new_active > max) {
				maxId = i;
				max = new_active;
			}
			ns.push_back(node_sort(i, new_active));
		}
		//Select maxid
		//cout << "max" << max << endl;
		sort(ns.begin(), ns.end(), comp);

		for (int i = 0; i < batch; i++) {
			maxId = ns[i].id;
			max = ns[i].key;
			int u = pool[maxId];


			pool[maxId] = pool[pool.size() - 1];
			pool.pop_back();


			queue<bfs_node> q;
			pids.push_back(u);
			q.push(bfs_node(u, 0, min_act_hop[u]));

			if (min_act_hop[u] > d) {
				nactive++;
			}
			min_act_hop[u] = 0;

			//vector<int> influence;
			while (!q.empty()) {
				bfs_node bn = q.front();
				q.pop();

				int v = bn.node_id;
				int hop_c = bn.hop_count;
				int prehop = bn.pre_hop + 1;

				if(hop_c<d){
					vector<Edge*> out_edges = g.out_edges(v);
					for (int j = 0; j < out_edges.size(); j++)
					{
						Edge e = *out_edges[j];

						if(min_act_hop[e.dest]>(hop_c+1))		//node already influenced in later hop-> update
						{
							int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];

							for(int k=(hop_c+1); k<effective; k++)
							{
								live[e.dest][k] = live[e.dest][k] - e.weight;
								if (live[e.dest][k] <= 0)
								{
									if (min_act_hop[e.dest] > d) //node not already activated
										nactive++;

									q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

									min_act_hop[e.dest]=k;
									break;
								}
							}
						}
					}
				}
			}
			of << pids.size() << " " << u << " " << nactive << " " << max << " " << (nactive/(1.0 * n)) << " " << double( clock() - startTime ) / (double)CLOCKS_PER_SEC<< endl;
			cout << pids.size() << " " << u << " " << max << " "  << nactive << "/" << n << endl;;
			total_max+=max;
		}
	}
	printf("\n\n total_max=%d", total_max);
	for (int i=0; i<n; i++) {
		delete [] live[i];
	}
	delete [] live;
	return pids;
}


vector<int> greedyUpdate(Graph &g, double fraction, int d, int r, int reset, string file) {
	return greedyUpdate(g, fraction, d, r, reset, g.vertex_ids(), file);
}
vector<int> greedyUpdate(Graph &g, double fraction, int d, int r, int reset, vector<int> pool, string file) {
	cout << "0" << endl;
	int n = g.order();

	//Track the status of each node at each hop
	float** live;
	live = new float*[n];

	for (int i=0; i<n; i++) {
		live[i] = new float[d+1];
	}

	int *min_act_hop = new int[n];

	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < d+1; j++) {
			live[i][j] = g[i].threshold;
		}
		min_act_hop[i] = d+1;
	}

	vector<int> pids;

	int nactive = 0;
	int new_active;

	cout << "1" << endl;
	vector<node_sort> heap;
	for (int i = 0; i < pool.size(); i++) {
		vector<int> tmp;
		int u = pool[i];

		new_active = 0;
		int node = u;

		stack<live_change> liveRecover;
		stack<hop_change> hopRecover;

		queue<bfs_node> q;

		//store the information
		liveRecover.push(live_change(node, 0, live[node][0]));
		hopRecover.push(hop_change(node, min_act_hop[node]));

		//push into the queue
		q.push(bfs_node(node, 0, min_act_hop[node]));

		//the seed not yet active
		if(min_act_hop[node] > d)
			new_active++;

		min_act_hop[node] = 0;

		while (!q.empty()) {
			bfs_node bn = q.front();
			q.pop();
			int v = bn.node_id;
			int hop_c = bn.hop_count;
			int prehop = bn.pre_hop + 1;

			if(hop_c<d){
				vector<Edge*> out_edges = g.out_edges(v);
				for (int j = 0; j < out_edges.size(); j++)
				{
					Edge e = *out_edges[j];
					int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];
					for(int k=(hop_c+1); k<effective; k++)
					{
						liveRecover.push(live_change(e.dest, k, live[e.dest][k]));

						live[e.dest][k] = live[e.dest][k] - e.weight;

						if (live[e.dest][k] <= 0)
						{
							if (min_act_hop[e.dest] > d) //node not already activated
								new_active++;

							q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

							hopRecover.push(hop_change(e.dest, min_act_hop[e.dest]));
							min_act_hop[e.dest]= k;
							break;
						}
					}
				}
			}
		}

		//recover state of nodes
		while (!liveRecover.empty()) {
			live_change lc = liveRecover.top();
			liveRecover.pop();
			live[lc.node_id][lc.hop] = lc.live_hop;
			//stored[lc.node_id][lc.hop] = false;
		}

		while (!hopRecover.empty()) {
			hop_change hc = hopRecover.top();
			hopRecover.pop();
			min_act_hop[hc.node_id] = hc.min_act_hop;
		}
		heap.push_back(node_sort(node, new_active));
		//push_heap(heap.begin(), heap.end(), rcomp);
		//ns.push_back(node_sort(i, new_active));
	}
	cout << "2" << endl;
	make_heap(heap.begin(), heap.end(), rcomp);
	cout << "3" << endl;
	ofstream of;
	//Loading vertex information
	of.open(file.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< file << "\"."<<endl;
		std::exit(1);
	}
	of << "#Greedy algorithm on the graph of " << g.order() << " vertices and " << g.size() << " edges" << d << " hops" << r << " range" << endl;
	cout << endl << n*fraction - 1 << endl;
	clock_t startTime = clock();
	int total_max=0;

	int count = 0;
	double pout = 0.01;
	while ( nactive < n*fraction - 1){
		int max = 0;
		int maxId = 0;
		count++;

		vector<int> checklist;
		int re = r;

		if (count % reset == 0) {
			re = heap.size();
		}

		for (int i = 0; i < re; i++) {
			checklist.push_back(heap.front().id);
			pop_heap(heap.begin(), heap.end(), rcomp);
			heap.pop_back();
		}
		reverse(checklist.begin(), checklist.end());
		for (int i = 0; i < checklist.size(); i++) {
			new_active = 0;
			int node = checklist[i];

			stack<live_change> liveRecover;
			stack<hop_change> hopRecover;

			queue<bfs_node> q;

			//store the information
			liveRecover.push(live_change(node, 0, live[node][0]));
			hopRecover.push(hop_change(node, min_act_hop[node]));

			//push into the queue
			q.push(bfs_node(node, 0, min_act_hop[node]));

			//the seed not yet active
			if(min_act_hop[node] > d)
				new_active++;

			min_act_hop[node] = 0;

			while (!q.empty()) {
				bfs_node bn = q.front();
				q.pop();
				int v = bn.node_id;
				int hop_c = bn.hop_count;
				int prehop = bn.pre_hop + 1;

				if(hop_c<d){
					vector<Edge*> out_edges = g.out_edges(v);
					for (int j = 0; j < out_edges.size(); j++)
					{
						Edge e = *out_edges[j];
						int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];
						for(int k=(hop_c+1); k<effective; k++)
						{
							liveRecover.push(live_change(e.dest, k, live[e.dest][k]));

							live[e.dest][k] = live[e.dest][k] - e.weight;

							if (live[e.dest][k] <= 0)
							{
								if (min_act_hop[e.dest] > d) //node not already activated
									new_active++;

								q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

								hopRecover.push(hop_change(e.dest, min_act_hop[e.dest]));
								min_act_hop[e.dest]= k;
								break;
							}
						}
					}
				}
			}

			//recover state of nodes
			while (!liveRecover.empty()) {
				live_change lc = liveRecover.top();
				liveRecover.pop();
				live[lc.node_id][lc.hop] = lc.live_hop;
				//stored[lc.node_id][lc.hop] = false;
			}

			while (!hopRecover.empty()) {
				hop_change hc = hopRecover.top();
				hopRecover.pop();
				min_act_hop[hc.node_id] = hc.min_act_hop;
			}

			if (new_active > max) {
				maxId = i;
				max = new_active;
			}
			heap.push_back(node_sort(node, new_active));
			push_heap(heap.begin(), heap.end(), rcomp);
		}

		for (int i = 0; i < 1; i++) {
			int u = heap.front().id;
			pop_heap(heap.begin(), heap.end(), rcomp);
			heap.pop_back();

			pool[maxId] = pool[pool.size() - 1];
			pool.pop_back();

			queue<bfs_node> q;
			pids.push_back(u);
			q.push(bfs_node(u, 0, min_act_hop[u]));

			if (min_act_hop[u] > d) {
				nactive++;
			}
			min_act_hop[u] = 0;

			while (!q.empty()) {
				bfs_node bn = q.front();
				q.pop();

				int v = bn.node_id;
				int hop_c = bn.hop_count;
				int prehop = bn.pre_hop + 1;

				if(hop_c<d){
					vector<Edge*> out_edges = g.out_edges(v);
					for (int j = 0; j < out_edges.size(); j++)
					{
						Edge e = *out_edges[j];

						if(min_act_hop[e.dest]>(hop_c+1))		//node already influenced in later hop-> update
						{
							int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];

							for(int k=(hop_c+1); k<effective; k++)
							{
								live[e.dest][k] = live[e.dest][k] - e.weight;
								if (live[e.dest][k] <= 0)
								{
									if (min_act_hop[e.dest] > d) //node not already activated
										nactive++;

									q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

									min_act_hop[e.dest]=k;
									break;
								}
							}
						}
					}
				}
			}
			if (nactive/(1.0 * n) > pout) {
				of << pids.size() << " " << u << " " << nactive << " " << max << " " << (nactive/(1.0 * n)) << " " << double( clock() - startTime ) / (double)CLOCKS_PER_SEC<< endl;
				cout << pids.size() << " " << u << " " << max << " "  << nactive << "/" << n << "\t" << pout << endl;;
				pout = pout + 0.01;
			}
		}
	}
	//printf("\n\n total_max=%d", total_max);
	for (int i=0; i<n; i++) {
		delete [] live[i];
	}
	delete [] live;
	delete [] min_act_hop;
	return pids;
}


vector<int> greedyUpdate(Graph &g, double fraction, int d, int t, int reset, vector<int> pool, vector<int> target, string file) {

	int n = g.order();


	//Track the status of each node at each hop
	float** live;
	live = new float*[n];
	bool *intarget = new bool[n];

	for (int i=0; i<n; i++) {
		live[i] = new float[d+1];
		intarget[i] = false;
	}

	for (int i = 0; i < target.size(); i++) {
		intarget[target[i]] = true;
	}

	int min_act_hop[n];

	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j < d+1; j++) {
			live[i][j] = g[i].threshold;
		}
		min_act_hop[i] = d+1;
	}

	vector<int> pids;

	int nactive = 0;
	int new_active;

	cout << "1" << endl;
	vector<node_sort> heap;
	for (int i = 0; i < pool.size(); i++) {
		vector<int> tmp;
		int u = pool[i];

		new_active = 0;
		int node = u;

		stack<live_change> liveRecover;
		stack<hop_change> hopRecover;

		queue<bfs_node> q;

		//store the information
		liveRecover.push(live_change(node, 0, live[node][0]));
		hopRecover.push(hop_change(node, min_act_hop[node]));

		//push into the queue
		q.push(bfs_node(node, 0, min_act_hop[node]));

		//the seed not yet active
		if(min_act_hop[node] > d)
			new_active++;

		min_act_hop[node] = 0;

		while (!q.empty()) {
			bfs_node bn = q.front();
			q.pop();
			int v = bn.node_id;
			int hop_c = bn.hop_count;
			int prehop = bn.pre_hop + 1;

			if(hop_c<d){
				vector<Edge*> out_edges = g.out_edges(v);
				for (int j = 0; j < out_edges.size(); j++)
				{
					Edge e = *out_edges[j];
					int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];
					for(int k=(hop_c+1); k<effective; k++)
					{
						liveRecover.push(live_change(e.dest, k, live[e.dest][k]));

						live[e.dest][k] = live[e.dest][k] - e.weight;

						if (live[e.dest][k] <= 0)
						{
							if (min_act_hop[e.dest] > d) //node not already activated
								new_active++;

							q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

							hopRecover.push(hop_change(e.dest, min_act_hop[e.dest]));
							min_act_hop[e.dest]= k;
							break;
						}
					}
				}
			}
		}

		//recover state of nodes
		while (!liveRecover.empty()) {
			live_change lc = liveRecover.top();
			liveRecover.pop();
			live[lc.node_id][lc.hop] = lc.live_hop;
			//stored[lc.node_id][lc.hop] = false;
		}

		while (!hopRecover.empty()) {
			hop_change hc = hopRecover.top();
			hopRecover.pop();
			min_act_hop[hc.node_id] = hc.min_act_hop;
		}
		heap.push_back(node_sort(node, new_active));
		//push_heap(heap.begin(), heap.end(), rcomp);
		//ns.push_back(node_sort(i, new_active));
	}
	cout << "2" << endl;
	make_heap(heap.begin(), heap.end(), rcomp);
	cout << "3" << endl;
	ofstream of;
	//Loading vertex information
	of.open(file.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< file << "\"."<<endl;
		std::exit(1);
	}
	of << "#Greedy algorithm on the graph of " << g.order() << " vertices and " << g.size() << " edges" << d << " hops" << t << " range" << endl;
	cout << endl << n*fraction - 1 << endl;
	clock_t startTime = clock();
	int total_max=0;

	int count = 0;
	int ntarget = target.size();
	while ( nactive < ntarget*fraction - 1){
		int max = 0;
		int maxId = 0;
		count++;

		//find the node which maximizes the number of new active nodes together with the existing seed-set
		//Only update first r nodes
		vector<int> checklist;
		int re = t;

		if (count % reset == 0) {
			re = heap.size();
			//ofstream f;
			//f.open("1distribution.txt");
			//sort(heap.begin(), heap.end(), comp);
			//for (int i=0; i<heap.size(); i++) f << i << "\t" << heap[i].key << endl;
			//break;
		}
		for (int i = 0; i < re; i++) {
			checklist.push_back(heap.front().id);
			pop_heap(heap.begin(), heap.end(), rcomp);
			heap.pop_back();
		}
		reverse(checklist.begin(), checklist.end());
		for (int i = 0; i < checklist.size(); i++) {
			new_active = 0;
			int node = checklist[i];

			stack<live_change> liveRecover;
			stack<hop_change> hopRecover;

			queue<bfs_node> q;

			//store the information
			liveRecover.push(live_change(node, 0, live[node][0]));
			hopRecover.push(hop_change(node, min_act_hop[node]));

			//push into the queue
			q.push(bfs_node(node, 0, min_act_hop[node]));

			//the seed not yet active
			if(min_act_hop[node] > d && intarget[node])
				new_active++;

			min_act_hop[node] = 0;

			while (!q.empty()) {
				bfs_node bn = q.front();
				q.pop();
				int v = bn.node_id;
				int hop_c = bn.hop_count;
				int prehop = bn.pre_hop + 1;

				if(hop_c<d){
					vector<Edge*> out_edges = g.out_edges(v);
					for (int j = 0; j < out_edges.size(); j++)
					{
						Edge e = *out_edges[j];
						int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];
						for(int k=(hop_c+1); k<effective; k++)
						{
							liveRecover.push(live_change(e.dest, k, live[e.dest][k]));

							live[e.dest][k] = live[e.dest][k] - e.weight;

							if (live[e.dest][k] <= 0)
							{
								if (min_act_hop[e.dest] > d && intarget[e.dest]) //node not already activated
									new_active++;

								q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

								hopRecover.push(hop_change(e.dest, min_act_hop[e.dest]));
								min_act_hop[e.dest]= k;
								break;
							}
						}
					}
				}
			}

			//recover state of nodes
			while (!liveRecover.empty()) {
				live_change lc = liveRecover.top();
				liveRecover.pop();
				live[lc.node_id][lc.hop] = lc.live_hop;
				//stored[lc.node_id][lc.hop] = false;
			}

			while (!hopRecover.empty()) {
				hop_change hc = hopRecover.top();
				hopRecover.pop();
				min_act_hop[hc.node_id] = hc.min_act_hop;
			}

			if (new_active > max) {
				maxId = i;
				max = new_active;
			}
			heap.push_back(node_sort(node, new_active));
			push_heap(heap.begin(), heap.end(), rcomp);
			//ns.push_back(node_sort(i, new_active));
		}
		//Select maxid
		//cout << "max" << max << endl;
		//sort(ns.begin(), ns.end(), comp);

		for (int i = 0; i < 1; i++) {
			int u = heap.front().id;
			pop_heap(heap.begin(), heap.end(), rcomp);
			heap.pop_back();


			pool[maxId] = pool[pool.size() - 1];
			pool.pop_back();


			queue<bfs_node> q;
			pids.push_back(u);
			q.push(bfs_node(u, 0, min_act_hop[u]));

			if (min_act_hop[u] > d && intarget[u]) {
				nactive++;
			}
			min_act_hop[u] = 0;

			//vector<int> influence;
			while (!q.empty()) {
				bfs_node bn = q.front();
				q.pop();

				int v = bn.node_id;
				int hop_c = bn.hop_count;
				int prehop = bn.pre_hop + 1;

				if(hop_c<d){
					vector<Edge*> out_edges = g.out_edges(v);
					for (int j = 0; j < out_edges.size(); j++)
					{
						Edge e = *out_edges[j];

						if(min_act_hop[e.dest]>(hop_c+1))		//node already influenced in later hop-> update
						{
							int effective  = (min_act_hop[e.dest] > prehop)? prehop : min_act_hop[e.dest];

							for(int k=(hop_c+1); k<effective; k++)
							{
								live[e.dest][k] = live[e.dest][k] - e.weight;
								if (live[e.dest][k] <= 0)
								{
									if (min_act_hop[e.dest] > d && intarget[e.dest]) //node not already activated
										nactive++;

									q.push(bfs_node(e.dest, k, min_act_hop[e.dest]));

									min_act_hop[e.dest]=k;
									break;
								}
							}
						}
					}
				}
			}
			of << pids.size() << " " << u << " " << nactive << " " << max << " " << (nactive/(1.0 * ntarget)) << " " << double( clock() - startTime ) / (double)CLOCKS_PER_SEC<< endl;
			cout << pids.size() << " " << u << " " << max << " "  << nactive << "/" << ntarget << endl;;
			total_max+=max;
		}
	}
	printf("\n\n total_max=%d", total_max);
	for (int i=0; i<n; i++) {
		delete [] live[i];
	}
	delete [] live;
	delete [] intarget;
	return pids;
}
