/*
 * maxInfluence.cpp
 *
 *  Created on: Dec 4, 2012
 *      Author: dung
 */

#include "maxInfluence.h"
#include <stack>
#include <queue>
#include <fstream>
#include <iostream>
#include <stdlib.h>
#include <set>
/*
 * Greedy algorithm with infinite hops
 * This algorithm does not eliminate redundant in the pool
 */
vector<int> greedy(Graph &g, double fraction, string file) {

	int n = g.order();
	clock_t start, stop;
	start = clock();

	//Track the status of each node at each level
	vector<float> live(n, 0);

	for (int i = 0; i < n; i++) {
		live[i] = g[i].threshold;
		//cout << i << "\t" <<live[i] << endl;
	}

	vector<int> pids;

	int nactive = 0;
	vector<int> vs = g.vertex_ids();
	set<int> pool(vs.begin(), vs.end());
	/*
	vector<int> pool;
	vector<int> vs = g.vertex_ids();
	for (int i = 0; i<vs.size(); i++) {
		if (vs[i] %3 == 0) pool.push_back(vs[i]);
	}
	 */
	ofstream of;
	float eps = 0.000001;
	//Loading vertex information
	of.open(file.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< file << "\"."<<endl;
		exit(1);
	}
	of << "#Greedy algorithm on the graph of " << g.order() << " vertices and " << g.size() << " edges" << endl;
	cout << n*fraction - 1 << endl;
	while ( nactive < n*fraction - 1){
		float max = 0;
		int maxId = 0;

		//find the node which maximize the number of new active node;
		for (set<int>::iterator it = pool.begin(); it != pool.end(); it++) {
			stack<int> vertices;
			stack<float> threshold;
			queue<int> q;
			set<int> removed;
			int u = *it;


			q.push(u);
			float new_active = 0;

			if (live[u] > 0) {
				vertices.push(u);
				threshold.push(live[u]);
				live[u] = -1;
				new_active++;
			}

			new_active += g.out_degree(u)/(1.0 * n);

			while (!q.empty()) {
				int v = q.front();
				q.pop();

				vector<Edge*> out_edges = g.out_edges(v);
				for (int j = 0; j < out_edges.size(); j++) {
					Edge e = *out_edges[j];
					if (live[e.dest] > 0) {
						vertices.push(e.dest);
						threshold.push(live[e.dest]);
						live[e.dest] = live[e.dest] - e.weight;
						if (live[e.dest] <= 0) {
							new_active++;
							q.push(e.dest);
						}
					}
				}
			}

			//recover state of nodes
			while (!vertices.empty()) {
				live[vertices.top()] = threshold.top();

				vertices.pop();
				threshold.pop();
			}

			if (new_active >= max) {
				maxId = u;
				max = new_active;
			}
		}

		//Select maxid
		int u = maxId;
		pool.erase(u);

		if (live[u] > 0) {
			live[u] = -1;
			nactive++;
		}
		pids.push_back(u);
		queue<int> q;
		q.push(u);
		set<int> removed;
		while (!q.empty()) {
			int v = q.front();
			q.pop();

			vector<Edge*> out_edges = g.out_edges(v);
			for (int j = 0; j < out_edges.size(); j++) {
				Edge e = *out_edges[j];
				if (live[e.dest] > 0) {
					live[e.dest] = live[e.dest] - e.weight;
					//cout << live[e.dest] << endl;
					if (live[e.dest] <= 0) {
						nactive++;
						q.push(e.dest);
						removed.insert(e.dest);
					}
				}
			}
		}
		stop = clock();
		of << pids.size() << "\t" << nactive << "\t" << (nactive/(1.0 * n)) << "\t" << (double) (stop-start)/CLOCKS_PER_SEC << endl;
		cout << pids.size() << "\t" << nactive << "/" << n << endl;;
		for (set<int>::iterator r = removed.begin(); r != removed.end(); r++) {
			pool.erase(*r);
		}
	}

	return pids;
}

/*
 * Eliminate redundant nodes using dependable graph
 */
vector<int> greedy2(Graph &g, double fraction, string file) {
	return greedy2(g, fraction, g.vertex_ids(), g.vertex_ids(), file);
}

/*
 * Eliminate redundant nodes using dependable graph
 */
vector<int> greedy2(Graph &g, double fraction, vector<int> source, vector<int> target, string file) {

	int n = g.order();
	clock_t start, stop;
	start = clock();

	//Track the status of each node at each level
	int tsize = target.size();
	vector<float> live(n, 0);
	vector<bool> inpool(n, true);
	vector<bool> intarget(n, false);

	for (int i = 0; i < n; i++) {
		live[i] = g[i].threshold;
	}
	for (int i = 0; i < tsize; i++) {
		intarget[target[i]] = true;
	}

	vector<int> pids;

	int nactive = 0;
	set<int> pool(source.begin(), source.end());

	ofstream of;
	//Loading vertex information
	of.open(file.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< file << "\"."<<endl;
		exit(1);
	}
	of << "#Greedy algorithm on the graph of " << g.order() << " vertices and " << g.size() << " edges" << endl;

	cout << tsize*fraction - 1 << endl;
	while ( nactive < tsize*fraction - 1){
		float max = 0;
		int maxId = 0;

		//find the node which maximize the number of new active node;
		for (set<int>::iterator it = pool.begin(); it != pool.end(); ) {
			stack<int> vertices;
			stack<float> threshold;
			queue<int> q;
			set<int> removed;
			int u = *it;

			q.push(u);
			float new_active = 0;

			if (live[u] > 0) {
				vertices.push(u);
				threshold.push(live[u]);
				live[u] = -1;
				if (intarget[u]) new_active++;
			}

			new_active += g.out_degree(u)/(1.0 * n);

			while (!q.empty()) {
				int v = q.front();
				q.pop();

				vector<Edge*> out_edges = g.out_edges(v);
				for (int j = 0; j < out_edges.size(); j++) {
					Edge e = *out_edges[j];
					if (live[e.dest] > 0) {
						vertices.push(e.dest);
						threshold.push(live[e.dest]);
						live[e.dest] = live[e.dest] - e.weight;
						if (live[e.dest] <= 0) {
							if (intarget[e.dest])new_active++;
							q.push(e.dest);
							if (inpool[e.dest]) removed.insert(e.dest);
						}
					}
				}
			}

			//recover state of nodes
			while (!vertices.empty()) {
				live[vertices.top()] = threshold.top();

				vertices.pop();
				threshold.pop();
			}

			if (new_active >= max) {
				maxId = u;
				max = new_active;
			}

			for (set<int>::iterator r = removed.begin(); r != removed.end(); r++) {
				pool.erase(*r);
				inpool[*r] = false;
			}

			it = pool.find(u);
			if (it == pool.end()) {
				cout << "errorrr" << endl;
				int a;
				cin >> a;
				break;
			}
			else it++;
		}

		//Select maxid
		int u = maxId;
		pool.erase(u);

		if (live[u] > 0) {
			live[u] = -1;
			if (intarget[u]) nactive++;
		}
		pids.push_back(u);
		queue<int> q;
		q.push(u);
		set<int> removed;
		while (!q.empty()) {
			int v = q.front();
			q.pop();
			vector<Edge*> out_edges = g.out_edges(v);
			for (int j = 0; j < out_edges.size(); j++) {
				Edge e = *out_edges[j];
				if (live[e.dest] > 0) {
					live[e.dest] = live[e.dest] - e.weight;
					if (live[e.dest] <= 0) {
						if (intarget[e.dest])nactive++;
						q.push(e.dest);
					}
				}
			}
		}
		stop = clock();
		of << pids.size() << "\t" << u << "\t" << nactive << "\t" << (nactive/(1.0 * tsize)) << "\t"<< (double) (stop-start)/CLOCKS_PER_SEC << endl;
		cout << pids.size() << "\t" << nactive << "/" <<  tsize << endl;
	}

	return pids;
}
/*
 * Compute the fraction of targeted nodes that are influenced by the source
 */
float influence_propagate(Graph &g, vector<int> source, vector<int> target) {
	int n = g.order();
	vector<float> live(n, 0);

	for (int i=0; i<n; i++) live[i] = g[i].threshold;

	queue<int> q;
	for (int i=0; i<source.size(); i++) {
		q.push(source[i]);
		live[source[i]] = -1;
	}

	while (!q.empty()) {
		int u = q.front();
		q.pop();

		vector<Edge*> out_edges = g.out_edges(u);
		for (int j = 0; j < out_edges.size(); j++) {
			Edge e = *out_edges[j];
			if (live[e.dest] > 0) {
				live[e.dest] = live[e.dest] - e.weight;
				if (live[e.dest] <= 0) {
					q.push(e.dest);
				}
			}
		}
	}

	int c = 0;
	for (int i = 0; i < target.size(); i++) {
		if (live[target[i]] <= 0) c++;
	}

	cout << c << endl;

	return c/(1.0 * target.size());
}




