/*
 * experiment.cpp
 *
 *  Created on: Dec 10, 2012
 *      Author: dung
 */

#include "experiment.h"
#include <iostream>
#include <fstream>
#include <map>
#include "Graph.h"
#include "coupling.h"
#include <time.h>
#include <stdio.h>
#include "maxInfluence.h"
//#include "maxInfluence_dhops.h"
#include "Random.h"
#include <queue>
#include "measure.h"
#include <algorithm>
#include "generateMultiple.h"

void grow(Graph &g, vector<int> pids) {

}

void lossless_exp(){
	for (int i = 1; i<=5; i++) {
		char vertex[20], edge[20], pidsfile[20], seed[20];

		sprintf(vertex, "losslessv%d.txt", i);
		sprintf(edge, "losslesse%d.txt", i);
		sprintf(pidsfile, "lossless%d_pids.txt", i);
		sprintf(seed, "lossless%d_seed.txt", i);

		double fraction = 1;
		Graph *g = new Graph(string(vertex), string(edge));
		vector<int> pids = greedy2(*g, fraction, string(pidsfile));
		ofstream f;
		f.open(seed);
		f << "#Graph info: " << g->order() << " vertices " << g->size() << " edges " << endl;
		for (int j = 0; j < pids.size(); j++) {
			f << pids[j] <<" " << endl;
		}
		delete (g);
	}
}
/*
 * Graphname may be lossless, lossy, t, f
 */
void seedsize(string graphname){
	for (int i = 1; i<=5; i++) {
		char vertex[20], edge[20], pidsfile[20], seed[20];

		sprintf(vertex, "%sv%d.txt", graphname.c_str(), i);
		sprintf(edge, "%se%d.txt",  graphname.c_str(), i);
		sprintf(pidsfile, "%s%d_pids.txt",  graphname.c_str(), i);
		sprintf(seed, "%s%d_seed.txt", graphname.c_str(), i);

		double fraction = 1;
		Graph *g = new Graph(string(vertex), string(edge));
		vector<int> pids = greedy2(*g, fraction, string(pidsfile));
		ofstream f;
		f.open(seed);
		f << "#Graph info: " << g->order() << " vertices " << g->size() << " edges " << endl;
		for (int j = 0; j < pids.size(); j++) {
			f << pids[j] <<" " << endl;
		}
		delete (g);
	}
}

void influence_twitter() {
	string graphname = "lossless";
	for (int i = 1; i<=5; i++) {
		char vertex[20], edge[20], pidsfile[20], seed[20];

		sprintf(vertex, "%sv%d.txt", graphname.c_str(), i);
		sprintf(edge, "%se%d.txt",  graphname.c_str(), i);
		sprintf(pidsfile, "%s_twitter_%d_pids.txt",  graphname.c_str(), i);
		sprintf(seed, "%s_twitter_%d_seed.txt", graphname.c_str(), i);

		double fraction = 1;

		vector<int> source;
		vector<int> target;
		int nf = 44832;
		int nt = 48088;
		int ov = 4100;

		for (int i = 0; i < ov; i++) {
			source.push_back(3*i);
			target.push_back(3*i);
		}

		for (int i = nf; i < nf + nt - ov; i++) {
			source.push_back(3*i);
			target.push_back(3*i);
		}

		Graph *g = new Graph(string(vertex), string(edge));
		vector<int> pids = greedy2(*g, fraction, source, target, string(pidsfile));
		ofstream f;
		f.open(seed);
		f << "#Graph info: " << g->order() << " vertices " << g->size() << " edges " << endl;
		for (int j = 0; j < pids.size(); j++) {
			f << pids[j] <<" " << endl;
		}
		delete (g);
	}
}

void influence_foursquare() {
	string graphname = "lossless";
	for (int i = 1; i<=5; i++) {
		char vertex[20], edge[20], pidsfile[20], seed[20];

		sprintf(vertex, "%sv%d.txt", graphname.c_str(), i);
		sprintf(edge, "%se%d.txt",  graphname.c_str(), i);
		sprintf(pidsfile, "%s_foursquare_%d_pids.txt",  graphname.c_str(), i);
		sprintf(seed, "%s_foursquare_%d_seed.txt", graphname.c_str(), i);

		double fraction = 1;

		vector<int> source;
		vector<int> target;
		int nf = 44832;
		int nt = 48088;
		int ov = 4100;

		for (int i = 0; i < nf; i++) {
			source.push_back(3*i);
			target.push_back(3*i);
		}

		Graph *g = new Graph(string(vertex), string(edge));
		vector<int> pids = greedy2(*g, fraction, source, target, string(pidsfile));
		ofstream f;
		f.open(seed);
		f << "#Graph info: " << g->order() << " vertices " << g->size() << " edges " << endl;
		for (int j = 0; j < pids.size(); j++) {
			f << pids[j] <<" " << endl;
		}
		delete (g);
	}
}

/*
 * Compute the fraction of targeted nodes that are influenced by the source
 */

void grow(Graph &g, vector<int> pids, int n1, int n2, int ov, string file) {
	int n = g.order();
	vector<float> live(n, 0);

	for (int i=0; i<n; i++) live[i] = g[i].threshold;

	int active1 = 0;
	int active2 = 0;
	int activeov = 0;

	queue<int> q;
	for (int i=0; i<pids.size(); i++) {
		int u = pids[i];
		q.push(u);
		live[u] = -1;
		if (u < 3*ov) {
			active1++;
			active2++;
			activeov++;
		} 	 else if (u < 3*n1) {
			active1++;
		} else active2++;
	}

	ofstream f;
	f.open(file.c_str());
	if (!f.is_open()) {
		cerr << "Unable to open file " << file << endl;
	}

	f << "# " << n << " vertices " << g.size() << " edges " << endl;
	f << "#info n = " << n << " n1 = " << n1 << " n2 = " << n2 << " ov = " << ov << endl;
	f << "#Propagation of influence in each network. Columns are | hops | number overlapped active nodes | number of active node in netwokr 1 | number of active nodes in network 2" << endl;
	// Printout hop by hop
	int d = 0;
	f << d << "\t" << activeov << "\t" << active1 << "\t" << active2 << endl;
	while (!q.empty()) {
		int l = q.size();
		d++;
		for (int i = 0; i<l; i++) {
			int u = q.front();
			q.pop();

			vector<Edge*> out_edges = g.out_edges(u);
			for (int j = 0; j < out_edges.size(); j++) {
				Edge e = *out_edges[j];
				if (live[e.dest] > 0) {
					live[e.dest] = live[e.dest] - e.weight;
					if (live[e.dest] <= 0) {
						q.push(e.dest);
						if (e.dest < ov*3) {
							active1++;
							active2++;
							activeov++;
						} else if (e.dest < 3*n1) {
							active1++;
						} else active2++;
					}
				}
			}
		}
		f << d << "\t" << activeov << "\t" << active1 << "\t" << active2 << endl;
	}
	f.close();
}

vector<int> read_pids(string file) {
	ifstream f;
	f.open(file.c_str());
	if (!f.is_open()) {
		cerr << "Unable to open file " << file << endl;
	}
	vector<int> pids;
	string dummy;
	getline(f, dummy);
	while (!f.eof()) {
		int a = -1;
		f >> a;
		if (a > -1) pids.push_back(a);
	}
	return pids;
}

void grow_exp() {
	//	vector<int> pids = read_pids("test.txt");
	//	for (int i=0; i<pids.size(); i++) cout << pids[i] << endl;
	string graphname = "lossless";
	for (int i = 1; i<=5; i++) {
		char vertex[50], edge[50], pidsfile[50], seed[50], seed_t[50], seed_f[50], grow_a[50], grow_t[50], grow_f[50];

		sprintf(vertex, "%sv%d.txt", graphname.c_str(), i);
		sprintf(edge, "%se%d.txt",  graphname.c_str(), i);
		//sprintf(pidsfile, "%s_foursquare_%d_pids.txt",  graphname.c_str(), i);
		sprintf(seed, "%s%d_seed.txt", graphname.c_str(), i);
		sprintf(seed_t, "%s_twitter_%d_seed.txt", graphname.c_str(), i);
		sprintf(seed_f, "%s_foursquare_%d_seed.txt", graphname.c_str(), i);
		sprintf(grow_a, "%s%d_grow.txt", graphname.c_str(), i);
		sprintf(grow_t, "%s_twitter_%d_grow.txt", graphname.c_str(), i);
		sprintf(grow_f, "%s_foursquare_%d_grow.txt", graphname.c_str(), i);

		int nf = 44832;
		int nt = 48088;
		int ov = 4100;


		Graph *g = new Graph(string(vertex), string(edge));
		vector<int> pids = read_pids(string(seed));
		vector<int> pids_t = read_pids(string(seed_t));
		vector<int> pids_f = read_pids(string(seed_f));

		grow(*g, pids, nf, nt, ov, string(grow_a));
		grow(*g, pids_t, nf, nt, ov, string(grow_t));
		grow(*g, pids_f, nf, nt, ov, string(grow_f));
		delete (g);
	}
}

void generate_lossy(){
	for (int i = 1; i<=1; i++) {
		char tv[20], te[20], fv[20], fe[20], losslessv[20],losslesse[20], lossyv[20], lossye[20];
		char lossy_averagev[30], lossy_averagee[30];
		char lossy_involmentv[30], lossy_involmente[30];
		char lossy_easiness2v[30], lossy_easiness2e[30];
		sprintf(tv, "tv%d.txt", i);
		sprintf(te, "te%d.txt", i);
		sprintf(fv, "fv%d.txt", i);
		sprintf(fe, "fe%d.txt", i);
		sprintf(losslessv, "losslessv%d.txt", i);
		sprintf(losslesse, "losslesse%d.txt", i);
		sprintf(lossyv, "lossyv%d.txt", i);
		sprintf(lossye, "lossye%d.txt", i);
		sprintf(lossy_averagev, "lossy_averagev%d.txt", i);
		sprintf(lossy_averagee, "lossy_averagee%d.txt", i);
		sprintf(lossy_involmentv, "lossy_involmentv%d.txt", i);
		sprintf(lossy_involmente, "lossy_involmente%d.txt", i);
		sprintf(lossy_easiness2v, "lossy_easiness2v%d.txt", i);
		sprintf(lossy_easiness2e, "lossy_easiness2e%d.txt", i);

		Graph *g1 = generate("f.txt", string(fv), string(fe), false, true, true);
		//Graph *g1 = new Graph(string(fv), string(fe));
		Graph *g2 = generate("t.txt", string(tv), string(te), false, true, true);
		//Graph *g2 = new Graph(string(tv), string(te));
		cout << g1->order() << " " << g1->size() << endl;
		cout << g2->order() << " " << g2->size() << endl;

		Graph *g4 = lossy_easyness(*g1, *g2, 4100);
		g4->print2file(string(lossyv), string(lossye));
		delete (g4);

		Graph *g5 = lossy_average(*g1, *g2, 4100);
		g5->print2file(string(lossy_averagev), string(lossy_averagee));
		delete (g5);

		Graph *g7 = lossy_easyness2(*g1, *g2, 4100);
		g7->print2file(string(lossy_easiness2v), string(lossy_easiness2e));
		delete (g7);

		Graph *g6 = lossy_involment(*g1, *g2, 4100);
		g6->print2file(string(lossy_involmentv), string(lossy_involmente));
		delete (g6);

		Graph *g3 = clique_scheme(*g1, *g2, 4100);
		g3->print2file(string(losslessv), string(losslesse));
		delete (g3);

		delete (g1);
		delete (g2);
	}
}

void generate_coupling(string fv, string fe, string tv, string te, string name, int ov, bool isweighted) {
	char losslessv[50],losslesse[50], lossyv[50], lossye[50];
	char lossy_averagev[50], lossy_averagee[50];
	char lossy_involmentv[50], lossy_involmente[50];
	char lossy_easiness2v[50], lossy_easiness2e[50];
	sprintf(losslessv, "%s_losslessv.txt", name.c_str());
	sprintf(losslesse, "%s_losslesse.txt",  name.c_str());
	sprintf(lossyv, "%s_lossy_easiness1v.txt",  name.c_str());
	sprintf(lossye, "%s_lossy_easiness1e.txt",  name.c_str());
	sprintf(lossy_averagev, "%s_lossy_averagev.txt",  name.c_str());
	sprintf(lossy_averagee, "%s_lossy_averagee.txt",  name.c_str());
	sprintf(lossy_involmentv, "%s_lossy_involmentv.txt",  name.c_str());
	sprintf(lossy_involmente, "%s_lossy_involmente.txt",  name.c_str());
	sprintf(lossy_easiness2v, "%s_lossy_easiness2v.txt",  name.c_str());
	sprintf(lossy_easiness2e, "%s_lossy_easiness2e.txt",  name.c_str());

	Graph *g1 = generate("f.txt", string(fv), string(fe), isweighted, true, true);
	//Graph *g1 = new Graph(string(fv), string(fe));
	Graph *g2 = generate("t.txt", string(tv), string(te), isweighted, true, true);
	//Graph *g2 = new Graph(string(tv), string(te));
	cout << g1->order() << " " << g1->size() << endl;
	cout << g2->order() << " " << g2->size() << endl;

	Graph *g4 = lossy(*g1, *g2, ov);
	g4->print2file(string(lossyv), string(lossye));
	delete (g4);

	Graph *g5 = lossy_average(*g1, *g2, ov);
	g5->print2file(string(lossy_averagev), string(lossy_averagee));
	delete (g5);

	Graph *g7 = lossy_easyness2(*g1, *g2, ov);
	g7->print2file(string(lossy_easiness2v), string(lossy_easiness2e));
	delete (g7);

	Graph *g6 = lossy_involment(*g1, *g2, ov);
	g6->print2file(string(lossy_involmentv), string(lossy_involmente));
	delete (g6);

	Graph *g3 = clique_scheme(*g1, *g2, ov);
	g3->print2file(string(losslessv), string(losslesse));
	delete (g3);

	delete (g1);
	delete (g2);
}

/*
 * Rearrange the node id such that high degree nodes tend to have small id
 * all ids are mapped to the range from 0 to n - 1
 */
void convert_positive_correlation (string inv, string ine, string outv, string oute, double factor) {
	Graph *g = new Graph(inv, ine);
	int n = g->order();
	int *index = new int[n];
	double *w = new double[n];
	vector<double> ww;
	vector<int> ids = g->vertex_ids();

	for (int i = 0; i < n; i++) {
		index[i] = i;
		Vertex v = (*g)[ids[i]];
		w[i] = v.in_degree + v.out_degree;
	}


	weight_shuffle(index, w, n, factor);

	map<int, int> newid;
	for (int i = 0; i < n; i++) {
		newid[ids[index[i]]] = i;
	}
	ofstream of;
	of.open(outv.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< outv << "\"."<<endl;
		exit(1);
	}
	for (int i = 0; i < n; i++) {
		Vertex v = (*g)[ids[i]];
		of << newid[v.id] << "\t" << v.threshold << "\n";
	}
	of.close();

	//Write edge info
	of.open(oute.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< oute << "\"."<<endl;
		exit(1);
	}

	vector<Edge*> es = g->edge_set();
	for (int i = 0; i < es.size(); i++) {
		Edge e = *es[i];
		of << newid[e.source] << "\t" << newid[e.dest] << "\t" << e.weight << "\n";
	}
	of.close();
	delete [] index;
	delete [] w;
	delete g;
}

void covariance_tf(string file) {
	vector<double> ti, to, fi, fo,f, t;
	ifstream infile;
	//Loading vertex information
	infile.open(file.c_str());
	if (!infile.is_open())
	{
		cerr <<"Unable to open file \""<< file << "\"."<<endl;
		exit(1);
	}

	//int n;
	//infile >> n;//get the number of vertices
	while (!infile.eof())
	{
		int a = -1, b, c, d;
		infile >> a >> b >> c >> d;

		if (a != -1) {
			fi.push_back(a);
			fo.push_back(b);
			ti.push_back(c);
			to.push_back(d);
			f.push_back(a + b);
			t.push_back(c + d);
		}
	}
	infile.close();
	cout << "Foursquare in-out: " << covariance(fi, fo) << endl;
	cout << "Twitter in-out: " << covariance(ti, to) << endl;
	cout << "Fin Tin: " << covariance(fi, ti) << endl;
	cout << "Fout Tout: " << covariance(fo, to) << endl;
	cout << "Ftotal Ttotal: " << covariance(f, t) << endl;

	cout << "Foursquare in-out: " << correlation(fi, fo) << endl;
	cout << "Twitter in-out: " << correlation(ti, to) << endl;
	cout << "Fin Tin: " << correlation(fi, ti) << endl;
	cout << "Fout Tout: " << correlation(fo, to) << endl;
	cout << "Ftotal Ttotal: " << correlation(f, t) << endl;
}

void influence_network(Graph &g, int ov, int n1, int network, double fraction, int d, int t, int r,  string file) {
	vector<int> pool;
	vector<int> target;
	for (int i = 0; i<ov; i++) {
		pool.push_back(i*3);
		target.push_back(i*3);
	}

	if (network == 1) {
		for (int i = ov; i < n1; i++) {
			pool.push_back(i*3);
			target.push_back(i*3);
		}
	} else {
		int n = g.order();
		for (int i = n1; i < n/3; i++) {
			pool.push_back(i*3);
			target.push_back(i*3);
		}
	}

	greedyUpdate(g, fraction, d, t, r, pool, target, file);
}

void scalability(int m, int r) {
	int d = 20;
	int t = 100;
	for (int n = m; n < 11*m; n = n + m) {
		char file[100];
		if (r < 0) {
			sprintf(file, "n_%d_t_%d_d_%d_r_inf.txt",n, t, d);
			Graph *g = ER_generate(n, d/(n*1.0));
			cout << "Doen" << endl;
			greedyUpdate(*g, 0.8, 4, t, n, string(file));
			delete g; }
		else {
			sprintf(file, "n_%d_t_%d_d_%d_r_%d.txt",n, t, d, r);
			Graph *g = ER_generate(n, d/(n*1.0));
			greedyUpdate(*g, 0.8, 4, t, r, string(file));
			delete g;
		}
	}
}

vector<pair<int, int>> read_list(string file) {
	vector<pair<int, int> > list;
	ifstream fin;
	fin.open(file.c_str());
	if (!fin.is_open()) {
		cerr << "File acess denied: " << file << endl;
		exit(1);
	}

	while (!fin.eof()) {
		int u = -1, v = -1;
		fin >> u >> v;
		if (u != 1 && v != -1) {
			list.push_back(pair<int, int> (u, v));

		}
	}
	return list;
}

void generate_chn_coauthor() {
	for (int t = 1; t <= 5; t++) {
		Graph *n = generate("n.txt", "v.txt", "e.txt", true);
		Graph *h = generate("h.txt", "v.txt", "e.txt", true);
		Graph *c = generate("c.txt", "v.txt", "e.txt", true);
		vector<Graph*> ographs;

		ographs.push_back(c);
		ographs.push_back(h);
		ographs.push_back(n);

		vector<vector<vector<pair<int, int> > > > overlap;
		for (int i = 0; i < 3; i++) {
			vector<vector<pair<int, int> > > adj(3);
			/*
			for (int j = 0; j < 3; j++) {
			vector<pair<int, int> > ov;
			adj.push_back(ov);
			}
			 */
			overlap.push_back(adj);
		}

		overlap[0][1] = read_list("ch.txt");
		overlap[0][2] = read_list("cn.txt");
		overlap[1][0] = read_list("hc.txt");
		overlap[1][2] = read_list("hn.txt");
		overlap[2][0] = read_list("nc.txt");
		overlap[2][1] = read_list("nh.txt");

		//for (int i = 0; i < overlap[2][1].size(); i++) {
		//cout << overlap[2][1][i].first << "\t" << overlap[2][1][i].second << endl;
		//}

		char newcv[30], newce[30], newhv[30],  newhe[30],  newnv[30],  newne[30], losslessv[30], losslesse[30];
		sprintf(newcv, "newcv_%d.txt", t);
		sprintf(newce, "newce_%d.txt", t);
		sprintf(newhv, "newhv_%d.txt", t);
		sprintf(newhe, "newhe_%d.txt", t);
		sprintf(newnv, "newnv_%d.txt", t);
		sprintf(newne, "newne_%d.txt", t);
		sprintf(losslessv, "chnlosslessv_%d.txt", t);
		sprintf(losslesse, "chnlosslesse_%d.txt", t);

		vector<Graph*> newgraphs = couple_multiple(ographs, overlap, losslessv, losslesse);

		delete ographs[0];
		delete ographs[1];
		delete ographs[2];

		newgraphs[0]->print2file(newcv, newce);
		newgraphs[1]->print2file(newhv, newhe);
		newgraphs[2]->print2file(newnv, newne);

		delete newgraphs[0];
		delete newgraphs[1];
		delete newgraphs[2];
		cout << t << endl;
	}
}

void generate_lossychn(){
	for (int t = 1; t<=5; t++) {
		char newcv[30], newce[30], newhv[30],  newhe[30], newnv[30],  newne[30], losslessv[30], losslesse[30], involmentv[50], averagev[50], easinessv[50], involmente[50], averagee[50], easinesse[50];
		sprintf(newcv, "newcv_%d.txt", t);
		sprintf(newce, "newce_%d.txt", t);
		sprintf(newhv, "newhv_%d.txt", t);
		sprintf(newhe, "newhe_%d.txt", t);
		sprintf(newnv, "newnv_%d.txt", t);
		sprintf(newne, "newne_%d.txt", t);
		sprintf(losslessv, "chnlosslessv_%d.txt", t);
		sprintf(losslesse, "chnlosslesse_%d.txt", t);
		sprintf(involmentv, "chninvolmentv_%d.txt", t);
		sprintf(involmente, "chninvolmente_%d.txt", t);
		sprintf(averagev, "chnaveragev_%d.txt", t);
		sprintf(averagee, "chnaveragee_%d.txt", t);
		sprintf(easinessv, "chneasinessv_%d.txt", t);
		sprintf(easinesse, "chneasinesse_%d.txt", t);

		Graph *n = new Graph(string(newnv), string(newne));
		Graph *h = new Graph(string(newhv), string(newhe));
		Graph *c = new Graph(string(newcv), string(newce));
		vector<Graph*> ographs;

		ographs.push_back(c);
		ographs.push_back(h);
		ographs.push_back(n);

		vector<map<int, double> > average;
		average.push_back(averagechn(*c));
		average.push_back(averagechn(*h));
		average.push_back(averagechn(*n));
		Graph *lossy_average = lossy(ographs, average);
		lossy_average->print2file(averagev, averagee);
		delete lossy_average;

		vector<map<int, double> > involvement;
		involvement.push_back(involmentchn(*c));
		involvement.push_back(involmentchn(*h));
		involvement.push_back(involmentchn(*n));
		Graph *lossy_involvement = lossy(ographs, involvement);
		lossy_involvement->print2file(involmentv, involmente);
		delete lossy_involvement;

		vector<map<int, double> > easiness;
		easiness.push_back(easinesschn(*c));
		easiness.push_back(easinesschn(*h));
		easiness.push_back(easinesschn(*n));
		Graph *lossy_easiness = lossy(ographs, easiness);
		lossy_easiness->print2file(easinessv, easinesse);
		delete lossy_easiness;

		delete ographs[0];
		delete ographs[1];
		delete ographs[2];

	}
}


