/*
 * Random.h
 *
 *  Created on: Feb 16, 2013
 *      Author: dung
 */

#include<vector>
#include<random>
#include <iostream>
#include <iostream>
#include <math.h>
#include <vector>
#include <stdio.h>      /* printf, scanf, puts, NULL */
#include <stdlib.h>

using namespace std;

class	Random {
private:
	mt19937 eng;
	uniform_real_distribution<double> dist;
public:
	Random(unsigned long sd=0) {
		eng.seed(sd);
	}

	double gen() {	return dist(eng);}
	double genDouble(double min, double max) {	return min + (max - min) * dist(eng);}
	int genInt(int min, int max) {	return int(min + floor(dist(eng)*(max - min)  + 0.5));}
};

int random(int min, int max);
double random(double min, double max);
void shuffle(int* a, int n);
void weight_shuffle(int *a, double *w, int n, double factor);
int* random_index(double *w, int n, double factor);
vector<int> rand_comb(int k, int n);
int random_sequence(double **seq, double *values, double *dis, int n, int s);
int degree_sequence(int **degs, int n, int k, double beta);
