/*
 * Util.cpp
 *
 *  Created on: Dec 5, 2011
 *      Author: dung
 */

#include "Random.h"
#include <iostream>
#include <math.h>
#include <vector>
#include <stdio.h>      /* printf, scanf, puts, NULL */
#include <stdlib.h>
#define FOR(i, n) for (int i = 0; i < n; i++)
#define MIN(a, b) ( a > b ? b : a)

using namespace std;

int random(int min, int max) {
	int result = min + floor(rand()/(RAND_MAX*1.0)*(max - min)  + 0.5);
	return result;
}

double random(double min, double max) {
	return  (min + rand()/(RAND_MAX*1.0) *(max - min));
}

void shuffle(int* a, int n) {
	a = new int[n];
	if (!a) {
		a = 0;
		return;
	}

	for (int i = 0; i < n; i++) a[i] = i;

	for (int i = 0; i < n; i++) {
		int j = random(i, n-1);
		int b = a[i];
		a[i] = a[j];
		a[j] = b;
	}
}

void weight_shuffle(int *a, double *weight, int n, double factor) {
	Random *rd = new Random();
	double sum = 0;
	double *w = new double[n];

	if(!a || !w) {
		cout<< "Memory allocation error!" << endl;
		return;
	}

	for (int i = 0; i < n; i++) {
		w[i] = pow(weight[i], factor);
		sum = sum + w[i];
	}
	for (int i = 0; i < n - 1; i++) {
		double rsum = rd->genDouble(0.0, sum);
		double temp = 0;
		for (int j = i; j<n; j++) {
			if (temp + w[j] >= rsum){
				int tg = a[i];
				a[i] = a[j];
				a[j] = tg;
				sum = sum - w[j];
				w[j] = w[i];
				break;
			}
			temp += w[j];
		}
	}
	delete [] w;
}

int* random_index(double *w, int n, double factor) {
	int *a = new int[n];
	for (int i = 0; i < n; i++) a[i] = i;
	weight_shuffle(a, w, n, factor);

	return a;
}

/*
 * Generate a random combination of k numbers from 0 to n - 1
 */
vector<int> rand_comb(int k, int n) {
	vector<int> comb(k);
	vector<int> source(n);
	for (int i = 0; i < n; i++) source[i] = i;
	for (int i = 0; i < k; i++) {
		int index = random(0, n - i -1);
		int element = source[index];
		source[index] = source[n-i-1];
		comb[i] = element;
	}
	return comb;
}

/*
 * Return the index i such that range[i - 1] < value <= range[i]
 */
int range_search(double *range, double value, int n) {
	if (!range) {
		cout << "Memory allocation error!";
		return -2;
	}

	if (value > range[n-1]) return -1;
	if (value <= range[0]) return 0;

	int l=0, h=n-1;
	while (l+1<h) {
		int m = (l+h)/2;
		if (range[m] >= value) h = m;
		else l = m;
	}

	return h;
}

int random_sequence(double **seq, double *values, double *dis, int n, int s) {
	if (!dis || !values) {
		cout << "Memory allocation error!" << endl;
		return 1;
	}

	double *cdf = new double[s];
	if (!cdf) {cout << "Memory allocation error!" << endl;return 1;}

	cdf[0] = dis[0];

	FOR (i, s - 1) {
		cdf[i+1] = cdf[i] + dis[i+1];
		//	cout << cdf[i+1] << endl;
	}

	*seq = new double[n];
	if (!*seq) {cout << "Memory allocation error!" << endl; delete [] cdf;return 1;}

	FOR (i, n) {
		double r = random(0.0, cdf[s-1]);
		int index = range_search(cdf, r, s);
		//cout << r << " " << index << endl;
		(*seq)[i] = values[index];
	}

	delete [] cdf;

	return 0;
}

int degree_sequence(int **degs, int n, int k, double beta) {

	int cutoff = (int) k*pow(n, 1/(beta-1));
	cutoff = MIN(cutoff, n-1);

	double *dis = new double[cutoff];
	double *values = new double[cutoff];
	*degs = new int[n];
	if (!dis || !values || !degs || k>=n) {
		cout << "Memory allocation error!" << endl;
		if (dis) delete [] dis;
		if (values) delete [] values;
		if (*degs) delete [] (*degs);
		return 1;
	}

	FOR (i, cutoff) {
		values[i] = i+1;
		dis[i] = pow(i+1, -beta);
	}
	double max = dis[k-1];

	FOR (i, k) {
		dis[i] = (max/2) * (1 + (i+1)*1.0/k);
	}

	double *seq;
	if (random_sequence(&seq, values, dis, n, cutoff)) return 1;


	FOR (i, n) {
		(*degs)[i] = (int) seq[i];
	}

	delete [] dis;
	delete [] values;
	delete [] seq;

	return 0;
}
