/*
 * Graph.h
 *
 *  Created on: Oct 22, 2012
 *      Author: seven
 */
#include <vector>
#include <string>
#include <map>

using namespace std;

#ifndef GRAPH_H_
#define GRAPH_H_

class Edge{
public:
	Edge(int _source, int _dest, float _weight) {
		source = _source;
		dest = _dest;
		weight = _weight;
	}
	~Edge(){};
	int source;
	int dest;
	float weight;
};

class Vertex{
public:
	int id;
	float threshold;
	int in_degree;
	int out_degree;
	vector<int> in_neighbors;
	vector<int> out_neighbors;

	Vertex(int _id, float _threshold) {
		id = _id;
		threshold = _threshold;
		in_degree = 0;
		out_degree = 0;
		in_neighbors.clear();
		out_neighbors.clear();
	};

	~Vertex(){
		in_neighbors.clear();
		out_neighbors.clear();
	}

};

class Graph {
private:
	map<int, Vertex*> vertices;
	map<pair<int, int>, Edge*> edges;
public:
	Graph();
	Graph(string vertex_info, string edge_info);
	int size();
	int order();

	//Vertex operators
	bool is_vertex(int vertex_id);
	bool add_vertex(int vertex_id, float threshold);

	Vertex& operator[] (int id);
	Vertex& operator() (int id);

	int in_degree(int vertex_id);
	int out_degree(int vertex_id);

	vector<int> in_neighbor_ids(int vertex_id);
	vector<int> out_neighbor_ids(int vertex_id);

	vector<Vertex*> in_neighbors(int vertex_id);
	vector<Vertex*> out_neighbors(int vertex_id);

	vector<Edge*> in_edges(int vertex_id);
	vector<Edge*> out_edges(int vertex_id);

	//Edge operators
	bool is_edge (int source, int dest);
	bool add_edge(int source, int dest, float weight);

	Edge& operator() (int source, int dest);

	//Graph operators
	void remove_half();
	vector<int> vertex_ids();
	vector<Vertex*> vertex_set();
	vector<Edge*> edge_set();

	void print();
	void print2file(string vertex, string edge);
	virtual ~Graph();
};

#endif /* GRAPH_H_ */
