/*
 * Graph.cpp
 *
 *  Created on: Oct 22, 2012
 *      Author: seven
 */

#include "Graph.h"
#include <fstream>
#include <iostream>
#include <stdlib.h>

Graph::Graph() {
	// TODO Auto-generated constructor stub
	vertices.clear();
	edges.clear();
}

Graph::Graph(string vertex_info, string edge_info) {
	ifstream infile;
	//Loading vertex information
	infile.open(vertex_info.c_str());
	if (!infile.is_open())
	{
		cerr <<"Unable to open file \""<< vertex_info << "\"."<<endl;
		exit(1);
	}

	//int n;
	//infile >> n;//get the number of vertices
	while (!infile.eof())
	{
		int id = -1;
		float threshold;

		infile >> id;
		infile >> threshold;

		if (id != -1) add_vertex(id, threshold);
	}
	infile.close();

	//Loading edge information
	infile.open(edge_info.c_str());
	if (!infile.is_open())
	{
		cout <<"Unable to open file \""<< edge_info << "\"."<<endl;
		exit(1);
	}

//	int m;
//	infile >> n;//get the number of nodes in edge information
//	infile >> m;
	while (!infile.eof())
	//for(int i = 0; i < m; i++)
	{
		int source = -1, dest = -1;
		float weight;

		infile >> source;
		infile >> dest;
		infile >> weight;

		if (source + dest != -2) add_edge(source, dest, weight);
	}
	infile.close();
}

/*
 * The number of vertices
 */
int Graph::order(){
	return vertices.size();
}

/*
 * The number of edges
 */
int Graph::size() {
	return edges.size();
}

/*
 * Check whether a vertex with given id exists or not
 */
bool Graph::is_vertex(int vertex_id) {
	return vertices.find(vertex_id) != vertices.end();
}

/*
 * Add a new vertex
 * Return false if the vertex id exists
 */
bool Graph::add_vertex(int vertex_id, float threshold) {
	if (is_vertex(vertex_id)) // the id exists
		return false;

	vertices[vertex_id] = new Vertex(vertex_id, threshold);

	return true;
}

Vertex& Graph::operator[] (int id) {
	return *vertices[id];
}

Vertex& Graph::operator() (int id) {
	return *vertices[id];
}

/*
 *Get the in-degree of a vertex
 */
int Graph::in_degree(int vertex_id){
	return vertices[vertex_id]->in_neighbors.size();
}

/*
 *Get the out-degree of a vertex
 */
int Graph::out_degree(int vertex_id){
	return vertices[vertex_id]->out_neighbors.size();
}

/*
 * Return list of in-neighbors' ids
 */
vector<int> Graph::in_neighbor_ids(int vertex_id){
	return vertices[vertex_id]->in_neighbors;
}

/*
 * Return list of out-neighbors' ids
 */
vector<int> Graph::out_neighbor_ids(int vertex_id){
	return vertices[vertex_id]->out_neighbors;
}

/*
 * return list of in-neighbors
 */
vector<Vertex*> Graph::in_neighbors(int vertex_id) {
	vector<int> neisId = vertices[vertex_id]->in_neighbors;
	vector<Vertex*> neis(neisId.size());
	for (int i = 0; i < neisId.size(); i++) {
		neis[i] = vertices[ neisId[i] ];
	}
	return neis;
}

/*
 * return list of out-neighbors
 */
vector<Vertex*> Graph::out_neighbors(int vertex_id) {
	vector<int> neisId = vertices[vertex_id]->out_neighbors;
	vector<Vertex*> neis(neisId.size());
	for (int i = 0; i < neisId.size(); i++) {
		neis[i] = vertices[ neisId[i] ];
	}
	return neis;
}

/*
 * Return list of in-edges
 */
vector<Edge*> Graph::in_edges(int vertex_id) {
	vector<int> neisId = vertices[vertex_id]->in_neighbors;
	vector<Edge*> inedges(neisId.size());
	for (int i = 0; i < neisId.size(); i++) {
		inedges[i] = edges[ pair<int, int>(neisId[i], vertex_id)];
	}
	return inedges;
}

/*
 * Return list of out-edges
 */
vector<Edge*> Graph::out_edges(int vertex_id) {
	vector<int> neisId = vertices[vertex_id]->out_neighbors;
	vector<Edge*> outedges(neisId.size());
	for (int i = 0; i < neisId.size(); i++) {
		outedges[i] = edges[ pair<int, int>(vertex_id, neisId[i])];
	}
	return outedges;
}

/*
 * Check whether an edge exists or not
 */
bool Graph::is_edge (int source, int dest) {
	return (edges.find(pair<int, int>(source, dest)) != edges.end());
}

/*
 * Return true if both endpoints exist and the edge is new
 */
bool Graph::add_edge(int source, int dest, float weight) {
	if (!is_vertex(source) || !is_vertex(dest))
		return false;
	if (is_edge(source, dest))
		return false;

	edges[pair<int, int>(source, dest)] = new Edge(source, dest, weight); // add new edge

	vertices[source]->out_neighbors.push_back(dest);
	vertices[source]->out_degree++;
	vertices[dest]->in_neighbors.push_back(source);
	vertices[dest]->in_degree++;

	return true;
}

Edge& Graph::operator() (int source, int dest) {
	return *edges[pair<int, int> (source, dest)];
}

void Graph::remove_half() {
	int n = order();
	n = n/2;
	vector<pair<int, int> > es;
	for (map<pair<int, int>, Edge*>::iterator it = edges.begin(); it != edges.end(); it++) {
		pair<int, int> sd = (*it).first;
		if (sd.first > n || sd.second > n) es.push_back(sd);
	}

	for (int i=0; i<es.size(); i++) {
		delete (edges[es[i]]);
		edges.erase(es[i]);
	}

	vector<int> vs;
	for (map<int, Vertex*>::iterator it = vertices.begin(); it != vertices.end(); it++) {
		if ((*it).first > n ) vs.push_back((*it).first);
	}
	for (int i=0; i<vs.size(); i++) {
		delete (vertices[vs[i]]);
		vertices.erase(vs[i]);
	}
}

/*
 * Return set of vertices ids
 */
vector<int> Graph::vertex_ids() {
	vector<int> vs;

	for (map<int, Vertex*>::iterator it = vertices.begin(); it != vertices.end(); it++) {
		vs.push_back((*it).first);
	}

	return vs;
}

/*
 * Return the set of vertices
 */
vector<Vertex*> Graph::vertex_set() {
	vector<Vertex*> vs;

	for (map<int, Vertex*>::iterator it = vertices.begin(); it != vertices.end(); it++) {
		vs.push_back((*it).second);
	}

	return vs;
}

vector<Edge*> Graph::edge_set() {
	vector<Edge*> es;
	for (map<pair<int, int>, Edge*>::iterator it = edges.begin(); it != edges.end(); it++) {
		es.push_back((*it).second);
	}
	return es;
}

void Graph::print2file(string vertex, string edge) {
	ofstream of;
	//Loading vertex information
	of.open(vertex.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< vertex << "\"."<<endl;
		exit(1);
	}
	//cout << "Node information: "<< endl;
	for (map<int, Vertex*>::iterator it = vertices.begin(); it != vertices.end(); it++) {
		Vertex v = *(*it).second;
		of << v.id << "\t" << v.threshold<< "\n";
	}
	of.close();

	//Write edge info
	of.open(edge.c_str());
	if (!of.is_open()) {
		cerr <<"Unable to open file \""<< edge << "\"."<<endl;
		exit(1);
	}

	for (map<pair<int, int>, Edge*>::iterator it = edges.begin(); it != edges.end(); it++) {
		Edge e = *(*it).second;
		of << e.source << "\t" << e.dest << "\t" << e.weight << "\n";
	}
	of.close();
}

/*
void Graph::print() {
	cout << "Node information: "<< endl;
	for (map<int, Vertex*>::iterator it = vertices.begin(); it != vertices.end(); it++) {
		Vertex v = *(*it).second;
		cout << v.id << " " << v.threshold << endl;
		//for (int i = 0 ; i < v.out_neighbors.size(); i++) cout << v.out_neighbors[i] << " ";
	}

	cout << "Edge information: " << endl;
	for (map<int, Vertex*>::iterator it = vertices.begin(); it != vertices.end(); it++) {
		int id = (*it).second->id;
		vector<Edge*> es = out_edges(id);

		if (es.size() > 0) {
			//cout << id << " to ";
			for (int i = 0; i < es.size(); i++) {
				of << es[i]->dest << "(" << es[i]->weight << ") ";
			}
			of << endl;
		}
	}
}
 */
Graph::~Graph() {
	// TODO Auto-generated destructor stub
	//Delete all vertices
	for (map<int, Vertex*>::iterator it = vertices.begin(); it != vertices.end(); it++) {
		delete((*it).second);
	}
	vertices.clear();

	for (map<pair<int, int>, Edge*>::iterator it = edges.begin(); it != edges.end(); it++) {
		delete((*it).second);
	}
	edges.clear();
}
