/*
 * Converter.h
 *
 *  Created on: Aug 26, 2012
 *      Author: dung
 */

#include <string>
#include <sstream>

#ifndef CONVERTER_H_
#define CONVERTER_H_

using namespace std;

class Converter {
public:
	Converter(){};

	/*
	 * Convert from data one type to another type
	 */
	template<class T, class U>
	static U convert(T in);	virtual ~Converter();

	/*
	 * Convert anything to string
	 */
	template<class T>
	static string to_string(T in);

	template<class T>
	static T string_to_number(string text);

	template<class T>
	static string n2s(T in){
		return to_string<T> (in);
	}

	template<class T>
	static T s2n(string text){
		return string_to_number<T> (text);
	}
};

template<class T, class U>
U Converter::convert(T in){
	ostringstream in_convert;
	in_convert << in;
	istringstream out_convert(in_convert.str());
	U out;
	out_convert >> out;
	return out;
}

template<class T>
T Converter::string_to_number(string text){
    istringstream ss(text);
    T result;
    return ss >> result ? result : 0;
}

template<class T>
string Converter::to_string(T in){
    ostringstream ss;
     ss << in;
     return ss.str();
}

#endif /* CONVERTER_H_ */
