/*
 * ip.cpp
 *
 *  Created on: May 9, 2011
 *      Author: Thang N. Dinh, CISE, UF
 */
#include "gurobi_c++.h"
#include "clustering.h"
#include "generalGraph.hpp"
#include "graphAlgorithm.hpp"
#include "edgeMap.hpp"
#include "lemonConversion.hpp"
#include "config.hpp"
#include "common.h"
#include "ip.h"
#include "clustering.h"
#include "callback.h"
#include "ModularityMetric.h"
#include <lemon/list_graph.h>
#include <lemon/preflow.h>
#include <ctime>
#include <queue>
#include <cstdlib>
#include <cstdio>
#include <string>
#include <vector>
#include <algorithm>
#include <limits>
#include <numeric>
#include <functional>
#include <sstream>
#include <ctime>

using namespace std;

extern	 Configuration	*par;

using namespace std;

int add_triangle_inequalities(vector<vector<double> > &xm, GRBModel &model,   GRBVar** x) {
	double dif, bestij;
	int bij, n = xm.size();
	vector<Triple> pq;
	FOR(i, n)
	FOR(j,i) {
		bestij = 0;
		FOR(k, n)
		if (k != i && k !=j ) {
			dif = MT(xm, i, k)+	MT(xm, k, j) - xm[i][j];
			if (dif < bestij) {
				bestij = dif;
				bij = k;
			}
		}// if
		if (bestij < -1e-3)
			pq.push_back( Triple(i, j, bij, bestij) );
	}// for
	int count  = 0;
	FOR(it, pq.size() ) {
		int i = pq[it].i, j = pq[it].j, k = pq[it].k;
		count++;
		if (count >= 200)
			break;
		model.addConstr( MT(x,i,k)+ MT(x, k,j) - x[i][j] >= 0);
	}
	return count;
}


int add_2partitioning_cuts1(vector<vector<double> > &xm, GRBModel &model,   GRBVar** x) {
	int count = 0, n = xm.size();
	FOR(u, n) {
		vector<pair<double, int> > W;
		FOR( v, n)
			if (v != u && (MT(xm, u,v) > 1e-6) && (MT(xm, u, v) < 1-(1e-6)) )
				W.push_back( make_pair(MT(xm, u, v), v) );
		sort( W.begin(), W.end() );
		while (W.size() > 2 ) {
			vector<int> T;
			double dif = 0;
			FOR(j, W.size() ) {
				bool zrd = true;
				int  w   = W[j].second;
				FOR(k, T.size() )
					if ( MT(xm, w, T[k])  < 1-(1e-6) ) {
						zrd = false;
						break;
					}
				if (zrd) {
					T.push_back(w);
					dif += 1 - W[j].first;
				}
			}
			if ( (dif > (1 + 1e-3)) && T.size() > 2) {
				count++;
				GRBLinExpr stc;
				FOR(k, T.size() )
					 stc += 1 - MT(x, u, T[k]);
				FOR(i, T.size() )
				 FOR(j, i)
				 	 stc -= 1 - MT(x, T[i], T[j]);
				model.addConstr(stc <= 1);
				break;
			}
			W.erase( W.begin() );
		}
	}
	return count;
}

int add_2partitioning_cuts2(vector<vector<double> > &xm,GRBModel &model,   GRBVar** x) {
	int count = 0, n = xm.size();
	FOR(u, n) {
		vector<pair<double, int> > W;
		FOR( v, n)
			if (v != u && (MT(xm, u,v) > 1e-6) && (MT(xm, u, v) < 1-(1e-6)) )
				W.push_back( make_pair(MT(xm, u, v), v) );
		sort( W.begin(), W.end() );
		while (W.size()>2 ) {
			vector<int> T;
			double dif = 0;
			FOR(j, W.size() ) {
				double zrd = 0;
				int  w   = W[j].second;
				FOR(k, T.size() )
					zrd += 1- MT(xm, w, T[k]);
				if ( (zrd+1e-4 ) < 1 - W[j].first) {
					T.push_back(w);
					dif += 1 - W[j].first - zrd;
				}
			}
			if ( (dif > (1 + 1e-4)) && T.size() > 2) {
				count++;
				GRBLinExpr stc;
				FOR(k, T.size() )
					 stc += 1 - MT(x, u, T[k]);
				FOR(i, T.size() )
				 FOR(j, i)
				 	 stc -= 1 - MT(x, T[i], T[j]);
				model.addConstr(stc <= 1);
				break;
			}
			W.erase(W.begin() );
		}
	}
	return count;
}


vector<Triple>  tri_min_degree(GeneralGraph<double> &g) {
    cout <<"Starting model: MIN DEGREE"<<endl;
    vector<Triple> result;    
    result.clear();
    //EdgeMap<double>	 em(g);
    int n  = g.size();
    FOR(i, n)
        FOR(j, i)
        //if (!em.isEdge(i, j))
        {
          int u = (g.degree(i) < g.degree(j))? i : j;
          NEIGHBORS(g,u, k)
            if (k != i && k != j)
                result.push_back(Triple(i, j, k, 0));
        }
    return result;
}

vector<Triple>  tri_full(GeneralGraph<double> &g) {
    cout <<"Starting model: COMPLETE"<<endl;
    vector<Triple> result;    
    int n  = g.size();
    FOR(i, n)
      FOR(j, i)
          FOR(k, n)
            if (k != i && k != j)
                result.push_back(Triple(i, j, k, 0));      
    return result;
}

vector<Triple>  tri_vertex_cut(GeneralGraph<double> &g) {
    cout <<"Starting model: VERTEX CUT"<<endl;    
    vector<Triple> result;    
    int n = g.size();
    LemonGraph<double>	lg(g);
    FOR(i, lg.n) {
    	ListDigraph::Node oi = lg.g.split( lg.id[i]);
    	lg.id.push_back(oi);
    	lg.rid[ oi ] = i + n;
    }
    vector< vector<int> >  arcMatrix( n, vector<int>(n, -1));
    ListDigraph::ArcMap<int> w(lg.g, 3 *n );// Sufficient large edge capacities
//    int p1, p2, p3,p4;
//    p1 = p2 = p3 = p4 = 0;
    for(ListDigraph::ArcIt e(lg.g); e != INVALID; ++e) {
    	int t = lg.rid[ lg.g.target(e)], s = lg.rid[ lg.g.source(e)];
    	if (t - s ==n )
    		w[e]  = 1; // Nodes have capacities one
    	arcMatrix[s % n][t % n] = lg.g.id(e);
//    	if (p1 < 100) {
//    		cout << s <<"\t"<<t<<"\t"<<arcMatrix[s%n][t%n]<<endl;
//    		cout.flush();
//    	}
//    	p1++;
    }
    Preflow<ListDigraph> flow(lg.g, w, lg.id[0], lg.id[n]);
    EdgeMap<double> em(g);
    int  vc = 0, md = 0;
    FOR(i, n)
      FOR(j, i)
    //  if (!em.isEdge(i, j) )
      {
    	  flow.source(lg.id[i + n]);
    	  flow.target(lg.id[j]);
    	  int mij= min(g.degree(i), g.degree(j) ), cij = 0;
    	  if (em.isEdge(i, j)) { // Remove the direct edge
//    		  if (p2 < 100) {
//    			  cout <<"---"<<i<<"\t"<<j<<"\t"<<arcMatrix[i][j]<<endl;
//    			  cout.flush();
//    		  }
//    		  p2++;
    		  w[ lg.g.arcFromId(arcMatrix[i][j]) ] = 0;
    		  w[ lg.g.arcFromId(arcMatrix[j][i]) ] = 0;
    		  mij--;
    		  flow.capacityMap(w);
    	  }
          flow.run();

          if (em.isEdge(i, j)) {
//        	   cout <<"VC ("<<setw(4)<<i<<setw(4)<<j<<"): "<<setw(4)<<flow.flowValue()<<setw(4)<<mij<<endl;
        	   w[ lg.g.arcFromId(arcMatrix[i][j]) ] = 3 * n;
        	   w[ lg.g.arcFromId(arcMatrix[j][i]) ] = 3 * n;
        	   flow.capacityMap(w);
          }
          vc+= flow.flowValue();
          md+= mij;          
          //cout <<"VC ("<<setw(4)<<i<<setw(4)<<j<<"): "<<setw(4)<<flow.flowValue()<<setw(4)<<mij<<endl;
          FOR(k, n) {              
              if ( (k!=i) && (k!=j) && flow.minCut(lg.id[k]) && !flow.minCut(lg.id[k+n]) ) {
                cij++;
          		result.push_back(Triple(i, j, k, 0));
              }
          }
          if (cij != flow.flowValue() || mij < cij) {
              cout<<"Mismatched vertex cut size for "<<i <<"\t"<<j<<"\t"<<cij<<"\t"
                  <<flow.flowValue()<<"\t"<<mij<<endl;
              return result;
          }
      }      
    cout <<"Total cut sizes (#constraints): "<<setw(7)<<vc<<" ("<<setprecision(4)<<vc*100.0/(1.0*md)<<" % min degree.)"<<endl;
    return result;
}

void    basic_modularity_modelling(GeneralGraph<double> &g,
                                 GRBModel &model,
                                 GRBVar** &x,
                                 vector<string> grb_files=vector<string>(0),
                                 double total_edge_weights = 0)
{
    int n = g.size(); // Number of vertices
    if (total_edge_weights < 1e-8)
    	total_edge_weights = accumulate(g.Weight(0), g.Weight(n), (double)0.0);
    // Create variables
    x = new GRBVar*[n];
    vector<double> lb(n, 0), ub(n, 1);
if (par->exists("lp")) {
    FOR(i, n)
    	x[i]= model.addVars(NULL, // Lower bound 0
    						&ub[0],
    						NULL, // No objective
    						NULL, // GRB_CONTINUOUS
    						NULL, // No names
    						i);
} else {
    FOR(i,n)
        x[i] = model.addVars(i, GRB_BINARY);
}

    // Integrate new variables
    model.update();
    // Add objective
    vector< vector<double> > m(n, vector<double>(n,0) );
    FOR(i, n)
    	FOR(j, i)
    		m[i][j] = -g.wdeg_in(i) * g.wdeg_out(j) -g.wdeg_in(j) * g.wdeg_out(i);
    ALL_EDGES(g,h,t)
        	if (h > t)
        		m[h][t] += total_edge_weights * g.edw(id);
        	else
        		m[t][h] += total_edge_weights * g.edw(id);
    FOR(i, n)
        FOR(j, i)
    		x[i][j].set(GRB_DoubleAttr_Obj, m[i][j]);
    

    // Turn off the presolve
    // model.getEnv().set(GRB_IntParam_Presolve, 0);
    
	GRBEnv menv = model.getEnv();
    //menv.set(GRB_IntParam_LPMethod, LP_METHOD);        // Solving LP with selected method
    //menv.set(GRB_IntParam_Method, ROOT_METHOD);   // Root relaxation selection
    menv.set(GRB_StringParam_LogFile, "modularityGurobi.log");
    menv.set(GRB_IntParam_PreCrush, 1);
    menv.set(GRB_IntParam_PrePasses, 3);
    if (par->exists("barrier"))
    	menv.set(GRB_IntParam_Method, 2); // barrier method
    if (par->exists("dual"))
        	menv.set(GRB_IntParam_Method, 1);// Dual simplex
    if (par->exists("primal"))
           	menv.set(GRB_IntParam_Method, 0);// Primal simplex
    //menv.set(GRB_IntParam_MIPFocus, 2); // 2 = Proving optimality
    //menv.set(GRB_IntParam_DisplayInterval, 3 * 60);     // 3 minutes
    //menv.set(GRB_IntParam_OutputFlag, 0);
    FOR(i, grb_files.size())
        model.read( grb_files[i] );
    model.update();
}


/**
 * Find a cluster with maximal modularity using the full Integer programming formula
 * @param g		Graph
 * @param init	Membership vector of a heuristic solution. Ignored if the length is different from the number of vertices.
 * @param total_edge_weights Overwrite the number of edges/arcs in the graph. It can be considered as the scaling factor. Ignored if not positive.
 * @param method    1: Full ip
 *                  2: For a pair of vertices (u, v), add all triple (u, v, k) for k is neighbors of u (assuming deg(u)<=deg(v)).
 * @return Membership array of a clustering with optimal (scaling) modularity
 */
Membership	modularity_ip( 
     GeneralGraph<double> &g, 
     const Membership& init, 
     IpModel im, 
     CuttingMethod cm, 
     vector<string> grb_files,
     bool unweighted_preprocess,
     double total_edge_weights)
{	
    clock_t start = clock();
    int n = g.size();
    Membership mbs(n, -1);
    if (total_edge_weights < 1e-8)
    	total_edge_weights = accumulate(g.Weight(0), g.Weight(n), (double)0.0);
    try {        
        GRBEnv env = GRBEnv();
        GRBModel model = GRBModel(env);
        model.getEnv().set(GRB_DoubleParam_MIPGap,1e-5);
        GRBVar **x;
        basic_modularity_modelling(g, model, x, grb_files,  total_edge_weights);
        // Set initial solution if provided                   
        if ((int)init.size() == n) {
           FOR(i,n)
             FOR(j, i)          
                if (init[i] == init[j])
                  x[i][j].set(GRB_DoubleAttr_Start, 0.0);        
                else
                  x[i][j].set(GRB_DoubleAttr_Start, 1.0);
           // Set the upper bound for the objective
//			GRBLinExpr obj_bound;
//			double 	   upper_bound = 0;
//			   FOR(i, n)
//				FOR(j, i) {
//					double cij = x[i][j].get(GRB_DoubleAttr_Obj);
//					if (init[i]==init[j])
//						upper_bound +=	 cij;
//					obj_bound += x[i][j] * cij;
//				}
//			model.addConstr(obj_bound <= upper_bound);
        }

        // Set the callback function
        GRBCallback *cb = NULL;
        if (CM_AGGRESSIVE == cm) {
                cb = new mycallback_aggressive(&model, x, g);                 
                model.setCallback( (mycallback_aggressive*)(cb));                
        }
        if (unweighted_preprocess) {
            vector< vector<int> > cc = connected_components(g);
            cout <<"Number of connected components: "<<setw(4)<<cc.size()<<" Sizes: ";
            FOR(i, cc.size() )
                 cout << setw(4)<<cc[i].size();
            cout << endl;            
            // Nodes in different components will be in different clusters
            int nec = 0;
            FOR(i, cc.size() )
                FOR(j, i)
                    FOR(u, cc[i].size())
                        FOR(v, cc[j].size()) {
                            int a = cc[i][u], b= cc[j][v];
                            if (a < b) 
                                std::swap(a, b);
                            nec++;
                            x[a][b].set(GRB_DoubleAttr_UB,1);
                            x[a][b].set(GRB_DoubleAttr_LB,1);
                        }
            cout <<"Number of edges presolved: "<< nec << endl;
            // Each node must be connected to at least one neighbor                                                
            int nLeaves = 0;
            FOR(u, n) 
               if (g.degree(u) > 0) {
                if (g.degree(u) == 1) {
                    nLeaves++;
                    model.addConstr(MT(x, u, g[u][0]) == 0);
                } else {
					GRBLinExpr dtot;
					NEIGHBORS(g, u, v)
						dtot += MT(x, u, v);
					model.addConstr(dtot <= g.degree(u) - 1);
                }
               }                
            cout <<"Number of leaves: "<<nLeaves<<endl;                        
            // Find cut vertices in the graph
            int cut_constraint=0, ncut_vertex=0;
            bool vccut = par->exists("vccut");
            FOR(u, n) {
                vector<bool> visited(n, false);
                visited[u] = true;
                vector< vector<int> > ccu;                
                NEIGHBORS(g, u, v) 
                    if (!visited[v])                        
                        ccu.push_back( bfs(g, v, visited) );
                int cus = ccu.size();
                if (cus > 1) {                    
                    ncut_vertex++;
                    if (vccut) {  // default no vertex cut
						FOR(i, cus)
							FOR(j, i)
							 if (ccu[i].size() > 2 && ccu[j].size() > 2)
								FOR(a, ccu[i].size())
									FOR(b, ccu[j].size()) {
										int av = ccu[i][a],
											bv = ccu[j][b];
										model.addConstr(  MT(x, av, bv) >= MT(x, av, u));
										model.addConstr(  MT(x, av, bv) >= MT(x, bv, u));
										cut_constraint+=2;
									}
                    }
                }               
            }
            cout <<"Number of vertex cut: "<<setw(6)<<ncut_vertex<<" Cut constraint(s): "<< setw(6)<<cut_constraint<<endl;
            // Find 3-cycle            
            int c3 = 0;
            FOR(u, n)
                if (g.degree(u) == 2) {
                    int a = g[u][0], b= g[u][1];
                    if (g.degree(b) == 2) 
                        std::swap(a, b);
                    if ((g.degree(a) == 2) && (u > a)) {
                        int c = (g[a][0] == u)?g[a][1]:g[a][0];
                        if (c == b) {
                            model.addConstr( x[u][a]==0);
                            model.addConstr( MT(x, u, b) == 0);
                            model.addConstr( MT(x, a, b) == 0);
                            cout <<"3-cycle: "<<setw(6)<<c<<setw(6)<<a<<setw(6)<<u<<endl;
                            c3++;
                        } // if c==b
                    } // if g.deg(b)
                } // if g.deg(u)
             cout <<"Number of 3-cycle(s): "<<setw(6)<< c3 << endl;
             // Number of node pairs with the same set of neighbors
             int nTwin = 0;
             int maxTwinDegree = (int)(2 * sqrt((double)g.Arcs()));
             FOR(u, n)
              NEIGHBORS(g, u, v)
              	if (u > v && g.degree(u) > 2 && (g.degree(u)+g.degree(v) <= maxTwinDegree) )  {
            	vector<int>	 mask(n, 0);
            	mask[u]++; mask[v]--;
            	FOR(iu, g.degree(u))
            		mask[ g[u][iu] ]++;
            	FOR(iv, g.degree(v))
            	    mask[ g[v][iv] ]--;
            	bool isTwin = true;
            	FOR(ic, n)
            		if (mask[ic] != 0) {
            			isTwin = false;
            			break;
            		}
            	if (isTwin) {
            		nTwin++;
            		model.addConstr( MT(x, u, v) == 0);
            		cout << setw(5)<<u <<setw(5)<<v<<setw(5)<<g.degree(u)<<endl;
            	}
              }
             cout <<"Number of twins: "<< setw(5)<<nTwin<<endl;
        }
        if (!par->exists("increment")) {
			vector<Triple> tinq;
			// Add complete triangle inequalities
			switch (im)  {
				case MODEL_FULL_IP:     tinq = tri_full(g); break;
				case MODEL_VERTEX_CUT: tinq = tri_vertex_cut(g); break;
				case MODEL_FULL_LP:
				case MODEL_MIN_DEGREE:  tinq = tri_min_degree(g);break;
				default:break;
			}

			cout <<"Model starts with "<<setw(8)<<tinq.size()<<" constraint(s)."<<endl;
			for(vector<Triple>::iterator it = tinq.begin();it != tinq.end();++it) {
				   int i = it->i, j = it->j, k = it->k;
				   model.addConstr(  (i>k?x[i][k]:x[k][i])+(k>j?x[k][j]:x[j][k]) >= x[i][j]);
			}
			model.update();
			model.optimize();
        } else {
        	for(int h = n; h >0;--h)
        	 NEIGHBORS(g, h, t) {
        		int htc = 0;
        		if (h > t) {
        			FOR(i, n)
        				if (i != h && i != t) {
        					if (g.degree(h) < g.degree(i)) {
        						htc++;
        						model.addConstr( MT(x, h, t) + MT(x, t, i) >= MT(x, h, i));
        					}
        					if (g.degree(t) < g.degree(i)) {
        						model.addConstr( MT(x, h, t) + MT(x, i, h) >= MT(x, i, t));
        						htc++;
        					}
        				}
        		}
        		cout << h << " "<<htc<<endl;
        		model.optimize();
        	}
        }
        vector< vector<bool> >	 cij( g.size(), vector<bool>(g.size(),false) );
        vector< vector<double> > dij( g.size(), vector<double>(g.size(),-1) );
        FOR(i, n)
        	FOR(j, i)
        		dij[i][j] = dij[j][i] = x[i][j].get(GRB_DoubleAttr_X);
        if (par->exists("lp") && par->exists("increment") ) {
        	cout <<"Looking for cutting planes..."<<endl; cout.flush();
        	GRBEnv menv = model.getEnv();
        	int cflag = menv.get(GRB_IntParam_OutputFlag);
        	menv.set(GRB_IntParam_OutputFlag, 0);
        	int tinq = 0, nst1 = 0, nst2=0, nvc=0;
        	do {
        		clock_t start_tr = clock();
        		tinq = nst1 = nst2 = nvc = 0;
        		tinq = add_triangle_inequalities(dij, model, x);
        		if (tinq <= n) {
					nst1 = add_2partitioning_cuts1(dij, model, x);
					if (nst1 <= n/5) {
						nst2 = add_2partitioning_cuts2(dij, model, x);
						if (nst2 <= 0) {
							vector<vector<int> > inqs = add_vertex_cut(g, dij);
							nvc = inqs.size();
							FOR(t, nvc ) {
								int i = inqs[t][0], j = inqs[t][1];
								GRBLinExpr vcc = MT(x, i, j) - 1;
								for (int l = 2; l < nvc; l++)
									vcc += 1 - MT(x, i, inqs[t][l]);
								model.addConstr(vcc >= 0);
							}
						}
					}
        		} // tinq
        		cout <<setw(6)<<tinq<<setw(6)<<nst1 << setw(6)<<nst2<<setw(6)<< nvc <<setw(8)<<setprecision(3)
        		        			 <<(clock()-start_tr)/(1.0 * CLOCKS_PER_SEC)<<"s. ";cout.flush();
        		if (nst2 >0) {
        			model.update();
        			model.presolve();
        		}
        		model.optimize();
        		cout << setw(8)<<setprecision(8)<<model.get(GRB_DoubleAttr_ObjVal)<<" "
        				<<setw(5)<<(clock()-start_tr)/(1.0 * CLOCKS_PER_SEC)<<"s." << endl;
        		FOR(i, n)
        		      FOR(j, i)
        		      	dij[i][j] = dij[j][i] = x[i][j].get(GRB_DoubleAttr_X);
        	} while (tinq+nst1+nst2+nvc >0);
        	cout <<"No more cuts found!"<<endl; cout.flush();
        	menv.set(GRB_IntParam_OutputFlag, cflag);
        }
        double Q = -model.get(GRB_DoubleAttr_ObjVal)/total_edge_weights/total_edge_weights;
        cout <<"Maximal modularity: "<<setprecision(6)<<setw(8)<< Q <<" found in "<<setw(6)<<(clock()-start)/(1.0*CLOCKS_PER_SEC)<<" second(s)."<<endl;
        if (cm == CM_AGGRESSIVE) {
            cout <<"Total time for triangle cuts: "<<((mycallback_aggressive*)cb)->triangle_time/(1.0*CLOCKS_PER_SEC)<<" s."<<endl;
            cout <<"Total time for vertex cuts: "<<((mycallback_aggressive*)cb)->vc_time/(1.0*CLOCKS_PER_SEC)<<" s."<<endl;
        }   
        // Get the cluster relationship
        bool err = false;
        FOR(i, n) {
        	cij[i][i] = true;
        	FOR(j, i) {
        		dij[i][j] = dij[j][i] = x[i][j].get(GRB_DoubleAttr_X);
        		cij[i][j] = cij[j][i] = (dij[i][j] < 0.5);
        	}
        }
        // Check if the partion is valid
        int nViolation = 0;
        FOR(i, n)
        	FOR(j, i)
        		FOR(k, n)
        			if (i != k && j != k && cij[i][k] && cij[k][j] && (!cij[i][j]) ) {
        				if (nViolation < 10)
        					cerr <<"Error: Invalid cut metric "<<i <<" "<<j <<" "<< k
        						 <<" "<<dij[i][k] << " "<<dij[k][j]<<" "<<dij[i][j]<<endl;
        				nViolation++;
        				err = true;
        			}

        int nclu = 0;
        FOR(i, n) 
            if (mbs[i] < 0) {
                mbs[i] = nclu;
                for(int j = i+1; j < n;++j)
                    if ( cij[i][j])
                            mbs[j] = nclu;
                nclu++;
            }
        if (err) {
        	cout <<"Error:" << nViolation << " violation(s) found!"<<endl;
        	ostringstream oss;
        	oss << nViolation;
        	string fileName = "violation_"+oss.str()+".sol";
        	ofstream	fs( fileName.c_str());
        	FOR(i, n) {
        		fs << setw(3) << i;
        	 FOR(j, n)
        			fs <<" "<< (int) cij[i][j];
        	 fs << endl;
        	}
        	fs.close();
        } else  {
        	double mod = 0;
        	FOR(i, n)
        		FOR(j, i)
        			if (cij[i][j])
        				mod += -g.wdeg_in(i) * g.wdeg_out(j) -g.wdeg_in(j) * g.wdeg_out(i);
			//ALL_EDGES(g, h, t)
			//	if (cij[h][t])
			//			mod += total_edge_weights * g.edw(id);                
        	mod /=-total_edge_weights*total_edge_weights;
        	cout <<"Solution is validated! "<<mod<<endl;
        }

        FOR(i, n)
            delete[] x[i];
        delete[] x;
        delete cb;
    } catch(GRBException e) {
        cout << "Error code = " << e.getErrorCode() << endl;
        cout << e.getMessage() << endl;
    } catch(...) {
        cout << "Exception during optimization" << endl;
    }    
    return mbs;
}
