#ifndef     DISRUPTOR_CALL_BACK_H
#define     DISRUPTOR_CALL_BACK_H

#include "gurobi_c++.h"
#include "generalGraph.hpp"
#include "ModularityMetric.h"
#include "clustering.h"
#include <cmath>
#include <iostream>
#include <queue>
#include <algorithm>
#include <vector>
#include <lemon/list_graph.h>
#include <lemon/preflow.h>
#include <ctime>

using namespace std;

#define	 MT(x, u, v)	( ((u)>(v))?(x)[(u)][(v)]:(x)[(v)][(u)])
vector<vector<int> > add_vertex_cut(GeneralGraph<double> &g,
		const vector<vector<double> > &xm) {
	vector<vector<int> > result;
	int n = g.size(), count = 0;
	LemonGraph<double> lg(g);
	FOR(i, n) {
		ListDigraph::Node oi = lg.g.split(lg.id[i]);
		lg.id.push_back(oi);
		lg.rid[oi] = i + n;
	}
	ListDigraph::ArcMap<double> w(lg.g, 3.0 * n);// Sufficient large edge capacities
	EdgeMap<double> em(g);
	double vc_dif = 0;
	vector<vector<int> > arcMatrix(n, vector<int> (n, -1));
	FOR(i, n) {
		for (ListDigraph::ArcIt e(lg.g); e != INVALID; ++e) {
			int s = lg.rid[lg.g.source(e)], t = lg.rid[lg.g.target(e)];
			arcMatrix[s % n][t % n] = lg.g.id(e);
			if (s != i && t - s == n)
				w[e] = 1 - xm[i][s]; // Nodes have capacities one
		}
		Preflow<ListDigraph, ListDigraph::ArcMap<double> > flow(lg.g, w,
				lg.id[i + n], lg.id[i]);
		FOR(j, n)
			if ((i != j) && !em.isEdge(i, j)) {
				flow.target(lg.id[j]);
				flow.run();
				double vlCut = 1 - xm[i][j] - flow.flowValue();
				if (vlCut > 1e-3) {
					count++;
					vc_dif = max(vc_dif, vlCut);
					vector<int> inq;
					inq.push_back(i);
					inq.push_back(j);
					FOR(k, n)
						if ((k != i) && (k != j) && flow.minCut(lg.id[k])
								&& !flow.minCut(lg.id[k + n]))
							inq.push_back(k);
					result.push_back(inq);
				}
			}
	}
	return result;
}



class mycallback_aggressive: public GRBCallback {
public:
	int triangle_time;
	int vc_time;
	mycallback_aggressive(GRBModel *grb_model, GRBVar **grb_x,
			GeneralGraph<double> &gp) :
		g(gp), model(grb_model), x(grb_x) {
		cout << "Cutting Mode: Aggressive!" << endl;
		tri_constraints = vc_constraints = 0;
		triangle_time = vc_time = 0;
		lastbnd = -1e-10;
		no_imprv = 0;
		lastNodeCount = -1;
		//int n = g.size();
		//added.resize(n * n * n, false);
	}

protected:
	//vector<bool>	added;
	vector<vector<int> > lc;
	vector<double> vl;
	int lastNodeCount;
	int tri_constraints, vc_constraints;
	double lastbnd;
	int no_imprv;
	GeneralGraph<double> &g;
	GRBModel *model;
	GRBVar** x;

	double tri_dif, vc_dif;

	int add_vertex_cut(double **xm) {
		int n = g.size(), count = 0;
		LemonGraph<double> lg(g);
		FOR(i, n) {
			ListDigraph::Node oi = lg.g.split(lg.id[i]);
			lg.id.push_back(oi);
			lg.rid[oi] = i + n;
		}
		ListDigraph::ArcMap<double> w(lg.g, 3.0 * n);// Sufficient large edge capacities
		EdgeMap<double> em(g);
		vc_dif = 0;
		vector<vector<int> > arcMatrix(n, vector<int> (n, -1));
		FOR(i, n) {
			for (ListDigraph::ArcIt e(lg.g); e != INVALID; ++e) {
				int s = lg.rid[lg.g.source(e)], t = lg.rid[lg.g.target(e)];
				arcMatrix[s % n][t % n] = lg.g.id(e);
				if (s != i && t - s == n)
					w[e] = 1 - MT(xm, i, s); // Nodes have capacities one
			}
			Preflow<ListDigraph, ListDigraph::ArcMap<double> > flow(lg.g, w,
					lg.id[i + n], lg.id[i]);
			FOR(j, n)
				if ((i != j) && !em.isEdge(i, j)) {
					flow.target(lg.id[j]);
					flow.run();
					double vlCut = 1 - MT(xm, i, j) - flow.flowValue();
					if (vlCut > 1e-3) {
						count++;
						vc_dif = max(vc_dif, vlCut);
						GRBLinExpr vcc = MT(x, i, j) - 1;
						FOR(k, n)
							if ((k != i) && (k != j) && flow.minCut(lg.id[k])
									&& !flow.minCut(lg.id[k + n]))
								vcc += 1 - MT(x, i, k);
						addCut(vcc, GRB_GREATER_EQUAL, 0);
					}
				}
		}
		return count;
	}

	int add_triangle_inequalities(double **xm) {
		double dif, bestij;
		int bij, n = g.size();
		vector<Triple> pq;
		FOR(i, n)
			FOR(j,i) {
				bestij = 0;
				FOR(k, n)
					if (k != i && k != j //&& !added[ (i*n+j)*n+k]
					) {
						dif = MT(xm, i, k) + MT(xm, k, j) - xm[i][j];
						if (dif < bestij) {
							bestij = dif;
							bij = k;
						}
					}// if
				if (bestij < -1e-3)
					pq.push_back(Triple(i, j, bij, bestij));
			}// for
		tri_dif = 0;
		int count = 0;
		FOR(it, pq.size()) {
			int i = pq[it].i, j = pq[it].j, k = pq[it].k;
			tri_dif = max(tri_dif, -pq[it].dif);
			count++;
			//added[ (i*n+j)*n+k] = true;
			addCut(MT(x,i,k) + MT(x, k,j) - x[i][j], GRB_GREATER_EQUAL, 0);
		}
		return count;
	}

	int add_2partitioning_cuts1(double **xm) {
		int count = 0, n = g.size();
		FOR(u, n) {
			vector<pair<double, int> > W;
			FOR( v, n)
				if (v != u && (MT(xm, u,v) > 1e-6) && (MT(xm, u, v) < 1
						- (1e-6)))
					W.push_back(make_pair(MT(xm, u, v), v));
			sort(W.begin(), W.end());
			while (!W.empty()) {
				vector<int> T;
				double dif = 0;
				FOR(j, W.size() ) {
					bool zrd = true;
					int w = W[j].second;
					FOR(k, T.size() )
						if (MT(xm, w, T[k]) < 1 - (1e-6)) {
							zrd = false;
							break;
						}
					if (zrd) {
						T.push_back(w);
						dif += 1 - W[j].first;
					}
				}
				if ((dif > (1 + 1e-3)) && T.size() > 2) {
					count++;
					GRBLinExpr stc;
					FOR(k, T.size() )
						stc += 1 - MT(x, u, T[k]);
					FOR(i, T.size() )
						FOR(j, i)
							stc -= 1 - MT(x, T[i], T[j]);
					addCut(stc, GRB_LESS_EQUAL, 1);
					break;
				}
				W.erase(W.begin());
			}
		}
		return count;
	}

	int add_2partitioning_cuts2(double **xm) {
		int count = 0, n = g.size();
		FOR(u, n) {
			vector<pair<double, int> > W;
			FOR( v, n)
				if (v != u && (MT(xm, u,v) > 1e-6) && (MT(xm, u, v) < 1
						- (1e-6)))
					W.push_back(make_pair(MT(xm, u, v), v));
			sort(W.begin(), W.end());
			while (!W.empty()) {
				vector<int> T;
				double dif = 0;
				FOR(j, W.size() ) {
					double zrd = 0;
					int w = W[j].second;
					FOR(k, T.size() )
						zrd += 1 - MT(xm, w, T[k]);
					if (zrd < 1 - W[j].first) {
						T.push_back(w);
						dif += 1 - W[j].first - zrd;
					}
				}
				if ((dif > (1 + 1e-6)) && T.size() > 2) {
					count++;
					GRBLinExpr stc;
					FOR(k, T.size() )
						stc += 1 - MT(x, u, T[k]);
					FOR(i, T.size() )
						FOR(j, i)
							stc -= 1 - MT(x, T[i], T[j]);
					addCut(stc, GRB_LESS_EQUAL, 1);
					break;
				}
				W.erase(W.begin());
			}
		}
		return count;
	}

	void callback() {
		//cout <<"Aggressive callback:"<< where << endl;
		try {
			if (where == GRB_CB_MESSAGE) {
			} else if (where == GRB_CB_PRESOLVE) {
			} else if (where == GRB_CB_SIMPLEX) {
			} else if (where == GRB_CB_MIP) {
			} else if (where == GRB_CB_MIPSOL) {
			} else if (where == GRB_CB_MIPNODE) {
				double nodcnt = getDoubleInfo(GRB_CB_MIPNODE_NODCNT);
				//int nodstat = getIntInfo(GRB_CB_MIPNODE_STATUS);
				//			if (lastNodeCount == nodcnt)
				//			return;
				int n = g.size();
				double **xm = new double*[n];
				try {
					MY_FOR(i, n)
						xm[i] = getNodeRel(x[i], i);
				} catch (GRBException e) {
					delete[] xm;
					return;
				}
				lastNodeCount = nodcnt;
				clock_t start_tr = clock();
				int nt = add_triangle_inequalities(xm);
				tri_constraints += nt;
				int nst1 = 0, nst2 = 0;
				if (nt <= n) {
					nst1 = add_2partitioning_cuts1(xm);
					if (nst1 <= 0)
						nst2 = add_2partitioning_cuts2(xm);
				}
				if (0 && nst1 <= 0 && nst2 <= 0) {
					clock_t start_vc = clock();
					int nc = add_vertex_cut(xm);
					clock_t stop_vc = clock();
					vc_time += stop_vc - start_vc;
					vc_constraints += nc;
					cout << " Vertex cut:" << setw(5) << nc << "/" << setw(6)
							<< vc_constraints << "/" << setprecision(2)
							<< setw(4) << vc_dif << "/" << setprecision(2)
							<< setw(4) << (stop_vc - start_vc) / (1.0
							* CLOCKS_PER_SEC) << "s" << endl;
				}
				clock_t stop_tr = clock();
				cout << setw(6) << (int) nodcnt << " " << setw(7) << nt << " "
						<< setw(7) << nst1 << " " << setw(7) << nst2 << " "
						<< setw(7) << (stop_tr - start_tr) / (1.0
						* CLOCKS_PER_SEC) << "s." << endl;
				MY_FOR(i, n)
					delete[] xm[i];
				delete[] xm;
			}

		} catch (GRBException e) {
			cout << "Error number: " << e.getErrorCode() << endl;
			cout << e.getMessage() << endl;
		} catch (...) {
			cout << "Error during callback" << endl;
		}
	}
};
#endif
