/*
 * ip.h
 *
 *  Created on: May 9, 2011
 *      Author: thang
 */

#ifndef IP_H_
#define IP_H_
#include	"clustering.h"
#include <vector>
#include <string>

enum IpModel {MODEL_NONE, MODEL_FULL_IP, MODEL_MIN_DEGREE, MODEL_FULL_LP, MODEL_VERTEX_CUT};
enum CuttingMethod {CM_AGGRESSIVE, CM_NORMAL, CM_LAZY, CM_NONE};
/**
 * Find a cluster with maximal modularity using the full Integer programming formula
 * @param g		Graph
 * @param init	Membership vector of a heuristic solution. Ignored if the length is different from the number of vertices.
 * @param total_edge_weights Overwrite the number of edges/arcs in the graph. It can be considered as the scaling factor. Ignored if not positive.
 * @param method    1: Full ip
 *                  2: For a pair of vertices (u, v), add all triple (u, v, k) for k is neighbors of u (assuming deg(u)<=deg(v)).
 * @param cm        How often cutting planes are generated: CM_AGGRESSIVE, CM_NORMAL, CM_LAZY, CM_NONE
 * @return Membership array of a clustering with optimal (scaling) modularity
 */
 Membership	modularity_ip( 
     GeneralGraph<double> &g, 
     const Membership& init, 
     IpModel im=MODEL_MIN_DEGREE, 
     CuttingMethod cm = CM_NORMAL, 
     std::vector<std::string> grb_files=std::vector<std::string>(0),
     bool unweighted_preprocess = false,
     double total_edge_weights=0);
#endif /* IP_H_ */
