/*
 * ModularityMetric.cpp
 *
 *  Created on: Jun 4, 2011
 *      Author: thang
 */
#include    "ModularityMetric.h"
using namespace std;

Membership ModularityMetric::optimize(const Membership& init) {
	clock_t start = clock();
	Membership mbs(n, -1);
	try {
		GRBEnv env = GRBEnv();
		model = new GRBModel(env);
		model->getEnv().set(GRB_DoubleParam_MIPGap, 1e-5);
		build_compact_model(!par->exists("lp"));
		// Set the callback function
        mycallback_normal cb(*this);
		if (par->match("cut", "normal"))
			model->setCallback(&cb);		
		// Each node must be connected to at least one neighbor
		FOR(u, n)
			if (u == parent[u] && g.degree(u) > 1) {
				GRBLinExpr dtot;
				NEIGHBORS(g, u, v)
					dtot += ME(u, v);
				model->addConstr(dtot <= g.degree(u) - 1);
			}
		// Add complete triangle inequalities
		int cs = 0;
		if (par->match("model", "full"))
			cs = model_full();
		else if (par->match("model", "vertexcut"))
			cs = model_vertex_cut();
		else if (par->match("model", "mindegree"))
			cs = model_min_degree();
		cout << "Model starts with " << setw(8) << cs << " constraint(s)."
				<< endl;
		// Set initial solution if provided
		if ((int) init.size() == n) {
			FOR(i,n)
				FOR(j, i)
					if (i==parent[i] && j==parent[j] && pcc(i,j)==UNIDENTIFIED) {
						if (init[i] == init[j])
							x[i][j].set(GRB_DoubleAttr_Start, 0.0);
						else
							x[i][j].set(GRB_DoubleAttr_Start, 1.0);
					}
		}
		model->update();
		model->optimize();
		double Q = -(model->get(GRB_DoubleAttr_ObjVal)+objAddition) / mw / mw;
		cout << "Maximal modularity: " << setprecision(6) << setw(8) << Q
				<< " found in " << setw(6) << (clock() - start) / (1.0
				*CLOCKS_PER_SEC) << " second(s)." << endl;
		// Get the cluster relationship
		bool err = false;
		vector<vector<bool> > cij(n, vector<bool> (n, false));
		vector<vector<double> > dij(n, vector<double> (n, -1));
		FOR(i, n) {
			cij[i][i] = true;
			FOR(j, i) {
                if (pcc(i, j) != UNIDENTIFIED)
				    dij[i][j]= dij[j][i] = pcc(i, j);
                else
					dij[i][j]= dij[j][i] = VAR(parent[i],parent[j]).get(
												GRB_DoubleAttr_X);
				cij[i][j] = cij[j][i] = (dij[i][j] < 0.5);
			}
		}        
		// Check if the partion is valid
		int nViolation = 0;
		FOR(i, n)
			FOR(j, i)
				FOR(k, n)
					if (i != k && j != k && cij[i][k] && cij[k][j]
							&& (!cij[i][j])) {
						if (nViolation < 10)
							cerr << "Error: Invalid cut metric " << i << " "
									<< j << " " << k << " " << dij[i][k] << " "
									<< dij[k][j] << " " << dij[i][j] << endl;
						nViolation++;
						err = true;
					}        
		int nclu = 0;
		FOR(i, n)
			if (mbs[i] < 0) {
				mbs[i] = nclu;
				for (int j = i + 1; j < n; ++j)
					if (cij[i][j])
						mbs[j] = nclu;
				nclu++;
			}        
		if (err) {
			cout << "Error:" << nViolation << " violation(s) found!" << endl;
			ostringstream oss;
			oss << nViolation;
			string fileName = "violation_" + oss.str() + ".sol";
			ofstream fs(fileName.c_str());
			FOR(i, n) {
				fs << setw(3) << i;
				FOR(j, n)
					fs << " " << (int) cij[i][j];
				fs << endl;
			}
			fs.close();
		} else {
			double mod = 0;
			FOR(i, n)
				FOR(j, i)
					if (!cij[i][j])
						mod += bm[idx(i,j)];
			mod /= -mw * mw;
			cout << "Solution is validated! " << mod << endl;
		}        
		FOR(i, n)
			delete[] x[i];
		delete[] x;
		delete model;
		model = NULL;
		x = NULL;
	} catch (GRBException e) {
		cout << "Error code = " << e.getErrorCode() << endl;
		cout << e.getMessage() << endl;
	} catch (...) {
		cout << "Exception during optimization" << endl;
	}
	return mbs;
}
