/*
 * clustering.h
 *
 *  Created on: May 9, 2011
 *      Author: thang
 */

#ifndef CLUSTERING_H_
#define CLUSTERING_H_

#include <vector>
#include <algorithm>
#include <string>


struct  Triple {
            int i, j, k;
            double dif;
            Triple(int x, int y, int z, double di): i(x), j(y), k(z), dif(di) {}
            bool operator<(const Triple &b ) const {
                return this->dif < b.dif;
            }
};

typedef	std::vector<int> Membership;

//class	Partition {
//	int			n, k;
//public:
//	int	size() const { return n;}
//	int	nClusters() const { return k; }
//	Membership
//};

//vector< vector<int> >	membershipToCommunities( const Vector *membership ) {
//// Count the number of communities
//  vector<int> cId( VSIZE(*membership) * 2+1, -1 );
//  int cSize = 0;
//  FOR(i, VSIZE(*membership) ) {
//	  int u = VECTOR(*membership)[i];
//	  if (u < 0 || u > 2 * VSIZE(*membership) ) {
//		  cerr <<"Error: Invalid membership: "<< u << endl;
//	  }  else  if (cId[ u ] < 0)  {
//		cId[ u ] = cSize;
//		cSize++;
//	  }
//  }
//  vector< vector<int> > communities(cSize, vector<int>(0) );
//  FOR(i, VSIZE(*membership) )
//    communities[ cId[ VECTOR(*membership)[i] ] ].push_back( i );
//  return communities;
//}

/**
 * @brief Write pajek cluster given by a Membership array to a file
 */
bool writePajekCluster(std::string file_name, const Membership mbs);

/**
 * @brief Read a cluster from a file to a membership array
 * @param file_name
 * @return Membership array
 */
Membership loadPajekCluster(std::string file_name);


#endif /* CLUSTERING_H_ */
