/*
 * clustering.cpp
 *
 *  Created on: May 9, 2011
 *      Author: thang
 */

#include "clustering.h"
#include "common.h"
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <vector>
#include <iomanip>
#include <algorithm>

using namespace std;


/**
 * @brief Write pajek cluster given by a Membership array to a file
 */
bool writePajekCluster(std::string file_name, const Membership mbs) {
	FILE* f= fopen(file_name.c_str(),"w");
	if (!f) {
		cerr <<"Error: Cannot create file " << file_name  << endl;
		return false;
	}
	fprintf(f, "*Vertices %d\n",mbs.size());
	FOR(i, mbs.size())
		 fprintf(f,"%d\n", mbs[i]);
	fclose(f);
	return true;
}

/**
 * @brief Read a cluster from a file to a membership array
 * @param file_name
 * @return Membership array
 */
Membership loadPajekCluster(std::string file_name) {
	Membership mbs;
	FILE* f= fopen(file_name.c_str(),"r");
	if (!f) {
		cerr <<"Error: Cannot access file " << file_name  << endl;
		return mbs;
	}
	char	buf[1000];
	int n = 0;
	fscanf(f, "%s%d\n",buf, &n);
	mbs.resize(n);
	int u = -1;
	FOR(i, n) {
         u = -1;
		 fscanf(f,"%d\n", &u);
		 if (u == -1 && feof(f)) {
			 cerr <<"Error: Invalid format Pajek cluster file " << file_name  << endl;
			 mbs.clear();
			 return mbs;
		 }
		 mbs[i] = u;
	}
	fclose(f);
	return mbs;
}
