/*
n * ModularityMetric.h
 *
 *  Created on: Jun 4, 2011
 *      Author: thang
 */

#ifndef MODULARITYMETRIC_H_
#define MODULARITYMETRIC_H_

#include "gurobi_c++.h"
#include "clustering.h"
#include "generalGraph.hpp"
#include "graphAlgorithm.hpp"
#include "edgeMap.hpp"
#include "lemonConversion.hpp"
#include "config.hpp"
#include "common.h"
#include "ip.h"
#include "clustering.h"
#include <lemon/list_graph.h>
#include <lemon/preflow.h>
#include <ctime>
#include <queue>
#include <cstdlib>
#include <cstdio>
#include <string>
#include <vector>
#include <algorithm>
#include <limits>
#include <numeric>
#include <functional>
#include <sstream>
#include <ctime>

using namespace std;
#define	 MAX_TRIANGLE	200
#define	 MT(x, u, v)	( ((u)>(v))?(x)[(u)][(v)]:(x)[(v)][(u)])
#define	 idx(a, b)   ((a) >(b)?(a)*n+(b):(b)*n+(a))	// Single index for a pair
#define	 VAR(a, b)	((a) >(b)?x[a][b]:x[b][a])		// Variables associated with edge (a,b)
#define	 pcc(u, v)	pc[idx(parent[u], parent[v])]

enum	PAIR_CONNECTION  {CONNECTED=0, DISCONNECTED=1, UNIDENTIFIED=2};

class	ModularityMetric {
public:
	GeneralGraph<double>		&g; // The graph
	int					 n; // The number of vertices
	bool  uniform_weighted;
	vector<double> 	 bm;   // Modularity Matrix
	vector<double> 	 bma;  // Accumulated Modularity Matrix
	vector< vector<int> >		 ccmp; // connected components
	vector<PAIR_CONNECTION>  pc; // Information about node pairs inferred from
										  // the network's topology e.g. leaves will
										  // always connected with their only neighbors
	vector< vector<int> >	vcp;	// Cut vertices that involve a certain pair idx(u, v)
	vector<int>		parent;				  // Pointer to representative of a node
	vector<int>		pmm;				  // Parent vector when modularity metric is
										  // supplied.
	double			mw;					  // total weight = 2 * m
	double			tolerance;
	// Gurobi model and variables
	GRBModel 		*model;
	GRBVar 			**x;
	Configuration	*par;
    double objAddition;

inline	GRBLinExpr ME(int u, int v)	{
	if (pc[idx(parent[u], parent[v])]==UNIDENTIFIED)
		return VAR(parent[u], parent[v]);
	else
		return pc[idx(parent[u], parent[v])];
}
	int	model_full() {
	    cout <<"Starting model: COMPLETE"<<endl;
	    int fc = 0;
	    FOR(i, n)
	      FOR(j, i)
	      	  if (parent[i] != parent[j])
	      		  FOR(k, n)
	      		  	  if ( pcc(i, k) == UNIDENTIFIED  && pcc(k, j) ==UNIDENTIFIED ) {
	      		  		  model->addConstr( ME(i, k) + ME(k, j) - ME(i, j) >= 0);
	      		  		  ++fc;
	      		  	  }
	    return fc;
	}

	int  model_vertex_cut() {
	    cout <<"Starting model: VERTEX CUT"<<endl;
	    LemonGraph<double>	lg(g);
	    FOR(i, n) {
	    	ListDigraph::Node oi = lg.g.split( lg.id[i]);
	    	lg.id.push_back(oi);
	    	lg.rid[ oi ] = i + n;
	    }
	    vector< vector<int> >  arcMatrix( n, vector<int>(n, -1));
	    ListDigraph::ArcMap<int> w(lg.g, 3 *n );// Sufficient large edge capacities
	    for(ListDigraph::ArcIt e(lg.g); e != INVALID; ++e) {
	    	int t = lg.rid[ lg.g.target(e)], s = lg.rid[ lg.g.source(e)];
	    	if (t - s ==n )
	    		w[e]  = 1; // Nodes have capacities one
	    	arcMatrix[s % n][t % n] = lg.g.id(e);
	    }
	    Preflow<ListDigraph> flow(lg.g, w, lg.id[0], lg.id[n]);
	    EdgeMap<double> em(g);
	    int  vc = 0;
	    FOR(i, n)
	      FOR(j, i)
	      if (parent[i] != parent[j]) {
			 if (vcp[idx(i, j)].size() > 0) {
				  FOR(l, vcp[ idx(i, j)].size() ){
					  int k = vcp[ idx(i, j)][l];
					  if (parent[i] != parent[k] && parent[j] != parent[k]) {
						  model->addConstr( ME(i, k) + ME(k, j) - ME(i, j) >= 0);
						  vc++;
						  break;
					  }
				  }
			  } else {
				  flow.source(lg.id[i + n]);
				  flow.target(lg.id[j]);
				  if (em.isEdge(i, j)) { // Remove the direct edge
					  w[ lg.g.arcFromId(arcMatrix[i][j]) ] = 0;
					  w[ lg.g.arcFromId(arcMatrix[j][i]) ] = 0;
					  flow.capacityMap(w);
				  }
				  flow.run();
				  if (em.isEdge(i, j)) {
					   w[ lg.g.arcFromId(arcMatrix[i][j]) ] = 3 * n;
					   w[ lg.g.arcFromId(arcMatrix[j][i]) ] = 3 * n;
					   flow.capacityMap(w);
				  }
				  vc+= flow.flowValue();
				  FOR(k, n) {
					  if (  pcc(i, k) == UNIDENTIFIED  && pcc(k, j) ==UNIDENTIFIED  && flow.minCut(lg.id[k]) && !flow.minCut(lg.id[k+n]) ) {
						vc++;
						model->addConstr( ME(i, k) + ME(k, j) - ME(i, j) >= 0);
					  }
				  }
			  } // else
	      } // if
	    cout <<"Total cut sizes (#constraints): "<<vc<<endl;
	    return vc;
	}


	int  model_min_degree() {
	    cout <<"Starting model: MIN DEGREE"<<endl;
	    int mdc =0;
	    FOR(i, n)
	        FOR(j, i)
	        if (parent[i] != parent[j]) {
	          int u = (g.degree(i) < g.degree(j))? i : j;
	          NEIGHBORS(g,u, k)
	            if ( pcc(i, k) == UNIDENTIFIED  && pcc(k, j) ==UNIDENTIFIED ) {
	            	model->addConstr( ME(i, k) + ME(k, j) - ME(i, j) >= 0);
	            	mdc++;
	            }
	        }
	    return mdc;
	}

	inline		void	merge_vertices(int u, int v) {
		int a = parent[u], b= parent[v], nroot = min( parent[u], parent[v]);
		FOR(i, n)
			if (parent[i] == a || parent[i] == b)
					parent[i] = nroot;        
	}

	void	build_compact_model(bool isMIP = true) {
		// Create variables
		x = new GRBVar*[n];
		vector<double> ub(n, 1);
		if (!isMIP) {
		    FOR(i, n)
		    	x[i]= model->addVars(NULL, // Lower bound 0
		    						&ub[0],
		    						NULL, // No objective
		    						NULL, // GRB_CONTINUOUS
		    						NULL, // No names
		    						i);
		} else {
		    FOR(i,n)
		        x[i] = model->addVars(i, GRB_BINARY);
		}		
	    // Integrate new variables
	    model->update();
        // Remove uneccessary variables
		int rVar = 0;
		objAddition = 0;
		FOR(i, n)
			FOR(j, i)
				if (i != parent[i] || j != parent[j] ) {
					bma[idx(parent[i], parent[j]) ] += bm[ idx(i, j)];
					model->remove(x[i][j]);
					rVar++;
				} else if (pcc(i,j) != UNIDENTIFIED ) {
					model->remove(x[i][j]);
					rVar++;
				}
		FOR(i, n)
			FOR(j, i)
				if (i==parent[i] && j==parent[j] && pcc(i,j) != UNIDENTIFIED)
					objAddition += pcc(i, j) * bma[ idx(i, j)];
		cout <<"Model starts with "<< (n*(n-1)/2 - rVar)<<" variables ("<<rVar<<" were removed)."<<endl;
		cout <<"Objective presolved constant: "<<objAddition<<endl;
        model->update();
	    // Add objective
	    vector< vector<double> > m(n, vector<double>(n,0) );
	    FOR(i, n)
		    FOR(j, i)
		    	if (i== parent[i] && j == parent[j] && pcc(i,j) == UNIDENTIFIED)
		    		x[i][j].set(GRB_DoubleAttr_Obj, bma[idx(i,j)]);
	    GRBEnv menv = model->getEnv();
	    menv.set(GRB_StringParam_LogFile, "modularityGurobi.log");
	    menv.set(GRB_IntParam_PreCrush, 1);
	    menv.set(GRB_IntParam_PrePasses, 2);
	    if (par->exists("barrier"))
	        	menv.set(GRB_IntParam_Method, 2); // barrier method
	    if (par->exists("dual"))
	          	menv.set(GRB_IntParam_Method, 1);// Dual simplex
	    if (par->exists("primal"))
	     		menv.set(GRB_IntParam_Method, 0);// Primal simplex
	    int mipfocus = 0, threads=0;
	    if (par->exists("threads")) {
	    		(*par)["threads"] >> threads;
	    		menv.set(GRB_IntParam_Threads, threads);
	    }
	    if (par->exists("mipfocus")) {
	    	(*par)["mipfocus"] >> mipfocus;
	    	menv.set(GRB_IntParam_MIPFocus, mipfocus);
	    }
	    menv.set(GRB_DoubleParam_Heuristics, 0.2);
	}

	void	preprocess() {
		// Connected component
		ccmp = connected_components(g);
		cout << "Number of connected components: " << ccmp.size();
		// Nodes in different components will be in different clusters
		int nec = 0;
		FOR(i, ccmp.size() )
			FOR(j, i)
				FOR(u, ccmp[i].size())
					FOR(v,  ccmp[j].size()) {
						int a =  ccmp[i][u], b =  ccmp[j][v];
						pc[ idx(a, b) ] = DISCONNECTED;
						nec++;
					}
		cout << ", disconnected pairs: " << nec << endl;
		// Find leaves
		int nLeaves = 0;
		FOR(u, n)
			if (g.degree(u) == 1) {
				++nLeaves;
				merge_vertices(u, g[u][0]);
			}
		cout << "Number of leaves: " << nLeaves << endl;
		// Find 3-cycle
		int c3 = 0;
		FOR(u, n)
			if (g.degree(u) == 2) {
				int a = g[u][0], b = g[u][1];
				if (g.degree(b) == 2)
					std::swap(a, b);
				if ((g.degree(a) == 2) && (u > a)) {
					int c = (g[a][0] == u) ? g[a][1] : g[a][0];
					if ( (c == b) && ( (!g.isWeighted())||
							 (fabs(g.Weight(u)[0]-g.Weight(u)[1])+
							  fabs(g.Weight(a)[0]-g.Weight(a)[1]) < 1e-6) ))
					{
						merge_vertices(u, a);
						merge_vertices(u, b);
						cout << "3-cycle: " << setw(6) << c << setw(6) << a
								<< setw(6) << u << endl;
						c3++;
					} // if c==b
				} // if g.deg(b)
			} // if g.deg(u)
		cout << "Number of 3-cycle(s): " << setw(6) << c3 << endl;
		// Number of node pairs with the same set of neighbors
		int nTwin = 0;
		FOR(u, n)
			NEIGHBORS(g, u, v)
				if (u > v && g.degree(u) > 2 && ( sqrt(4*mw*g.edw(id))>= (g.wdeg_out(u)+g.wdeg_out(v)))  ) {
					vector<double> mask(n, 0);
					FOR(iu, g.degree(u))
						mask[g[u][iu]] += g.Weight(u)[iu];
					FOR(iv, g.degree(v))
						mask[g[v][iv]] -= g.Weight(v)[iv];
					bool isTwin = true;
					FOR(ic, n)
						if (ic != u && ic != v && fabs(mask[ic])>1e-6) {
							isTwin = false;
							break;
						}
					if (isTwin) {
						nTwin++;
						merge_vertices(u, v);
						cout <<"Twin: "<< setw(5) << u << setw(5) << v << setw(5)
								<< g.degree(u) << endl;
					}
				}
		cout << "Number of twins: " << setw(5) << nTwin << endl;
		// Cut vertices and cut constraints
		int ncut_vertex = 0;
		vcp = vector< vector<int> > (n*n, vector<int>(0));
		FOR(u, n) {
			vector<bool> visited(n, false);
			visited[u] = true;
			vector<vector<int> > ccu;
			NEIGHBORS(g, u, v)
				if (!visited[v])
					ccu.push_back(bfs(g, v, visited));
			int cus = ccu.size();
			if (cus > 1) {
				bool not_leaf = false;
				FOR(i, cus)
				 FOR(j, i)
					if (ccu[i].size() > 2 && ccu[j].size() > 2) {
				 	  FOR(a, ccu[i].size())
						FOR(b, ccu[j].size()) {
						  int av = ccu[i][a], bv = ccu[j][b];
						  vcp[ idx(av, bv) ].push_back(u);
						}
				 	  not_leaf = true;
					}
				if (not_leaf)
					ncut_vertex++;
			}
		}
		cout << "Number of vertex cut (not involving leaves): " << setw(6) << ncut_vertex<<endl;
	}

	ModularityMetric(GeneralGraph<double> &gg, Configuration *parameter):g(gg), par(parameter) {
		n = g.size();
		model = NULL;
		// Calculate total edge weights (i.e. 2 *m for undirected graph)
		double mw2= 0;
		FOR(i, g.Arcs())
		 mw2 += g.edw(i);
		mw = accumulate(g.Weight(0), g.Weight(n), (double)0.0);
		cout <<"Total edge weights: "<<setprecision(8)<< mw<<" | "<< mw2
			 <<" ( of "<< g.Weight(n) - g.Weight(0)<<" arcs)"<< endl;
		// Modularity matrix
		bm = vector<double> (n*n,0);
		FOR(i, n)
		 FOR(j, i)
		  bm[idx(i,j)] = -g.wdeg_in(i) * g.wdeg_out(j) - g.wdeg_in(j) * g.wdeg_out(i);
		ALL_EDGES(g,h,t)
		  bm[idx(h,t)] += mw * g.edw(id);
		bma = bm;
		// Check if the graph has uniform weights
		uniform_weighted = true;
		ALL_EDGES(g, h, t)
			if ( fabs(g.edw(id) - g.edw(0))>1e-6)
				uniform_weighted = false;
		// Vertex pointer
		parent = vector<int>(n);		
		pc = vector< PAIR_CONNECTION >(n*n, UNIDENTIFIED );
        FOR(i, n) {
			parent[i] = i;
            pc[idx(i, i)] = CONNECTED;
        }
		if (!g.directed)
			preprocess();
	}

	/**
	 * Find a cluster with maximal modularity using the full Integer programming formula
	 * @param g		Graph
	 * @param init	Membership vector of a heuristic solution. Ignored if the length is different from the number of vertices.
	 * @param total_edge_weights Overwrite the number of edges/arcs in the graph. It can be considered as the scaling factor. Ignored if not positive.
	 * @param method    1: Full ip
	 *                  2: For a pair of vertices (u, v), add all triple (u, v, k) for k is neighbors of u (assuming deg(u)<=deg(v)).
	 * @return Membership array of a clustering with optimal (scaling) modularity
	 */
	Membership	optimize (const Membership& init);
};

class mycallback_normal: public GRBCallback {
public:
	mycallback_normal(ModularityMetric &mm):
		m(mm), g(mm.g), model(*mm.model), x(mm.x), pc(m.pc), parent(m.parent),  n(mm.n) {
		cout << "Cutting Mode: Normal!" << endl;
		cout << setw(6) << "Node" << setw(6) << "Tri" << setw(6)
				<< "CutVt" << setw(6) << "2prt1" << setw(6) << "2prt2" << setw(
				6) << "Vc" << setw(6) << "Vc2" << setprecision(2) << setw(7)
				<< "Time" << endl;
		pcm = vector< vector<double> >(n, vector<double>(n, -1));
		xh =  vector< vector<int> >(n, vector<int>(n, -1));
		FOR(i, n)
			FOR(j, n)
				pcm[i][j] = pc[idx(i,j)];
		heuObj = 0;

		if (m.par->exists("tri2"))
			cout <<"Using triangle inequalities type 2!"<<endl;
		else if (m.par->exists("tri3"))
			cout <<"Using triangle inequalities type 3!"<<endl;
	}
protected:
	ModularityMetric &m;
	GeneralGraph<double> &g;
	GRBModel &model;
	GRBVar** x;
	double lastbnd;
	vector<int>		clu;
	vector<PAIR_CONNECTION>  pc;
	vector< vector<double> >	 pcm; // matrix form of pc
	vector<int>		parent;
	vector< vector<double> > d;
	int n;
	double	heuObj;				// heuristic objective
	vector< vector<int> >	xh; // heuristic solution

	int add_vertex_cut_fast(){
		//TODO:
		return 0;
	}
	inline	GRBLinExpr ME(int u, int v)	{
		if (pc[idx(parent[u], parent[v])]==UNIDENTIFIED)
			return VAR(parent[u], parent[v]);
		else
			return pc[idx(parent[u], parent[v])];
	}

	inline	bool isRational(double x) {
		return (x > 1e-6 && x < (1-1e-6));
	}

	int add_vertex_cut() {
		int count = 0;
		LemonGraph<double> lg(g);
		FOR(i, n) {
			ListDigraph::Node oi = lg.g.split(lg.id[i]);
			lg.id.push_back(oi);
			lg.rid[oi] = i + n;
		}
		ListDigraph::ArcMap<double> w(lg.g, 3.0 * n);// Sufficient large edge capacities
		EdgeMap<double> em(g);
		vector<vector<int> > arcMatrix(n, vector<int> (n, -1));
		FOR(i, n) {
			for (ListDigraph::ArcIt e(lg.g); e != INVALID; ++e) {
				int s = lg.rid[lg.g.source(e)], t = lg.rid[lg.g.target(e)];
				arcMatrix[s % n][t % n] = lg.g.id(e);
				if (s != i && t - s == n)
					w[e] = 1 - d[i][s]; // Nodes have capacities one
			}
			Preflow<ListDigraph, ListDigraph::ArcMap<double> > flow(lg.g, w,
					lg.id[i + n], lg.id[i]);
			FOR(j, n)
				if ((i != j) && !em.isEdge(i, j)) {
					flow.target(lg.id[j]);
					flow.run();
					double vlCut = 1 - d[i][j] - flow.flowValue();
					if (vlCut > 1e-3) {
						count++;
						GRBLinExpr vcc = MT(x, i, j) - 1;
						FOR(k, n)
							if ((k != i) && (k != j) && flow.minCut(lg.id[k])
									&& !flow.minCut(lg.id[k + n]))
								vcc += 1 - MT(x, i, k);
						addCut(vcc, GRB_GREATER_EQUAL, 0);
					}
				}
		}
		return count;
	}

	int add_triangle() {
		int count  = 0;
		priority_queue<Triple> pq;
		double dif;
		FOR(i, n)
		 FOR(j, i)
		 	 if (clu[i] == clu[j]) {
		 		 FOR(k, n)
		 		  if (k != i && k != j && fabs(d[i][k] - d[j][k]) > 0.1 ) {
		 			  if (d[i][k] > d[j][k]) {
		 				  dif = d[i][j] + d[j][k] - d[i][k];
		 				  if (dif < -0.1) {
							 if ((int) pq.size() < MAX_TRIANGLE*5)
								 pq.push(Triple(i, k, j, dif));
							 else if (dif < pq.top().dif) {
										pq.pop();
										pq.push(Triple(i, k, j, dif));
							 }
						  }
		 				  //addCut( ME(i, j) + ME(j, k) - ME(i, k), GRB_GREATER_EQUAL,0);
		 			  } else {
		 				  dif = d[i][j] + d[i][k] - d[j][k];
		 				  if (dif < -0.1) {
							 if ((int) pq.size() < MAX_TRIANGLE*5)
								 pq.push(Triple(j, k, i, dif));
							 else if (dif < pq.top().dif) {
										pq.pop();
										pq.push(Triple(j, k, i, dif));
							 }
						  }
		 				 //addCut( ME(i, j) - ME(j, k) + ME(i, k), GRB_GREATER_EQUAL,0);
		 			  }
		 		  }
		 	 }
		FOR(i, n)
			FOR(j,i)
			if (i == parent[i] && j == parent[j] && i != j)	{
				FOR(k, n)
					if (k == parent[k] && clu[k] != clu[i] && clu[k] != clu[j] ) {
						dif = d[i][k] + d[k][j] - d[i][j];
						if (dif < -1e-6) {
							if ((int)pq.size() < MAX_TRIANGLE)
								pq.push(Triple(i, j, k, dif));
							else if (dif < pq.top().dif) {
								pq.pop();
								pq.push(Triple(i, j, k, dif));
							}
						}
					}// if
			}// for
		while (!pq.empty()) {
			Triple  tp = pq.top(); pq.pop();
			addCut(ME(tp.i, tp.k) + ME(tp.k, tp.j) - ME(tp.i, tp.j), GRB_GREATER_EQUAL, 0);
			count++;
		}
		return count;
	}

	int add_triangle2() {
		priority_queue<Triple> pq;
		double dif;
		vector< vector<double> >	dt = d;
		FOR(k, n)
			FOR(i, n)
				FOR(j, n)
					if (i != j && i != k && j != k && dt[i][j] > dt[i][k] + dt[k][j])
						dt[i][j] = dt[i][k] + dt[k][j];
		int maxsize=  ((n*3/200)*100)+100;
		FOR(i, n)
			FOR(j, i)
				FOR(k, n) {
					dif =dt[i][j] - d[i][j];
					if (k != i && k != j &&  dif < -1e-4 && dt[i][k] + dt[k][j]-dt[i][j] < 1e-5
							&& d[i][k] - dt[i][k] < 1e-5 && d[k][j]-dt[k][j] < 1e-5 ) {
										    if ((int)pq.size() < maxsize)
												pq.push(Triple(i, j, k, dif));
											else if (dif < pq.top().dif) {
												pq.pop();
												pq.push(Triple(i, j, k, dif));
											}
				 	}
		}
		int count  = pq.size();
		while (!pq.empty()) {
			Triple  tp = pq.top(); pq.pop();
			addCut(ME(tp.i, tp.k) + ME(tp.k, tp.j) - ME(tp.i, tp.j), GRB_GREATER_EQUAL, 0);
		}
		return count;
	}

	int add_triangle3() {
		priority_queue<Triple> pq;
		double dif;
		vector< vector<double> >	dt = d;
		FOR(k, n)
			FOR(i, n)
				FOR(j, n)
					if (i != j && i != k && j != k && dt[i][j] > dt[i][k] + dt[k][j])
						dt[i][j] = dt[i][k] + dt[k][j];
		int maxsize=  ((n*3/200)*100)+100;
		FOR(i, n)
			FOR(j, i)
				if  ( ((parent[i]==i) && (parent[j]==j)) || (parent[i]==parent[j]) )
				FOR(k, n)
					if (k == parent[k] && k != i && k != j) {
						dif =dt[i][j] - d[i][j];
						if (dif < -1e-4 && dt[i][k] + dt[k][j]-dt[i][j] < 1e-5
							&& d[i][k] - dt[i][k] < 1e-5 && d[k][j]-dt[k][j] < 1e-5 ) {
											dif = dif * (-m.bma[idx(i,j)]);
										    if ((int)pq.size() < maxsize)
												pq.push(Triple(i, j, k, dif));
											else if (dif < pq.top().dif) {
												pq.pop();
												pq.push(Triple(i, j, k, dif));
											}
						}
					}
		int count  = pq.size();
		while (!pq.empty()) {
			Triple  tp = pq.top(); pq.pop();
			addCut(ME(tp.i, tp.k) + ME(tp.k, tp.j) - ME(tp.i, tp.j), GRB_GREATER_EQUAL, 0);
		}
		return count;
	}


	int add_2partitioning_fast() {
		int count = 0;
		FOR(u, n)
		if (u == clu[u]){
			vector<pair<double, int> > W;
			FOR( v, n)
				if (v == clu[v] && v != u && isRational(d[u][v]) )
					W.push_back(make_pair(d[u][v], v));
			sort(W.begin(), W.end());
			while (!W.empty()) {
				vector<int> T;
				double dif = 0;
				FOR(j, W.size() ) {
					bool zrd = true;
					int w = W[j].second;
					FOR(k, T.size() )
						if ( d[w][ T[k] ] < 1 - (1e-6)) {
							zrd = false;
							break;
						}
					if (zrd) {
						T.push_back(w);
						dif += 1 - W[j].first;
					}
				}
				if ((dif > (1 + 1e-3)) && T.size() > 2) {
					count++;
					GRBLinExpr stc;
					FOR(k, T.size() )
						stc += 1 - ME(u, T[k]);
					FOR(i, T.size() )
						FOR(j, i)
							stc -= 1 - ME(T[i], T[j]);
					if (count < 0) {
						cout <<u;
						FOR(k, T.size())
							cout <<"\t"<< T[k];
						cout << endl;
					}
					addCut(stc, GRB_LESS_EQUAL, 1);
					break;
				}
				W.erase(W.begin());
			}
		}
		return count;
	}

	int add_2partitioning_deep() {
		int count = 0, n = g.size();
		FOR(u, n)
		if (u == parent[u]){
			vector<pair<double, int> > W;
			FOR(v, n)
				if (v == parent[v] && parent[v] != parent[u] && isRational(d[u][v]) )
					W.push_back( make_pair(d[u][v], v) );
			sort(W.begin(), W.end());
			while (!W.empty()) {
				vector<int> T;
				double dif = 0;
				FOR(j, W.size() ) {
					double zrd = 0;
					int w = W[j].second;
					FOR(k, T.size() )
						zrd += 1 - d[w][ T[k] ];
					if (zrd < 1 - W[j].first) {
						T.push_back(w);
						dif += 1 - W[j].first - zrd;
					}
				}
				if ((dif > (1 + 1e-6)) && T.size() > 2) {
					count++;
					GRBLinExpr stc;
					FOR(k, T.size() )
						stc += 1 - ME(u, T[k]);
					FOR(i, T.size() )
						FOR(j, i)
							stc -= 1 - ME(T[i], T[j]);
					addCut(stc, GRB_LESS_EQUAL, 1);
					break;
				}
				W.erase(W.begin());
			}
		}
		return count;
	}

	void reconstruct(const vector< vector<double> > &xm) {
		d = xm;
		clu = m.parent;
		FOR(i, n)
			FOR(j, i)
				if ( d[i][j] < 0) {
					if (d[i][j] < -1e-2) {
						cerr <<"Error: Variable with negative value found! "
							 <<i<<" "<<j<<" "<<d[i][j]<< endl;
						exit(1);
					}
					d[i][j] = d[j][i] = 0;
				}
		FOR(i, n)
			FOR(j, i)
				if (clu[i] != clu[j] && d[i][j] < 1e-6 ) {
					int ci = clu[i], cj = clu[j], newc = min( clu[i], clu[j]);
					FOR(k, n)
						if (clu[k] == ci || clu[k] == cj)
							clu[k] = newc;
				}
	}

	int	 cut_vertices_check() {
		int count = 0;
		FOR(i, n)
			FOR(j, n)
				FOR(t, m.vcp[ idx(i, j) ].size()) {
					int k = m.vcp[ idx(i, j) ][t];
					if ( d[i][k] - d[i][j] > 1e-2 ) {
						addCut( ME(i,j) - ME(i,k),GRB_GREATER_EQUAL, 0);
						++count;
					}
					if ( d[j][k] - d[i][j] > 1e-2 ) {
						addCut( ME(i,j) - ME(i,k),GRB_GREATER_EQUAL, 0);
						++count;
					}
				}
		return count;
	}

	void	localSearch(vector<vector<int> > r, vector<int> grp) {
		// Check if the grouping and the metric r agree
		FOR(i, n)
			FOR(j, n) {
				if (r[i][j] != r[ grp[i]][ grp[j]]) {
					cout<<"Local search: Metric r does not"
						 <<" satisfy the provided grouping! "<<i<<" "
						 <<j<<" | "<<grp[i]<<" "<<grp[j]<<" ";
					return;
				}
				FOR(k, n)
					if (k != i && k != j && i!= j && r[i][k]==0 && r[k][j]==0 && r[i][j]!=0) {
						cout<<"Local search: Invalid metric r "
							<<i<<" "<<j<<"  "<<k<<" | "
							<<grp[i]<<" "<<grp[j]<<" "<<grp[k]<<"| "
							<<pcc(i,k)<<" "<<pcc(j, k)<<" "<<pcc(i,j) <<" ";
						return;
					}
			}
		vector< vector<int> >	fv(n, vector<int>(0));
		vector<int>				iv, riv(n, -1);
		int 					n2=0;
		FOR(i, n)
			if (i==grp[i]) {
				riv[i] = n2;
				iv.push_back(i);
				n2++;
			}
		FOR(i, n)
			riv[i] = riv[ grp[i] ];
		double obj = 0, c_obj=0;
		// Construct compressed graph
#define	idx2(u, v)	(((u)>(v))?(u)*n2+(v):(v)*n2+(u))
		vector< double > bmc(n2 * n2, 0);
		FOR(i, n)
			FOR(j, i) {
				bmc[ idx2(riv[i],riv[j])] += m.bm[idx(i,j)];
                if (riv[i] == riv[j] && r[i][j] != 0) {
                    cerr <<"wrong: "<<i <<" "<<j<<" | "<<riv[i]<<" "<<riv[j]<<endl;
                }
				c_obj += m.bm[idx(i,j)]*r[i][j];
			}
		FOR(i, n2) 
				bmc[ idx2(i, i)] = 0;
		// Partition vector
		vector< vector<int> > p(n2, vector<int>(0));
		vector<int>	com(n2, -1);
		int nc = 0;
		for(int i2=n2-1;i2 >=0;--i2)
			if (com[i2] < 0) {
				FOR(j2, i2+1)
					if (r[ iv[i2] ][ iv[j2] ] == 0) {
						com[j2] = nc;
						p[nc].push_back(j2);
					}
				++nc;
			} // if        
		FOR(i2, n2)
			FOR(j2, i2)
				if (com[i2] != com[j2])
					obj+= bmc[ idx2(i2, j2) ];
        
		if (fabs(obj-c_obj) > 1e-5) {
			cout <<"Error: Mismatched objectives! "<< obj<<" "<<c_obj<<" ";
			return;
		}
        cout<<" before: "<<setw(8)<<setprecision(8)<<obj<<" ";
		// swapping
		bool improved;
		do {
			improved = false;
            FOR(c, nc) {
            	//cout <<c<<" ";
				for(int i=p[c].size()-1; i>=0;--i) {
					//cout << p[c][i]<<" ";
					double maxc = 0, bcc=0;
					int	   maxi = -1;
					FOR(c2, nc) {
						double bc2 = 0;
						FOR(i2, p[c2].size())
							bc2 += bmc[ idx2(p[c][i], p[c2][i2]) ];
						if (c2==c)
							bcc = bc2;
						if (bc2 > maxc) {
							maxc = bc2;
							maxi = c2;
						}
					} // FOR
					if ( maxc -bcc > 1e-6) {
						p[maxi].push_back(p[c][i]);
						p[c][i] = p[c].back();
						p[c].pop_back();
						obj = obj + bcc - maxc;
						improved = true;
					}
					//cout<<bcc<<" "<<maxc <<" "<<maxi<<"| ";
				}
				//cout << endl;
            }
		} while (improved);
		FOR(c, nc)
			FOR(i, p[c].size() )
				com[p[c][i] ] = c;
		if (obj < heuObj) {
			double c2_obj = 0;
			FOR(i, n) {
				FOR(j, i) {
					xh[i][j] = xh[j][i]
					         = (com[riv[i] ] == com[riv[j]])?0:1;
					c2_obj += xh[i][j] * m.bm[idx(i,j)];
				}
				xh[i][i] = 0;
			}
			if (fabs(obj-c2_obj) > 1e-5 ) {
				cout<<"Error: Mismatched objective after swapping "<<obj<<" "<<c2_obj<<" ";
				return;
			}            
			heuObj = obj;
		}
        cout <<" after:  "<<setw(8)<<setprecision(8)<<obj;
	}

	void	refineSolution( vector< vector<double> > xm) {
        clock_t start = clock();
        cout<<setw(5)<<" "<<"Refining ";
		vector< vector<int> >	r(n, vector<int>(n,0));
		FOR(i, n) {
			FOR(j, i) {
				r[i][j] = r[j][i] = (xm[i][j]>0.5)?1:0;
				if (xm[i][j] <-0.1) {
					cerr<<"Error: Negative entry found "
						<<i<<" "<<j <<" "<<xm[i][j]<<endl;
					return ;
				}
			}
			r[i][i] = 0;
		}
		localSearch(r, parent);
        cout <<"  time: "<<setprecision(3)<<(clock()-start)/(1.0*CLOCKS_PER_SEC)
             <<" s."<<endl;
             
	}
	void callback() {        
		try {
			if (where == GRB_CB_MESSAGE) {
			} else if (where == GRB_CB_PRESOLVE) {
			} else if (where == GRB_CB_SIMPLEX) {
			} else if (where == GRB_CB_MIP) {
			} else if (where == GRB_CB_MIPSOL) {
                if ( fabs(getDoubleInfo(GRB_CB_MIPSOL_OBJBST)-heuObj)<1e-6)
                    return;
				vector< vector<double> > xm=pcm;
				MY_FOR(i, n)
						FOR(j, i)
							if (i == parent[i] && j == parent[j] && pcc(i,j)==UNIDENTIFIED)
								xm[i][j]= xm[j][i] = getVarSolution(x[i][j]);
							else
								xm[i][j]= xm[j][i] = xm[parent[i]][parent[j]];
                if (m.par->exists("refine"))
				    refineSolution( xm );
			} else if (where == GRB_CB_MIPNODE) {
				double nodcnt = getDoubleInfo(GRB_CB_MIPNODE_NODCNT);
				//int nodstat = getIntInfo(GRB_CB_MIPNODE_STATUS);
				vector< vector<double> > xm=pcm;
				try {
					MY_FOR(i, n)
						 FOR(j, i)
						 	 if (i == parent[i] && j == parent[j] && pcc(i,j)==UNIDENTIFIED)
						 		 xm[i][j] = xm[j][i]= getVarNodeRel(x[i][j]);
						 	 else
						 		 xm[i][j]= xm[j][i] = xm[parent[i]][parent[j]];

				} catch (GRBException e) {                    
                    return;
				}
                reconstruct(xm);
				clock_t start_tr = clock();
				int nt, nst1 = 0, nst2 = 0, cv = 0, vc = 0, vc2=0;
				cv = cut_vertices_check();
				if (m.par->exists("tri2"))
					nt = add_triangle2();
				else if (m.par->exists("tri3"))
					nt = add_triangle3();
				else
					nt = add_triangle();
				if (nt <= n/10) {
					nst1 = add_2partitioning_fast();
					if (nst1 <= n / 10) {
						nst2 = add_2partitioning_deep();
						vc = add_vertex_cut_fast();
						if (nst2 <= 0 && vc <= 0)
							vc2 = add_vertex_cut();
					}
				}
				cout <<"."<<setw(5) << (int)nodcnt << setw(6) << nt << setw(6) << cv
						<< setw(6) << nst1 << setw(6) << nst2 << setw(6) << vc
						<< setw(6) << vc2 << setprecision(2) << setw(7)
						<< (clock() - start_tr) / (1.0 * CLOCKS_PER_SEC) << "s"
						<< endl;
				// Set heuristic solution if better
				if (heuObj < getDoubleInfo(GRB_CB_MIPNODE_OBJBST)) {
					MY_FOR(i, n)
						FOR(j, i)
							if (i == parent[i] && j == parent[j] && pcc(i,j)
									== UNIDENTIFIED)
							setVarSolution(x[i][j], xh[i][j]);
					//cout <<"h"<<setw(6)<<" "<<"New obj: "<<setprecision(8)<<heuObj<<endl;
				}
			}
		} catch (GRBException e) {
			cout << "Error number: " << e.getErrorCode() << endl;
			cout << e.getMessage() << endl;
		} catch (...) {
			cout << "Error during callback" << endl;
		}
	}
};
#endif /* MODULARITYMETRIC_H_ */
