/*
 * Fixed Size Vector
 * Created on: Oct 29, 2010
 * By        : Thang N. Dinh
 * Version   : 0.1
 *
 */
#ifndef	 FIXED_SIZE_VECTOR_HPP 
#define	 FIXED_SIZE_VECTOR_HPP

#include	<vector>
#include	<iostream>
#include 	<fstream>
#include	<algorithm>
#include	<cstdlib>
#include	<cstdio>


struct	 FixedSizeVector {	// labels associated with edges
	T*	 w;
	static int size;
	FixedSizeVector():w(NULL) {}
	inline T &operator[](int i) { return w[i]; }
	FixedSizeVector(const FixedSizeVector<T> &lb) {
		size = lb.size;
		if (lb.w != NULL) {			
			w = new T[size];
			for(int i=0; i < size;++i)
				w[i] = lb.w[i];
		} else {
			w = NULL;
		}
	}
	
	FixedSizeVector(const vector<T> &lb) {
		size = lb.size();
		if (lb.w != NULL) {
			w = new T[size];
			for(int i=0; i < size;++i)
				w[i] = lb.w[i];
		} else {
			w = NULL;
		}
	}
	
	FixedSizeVector& operator=(const FixedSizeVector<T> &lb) {
		if (lb.w == NULL) {
			if (w != NULL)
				delete[] w;
			w = NULL;
		} else {
			if (w == NULL)
				w = new T[size];
			memcpy(w, lb.w,sizeof(T)*size);
		}
        return *this;
	}
	bool operator==(const FixedSizeVector<T> fsv) const {
		if (fsv.w == w)
			return true;
		if (fsv.w == NULL || w == NULL)
			return false;
		for(int i=0; i <size;++i)
			if (w[i] != fsv.w[i])
				return false;
		return true;
	}
	~FixedSizeVector() {
		delete[] w;
	}
};
template <class T>
int FixedSizeVector<T>::size = 0;

template <class T>
istream& operator>>(istream &is, FixedSizeVector<T> &lb) {
	int k = FixedSizeVector<T>::size;
	lb.w = new T[k];
	FOR(i, k)
			is >> lb.w[i];
    return is;
}

istream &operator>>(istream &is, qosAnswer &q) {
	int k, x, y;
	is >> k;
	q.clear();
	for (int i = 0; i < k; ++i) {
		is >> x >> y;
		q.push_back(make_pair(x, y));
	}
	return is;
}

#endif