//==========================================================================================//
// Name        : DOCA.cpp                                                       //
// Author      : Nam Nguyen                                                                 //
// Version     : Final version on static networks                                           //
// Copyright   : Copyright 2011. Date: Sep 02, 2011                                         //
// Description : Main procedure for Overlapping community detection on static networks, as  //
//               described in the paper:                                                    //
//               ''Overlapping Community Structures and Their Detection on Social Networks''//
//               Nam P. Nguyen, Thang N. Dinh, Dung T. Nguyen and My T. Thai                //
//               Proceedings of the 3rd IEEE International Conference on Social Computing   //
//               (SOCIALCOM) 2011.                                                          //
//==========================================================================================//
#include "prototypes.h"
//==========================================================================================//
int main(int argc, char *argv[]) {
	if (argc != 3) {
		cout<<"Error: Usage DOCA.exe <file_name> <overlapping_threshold>"<<endl;
		return NOT_OK;
	}
	char inputFile[256];
	strcpy_s(inputFile, argv[1]);
	double overlapThres = atof(argv[2]);	
	doDOCA(inputFile, overlapThres);
	return OK;
}
