import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;

public class main {
	public static void main(String[] args) throws Exception {		                
                String inputEdgeDeleteFileName=args[2];
                String inputGraphFileName = args[0];                
                String inputCommunityFileName=args[1];
                String outputGraphFileName=args[3];                
                int numberOfCommunitiesToBeDeleted=Integer.parseInt(args[4]);     // number of to be deleted communities, K
                String type=args[5];    // indicates whether K is absolute number or % of total communities
		
                
                // read the input graph file and construct adjacency list
                graph g = new graph(inputGraphFileName + ".txt", inputEdgeDeleteFileName+".txt");                                
                
                // construct the community wise edge list
                g.communityEdgeVertexList(inputGraphFileName+ ".txt", inputCommunityFileName+".txt");		
                
                
                // create the output statistics file
                String figFile=outputGraphFileName;
                if(type.equals("percent")) figFile+="_fig_percent_";
                else figFile+="_fig_absolute_";
                PrintStream fig_file = new PrintStream(new FileOutputStream(new File(figFile+numberOfCommunitiesToBeDeleted+".txt"),false));
                
                
                // break the largest community
                int k=1;
                CCV_Edge_Greedy cip=new CCV_Edge_Greedy(g,inputEdgeDeleteFileName+".txt",k,outputGraphFileName+"_"+k+".txt", type);
                cip.computeTargetCommunity();
                cip.createEdgeGainForEachCommunity();
                cip.compute(); 
                
                int x=(int)(cip.deletedEdgeCount*100/cip.totalCommunityEdges.size());                                
                // print the statistics for k=1
                fig_file.println(k+" "+cip.deletedEdgeCount+" "
                        +x+" "                        
                        +cip.totalCommunityEdges.size());
                
                
                // break rest of the K-1 communities
                for(k=2; k<=numberOfCommunitiesToBeDeleted; k++ )
                {                                        
                    cip.K=k;                    
                    cip.output_file_name=outputGraphFileName+"_"+k+".txt";
                    cip.createEdgeGainForEachCommunity();
                    cip.compute();                                    
                    x=(int)(cip.deletedEdgeCount*100/cip.totalCommunityEdges.size());                                    
                    fig_file.println(k+" "+cip.deletedEdgeCount+" "
                        +x+" "
                        +cip.totalCommunityEdges.size());
                }
                
                fig_file.close();
	}
}