import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import static java.util.concurrent.TimeUnit.NANOSECONDS;
import java.util.StringTokenizer;
import java.util.LinkedHashMap;
import java.util.LinkedList;


public class graph {
	public HashMap<Integer, Set<Integer>> adj; // adjacency matrix
        //public LinkedHashMap<Integer, String> edgeList; // list of edges in graph
        public HashMap<Integer,Integer> nodeId; // all vertices list starting from 0
        public List<String> edgeListIndexOnly; // edges listed according to index
        public List<Integer> vertexListIndexOnly; // vertices listed according to index
        public LinkedHashMap<String,Integer> edgeList; // all edges list starting from 0
        public HashMap<Integer, Set<Integer>> communityVertex;
        public HashMap<Integer, Set<Integer>> communityEdge;
	public int n; // number of nodes
	public int m; // number of edges
        public int l; // number  of communities
        
        public String input_graph_file;

	public graph(graph _g) {		
		this.adj = new HashMap<Integer, Set<Integer>>();
		Set<Entry<Integer, Set<Integer>>> adjSet = _g.adj.entrySet();
		for (Entry<Integer, Set<Integer>> e : adjSet) {
			this.adj.put(e.getKey(), new HashSet<Integer>(e.getValue()));
		}

		// # nodes and # edges
		this.n = _g.n;
		this.m = _g.m;
                this.l = _g.l;
                this.edgeList=_g.edgeList;
                this.nodeId=_g.nodeId;
                this.communityVertex=_g.communityVertex;
                this.edgeListIndexOnly=_g.edgeListIndexOnly;
                this.vertexListIndexOnly=_g.vertexListIndexOnly;
                this.communityEdge= _g.communityEdge;
                this.input_graph_file= _g.input_graph_file;
	}

	public graph(String file_name, String edge_delete_file_name) throws Exception {
		
                this.input_graph_file = file_name;
            
                FileInputStream fstream = new FileInputStream(edge_delete_file_name);
		DataInputStream in = new DataInputStream(fstream);
		BufferedReader br = new BufferedReader(new InputStreamReader(in));
                
		// read the first line to initiate
		String strFirstLine[] = br.readLine().split(" ");
		this.n = Integer.parseInt(strFirstLine[0]);
                this.l = Integer.parseInt(strFirstLine[1]);
                
                System.out.println(this.l);
                
                br.close();
		in.close();
		fstream.close();
                
                fstream = new FileInputStream(file_name);
                in = new DataInputStream(fstream);
		br = new BufferedReader(new InputStreamReader(in));
                String strLine;
                
                long startTime=System.nanoTime();                
                this.nodeId= new HashMap<Integer,Integer>();
                this.vertexListIndexOnly=new ArrayList<Integer>();
                int vertexCounter=0;
                while ((strLine = br.readLine()) != null) {
                        String endpoints[] = strLine.split(" ");

			// node index starts from 1
			int a = Integer.parseInt(endpoints[0]);
			int b = Integer.parseInt(endpoints[1]);
                        
                        if(nodeId.get(a) == null)
                        {
                            nodeId.put(a,vertexCounter);
                            this.vertexListIndexOnly.add(a);
                            vertexCounter++;
                        }
                        if(nodeId.get(b) == null)
                        {
                            nodeId.put(b,vertexCounter);
                            this.vertexListIndexOnly.add(b);
                            vertexCounter++;
                        }
                }
                long endTime = System.nanoTime();                               
                System.out.println("vertex list construction complete, time taken "+NANOSECONDS.toSeconds(endTime-startTime));                
                
                System.out.println("size of nodeId list: "+nodeId.size()+" , total nodes: "+this.n+" vertexCounter: "+vertexCounter+" vertexListOnlySize: "+vertexListIndexOnly.size());
                if(nodeId.size()!=this.n || vertexCounter != this.n || this.vertexListIndexOnly.size() != this.n) 
                {
                    System.out.println("vertex number mismatch, might be problem in input file");
                    System.exit(1);
                }
                
                this.n=nodeId.size();
                
                br.close();
		in.close();
		fstream.close();
                                
                fstream = new FileInputStream(file_name);
                in = new DataInputStream(fstream);
		br = new BufferedReader(new InputStreamReader(in));
                		                
		// initialize empty adjacency matrix
                startTime=System.nanoTime();
		this.adj = new HashMap<Integer, Set<Integer>>();
                for(Integer keySet: nodeId.keySet()){		
			this.adj.put(keySet, new HashSet<Integer>());
		}
                endTime = System.nanoTime();               
                System.out.println("adjacency hash map initialization complete, time taken "+NANOSECONDS.toSeconds(endTime-startTime));
                
		// count the number of edges
                startTime=System.nanoTime();
		this.m = 0;    
                this.edgeListIndexOnly=new ArrayList<String>();
                //this.edgeList=new LinkedHashMap<Integer,String>();
                this.edgeList=new LinkedHashMap<String, Integer>();
                int edgeCounter=0;
		while ((strLine = br.readLine()) != null) {
			String endpoints[] = strLine.split(" ");

			// node index starts from 1
			int a = Integer.parseInt(endpoints[0]);
			int b = Integer.parseInt(endpoints[1]);
                        
			this.adj.get(a).add(b);
			this.adj.get(b).add(a);
                        edgeListIndexOnly.add(a+" "+b);
                        edgeList.put(a+" "+b,edgeCounter);                                                
                        edgeCounter++;
		}
                endTime = System.nanoTime();               
                System.out.println("adjacency list construction complete, time taken "+NANOSECONDS.toSeconds(endTime-startTime));
                
		// count the number of edges
		for (int nodes: nodeId.keySet()){
                        this.m += this.adj.get(nodes).size();
                        
                }                
		// the number of real edges is divided by 2                
		this.m /= 2;

                System.out.println("total number of edges: "+m+ " size of edgelist "+edgeList.size()+ " edgeListIndexOnly size: "+edgeListIndexOnly.size());
                if(edgeList.size()!=this.m || edgeListIndexOnly.size() != this.m) 
                {
                    System.out.println("edge number mismatch, might be problem in input file");
                    System.exit(1);
                }
                
		br.close();
		in.close();
		fstream.close();
	}

        public void communityEdgeVertexList(String inputGraphFileName, String inputCommunityFileName) throws Exception
        {
                FileInputStream fstream = new FileInputStream(inputCommunityFileName);
		DataInputStream in = new DataInputStream(fstream);
		BufferedReader br = new BufferedReader(new InputStreamReader(in));

                
                // initialize community wise edge list
                long startTime=System.nanoTime();
                this.communityEdge = new HashMap<Integer, Set<Integer>>();
                this.communityVertex = new HashMap<Integer, Set<Integer>>();
		for (int i = 1; i <= this.l; i++) {
			this.communityEdge.put(i, new HashSet<Integer>());
                        this.communityVertex.put(i,new HashSet<Integer>());
		}
                long endTime = System.nanoTime();               
                System.out.println("community wise edge hash map initialization complete, time taken "+NANOSECONDS.toSeconds(endTime-startTime));
                
		// read lines one by one for each community
                startTime=System.nanoTime();
                String strLine;
                int communityNum=1;
                while ((strLine = br.readLine()) != null) {                    
                    String community[] = strLine.split(" ");
                    
                    for(int i=0; i<community.length; i++)
                        communityVertex.get(communityNum).add(Integer.parseInt(community[i]));
                                        
                    for(int i=0; i<community.length; i++)
                    {                        
                        for(int j=i+1; j<community.length; j++)
                        {                     
                            if(this.adj.get(Integer.parseInt(community[i])).contains(Integer.parseInt(community[j])))
                                if(this.edgeList.get(community[i]+" "+community[j]) == null)
                                    communityEdge.get(communityNum).add(this.edgeList.get(community[j]+" "+community[i]));
                                else communityEdge.get(communityNum).add(this.edgeList.get(community[i]+" "+community[j]));
                        }
                    }
                    communityNum++;
                }
                endTime = System.nanoTime();               
                System.out.println("graph building and edge identification complete, time taken "+NANOSECONDS.toSeconds(endTime-startTime));
                
                br.close();
		in.close();
		fstream.close();
        }
}
