/**
 *
 * @author alim
 */
import java.util.HashSet;
import java.util.Set;
import java.util.Iterator;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.File;
import java.io.FileOutputStream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import static java.util.concurrent.TimeUnit.NANOSECONDS;

public class CCV_Edge_Greedy {
	private int[] k; // indicates edge numbers to be deleted from community i        
	private int[] s; // indicates node numbers in community i
        private int[] edge; // indicates total edge numbers in community i
        public int[] targetCommunityList; // stores the communities we want to break
                
        private int l; // number of communities
        
        private String file_name;           // input graph file name
        public String output_file_name;     //        

	private graph g; // input graph	
	public int K; // #critical edges	        
        
        public int deletedEdgeCount;    // total deleted edge count for breaking k communities
        String type;    // # of broken communities to be broken are absolute number / percentage of total communities
        
        public HashMap<Integer, Set<Integer>> edgeCommList;     // edge numbers for each community
        private Map<Integer,Integer> edgeGain;  // gain for each edge
        private Map<Integer,Integer> unSortedCommunity;    // stores commuities
        public LinkedHashMap<Integer, Set<Integer>> targetCommunityEdge; // stores communities in sorted order
        public HashSet<Integer> totalCommunityEdges;   // cumulative edges of all the deleted communities         
        
        public CCV_Edge_Greedy(graph _g, String input_file_name, int k, String output_file_name,String type)/*, int _k, int _d, double _theta)*/ throws Exception {
		this.g = new graph(_g);
                this.file_name=input_file_name;
                this.output_file_name=output_file_name;                
                this.K=k;                
                this.type=type;
	}
        
        public void createEdgeGainForEachCommunity() throws Exception
        {               
            if(this.type.equals("percent")) this.K=this.g.l*K/100;
            this.edgeGain= new HashMap<Integer,Integer>();
            this.edgeCommList = new HashMap<Integer,Set<Integer>>();
            int index = 0;
            totalCommunityEdges= new HashSet<Integer>();            
            
            for (Map.Entry<Integer, Set<Integer>> entry : this.targetCommunityEdge.entrySet()) 
            {
                if (index == this.K)
                        break;
                else {                            
                    int commNum=entry.getKey();
                    totalCommunityEdges.addAll(this.g.communityEdge.get(commNum));                    
                    for (Integer j : this.targetCommunityEdge.get(commNum)) {
                        this.edgeCommList.put(j, new HashSet<Integer>());
                        this.edgeCommList.get(j).add(commNum);
                        if(edgeGain.get(j)==null) edgeGain.put(j, 1);
                        else edgeGain.put(j, edgeGain.get(j)+1);                                    
                    }                     
                    Set<Integer> S_comm=new HashSet<Integer>(g.communityVertex.get(commNum));                        
                    Set<String> deletedVertexEdgeThisComm= new HashSet<String>(); 
                    while(deletedVertexEdgeThisComm.size() < this.k[commNum-1])
                    {
                        int degree=99999;
                        int minVertex=-1;
                        Set<Integer> S=S_comm;
                        Set<Integer> tAdjacentOfj =null;
                        for(int j: S)
                        {                        
                            tAdjacentOfj = new HashSet<Integer>(g.adj.get(j));
                            tAdjacentOfj.retainAll(S_comm);                            
                            int indegreeOfj = tAdjacentOfj.size();                            
                            if(indegreeOfj < degree)
                            {   
                                degree=indegreeOfj;                                            
                                minVertex=j;
                            }
                        }
                        S_comm.remove(minVertex);                    
                        tAdjacentOfj = new HashSet<Integer>(g.adj.get(minVertex));
                        tAdjacentOfj.retainAll(S_comm);
                        for(int d: tAdjacentOfj)
                        {
                            if(d > minVertex) deletedVertexEdgeThisComm.add(minVertex+" "+d);
                            else deletedVertexEdgeThisComm.add(d+" "+minVertex);
                        }                                            
                    }                    
                    index++;
                }
            }
        }       
	
        public List<Map.Entry<Integer, Integer>> sortEdgeGains()
        {
            List<Map.Entry<Integer, Integer>> list = new LinkedList<Map.Entry<Integer, Integer>>(
                            this.edgeGain.entrySet());    
            
            Collections.sort(list, new Comparator<Map.Entry<Integer, Integer>>() 
            {
                public int compare(Map.Entry<Integer, Integer> o1,
                                Map.Entry<Integer, Integer> o2) {
                    // sort decreasingly                            
                    if(o2.getValue()>o1.getValue())
                        return 1;
                    else if(o2.getValue()<o1.getValue())
                        return -1;
                    else return 0;                             
                }
            });            
            return list;
        }
        
        public void compute() throws Exception {
            
            int [] dv= new int[this.l];            
            for(int c=0; c<this.l; c++){                
                dv[c]=k[c];                
            }    
            // **************************** Greedy Algorithm **********************************//
            List<Integer> resultEdgeList= new ArrayList<Integer>();
            int maxGainEdge;  
            List<Map.Entry<Integer, Integer>> list=null;
            
            int edgeCount=0;            
            Set<Integer> handledCommunity= new HashSet<Integer>();
            list= sortEdgeGains();
            while(handledCommunity.size()<this.K)
            {   
                maxGainEdge=list.get(edgeCount).getKey();                
                resultEdgeList.add(maxGainEdge);
                edgeCount++;
                for(int l=0;l<this.K; l++)
                {
                    int commNum=this.targetCommunityList[l];
                    if(handledCommunity.contains(commNum))continue;
                    if(this.g.communityEdge.get(commNum).contains(maxGainEdge)) 
                    {
                        dv[commNum-1] = dv[commNum-1] - 1;
                        if(dv[commNum-1] <= 0 )   // this community is already broken so no need to any more edge from this community
                        {
                            handledCommunity.add(commNum);                            
                            boolean changed=false;
                            for(int j: this.g.communityEdge.get(commNum))                                
                                if( ! resultEdgeList.contains(j)) {
                                    changed=true;                                
                                    this.edgeGain.put(j, edgeGain.get(j)-1);
                                }
                            if(changed) list= sortEdgeGains();
                        }
                    }
                }
            }
            
            deletedEdgeCount=resultEdgeList.size();
	}
        
        public void computeTargetCommunity() throws Exception
        {
            FileInputStream fstream = new FileInputStream(this.file_name);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));

            String strLine[] = br.readLine().split(" ");
            this.l = Integer.parseInt(strLine[1]);      // total community count is l

            // reading the file for number of edge per community
            this.k= new int[l];            
            this.s=new int[l];
            this.edge=new int[l];
            for(int c=0; c<this.l; c++){
                String str[]=br.readLine().split(" ");
                this.k[c]=Integer.parseInt(str[0]);                                
                this.s[c]=Integer.parseInt(str[1]); 
                this.edge[c]=Integer.parseInt(str[2]); 
            }
            
            // store the community number and vertex count for each community
            unSortedCommunity = new HashMap<Integer, Integer>();
            for (int v=1;v<=this.l;v++) {
                unSortedCommunity.put(v, s[v-1]);  
            }            
            List<Map.Entry<Integer, Integer>> list = new LinkedList<Map.Entry<Integer, Integer>>(
                                unSortedCommunity.entrySet());    
            
            Collections.sort(list, new Comparator<Map.Entry<Integer, Integer>>() 
            {
                public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) 
                {
                    // sort decreasingly                                
                    if(o2.getValue()>o1.getValue())
                        return 1;
                    else if(o2.getValue()<o1.getValue())
                        return -1;
                    else 
                    {
                        // for a tie, we will return the community with more inside edges, leading the possibility of stronger community when detected later                                
                        return  edge[o2.getKey()-1]-edge[o1.getKey()-1];                                                                        
                    }
                }
            });
            
            targetCommunityList = new int[this.g.l];
            this.targetCommunityEdge = new LinkedHashMap<Integer, Set<Integer>>();		
            int currentCommunity=0;
            for (Map.Entry<Integer, Integer> entry : list) {            
                targetCommunityList[currentCommunity++]=entry.getKey();
                this.targetCommunityEdge.put(entry.getKey(), this.g.communityEdge.get(entry.getKey()));                
            }
            
            br.close();
            in.close();
            fstream.close();
        }
        
}