/*
 * maxheap.h
 *
 *  Created on: Mar 6, 2010
 *      Author: seven
 */
#include "common.h"
#include <vector>
#include <limits>
#ifndef MAXHEAP_H_
#define MAXHEAP_H_
using namespace std;

struct heapElement {
	int id;
	double key;
};

class MaxHeap {
private:
	vector<int> id2Index;
	vector<heapElement> elements;
public:
	MaxHeap(vector<heapElement>);
	void exchangePosition(int, int);
	void heapify(int);
	void build();
	heapElement getMax();
	heapElement extractMax();
	void increaseKey(int, double);
	void updateKey(int, double);
	void changeKey(int, double);
	void insert(heapElement);
	int getSize();
	virtual ~MaxHeap();
};

#endif /* MAXHEAP_H_ */
