#include "common.h"
#include "IDS.h"
#include "ICM.h"
#include "Measure.h"
#include "Util.h"
#include "test.h"
#include "DynStack.h"
#include "RW.h"
#include "Experiments.h"
#include <iostream>
#include <cstdio>
#include <fstream>
#include <cstdlib>
#include <cmath>
#include <map>
#include <iterator>
#include <algorithm>
#include <vector>
#include <sstream>
#include <string>
#include <set>
#include <ctime>
#include <cassert>
#include  <stdlib.h>
#include  <stdio.h>
#include  <time.h>

//extern "C" {
//#include <igraph.h>
//}
// For PC
//#define	 DIRECTORY "D:\\Store\\Study-work-research\\Work\\experiment\\realData"
// For Workstation
#define	 DIRECTORY "D:\\Research\\dung\\realData"
#define	 INPUT "\\karate.paj"
//#define  OUTPUT "\\facebook-modified.dat"
//#define  OUTPUT "\\karate.dat"
//#define  OUTPUT "\\test1.dat"
//#define  OUTPUT "\\orkut-modified.dat"
#define  OUTPUT "\\hep.dat"
//#define  OUTPUT "\\phy.dat"
//#define  OUTPUT "\\barabasi24_10000_78668.dat"
//#define  OUTPUT "\\er10000_78653.dat"
using namespace std;


void testDecay(AdjGraph& graph, double rho, string dataName);
void testGrow(AdjGraph& graph, double rho, int latency, string dataName);
void testRhoTpids(AdjGraph& graph, string dataName);
void testPidsCommunityBase(AdjGraph& graph, string directory, double rho, double fraction, string dataName);
void histogramCommunity(AdjGraph& graph, string comFile, string dataName);
void testPidsRandom(AdjGraph& graph, double rho, double fraction, string dataName);
void histogramDegree(AdjGraph& graph, string dataName);
void testTpidsCommunityBase(AdjGraph& graph, string directory, string dataName);
void testCombination(AdjGraph& graph, double rho, double fraction, double factor, string dataName);
void testPidsLatency(vector<int> (*f)(AdjGraph&, double, double, int),AdjGraph& graph, double rho, double fraction, string dataName);
void testPidsRho(vector<int> (*f)(AdjGraph&, double, double, int),AdjGraph& graph, double fraction, int latency, string dataName);
void testPidsRandomRho(AdjGraph& graph, double fraction, int latency, string dataName);
vector<int> removeDuplicates(vector<int> sequence, int maxValue);
void communityDetect(AdjGraph& graph, const char *fileName);
int convertIF2Blond(const char *inFile,const char *outFile);
void testPidsLatencyRW(AdjGraph& graph, double rho, double fraction, string dataName);
void testPidsLatencyIMeter(AdjGraph& graph, double rho, double fraction, string dataName);
void experiment(string file, string dataName);
void testPidsGrow(vector<int> (*f)(AdjGraph&, double, double, int),AdjGraph& graph, double rho, int latency, string dataName);
int main(void)
{
	//random_device rd;
	//srand(rd());
	srand(time ( NULL ));
	string directory = string("D:\\Research\\dung\\realData");
	char testFile[50];
	sprintf(testFile, "%s\\karate.dat", directory.c_str());
	FILE *fo;
	fo = fopen(testFile, "r");

	if (!fo) {
		directory = string("D:\\Store\\Study-work-research\\Work\\experiment\\realData");
	}

	//clock_t start, stop;
	//double t = 0.0;
	// Start timer
	//double rho = 0.1;
	//double rho = 0.3;
	//int latency = 10;
	double fraction = 0.8;
	double factor;
	int latency = 1;
	double rho;
	double t;
	//assert((start = clock())!=-1);

	string input = string(DIRECTORY) + string(INPUT), output = string(DIRECTORY) + string(OUTPUT);
	//string input = string("erdos.adj");
	//string output = string("erdos.bin");
	//string output = string("orkut-modified.dat");

	AdjGraph *graph = new AdjGraph(output.c_str(), false);

	//double r[] = {0.2, 0.8, 0.3, 0.4, 0.5 }
	/*
	rho = 0.8;
	for (latency = 2; latency < 5; latency++){
		cout << rho << latency << endl;
		//testPidsGrow(pidsGreedyHighestDegree, *graph, rho, latency, "MaxDegree_Orkut_increase");
		testPidsGrow(pidsMaxActiveNodePruned, *graph, rho, latency, "NodePrune_Orkut_increase");
	}
*/

	for (rho = 0.3; rho < 0.4; rho += 0.1)
	for (latency = 1; latency < 7; latency++){
		cout << rho << latency << endl;
		//testPidsGrow(pidsGreedyHighestDegree, *graph, rho, latency, "MaxDegree_Orkut_increase");
		pidsMaxActiveNodePruned(*graph, rho, fraction, latency);
		pidsMaxActiveNode(*graph, rho, fraction, latency);
	}

	for (rho = 0.3; rho < 0.4; rho += 0.1)
	for (latency = 1; latency < 7; latency++){
		cout << rho << latency << endl;
		//testPidsGrow(pidsGreedyHighestDegree, *graph, rho, latency, "MaxDegree_Orkut_increase");
		nostate_lazy(*graph, rho, fraction, latency);
		nostate_nolazy(*graph, rho, fraction, latency);
	}

	delete(graph);
/*
	//convertFile(input.c_str(), output.c_str());
	AdjGraph *graph = new AdjGraph(output.c_str(), false);
	for (rho = 0.2; rho < 0.9; rho += 0.1)
	for (latency = 2; latency < 5; latency++){
		testPidsGrow(pidsMaxActiveNode, *graph, rho, latency, "Selective_Erdos_increase");
		testPidsGrow(pidsGreedyHighestDegree, *graph, rho, latency, "MaxDegree_Erdos_increase");
	}
	delete(graph);


	/*
	AdjGraph *graph = new AdjGraph(output.c_str(), false);
	for (rho = 0.3; rho < 0.9; rho += 0.1) {
		testPidsLatency(pidsMaxActiveNode, *graph, rho, fraction, "GreedyLatency");
		testPidsLatency(pidsGreedyHighestDegree, *graph, rho, fraction, "MaxDegreeLatency");
	}
	delete(graph);
	//output = string("facebook-modified.dat");
	//string communityDir = string(DIRECTORY) + "\\orkut-COM";
	//string communityDir = string(DIRECTORY) + "\\facebook-COM";
	//communitySizeDistribution(communityDir.c_str());
	//output = "facebook-modified.dat";
	//convertFile(input.c_str(), output.c_str());
	//printf("Any thing");
	//testBiEdgeComponents();
	//testBiNodeComponents();
	//DynStack<int> intStack;

	//intStack.push( 5 );
	//convertParjekFile(input.c_str(),output.c_str());

	//AdjGraph *graph = new AdjGraph(output.c_str(), false);
	//fusedWalkShow(*graph);
	//delete graph;
	//experiment(string(DIRECTORY) + "\\facebook-modified.dat", "Facebook");
	//experiment(string(DIRECTORY) + "\\hep.dat", "Hep");
	//experiment(string(DIRECTORY) + "\\phy.dat", "Phy");
	//experiment(string(DIRECTORY) + "\\orkut-modified.dat", "Orkut");
	//exprIcmGreedyVsImeterVsRW(string(DIRECTORY) + "\\facebook-modified.dat", "Facebook");
	//exprIcmGreedyVsImeterVsRW(directory + "\\karate.dat", "Karate");
	//exprIcmGreedyVsImeterVsRW(string(DIRECTORY) + "\\hep.dat", "Hep");
	//exprIcmGreedyVsImeterVsRW(string(DIRECTORY) + "\\phy.dat", "Phy");

	//effector(directory + "\\karate.dat", "Karate");
	//effector(directory + "\\hep.dat", "Hep");
	//effector(directory + "\\phy.dat", "Phy");
	//effector(directory + "\\facebook-modified.dat", "Facebook");
	//effectorNodes(directory + "\\karate.dat", "Karate");
	//effectorNodes(directory + "\\facebook-modified.dat", "Facebook");
	//effectorNodes(directory + "\\hep.dat", "Hep");
	//effectorNodes(directory + "\\phy.dat", "Phy");

	//effectorNodesGreedy(directory + "\\hep.dat", "Hep");
	//effectorNodesGreedy(directory + "\\soc-Epinions1.dat", "Epinions");
	//effectorNodesGreedy(directory + "\\Email-Enron.dat", "EmailEnron");
	//effectorNodesGreedy(directory + "\\Slashdot0902.dat", "Slashdot");

	//effectorNodesEffector(directory + "\\soc-Epinions1.dat", "Epinions");
	//effectorNodesEffector(directory + "\\Email-Enron.dat", "EmailEnron");
	//effectorNodesEffector(directory + "\\Slashdot0902.dat", "Slashdot");

	//effectorNodes(directory + "\\soc-Epinions1.dat", "Epinions");
	//effectorNodes(directory + "\\Email-Enron.dat", "EmailEnron");
	//effectorNodes(directory + "\\Slashdot0902.dat", "Slashdot");

	//effectorNodesEffector(directory + "\\karate.dat", "Karate");
	//optimalTestGreedy(directory + "\\karate.dat", "Karate");
	//optimalTestDistance(directory + "\\karate.dat", "Karate");
	//optimalTestSort(directory + "\\karate.dat", "Karate");
	//effectorNodesEffector(directory + "\\karate.dat", "EmailEnron");
	//string txtFile = directory + "\\soc-Epinions1.txt";
	//string binFile = directory + "\\soc-Epinions1.dat";
	//convertFile(txtFile.c_str(), binFile.c_str(), true, true);


	//testPidsLatency(pidsGreedyHighestDegree, *graph, rho, fraction, "Facebook");
	//testPidsLatencyRW(*graph, rho, fraction, "Facebook");
	//testPidsLatencyIMeter(*graph, rho, fraction, "Facebook");

	//testPidsLatencyRW(*graph, rho, fraction, "Phy");
	//testPidsLatencyIMeter(*graph, rho, fraction, "Phy");

	//exportEdgeListTxt(graph, "karate.txt");
	//biEdgeComponents(graph);
	//biNodeComponents(graph);
	//exportEdgeListTxt(graph, "facebook.txt");
	//delete graph;

	//vector<int> pids = pidsGreedyHighestDegree(*graph, rho, fraction, latency);
	//printf("Latency is %d %d ", pids[0], getLatency(*graph, 0.1, 0.6, &pids[0], pids.size()));
	//vector<int> pids = Icm_Pids(*graph, 0.1, 0.6, 0.9, 4, 100);
	//printf("Size of PIDS %d", pids.size());

	//delete graph;
	//AdjGraph *graph = new AdjGraph(output.c_str(), false);
	//communityDetect(*graph, "facebookLabel.txt");
	//graph->exportParjek("orkut.net");
	//convertIF2Blond("facebook.clu", "facebook_IF_COM.txt");

	//graph->exportTulip("facebook.tlp");
	//graph->exportParjek("facebookParjek.txt");
	//vector<int> pids = pidsGreedyHighestDegree(*graph, rho, fraction, latency);
	//printf("Coverage %d size %d ", pidsCoverage(*graph, rho, latency, pids), pids.size());

	//Test rho
	latency = 5;
	//testPidsRandomRho(*graph, fraction, latency, "Er");
	//testPidsRho(pidsMaxActiveNodePruned, *graph, fraction, latency, "PidsErPruneMaxActiveEdgeOne");
	//testPidsRho(pidsModifiedHighestDomination, *graph, fraction, latency, "PidsErVirAds");
	//testPidsRho(pidsGreedyHighestDegree, *graph, fraction, latency, "PidsErMaxDegree");
	//testPidsRho(pidsMaxActiveNode, *graph, fraction, latency,"PidsFacebookMaxActiveNodeOrigin");
	//Test latency
	rho = 0.1;
	//testPidsRandom(*graph, rho, fraction, "Er");
	//testPidsLatency(pidsMaxActiveNodePruned, *graph, rho, fraction, "PidsErPruneMaxActiveEdgeOne");
	//testPidsLatency(pidsModifiedHighestDomination, *graph, rho, fraction,"PidsErVirAds");
	//testPidsLatency(pidsGreedyHighestDegree, *graph, rho, fraction,"PidsErMaxDegree");
	//testPidsLatency(pidsMaxActiveNode, *graph, rho, fraction,"PidsErMaxActiveNodeOrigin");
	//vector<int> pids = pidsMaxActiveNode(*graph, rho, fraction, latency);

	latency = 10;
	//testPidsRandomRho(*graph, fraction, latency, "Orkut");
	//testPidsRho(pidsMaxActiveNodePruned, *graph, fraction, latency, "PidsOrkutPruneMaxActiveEdgeOne");
	//testPidsRho(pidsModifiedHighestDomination, *graph, fraction, latency, "PidsOrkutVirAds");
	//testPidsRho(pidsGreedyHighestDegree, *graph, fraction, latency, "PidsOrkutMaxDegree");

	//delete graph;
	//convertFile(input.c_str(), output.c_str());
	/*
	AdjGraph *graph = new AdjGraph(output.c_str(), false);
	//vector<int> pids = pidsMaxActiveNode(*graph, rho, fraction, latency);
	//printf("Test coverage: %d and size %d", pidsCoverage(*graph, rho, latency, pids), pids.size());
	rho = 0.1;
	//testPidsLatency(pidsMaxActiveNode, *graph, rho, fraction, "xxPidsFacebookMaxActive");
	rho = 0.3;
	//testPidsLatency(pidsMaxActiveNode, *graph, rho, fraction, "xxPidsFacebookMaxActive");
	rho = 0.5;
	//testPidsLatency(pidsMaxActiveNode, *graph, rho, fraction, "xxPidsFacebookMaxActive");
	//vector<int> pids = pidsMaxActiveNode(*graph, rho, fraction, latency);
	//printf("Test coverage: %d and size %d", pidsCoverage(*graph, rho, latency, pids), pids.size());
	rho = 0.1;
	//testPidsLatency(pidsMaxActiveEdge, *graph, rho, fraction, "xxPidsFacebookMaxActiveEdge");
	rho = 0.3;
	testPidsLatency(pidsMaxActiveNode, *graph, rho, fraction, "xxPidsFacebookMaxActiveEdge");
	rho = 0.5;
	testPidsLatency(pidsMaxActiveNode, *graph, rho, fraction, "xxPidsFacebookMaxActiveEdge");

	delete graph;
/**/
	/*
//Test with rho
	AdjGraph *graph = new AdjGraph(output.c_str(), false);
	//rho = 0.1;
	//testPidsRandom(*graph, rho, fraction, "Orkut");
	//testPidsLatency(pidsGreedyHighestDegree, *graph, rho, fraction, "PidsOrkutMaxDegree");
	//testPidsLatency(pidsModifiedHighestDomination, *graph, rho, fraction, "PidsOrkutVirAds");
	//testPidsLatency(pidsImprovedHighestDomination, *graph, rho, fraction, "PidsOrkutFraction");
	//rho = 0.3;
	//testPidsRandom(*graph, rho, fraction, "Orkut");
	//testPidsLatency(pidsGreedyHighestDegree, *graph, rho, fraction, "PidsOrkutMaxDegree");
	//testPidsLatency(pidsModifiedHighestDomination, *graph, rho, fraction, "PidsOrkutVirAds");
	//testPidsLatency(pidsImprovedHighestDomination, *graph, rho, fraction, "PidsOrkutFraction");
	//rho = 0.5;
	//testPidsRandom(*graph, rho, fraction, "Orkut");
	//testPidsLatency(pidsGreedyHighestDegree, *graph, rho, fraction, "PidsOrkutMaxDegree");
	//testPidsLatency(pidsModifiedHighestDomination, *graph, rho, fraction, "PidsOrkutVirAds");
	//testPidsLatency(pidsImprovedHighestDomination, *graph, rho, fraction, "PidsOrkutFraction");
	rho = 0.1;
	//testPidsRandom(*graph, rho, fraction, "Facebook");
	testPidsLatency(pidsGreedyHighestDegree, *graph, rho, fraction, "PidsFacebookMaxDegree");
	//testPidsLatency(pidsModifiedHighestDomination, *graph, rho, fraction, "PidsFacebookVirAds");
	//testPidsLatency(pidsImprovedHighestDomination, *graph, rho, fraction, "PidsFacebookFraction");
	rho = 0.3;
	//testPidsRandom(*graph, rho, fraction, "Facebook");
	testPidsLatency(pidsGreedyHighestDegree, *graph, rho, fraction, "PidsFacebookMaxDegree");
	//testPidsLatency(pidsModifiedHighestDomination, *graph, rho, fraction, "PidsFacebookVirAds");
	//testPidsLatency(pidsImprovedHighestDomination, *graph, rho, fraction, "PidsFacebookFraction");
	rho = 0.5;
	//testPidsRandom(*graph, rho, fraction, "Facebook");
	testPidsLatency(pidsGreedyHighestDegree, *graph, rho, fraction, "PidsFacebookMaxDegree");
	//testPidsLatency(pidsModifiedHighestDomination, *graph, rho, fraction, "PidsFacebookVirAds");
	//testPidsLatency(pidsImprovedHighestDomination, *graph, rho, fraction, "PidsFacebookFraction");
	delete graph;
/**/
	//testImproved(*graph, 0.5, 0.1, "facebook");
	//double averageDegree = 2 * graph->numberOfEdge()/(graph->order()*1.0);
	//printf("average degree: %f", averageDegree);
	//for (factor = 0.1; factor<1;factor += 0.1)
	//testCombination(*graph, rho, fraction, factor, "Orkut");
	//testHighestDegree(*graph, 0.3, 1.0, "Facebook");
	//vector<int> pids = pidsModifiedHighestDomination(*graph, rho, fraction, latency);
	//vector<int> pids = pidsMMHighestDomination(*graph, rho, fraction, latency);
	//vector<int> pids = pidsGreedyHighestDegree(*graph, rho, fraction, latency);
	//printf("Test coverage: %d and size %d", pidsCoverage(*graph, rho, latency, pids), pids.size());
	//testMMHighestDegree(*graph, 0.3, 1.0, "facebook");
	//testModifiedHighestDegree(*graph, 0.1, 1.0, "orkut");
	//testModifiedHighestDegree(*graph, 0.3, 1.0, "orkut");
	//testModifiedHighestDegree(*graph, 0.5, 1.0, "orkut");
	//testPidsCommunityBase(*graph, communityDir, 0.1, fraction, "orkut");
	//testPidsCommunityBase(*graph, communityDir, 0.3, fraction, "orkut");
	//testPidsCommunityBase(*graph, communityDir, 0.5, fraction, "orkut");
	//testTpidsCommunityBase(*graph, communityDir, "facebook");
	//testGrow(*graph, 0.1, 10, "Facebook");
	//testGrow(*graph, 0.3, 10, "Facebook");
	//testGrow(*graph, 0.5, 10, "Facebook");
	//delete graph;



	//string comFile =  string(DIRECTORY) + string("\\orkut-COM.txt");
	//string output = string("facebook-links-full.dat");
	//string output = string("orkut-links.dat");
	//string out = string(DIRECTORY) + string("orkut-com.bin");
	//printf("%s\n", communityDir.c_str());

	/*
	//Print degree distribution
	AdjGraph *graph = new AdjGraph(output.c_str(), false);
	//testTpidsCommunityBase(communityDir, "Facebook");
	//printf(" %d %d", graph->order(), graph->numberOfEdge());
	histogramDegree(*graph, "Phy");
	//testPidsRandom(*graph, 0.5, 1, "Orkut");
	//testPidsRandom(*graph, 0.1, 1, "Orkut");

	delete graph;

	/**/
	/* Stop timer */
	//stop = clock();
	//t = (double) (stop-start)/CLOCKS_PER_SEC;

	//printf("Run time: %f\n", t);
	//testPidsCommunityBase(communityDir, 0.5, fraction, "orkut");
	//testPidsCommunityBase(communityDir, 0.1, 1.0, "orkut");
	//vector<int> pids = pidsCommunityBaseHighestDegree(communityDir.c_str(), rho, fraction, latency);
	//vector<int> pids = pidsCommunityBaseHighestDomination(communityDir.c_str(), rho, fraction, latency);
	//printf("size of pids community base is %d", pids.size());
	//delete graph;


	/*
	 //extract Histogram of communities

	 */

	/*

	//testRhoTpids(*graph, "Orkut");
	//testRhoTpids(*graph, "Orkut");
	//testGrow(*graph, 1, "Facebook");

	//testDecay(*graph, 0.5, "FacebookDecay");
	//testDecay(*graph, 0.1, "OrkutDecay");


	//testDecay(*graph, "Facebook");
	/*
	vector<int> thd = tpidsGreedyHighestDomination(*graph, rho);
	vector<int> thde = tpidsGreedyHighestDegree(*graph, rho);
	thd.erase(thd.begin());
	vector<int> newSet = tpidsDecay(*graph, rho, thd);

	printf("\nthd %d %d", tpidsCheck(*graph, rho, thd), thd.size());
	printf("\nthd %d %d", tpidsCheck(*graph, rho, thde), thde.size());
	printf("\nthd %d %d", tpidsCheck(*graph, rho, newSet), newSet.size());
	//rhoFractionLatency(*graph, dataName);
	 *
	 */

	/**/
	/*
	 //Test Community

	AdjGraph *graph = new AdjGraph(output.c_str(), false);
	//string communityDir = string(DIRECTORY) + string("\\orkut-SemiOverlapCOM");
	string communityDir = string(DIRECTORY) + string("\\facebook-SemiOverlapCOM_IF");
	rho = 0.1;
	testPidsCommunityBase(*graph, communityDir, rho, fraction, "FacebookSemiOverlapIF");
	rho = 0.3;
	testPidsCommunityBase(*graph, communityDir, rho, fraction, "FacebookSemiOverlapIF");
	rho = 0.5;
	testPidsCommunityBase(*graph, communityDir, rho, fraction, "FacebookSemiOverlapIF");

	delete graph;
	/**/

	/*
	//Create dat file for communities

	//string comFile =  string(DIRECTORY) + string("\\orkut-COM.txt");
	string comFile =  string(DIRECTORY) + string("\\facebook_IF_COM.txt");
	char from[30];
	char to[30];
	printf("%s", comFile.c_str());
	AdjGraph *graph = new AdjGraph(output.c_str(), false);

	int max = graph->createSemiOverlapCommunityFile(comFile.c_str(), "Facebook");
	printf("\nMax = %d\n", max);
	for (int i=0;i<max;i++){
		sprintf(from, "FacebookCOM%d.txt", i);
		sprintf(to, "FacebookCOM%d.dat", i);
		convertFile(from, to);
	}
	delete graph;
	/* */
	return 0;
}
/*
void communityDetect(AdjGraph& graph, const char *fileName){
	igraph_t igraph;
	igraph_vector_t edges;
	igraph_vector_t weight;
	igraph_vector_t member, initial;
	igraph_vector_bool_t fixed;

	int m = graph.numberOfEdge();
	int n = graph.order();
	int edge_index = 0;


	igraph_vector_init(&edges, m*2);
	igraph_vector_init(&weight, m);
	for (int u=0;u<n;++u){
		vector<int> neis = graph.neighbors(u);

		for(int j=0;j<neis.size();++j){
			if (u<neis[u]){
				VECTOR(edges)[ 2 * edge_index ] = u;
				VECTOR(edges)[ 2 * edge_index + 1 ] = neis[ j ];
				VECTOR(weight)[ edge_index ] = 1;
				edge_index++;
			}
		}
	}

	igraph_create(&igraph, &edges, 0, IGRAPH_UNDIRECTED);

	igraph_vector_init(&member, n);

	igraph_community_label_propagation(&igraph,&member, &weight,&initial, &fixed);


	FILE *fo = fopen(fileName, "w");
	for (int u=0;u<n;++u)
		fprintf(fo, "%d %d\n", u, VECTOR(member)[ u ]);
	fclose(fo);

	igraph_vector_destroy(&edges);
	igraph_vector_destroy(&weight);
	igraph_vector_destroy(&member);
	igraph_vector_destroy(&initial);
	igraph_vector_bool_destroy(&fixed);
	igraph_destroy(&igraph);
}
 */

int convertIF2Blond(const char *inFile,const char *outFile){
	FILE *fin = fopen(inFile, "r");
	FILE *fo = fopen(outFile, "w");
	if (!fin || !fo) {
		cerr <<"Error: File access denied."<<endl;
		return 2;
	}
	printf("aa\n");
	int n;
	int com;
	char str [100];
	printf("1\n");
	fscanf(fin, "%s %d", str,&n);
	printf("2\n");
	for (int u = 0; u < n; ++u){
		//printf("3\n");
		fscanf(fin, "");
		fscanf(fin, "%d ", &com);
		fprintf(fo, "%d %d\n", u, com);
	}

	fclose(fin);
	fclose(fo);
	return 0;
}


///==================================================================================

void experiment(string file, string dataName){
	double rho, fraction;
	AdjGraph *graph = new AdjGraph(file.c_str(), false);

	//Test with different rho
	fraction = 1;
	rho = 0.1;
	testPidsLatencyRW(*graph, rho, fraction, dataName);
	testPidsLatencyIMeter(*graph, rho, fraction, dataName);

	rho = 0.3;
	testPidsLatencyRW(*graph, rho, fraction, dataName);
	testPidsLatencyIMeter(*graph, rho, fraction, dataName);

	rho = 0.5;
	testPidsLatencyRW(*graph, rho, fraction, dataName);
	testPidsLatencyIMeter(*graph, rho, fraction, dataName);

	delete graph;
}
///==================================================================================

void testDecay(AdjGraph& graph, double rho, string dataName){
	FILE *fo;
	char outName[40];
	//double rho;
	double fraction;
	int latency;
	int percent;
	int result[11][6];

	//rho = 0.5
	//rho = 0.5;
	vector<int> thd = tpidsGreedyHighestDomination(graph, rho);
	printf("Finished tpids");

	//Delete highest degree
	sprintf(outName, "%sRho%0.1fHDHD.txt",dataName.c_str(), rho);

	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "Decay phenomenon on the total pids produced by highest dominationg algorithm.\n");
	fprintf(fo, "Rho = %0.1f, decay percent increase from 5 to 30 and the process lasts 10 hops. Nodes are delete from highest one.\n", rho);

	vector<Node> nodes;
	nodes.reserve( thd.size() );
	FOR (i, thd.size() ){
		Node node = { thd[ i ], graph.getDegree( thd[ i ]) };
		nodes.push_back(node);
	}

	sort(nodes.begin(), nodes.end(), comp);
	FOR (i, thd.size() )
	thd[ i ] = nodes[ i ].id;

	for ( percent = 5; percent <= 30; percent += 5){
		vector<int> initial;

		for (int i = percent*thd.size()/100; i < thd.size(); ++i)
			initial.push_back( thd[i] );
		result [ 0 ][ percent/5 - 1 ] = initial.size();

		FOR (latency, 10){
			initial = tpidsDecay(graph, rho, initial);
			result[ latency + 1][percent/5 - 1] = initial.size();
		}
	}

	FOR (i, 11){
		fprintf(fo, "%d ", i);
		FOR (j, 6)
		fprintf(fo, "%d ", result [ i ][ j ]);
		fprintf(fo, "\n");
	}
	fclose(fo); //end of delete highest degree nodes


	//Delete random nodes
	sprintf(outName, "%sRho%0.1fHDRD.txt",dataName.c_str(), rho);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "Decay phenomenon on the total pids produced by highest dominationg algorithm.\n");
	fprintf(fo, "Rho = %0.1f, decay percent increase from 5 to 30 and the process lasts 10 hops. Nodes are deleted randomly\n", rho);


	FOR (i, 11)
	FOR (j, 6)
	result[ i ][ j ] = 0;
	//printf("die hear?");
	srand((unsigned)time(0));
	//printf("die hear?1");
	int times = 10;
	FOR (i, times){
		for ( percent = 5; percent <= 30; percent += 5){
			vector<int> initial = thd;
			//printf("die hear?2");

			int random_integer;
			int lowest = 0;
			int range, highest;
			FOR (i, percent*thd.size()/100){
				highest= initial.size() - 1;
				range=(highest-lowest)+1;
				int t = rand();
				random_integer = lowest + ( (t/(RAND_MAX + 1.0) ) * range );
				initial[ random_integer ] = initial[ highest ];
				//printf("\nrandom %d and remained size %d because the random value is %d", random_integer, initial.size(), t);
				initial.pop_back();

			}
			result[ 0 ][percent/5 - 1] += initial.size();
			printf("%d %d \n", i , percent/5 - 1 );
			FOR (latency, 10){
				initial = tpidsDecay(graph, rho, initial);
				result[ latency + 1][percent/5 - 1] += initial.size();
			}
		}
	}

	FOR (i, 11){
		fprintf(fo, "%d ", i);
		FOR (j, 6)
		fprintf(fo, "%d ", result [ i ][ j ]/times);
		fprintf(fo, "\n");
	}
	fclose(fo);
}
////////////////////////////////////////////////////////////////////
void testGrow(AdjGraph& graph, double rho, int latency, string dataName){
	FILE *fo;
	char outName[40];
	//double rho;
	//double fraction;

	//int percent;
	//int result[11][6];
	sprintf(outName, "Grow%sRho%0.1f.txt", dataName.c_str(), rho);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "Growth phenomenon on the pids produced by highest dominationg algorithm.\n");
	fprintf(fo, "Rho = %0.1f, the process lasts %d hops. \n", rho, latency);

	int *sequence;
	vector<int> pids = pidsModifiedHighestDomination(graph, rho, 1, latency);
	sequence = pidsGrow(graph, rho, latency, pids);
	FOR(i, latency + 1)
	fprintf(fo, "%d %d\n", i, sequence[ i ]);
	fclose(fo);
	delete [] sequence;
}//end of test Growing
//==========================================================================
void testRhoTpids(AdjGraph& graph, string dataName){
	FILE *fo;
	char outName[40];
	double rho;
	//double fraction;

	//int percent;
	//int result[11][6];
	sprintf(outName, "RhoTpids%s.txt", dataName.c_str());
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "Dataset: %s\n", dataName.c_str());
	fprintf(fo, "Size of tpids with different rho.\n");
	fprintf(fo, "First column is rho, the second one is the highest degree solution, the last is highest domination.\n");

	for ( rho = 0.1; rho<=1; rho += 0.1)
		fprintf(fo, "%0.1f %d %d \n", rho, tpidsGreedyHighestDegree(graph, rho).size(), tpidsGreedyHighestDomination(graph, rho).size() );

	fclose(fo);
}//end of testRhoTpids
//==========================================================================
void testPidsCommunityBase(AdjGraph& graph, string directory, double rho, double fraction, string dataName){
	FILE *fo;
	char outName[60];
	//double fraction;

	//int percent;
	//int result[11][6];
	int n = graph.order();
	sprintf(outName, "PidsCommunityBase%sRho%0.1fFraction%0.1f.txt", dataName.c_str(), rho, fraction);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#Size of pids using community partitioning.\n");
	fprintf(fo, "#First column is number of hops, the second is the size, coverage fraction and running time.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	for (int latency=1; latency <= 10; latency++){
		printf("hop %d\n", latency);
		fflush(fo);
		clock_t start, stop;
		double t = 0.0, t2 = 0;
		// Start timer
		assert((start = clock())!=-1);
		/*
		vector<int> pidsHde = pidsCommunityBaseHighestDegree(
				directory.c_str(),
				rho,
				fraction,
				latency);
		stop = clock();
		t1 = (double) (stop-start)/CLOCKS_PER_SEC;

		double hdeCoverage = pidsCoverage(graph, rho, latency, pidsHde)/n;
		 */
		//printf("die1");

		vector<int> pidsHd = 	pidsCommunityBaseHighestDomination(
				directory.c_str(),
				rho,
				fraction,
				latency, t);
		//start = clock();
		vector<int> reducedPidsHd = removeDuplicates(pidsHd, graph.order() - 1);
		int hdCoverage = pidsCoverage(graph, rho, latency, reducedPidsHd);
		//stop = clock();
		t2 = (double) (stop-start)/CLOCKS_PER_SEC;

		//printf("die2");
		fprintf(fo, "%d %d %d %f %f \n", latency, reducedPidsHd.size(),
				(reducedPidsHd.size() + n - hdCoverage),hdCoverage/(n*1.0), t);

		//printf("die3");
	}

	fclose(fo);
}//end of testPidsCommunityBase
/////////////////////////////////////////////////////////////////
void histogramCommunity(AdjGraph& graph, string comFile, string dataName){
	//printf("in");
	int n = graph.order();
	FILE *fin = fopen(comFile.c_str(), "r");
	FILE *fo;
	if (!fin){
		cerr << "Error: File access denied."<<endl;
		return;
	}

	//printf(" de1");
	int *com = new int[ n ];
	int node, community;

	while (!feof(fin)){
		node = -1, community = -1;
		fscanf(fin, "%d %d", &node, &community);
		if ( node + community > 0 ) com[ node ] = community;
	}
	fclose(fin);
	//printf(" de2");
	//compute number of communities
	int max = 0;
	FOR( i, n)
	max = MAX( com[ i ], max);
	max++;

	char filename[30];
	sprintf(filename, "HistogramCom%s.txt", dataName.c_str());
	fo = fopen(filename, "w");
	if (!fo){
		cerr << "Error: File access denied."<<endl;
		return;
	}
	fprintf(fo, "Dataset: %s\n", dataName.c_str());
	fprintf(fo, "List size of communities\n");

	int *size = new int[ max ];
	FOR (i, max)
	size [ i ] = 0;

	FOR (i, n)
	size[ com[ i ] ]++;
	FOR(i, max)
	fprintf(fo, "%d \n", size[ i ]);
	fclose(fo);

	delete [] size;
	delete [] com;
}
//==========================================================================
void testPidsRandom(AdjGraph& graph, double rho, double fraction, string dataName){
	FILE *fo;
	int latency;
	char outName[100];
	//double fraction;

	//int percent;
	//int result[11][6];
	//printf("WHy");
	sprintf(outName, "Pids%sRandomRho%0.1fFraction%0.1f.txt", dataName.c_str(), rho, fraction);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#Size of pids using random algorithm.\n");
	fprintf(fo, "#First column is number of hops, the second collumn is the size of pids and the last one is running time (second).\n");
	fprintf(fo, "#number of node %d, number of edges %d.\n", graph.order(), graph.size());
	for ( latency=1; latency <= 10; latency += 1){
		fflush(fo);
		int times = 10;
		int size = 0;
		clock_t start, stop;
		double t = 0.0;
		// Start timer
		assert((start = clock())!=-1);
		FOR(i, times){
			size += pidsRandom(graph, rho, fraction, latency).size();
			printf("Time %d\n", i);
		}
		stop = clock();
		t = (double) (stop-start)/CLOCKS_PER_SEC;
		printf("hop %d\n", latency);
		fprintf(fo, "%d %d %f\n", latency, size/times, t/times);

		//printf("die3");
	}
	fclose(fo);
}//end of testPidsCommunityBase
//==========================================================================
void testPidsRandomRho(AdjGraph& graph, double fraction, int latency, string dataName){
	FILE *fo;
	double rho;
	char outName[100];
	//double fraction;

	//int percent;
	//int result[11][6];
	//printf("WHy");
	sprintf(outName, "Pids%sRandomFraction%0.1fLatency%d.txt", dataName.c_str(), fraction, latency);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#Size of pids using random algorithm.\n");
	fprintf(fo, "#First column is number of hops, the second collumn is the size of pids and the last one is running time (second).\n");
	fprintf(fo, "#number of node %d, number of edges %d.\n", graph.order(), graph.size());
	for ( rho=0.05; rho <= 0.5; rho += 0.05){
		fflush(fo);
		int times = 10;
		int size = 0;
		clock_t start, stop;
		double t = 0.0;
		// Start timer
		assert((start = clock())!=-1);
		FOR(i, times){
			size += pidsRandom(graph, rho, fraction, latency).size();
			printf("Time %d\n", i);
		}
		stop = clock();
		t = (double) (stop-start)/CLOCKS_PER_SEC;
		printf("rho %f\n", rho);
		fprintf(fo, "%f %d %f\n", rho, size/times, t/times);

		//printf("die3");
	}
	fclose(fo);
}//end of testPidsCommunityBase
/////////////////////////////////////////////////////////////////
void histogramDegree(AdjGraph& graph, string dataName){
	//printf("in");
	int n = graph.order();
	FILE *fo;

	int max = 0;
	FOR( i, n)
	max = MAX( graph.getDegree(i), max);
	max++;

	char filename[30];
	sprintf(filename, "HistogramDegree%s.txt", dataName.c_str());
	fo = fopen(filename, "w");
	if (!fo){
		cerr << "Error: File access denied."<<endl;
		return;
	}
	fprintf(fo, "Dataset: %s\n", dataName.c_str());
	fprintf(fo, "Degree sequence\n");

	int *size = new int[ max ];
	FOR (i, max)
	size [ i ] = 0;

	FOR (i, n)
	size[ graph.getDegree( i) ]++;
	FOR(i, max)
	fprintf(fo, "%d %d \n", i, size[ i ]);
	fclose(fo);

	delete [] size;

}

//==========================================================================
void testTpidsCommunityBase(AdjGraph& graph, string directory, string dataName){
	FILE *fo;
	double rho;
	char outName[40];
	int n = graph.order();
	//double fraction;

	//int percent;
	//int result[11][6];
	sprintf(outName, "TpidsCommunityBase%sRho%0.1f.txt", dataName.c_str(), rho);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "Dataset: %s\n", dataName.c_str());
	fprintf(fo, "Size of Total pids using community partitioning.\n");
	fprintf(fo, "First column is rho the highest degree solution, its coverage and its time,  the last is highest domination and its time.\n");

	for (rho=0.1; rho <= 1; rho += 0.1){
		printf("rho %0.1f\n", rho);
		fflush(fo);
		clock_t start, stop;
		double t1 = 0.0, t2 = 0.0;
		start = clock();

		vector<int> pidsHde = tpidsCommunityBaseHighestDegree(
				directory.c_str(),
				rho);
		//printf("die1");
		stop = clock();
		int hdecoverage = tpidsCoverage(graph, rho, pidsHde);
		t1 = (double) (stop-start)/CLOCKS_PER_SEC;
		start = stop;
		vector<int> pidsHd = 	tpidsCommunityBaseHighestDomination(
				directory.c_str(),
				rho);
		//printf("die2");
		stop = clock();
		t2 = (double) (stop-start)/CLOCKS_PER_SEC;
		int hdcoverage = tpidsCoverage(graph, rho, pidsHd);
		fprintf(fo, "%f %d %f %0.1f %d %f %0.1f \n", rho,
				pidsHde.size() + n - hdecoverage, hdecoverage/(n*1.0), + t1,
				pidsHd.size() + n - hdcoverage, hdcoverage/(n*1.0), t2);
		fflush(fo);
		//printf("die3");
	}

	fclose(fo);
}//end of testPidsCommunityBase


//==========================================================================
void testCombination(AdjGraph& graph, double rho, double fraction, double factor, string dataName){
	FILE *fo;
	char outName[40];
	//double fraction;

	//int percent;
	//int result[11][6];
	sprintf(outName, "PidsCombination%sRho%0.1fFraction%0.1fFactor%0.1f.txt", dataName.c_str(), rho, fraction, factor);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "Dataset: %s\n", dataName.c_str());
	fprintf(fo, "Size of pids using modified highest domination.\n");
	fprintf(fo, "First column is number of hops, second one is the size and the last is time.\n");
	fprintf(fo, "Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	for (int latency=1; latency <= 10; latency++){
		printf("hop %d\n", latency);
		fflush(fo);
		clock_t start, stop;
		double t1 = 0.0;
		// Start timer
		assert((start = clock())!=-1);

		vector<int> pids = pidsCombination(graph, rho, fraction, latency, factor);
		stop = clock();
		t1 = (double) (stop-start)/CLOCKS_PER_SEC;
		fprintf(fo, "%d %d %f \n", latency, pids.size(), t1);
		//printf("die3");
	}

	fclose(fo);
}//end of testPidsCommunityBase
/////////////////////////////////////////////////////////////////
void testPidsLatency(vector<int> (*f)(AdjGraph&, double, double, int),AdjGraph& graph, double rho, double fraction, string dataName){
	FILE *fo;
	char outName[200];
	//double fraction;
	//int percent;
	//int result[11][6];

	sprintf(outName, "%sRho%0.1fFraction%0.1f.txt", dataName.c_str(), rho, fraction);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#Size of pids using sum of 1/activeNeed of neighbors. Priority = inactive neis + degree/n.\n");
	fprintf(fo, "#First column is number of hops, second one is the size and third is time.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	for (int latency=1; latency <= 4; latency++){
		printf("hop %d\n", latency);
		fflush(fo);
		clock_t start, stop;
		double t1 = 0.0;
		// Start timer
		assert((start = clock())!=-1);

		vector<int> pids = f(graph, rho, fraction, latency);
		stop = clock();
		t1 = (double) (stop-start)/CLOCKS_PER_SEC;
		fprintf(fo, "%d %d %f %d\n", latency, pids.size(), t1, pidsCoverage(graph, rho, latency, pids));
		//printf("die3");
	}

	fclose(fo);

}//end of testPidsLatency

void testPidsGrow(vector<int> (*f)(AdjGraph&, double, double, int),AdjGraph& graph, double rho, int latency, string dataName){
	FILE *fo;
	double fraction = 1.0;
	char outName[200];
	//double fraction;
	//int percent;
	//int result[11][6];

	sprintf(outName, "Grow_%s_Rho%0.1fLatency%d.txt", dataName.c_str(), rho, latency);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	//fprintf(fo, "#Number of nodes %d \n", graph.order());
	fprintf(fo, "#First column is number of selected nodes, second one is the number of actived nodes, 3. fraction of selected nodes 4. fraction of activated nodes 5. activated/selected.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f hop = %d fraction = %0.1f \n", graph.order(), graph.size(), rho, latency, fraction);

	vector<int> pids = f(graph, rho, fraction, latency);
	/*
	int n = graph.order();
	vector<int> tmp;
	FOR(i, pids.size()){
		tmp.push_back(pids[i]);
		int cover = pidsCoverage(graph, rho, latency, tmp);
		fprintf(fo, "%d %d %f %f %f \n", i+1, cover, (i+1)/(1.0*n), cover/(1.0*n), cover/(1.0*(i+1)));
	}
	 */
	fflush(fo);
	fclose(fo);

}//end of testPidsLatency
void testPidsRho(vector<int> (*f)(AdjGraph&, double, double, int),AdjGraph& graph, double fraction, int latency, string dataName){
	FILE *fo;
	fraction = 1.0;
	char outName[100];
	//double fraction;
	//int percent;
	//int result[11][6];

	sprintf(outName, "%sFraction%0.1fLatency%d.txt", dataName.c_str(), fraction, latency);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#First column is rho, second one is the size and the last is time.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, fraction = %f latency = %d\n", graph.order(), graph.size(), fraction, latency);
	for (double rho = 0.05; rho <= 0.5; rho += 0.05){
		printf("rho %f\n", rho);
		fflush(fo);
		clock_t start, stop;
		double t1 = 0.0;
		// Start timer
		assert((start = clock())!=-1);

		vector<int> pids = f(graph, rho, fraction, latency);
		stop = clock();
		t1 = (double) (stop-start)/CLOCKS_PER_SEC;
		fprintf(fo, "%f %d %f %d\n", rho, pids.size(), t1, pidsCoverage(graph, rho, latency, pids));
		//printf("die3");
	}

	fclose(fo);

}//end of testPidsLatency

vector<int> removeDuplicates(vector<int> sequence, int maxValue){
	bool *appear = new bool[ maxValue + 1];
	FOR (i, maxValue+1){
		appear[ i ] = false;
	}

	vector<int> result;

	FOR (i, sequence.size()){
		if (!appear[ sequence[ i ] ]){
			result.push_back(sequence[ i ]);
			appear[ sequence[ i ] ] = true;
		}
	}

	delete [] appear;
	return result;
}
/////////////////////////////////////////////////////////////////
void testPidsLatencyRW(AdjGraph& graph, double rho, double fraction, string dataName){
	FILE *fo;
	char outName[100];
	//double fraction;
	//int percent;
	//int result[11][6];

	sprintf(outName, "%sRWRho%0.1fFraction%0.1f.txt", dataName.c_str(), rho, fraction);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#Size of pids using sum of 1/activeNeed of neighbors. Priority = inactive neis + degree/n.\n");
	fprintf(fo, "#First column is number of hops, second one is the size and the last is time.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	for (int latency=1; latency <= 10; latency++){
		printf("hop %d\n", latency);
		fflush(fo);
		clock_t start, stop;
		double t1 = 0.0;
		// Start timer
		assert((start = clock())!=-1);
		vector<double> initial;
		int len;
		if (latency < 4) len = 4;
		else len = latency;
		vector<int> order = hitCountSort(graph, 4, 10*graph.order(), initial);
		vector<int> pids = pidsFixedOrder(graph, rho, fraction, latency, order);
		stop = clock();
		t1 = (double) (stop-start)/CLOCKS_PER_SEC;
		fprintf(fo, "%d %d %f %d\n", latency, pids.size(), t1, pidsCoverage(graph, rho, latency, pids));
		//printf("die3");
	}

	fclose(fo);

}//end of testPidsLatency

void testPidsLatencyIMeter(AdjGraph& graph, double rho, double fraction, string dataName){
	FILE *fo;
	char outName[100];
	//double fraction;
	//int percent;
	//int result[11][6];

	sprintf(outName, "%sIMeterRho%0.1fFraction%0.1f.txt", dataName.c_str(), rho, fraction);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
		return ;
	}
	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#Size of pids using sum of 1/activeNeed of neighbors. Priority = inactive neis + degree/n.\n");
	fprintf(fo, "#First column is number of hops, second one is the size and the last is time.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	for (int latency=1; latency <= 10; latency++){
		printf("hop %d\n", latency);
		fflush(fo);
		clock_t start, stop;
		double t1 = 0.0;
		// Start timer
		assert((start = clock())!=-1);
		vector<double> initial;
		int len;
		if (latency < 4) len = 4;
		else len = latency;
		vector<int> order = iMeterOrder(graph, 4, 1000);
		vector<int> pids = pidsFixedOrder(graph, rho, fraction, latency, order);
		stop = clock();
		t1 = (double) (stop-start)/CLOCKS_PER_SEC;
		fprintf(fo, "%d %d %f %d\n", latency, pids.size(), t1, pidsCoverage(graph, rho, latency, pids));
		//printf("die3");
	}

	fclose(fo);

}//end of testPidsLatency
