/*
 * common.h
 *
 *  Created on: Dec 24, 2008
 *      Author: Thang
 */

#include <iostream>
#include <cstdio>
#include <fstream>
#include <cstdlib>
#include <cmath>
#include <map>
#include <iterator>
#include <algorithm>
#include <vector>
#include <sstream>
#include <string>
#include <set>

#ifndef COMMON_H_
#define COMMON_H_

#ifdef	 CPPUNIT_TEST
// Test Unit
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/TestFixture.h>

#define ASSERT 	CPPUNIT_ASSERT
#endif
/*
extern "C" {
#include <igraph.h>
}
// Short Alias
#define	Graph	igraph_t
#define	Vector	igraph_vector_t
#define	Integer	igraph_integer_t
#define Bool	igraph_bool_t
#define	Real	igraph_real_t
#define	Matrix	igraph_matrix_t
#define Selector igraph_vs_t
*/
// Quick macros
#define	FOR(i,n) for(int i =0;i<n;++i)
#define MIN(a,b) ((a)<(b)?(a):(b))
#define MAX(a,b) ((a)>(b)?(a):(b))
#define	VSIZE(a) igraph_vector_size(& (a))	// Size of a vector
#define	GSIZE(g) igraph_vcount(& g) 		// Number of vertices in a graph
#define	INFINITY 1e8
#define	EPS		 1e-7
#define	ALL(v)	 v.begin(), v.end()
#define	FOREACH(itr,v)	for( typeof(v.begin()) itr=v.begin(); itr!=v.end();itr++ )



#endif /* COMMON_H_ */
