/*
 * Measure.h
 *
 *  Created on: Feb 21, 2011
 *      Author: dung
 */
#include "AdjGraph.h"
#include "common.h"
#include "DynStack.h"
#include "IDS.h"
#include <vector>
#include <stack>
#include <algorithm>
#include <time.h>
#include <windows.h>
#include "BoostGraph.h"

#ifndef MEASURE_H_
#define MEASURE_H_

void communitySizeDistribution(const char* directory);
void biEdgeDFS(AdjGraph *graph, int u, int *p, int *d, int *b, int *com, int &comIndex, int &t, stack<int> &edgeS);
void biEdgeComponents(AdjGraph *graph);
void biNodeDFS(AdjGraph *graph, int u, int *p, int *d, int *b, int *com, int &comIndex, int &t, DynStack<pair<int, int> > &edgeS);
void biNodeComponents(AdjGraph *graph);
vector<int> hitCount(AdjGraph& graph, int len, int numRW, vector<double> initialDistribution);
vector<int> hitCountSort(AdjGraph& graph, int len, int numRW, vector<double> initialDistribution);
vector<int> iMeter (AdjGraph& graph, int len, int round);
vector<int> iMeterOrder (AdjGraph& graph, int len, int round);
vector<int> fusedWalk (AdjGraph& graph, int len, int round);
vector<int> fusedWalkOrder (AdjGraph& graph, int len, int round);

vector<double> fusedWalk (Graph& g, int len, int round);
vector<Vertex> fusedWalkOrder (Graph& g, int len, int round);

vector<Vertex> iMeterOrder (Graph& g, int len, int round);
vector<Vertex> hitCountSort(Graph& g, int len, int numRW, vector<double> initialDistribution);

vector<Vertex> iMeterOrder (Graph& g, int len, int round, vector<Vertex> target);
vector<Vertex> fusedWalkOrder (Graph& g, int len, int round, vector<Vertex> target);
#endif /* MEASURE_H_ */
