/*
 * Measure.cpp
 *
 *  Created on: Feb 21, 2011
 *      Author: dung
 */

#include "Measure.h"

using namespace std;

void communitySizeDistribution(const char* directory){
  std::string     strPattern;              // Pattern
  HANDLE          hFile;                   // Handle to file
  WIN32_FIND_DATA FileInformation;         // File information


  strPattern = string(directory) + "\\*.*";

  hFile = ::FindFirstFile(strPattern.c_str(), &FileInformation);
  vector<string> files;
  if(hFile != INVALID_HANDLE_VALUE) {
    do {
      if(FileInformation.cFileName[0] != '.')
      {
		files.push_back(FileInformation.cFileName);        
      }
    } while(::FindNextFile(hFile, &FileInformation) == TRUE);
  }

    // Close handle
    ::FindClose(hFile);

	FILE *fo;
	char outName[100];

	sprintf(outName, "CommunitySize_%s.txt", files[ 0 ].c_str());
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: %s\n", files[ 0 ].c_str());
	fprintf(fo, "#Compute the size distribution of communities");

	map<int, int> sizes;
	AdjGraph *graph;
	FOR (i, files.size() ){
		string file = string(directory) + "\\" + files[ i ];
		graph = new AdjGraph( file.c_str(), false);

		if (sizes.find(graph->order()) == sizes.end()){
			sizes[graph->order()] = 1;
		} else
			sizes[graph->order()]++;
		delete graph;
	}
	int total = 0;
	for (map<int, int>::const_iterator itr = sizes.begin(); itr != sizes.end(); itr++) {
		total += itr->second;
		fprintf(fo, "%d %d \n", itr->first, total);
	}
	fclose(fo);
} // End communitySizeDistribution
/************************************************************************/
/*
 * Compute the 2-edge components
 */
void biEdgeComponents(AdjGraph *graph) {
	int n = graph->order();
	int t = 0;
	int comIndex = 0;
	stack<int> nodeS;
	stack<pair<int, int> > edgeS;
	int *d = new int[n];
	int *b = new int[n];
	int *com = new int[n];
	int *p = new int[n];

	for (int u=0; u<n; u++){
		d[u] = t;
		b[u] = n + 1;
		p[u] = -1;
		com[u] = -1;
	}

	for (int u=0; u<n; u++){
		if (d[u] == 0) {
			nodeS.push(u);
			biEdgeDFS(graph, u, p, d, b, com, comIndex, t, nodeS);
		}
	}

	int *size = new int[comIndex];
	for (int i=0; i<comIndex; i++){
		size[i] = 0;
	}

	FOR (u, n) {
		size[com[u]]++;
	}

	sort(size, size + comIndex);

	//	FOR (u, n) {
	//		printf("node: com %d %d \n", graph->getName(u), com[u]);
	//	}

	printf("node: com %d %d \n", size[0], size[comIndex-1]);

	delete [] p;
	delete [] d;
	delete [] b;
	delete [] com;

} //End of biEdgeComponents
/************************************************************************/
void biEdgeDFS(AdjGraph *graph, int u, int *p, int *d, int *b, int *com, int &comIndex, int &t, stack<int> &nodeS) {
	/*	t++;
	d[u] = t;
	b[u] = t;

	//printf("%d \n", u);
	vector<int> neis = graph->neighbors(u);

	int min = graph->order() + 2;
	for (int i=0; i<neis.size(); i++){
		if (d[neis[i]] == 0){
			p[neis[i]] = u;
			nodeS.push(neis[i]);
			biEdgeDFS(graph, neis[i], p, d, b, com, comIndex, t, nodeS);
			min = MIN(min, b[neis[i]]);
			b[u] = MIN(b[u], b[neis[i]]);
		} else {
			if (d[neis[i]] < d[u] && neis[i] != p[u]) {
				b[u] = MIN(b[u], d[neis[i]]);
			}
		}
	}
	if (min == d[u]) {
		int v = 0;
		do {
			v = nodeS.top();
			nodeS.pop();
			com[v] = comIndex;
		} while( v != u && !nodeS.empty());
		comIndex++;
	}

	FOR (u, graph->order()) {
		//printf("%d ", com[u]);
	}*/
} //End of BiDFS

/*
void biNodeComponents(AdjGraph *graph) {
	int n = graph->order();
	int t = 0;
	int comIndex = 0;
	stack<int> nodeS;
	DynStack<pair<int, int> > edgeS;
	//edgeS = new DynStack();
	int *d = new int[n];
	int *b = new int[n];
	int *com = new int[n];
	int *p = new int[n];

	for (int u=0; u<n; u++){
		d[u] = t;
		b[u] = n + 1;
		p[u] = -1;
		com[u] = -1;
	}

	for (int u=0; u<n; u++){
		if (d[u] == 0) {
			//nodeS.push(u);
			biNodeDFS(graph, u, p, d, b, com, comIndex, t, edgeS);
		}
	}

	int *size = new int[comIndex];
	for (int i=0; i<comIndex; i++){
		size[i] = 0;
	}

	FOR (u, n) {
		size[com[u]]++;
	}

	sort(size, size + comIndex);

//	FOR (u, n) {
//		printf("node: com %d %d \n", graph->getName(u), com[u]);
//	}

	printf("node: com %d %d \n", size[0], size[comIndex-1]);

	delete [] p;
	delete [] d;
	delete [] b;
	delete [] com;
	//delete edgeS;

} //End of biEdgeComponents

void biNodeDFS(AdjGraph *graph, int u, int *p, int *d, int *b, int *com, int &comIndex, int &t, DynStack<pair<int, int> > &edgeS) {
	pair<int, int> ab;
	t++;
	d[u] = t;
	b[u] = t;

	printf("%d \n", u);
	vector<int> neis = graph->neighbors(u);

	for (int i=0; i<neis.size(); i++){
		if (d[neis[i]] == 0){

			p[neis[i]] = u;

			edgeS.push <pair<int, int> > (make_pair(u, neis[i]));
			//edgeS.push (make_pair(u, neis[i]));
			biNodeDFS(graph, neis[i], p, d, b, com, comIndex, t, edgeS);
			if (b[neis[i]] >= d[u]){
				printf("Component %d \n", comIndex);
				pair<int, int> uv;
				do {
					//uv = edgeS.top();
					edgeS.pop(uv);
					//com[uv.first] = comIndex;
					//com[uv.second] = comIndex;

					printf("%d %d \n", graph->getName(uv.first), graph->getName(uv.second));
				} while( uv.first != u || uv.second != neis[i]);
				comIndex++;
			}
			else
				b[u] = MIN(b[u], b[neis[i]]);

		} else {
			if (d[neis[i]] < d[u] && neis[i] != p[u]) {
				edgeS.push(make_pair(u, neis[i]));
				b[u] = MIN(b[u], d[neis[i]]);
			}
		}
	}
	FOR (u, graph->order()) {
		//printf("%d ", com[u]);
	}
} //End of BiDFS
 */

/*
 * Compute the number of times that each vertex is hit by random walks
 */
vector<int> hitCount(AdjGraph& graph, int len, int numRW, vector<double> initialDistribution) {
	int n = graph.order();

	int *count = new int[n];
	FOR(i, n){
		count[i] = 0;
	}
	Sleep(1000);
	srand(time(0));
	FOR(i, numRW) {
		int startV = (int)(rand()/(RAND_MAX * 1.0 + 1) * n);
		count[startV]++;
		FOR(j, len) {
			int index = (int)(rand()/(RAND_MAX * 1.0 + 1) * graph.getDegree(startV));
			startV = graph.getNeighbor(startV, index);
			count[startV]++;
		}
	}

	vector<int> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	return vcount;
}

vector<int> hitCountSort(AdjGraph& graph, int len, int numRW, vector<double> initialDistribution) {
	vector<int> hit = hitCount(graph, len, numRW, initialDistribution);

	int n = graph.order();
	vector<Node> nodes;
	vector<int> order;
	nodes.reserve(n);
	order.reserve(n);

	FOR(u, n){
		Node newNode = {u, hit[ u ]};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR(u, n){
		order.push_back(nodes[u].id);
	}

	return order;
}

/*
 * Measure the influence of nodes by counting the number of hit using fusion random walks
 * At the same time, there are n random walks from all nodes.
 * When two random walks meet each other, they are fused into one
 * graph: Graph
 * len : the length of Random walks
 * round : number of rounds. In each round, n random walks are created.
 */
vector<int> iMeter (AdjGraph& graph, int len, int round) {
	int n = graph.order();

	int *count = new int[n];
	FOR (i, n) {
		count[i] =  0;
	}

	//Mark alive random walks
	bool *alive = new bool[n];
	Sleep(1000);
	srand(time(NULL));
	FOR (r, round) {
		FOR (i, n) {
			alive[i] = true;
		}

		FOR (l, len) {
			vector<int> visitedVertices;
			FOR (u, n) {
				if (alive[u]) {
					alive[u] = false;
					int index = (int)(rand()/(RAND_MAX * 1.0 + 1) * graph.getDegree(u));
					int visitedVetex = graph.getNeighbor(u, index);
					count[visitedVetex]++;
					visitedVertices.push_back(visitedVetex);
				}
			}

			FOR (i, visitedVertices.size()) {
				alive[visitedVertices[i]] = true;
			}
		}
	}

	vector<int> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	return vcount;
}

vector<int> iMeterOrder (AdjGraph& graph, int len, int round) {
	vector<int> hit = iMeter(graph, len, round);

	int n = graph.order();
	vector<Node> nodes;
	vector<int> order;
	nodes.reserve(n);
	order.reserve(n);

	FOR(u, n){
		Node newNode = {u, hit[ u ]};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR(u, n){
		order.push_back(nodes[u].id);
	}

	return order;
} // End of iMeterOrder

/*
 * Fused Walk: do round times. Each time creates n subflow of value 1 from all nodes.
 * If two flow meet each other, they fuse to create a bigger one.
 * The hit count of visited node is increased by the value of the flow
 */

vector<int> fusedWalk (AdjGraph& graph, int len, int round) {
	int n = graph.order();
	int *flowValue = new int[n];
	int *newFlowValue = new int[n];

	int **parent = new int*[len];
	parent[0] = new int[len*n];
	FOR(t, len-1) {
		parent[t+1] = parent[t] + n;
	}

	int *count = new int[n];

	FOR (i, n) {
		count[i] =  0;
		flowValue[i] = 0;
		FOR(t, len) {
			parent[t][i] = -1;
		}

	}

	//Mark alive random walks
	bool *alive = new bool[n];
	Sleep(1000);
	srand(time(NULL));
	FOR (r, round) {
		FOR (i, n) {
			alive[i] = true;
			newFlowValue[i] = 0;
			flowValue[i] = 1;
		}

		FOR (t, len) {
			vector<int> visitedVertices;

			FOR (u, n) {
				if (alive[u]) {
					alive[u] = false;
					int index = (int)(rand()/(RAND_MAX * 1.0 + 1) * graph.getDegree(u));
					int visitedVetex = graph.getNeighbor(u, index);

					//Check whether visitedVertex on the walk or not
					bool visited = false;
					FOR(bt, t) {
						int next = visitedVetex;

						FOR(k, t-bt){
							if (parent[bt+k][next] == -1){
								next = -1;
								break;
							} else next = parent[bt+k][next];
						}
						if (next == u) visited = true;
					}

					if (!visited){
						count[visitedVetex] += flowValue[u];
						//count[visitedVetex] += 1;
						newFlowValue[visitedVetex] += flowValue[u];
						visitedVertices.push_back(visitedVetex);
						parent[t][u] = visitedVetex;
					}
				}
			}

			FOR (i, visitedVertices.size()) {
				int u = visitedVertices[i];
				alive[u] = true;
				flowValue[u] = newFlowValue[u];
				newFlowValue[u] = 0;
			}
			if (visitedVertices.size() == 0) break;
		}
	}

	vector<int> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	delete [] flowValue;
	delete [] newFlowValue;
	delete [] parent[0];
	delete [] parent;
	return vcount;
} //End of fusedWalk


vector<int> fusedWalkOrder (AdjGraph& graph, int len, int round) {
	vector<int> hit = fusedWalk(graph, len, round);

	int n = graph.order();
	vector<Node> nodes;
	vector<int> order;
	nodes.reserve(n);
	order.reserve(n);

	FOR(u, n){
		Node newNode = {u, hit[ u ]};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR(u, n){
		order.push_back(nodes[u].id);
	}

	return order;
} // End of fusedWalkOrder
/*
 * Measure the influence of nodes by counting the number of hit using fusion random walks
 * At the same time, there are n random walks from all nodes.
 * When two random walks meet each other, they are fused into one. When they meet each other they stop
 * graph: Graph
 * len : the length of Random walks
 * round : number of rounds. In each round, n random walks are created.
 */
vector<int> avoidImeter (AdjGraph& graph, int len, int round) {
	int n = graph.order();

	int *count = new int[n];
	FOR (i, n) {
		count[i] =  0;
	}

	//Mark alive random walks
	bool *alive = new bool[n];
	Sleep(1000);
	srand(time(NULL));
	FOR (r, round) {
		FOR (i, n) {
			alive[i] = true;
		}

		FOR (l, len) {
			vector<int> visitedVertices;
			FOR (u, n) {
				if (alive[u]) {
					alive[u] = false;
					int index = (int)(rand()/(RAND_MAX * 1.0 + 1) * graph.getDegree(u));
					int visitedVetex = graph.getNeighbor(u, index);
					count[visitedVetex]++;
					visitedVertices.push_back(visitedVetex);
				}
			}

			FOR (i, visitedVertices.size()) {
				alive[visitedVertices[i]] = true;
			}
		}
	}

	vector<int> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	return vcount;
}

vector<double> fusedWalk (Graph& g, int len, int round) {
	int n = num_vertices(g);
	double *flowValue = new double[n];
	double *newFlowValue = new double[n];

	int **parent = new int*[len];
	parent[0] = new int[len*n];
	FOR(t, len-1) {
		parent[t+1] = parent[t] + n;
	}

	double *count = new double[n];

	FOR (i, n) {
		count[i] =  0;
		flowValue[i] = 0;
		FOR(t, len) {
			parent[t][i] = -1;
		}
	}

	//Mark alive random walks
	bool *alive = new bool[n];
	Sleep(1000);
	srand(time(NULL));

	vector<Node> nodes;
	nodes.reserve(n);


	FOR(u, n){
		Node newNode = {u, in_degree(vertex(u, g), g)};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR (r, round) {
		FOR (i, n) {
			alive[i] = true;
			newFlowValue[i] = 0;
			flowValue[i] = 1;
		}

		//FOR(u, n/3){
		//alive[nodes[u].id] = true;
		//}

		FOR (t, len) {
			vector<int> visitedVertices;

			FOR (u, n) {
				if (alive[u]) {
					alive[u] = false;

					Vertex v = vertex(u, g);
					if (in_degree(v, g) == 0) continue;
					double ran = rand()* g[ v ].in_total/(RAND_MAX );
					Vertex visitedVertex  = -1;

					double in_total = 0;
					pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(v, g);
					for(; inEdges.first != inEdges.second; ++inEdges.first) {
						Edge e = *inEdges.first;
						if (in_total + g[ e ].weight >= ran) {
							visitedVertex = source(e, g);
							break;
						} else in_total =+ g[ e ].weight;
					}

					if (visitedVertex == -1) continue;
					int visitedIndex = g[ visitedVertex ].index;

					//Check whether visitedVertex on the walk or not
					bool visited = false;
					/*
					FOR(bt, t) {
						int next = visitedIndex;

						FOR(k, t-bt){
							if (parent[bt+k][next] == -1){
								next = -1;
								break;
							} else next = parent[bt+k][next];
						}
						if (next == u) visited = true;
					}
					 */
					if (!visited){
						//count[visitedIndex] += flowValue[u];
						count[visitedIndex]++;
						newFlowValue[visitedIndex] += flowValue[u];
						visitedVertices.push_back(visitedIndex);
						parent[t][u] = visitedIndex;
					}
				}
			}

			FOR (i, visitedVertices.size()) {
				int u = visitedVertices[i];
				alive[u] = true;
				newFlowValue[u] = 0;
			}
			if (visitedVertices.size() == 0) break;
		}
	}

	vector<double> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	delete [] flowValue;
	delete [] newFlowValue;
	delete [] parent[0];
	delete [] parent;
	return vcount;
} //End of fusedWalk

vector<Vertex> fusedWalkOrder (Graph& g, int len, int round) {
	vector<double> hit = fusedWalk(g, len, round);

	int n = num_vertices(g);
	vector<Node> nodes;
	vector<Vertex> order;
	nodes.reserve(n);
	order.reserve(n);

	FOR(u, n){
		Node newNode = {u, hit[ u ]};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR(u, n){
		order.push_back( vertex(nodes[u].id, g) );
	}

	return order;
} // End of fusedWalkOrder

/*
vector<int> iMeter (Graph& g, int len, int round) {
	int n = num_vertices(g);

	int *count = new int[n];
	FOR (i, n) {
		count[i] =  0;
	}

	//Mark alive random walks
	bool *alive = new bool[n];
	Sleep(1000);
	srand(time(NULL));
	FOR (r, round) {
		FOR (i, n) {
			alive[i] = true;
		}

		FOR (l, len) {
			vector<int> visitedVertices;
			FOR (u, n) {
				if (alive[u]) {
					alive[u] = false;

					Vertex v = vertex(u, g);
					if (in_degree(v, g) == 0) continue;
					double ran = (g[ v ].in_total * rand())/((1+RAND_MAX));
					Vertex visitedVertex = - 1;

					double in_total = 0;
					pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(v, g);
					for(; inEdges.first != inEdges.second; ++inEdges.first) {
						Edge e = *inEdges.first;
						if (in_total + g[ e ].weight >= ran) {
							visitedVertex = source(e, g);
							in_total = in_total + g[ e ].weight;
							break;
						} else in_total = in_total + g[ e ].weight;
					}
					if (visitedVertex == -1) {
						cout << "Wrong here" << in_total << "Degree " << in_degree(v, g) ;
						in_total = 0;
						pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(v, g);
						for(; inEdges.first != inEdges.second; ++inEdges.first) {
							Edge e = *inEdges.first;
							in_total = in_total + g[ e ].weight;
							cout << "rand" << ran << "w" << in_total;
						}
					}
					int visitedIndex = g[ visitedVertex ].index;
					count[visitedIndex]++;
					visitedVertices.push_back(visitedIndex);
				}
			}

			FOR (i, visitedVertices.size()) {
				alive[visitedVertices[i]] = true;
			}
		}
	}

	vector<int> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	return vcount;

} //End of iMeter
 */

vector<int> hitCount(Graph& g, int len, int numRW, vector<double> initialDistribution) {
	int n = num_vertices(g);

	int *count = new int[n];
	FOR(i, n){
		count[i] = 0;
	}
	Sleep(1000);
	srand(time(0));
	FOR(i, numRW) {
		int startV = (int)(rand()/(RAND_MAX * 1.0 + 1) * n);
		count[startV]++;
		FOR(j, len) {
			Vertex v = vertex(startV, g);
			if (in_degree(v, g) == 0) continue;

			double ran = (g[ v ].in_total * rand())/((1+RAND_MAX));
			Vertex visitedVertex = - 1;

			double in_total = 0;
			pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(v, g);
			for(; inEdges.first != inEdges.second; ++inEdges.first) {
				Edge e = *inEdges.first;
				if (in_total + g[ e ].weight >= ran) {
					visitedVertex = source(e, g);
					in_total = in_total + g[ e ].weight;
					break;
				} else in_total = in_total + g[ e ].weight;
			}

			startV = g[ visitedVertex ].index;
			count[startV]++;
		}
	}

	vector<int> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	return vcount;
}

vector<Vertex> hitCountSort(Graph& g, int len, int numRW, vector<double> initialDistribution) {
	vector<int> hit = hitCount(g, len, numRW, initialDistribution);

	int n = num_vertices(g);
	vector<Node> nodes;
	vector<Vertex> order;
	nodes.reserve(n);
	order.reserve(n);

	FOR(u, n){
		Node newNode = {u, hit[ u ]};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR(u, n){
		order.push_back(vertex(nodes[u].id, g));
	}

	return order;
}
/*
vector<int> iMeter (Graph& g, int len, int round, vector<Vertex> target) {
	int n = num_vertices(g);
	double alpha = 0.5;
	int *count = new int[n];
	FOR (i, n) {
		count[i] =  0;
	}

	//Mark alive random walks
	bool *alive = new bool[n];
	Sleep(1000);
	srand(time(NULL));
	FOR (r, round) {
		FOR (i, n) {
			alive[i] = false;
		}
		FOR (i, target.size()) {
			alive[ g[ target[ i ] ].index ] = true;
		}

		FOR (l, len) {
			vector<int> visitedVertices;
			FOR (u, n) {
				if (alive[u]) {
					alive[u] = false;

					Vertex v = vertex(u, g);
					if (in_degree(v, g) == 0) continue;
					double ran = (g[ v ].in_total * rand())/((1+RAND_MAX));
					Vertex visitedVertex = - 1;

					double in_total = 0;
					pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(v, g);
					for(; inEdges.first != inEdges.second; ++inEdges.first) {
						Edge e = *inEdges.first;
						if (in_total + g[ e ].weight >= ran) {
							visitedVertex = source(e, g);
							in_total = in_total + g[ e ].weight;
							break;
						} else in_total = in_total + g[ e ].weight;
					}
					if (visitedVertex == -1) {
						cout << "Wrong here" << in_total << "Degree " << in_degree(v, g) ;
						in_total = 0;
						pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(v, g);
						for(; inEdges.first != inEdges.second; ++inEdges.first) {
							Edge e = *inEdges.first;
							in_total = in_total + g[ e ].weight;
							cout << "rand" << ran << "w" << in_total;
						}
					}
					int visitedIndex = g[ visitedVertex ].index;
					count[visitedIndex]++;
					visitedVertices.push_back(visitedIndex);
				}
			}

			FOR (i, visitedVertices.size()) {
				if ( rand() > alpha*RAND_MAX)
					alive[visitedVertices[i]] = true;
			}
		}
	}

	vector<int> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	return vcount;

} //End of iMeter with given target
*/
vector<int> iMeter (Graph& g, int len, int round, vector<Vertex> target) {
	int n = num_vertices(g);
	double alpha = 0.5;

	bool *inTarget = new bool[n];

	FOR (i, n) {
		inTarget[i] = false;
	}

	FOR (i, target.size()) {
		inTarget[ g[ target[ i ] ].index ] = true;
	}

	FOR (i, n) {
		Vertex u = vertex(i, g);
		double in_total = 0;
		pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(u, g);
		for(; inEdges.first != inEdges.second; ++inEdges.first) {
			Edge e = *inEdges.first;
			Vertex v = source(e, g);
			if (inTarget[ g[ v ].index ])
			in_total = in_total + g[ e ].weight;
		}
		g[ u ].in_total = in_total;
	}

	int *count = new int[n];
	FOR (i, n) {
		count[i] =  0;

	}

	//Mark alive random walks
	bool *alive = new bool[n];
	Sleep(1000);
	srand(time(NULL));
	FOR (r, round) {
		FOR (i, n) {
			alive[i] = false;
		}
		FOR (i, target.size()) {
			alive[ g[ target[ i ] ].index ] = true;
		}

		FOR (l, len) {
			vector<int> visitedVertices;
			FOR (u, n) {
				if (alive[u]) {
					alive[u] = false;
					if ( rand() < alpha*RAND_MAX) continue;
					Vertex v = vertex(u, g);
					if (in_degree(v, g) == 0) continue;
					double ran = (g[ v ].in_total * rand())/((1+RAND_MAX));
					Vertex visitedVertex = - 1;
					double in_total = 0;
					pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(v, g);
					for(; inEdges.first != inEdges.second; ++inEdges.first) {
						Edge e = *inEdges.first;
						if (!inTarget[g[ source(e, g)].index]) continue;
						if (in_total + g[ e ].weight >= ran) {
							visitedVertex = source(e, g);
							in_total = in_total + g[ e ].weight;
							break;
						} else in_total = in_total + g[ e ].weight;
					}
					if (visitedVertex == -1) continue;
					int visitedIndex = g[ visitedVertex ].index;
					count[visitedIndex]++;
					visitedVertices.push_back(visitedIndex);
				}
			}

			FOR (i, visitedVertices.size()) {
				alive[visitedVertices[i]] = true;
			}
		}
	}

	vector<int> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	delete [] inTarget;
	delete [] alive;
	return vcount;

} //End of iMeter with given target


vector<int> iMeter (Graph& g, int len, int round) {
	vector<Vertex> target;
	vertex_iterator vi, vend;
	tie(vi, vend) = vertices(g);
	for(;vi != vend; vi++) {
		target.push_back(*vi);
	}

	return iMeter(g, len, round, target);
} // End of iMeter

vector<Vertex> iMeterOrder (Graph& g, int len, int round, vector<Vertex> target) {
	//cout << "test";
	vector<int> hit = iMeter(g, len, round, target);
	//cout << "test";
	int n = num_vertices(g);
	vector<Node> nodes;
	vector<Vertex> order;
	nodes.reserve(n);
	order.reserve(n);

	FOR(u, n){
		Node newNode = {u, hit[ u ]};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR(u, n){
		order.push_back( vertex(nodes[u].id, g) );
	}

	return order;
} // End of iMeterOrder

vector<Vertex> iMeterOrder (Graph& g, int len, int round) {
	vector<int> hit = iMeter(g, len, round);

	int n = num_vertices(g);
	vector<Node> nodes;
	vector<Vertex> order;
	nodes.reserve(n);
	order.reserve(n);

	FOR(u, n){
		Node newNode = {u, hit[ u ]};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR(u, n){
		order.push_back( vertex(nodes[u].id, g) );
	}

	return order;
} // End of iMeterOrder

vector<double> fusedWalk (Graph& g, int len, int round, vector<Vertex> target) {
	int n = num_vertices(g);
	double alpha = 0.5;
	double *flowValue = new double[n];
	double *newFlowValue = new double[n];

	double *count = new double[n];

	FOR (i, n) {
		count[i] =  0;
		flowValue[i] = 0;
	}

	//Mark alive random walks
	bool *alive = new bool[n];
	Sleep(1000);
	srand(time(NULL));

	vector<Node> nodes;
	nodes.reserve(n);


	FOR(u, n){
		Node newNode = {u, in_degree(vertex(u, g), g)};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR (r, round) {
		FOR (i, n) {
			alive[i] = false;
			newFlowValue[i] = 0;
			flowValue[i] = 0;
		}

		FOR (i, target.size()) {
			alive[ g[ target[ i ] ].index ] = true;
			flowValue[i] = 1;
		}

		FOR (t, len) {
			vector<int> visitedVertices;

			FOR (u, n) {
				if (alive[u]) {
					alive[u] = false;

					Vertex v = vertex(u, g);
					if (in_degree(v, g) == 0) continue;
					double ran = rand()* g[ v ].in_total/(RAND_MAX );
					Vertex visitedVertex  = -1;

					double in_total = 0;
					pair<in_edge_iterator, in_edge_iterator> inEdges = in_edges(v, g);
					for(; inEdges.first != inEdges.second; ++inEdges.first) {
						Edge e = *inEdges.first;
						if (in_total + g[ e ].weight >= ran) {
							visitedVertex = source(e, g);
							break;
						} else in_total =+ g[ e ].weight;
					}

					if (visitedVertex == -1) continue;
					int visitedIndex = g[ visitedVertex ].index;

					count[visitedIndex] += flowValue[u];
					//	count[visitedIndex]++;
					newFlowValue[visitedIndex] += flowValue[u];
					visitedVertices.push_back(visitedIndex);
				}
			}

			FOR (i, visitedVertices.size()) {
				int u = visitedVertices[i];
				if ( rand() > alpha*RAND_MAX)
					alive[u] = true;
				newFlowValue[u] = 0;
			}
			if (visitedVertices.size() == 0) break;
		}
	}

	vector<double> vcount;
	vcount.reserve(n);
	FOR(i, n){
		vcount.push_back(count[i]);
	}

	delete [] count;
	delete [] flowValue;
	delete [] newFlowValue;
	return vcount;
} //End of fusedWalk
vector<Vertex> fusedWalkOrder (Graph& g, int len, int round, vector<Vertex> target) {
	vector<double> hit = fusedWalk(g, len, round, target);

	int n = num_vertices(g);
	vector<Node> nodes;
	vector<Vertex> order;
	nodes.reserve(n);
	order.reserve(n);

	FOR(u, n){
		Node newNode = {u, hit[ u ]};
		nodes.push_back(newNode);
	}
	sort(nodes.begin(), nodes.end(), comp);

	FOR(u, n){
		order.push_back( vertex(nodes[u].id, g) );
	}

	return order;
} // End of fusedWalkOrder
