/*
 * MaxHeap2.cpp
 *
 *  Created on: Mar 11, 2010
 *      Author: Seven
 */

#include "MaxHeap2.h"

MaxHeap2::MaxHeap2(vector<heapElement> list, int maxId) {
	// TODO Auto-generated constructor stub
	this->maxId = maxId;
	id2Index = new int[maxId];
	FOR (i, maxId)
		id2Index[i] = -1;
	FOR(i, list.size()){
		elements.push_back( list[ i ] );
		id2Index[ list[ i ].id ] = i;

	}
}

MaxHeap2::MaxHeap2(int maxId) {
	this->maxId = maxId;
	id2Index = new int[maxId];
	FOR (i, maxId)
			id2Index[i] = -1;
}
void MaxHeap2::exchangePosition(int firstIndex, int secondIndex){
	int firstId = elements[ firstIndex ].id;
	int secondId = elements[ secondIndex ].id;
	swap( id2Index[ firstId ], id2Index[ secondId ]);
	swap( elements[ firstIndex ], elements[ secondIndex ]);
}

void MaxHeap2::heapify(int index){
	if (index<0) return;

	int left = 2*index+1;
	int right = 2*index+2;
	int largest = index;

	if (left < getSize() && elements[ left ].key > elements[ largest ].key)
		largest = left;

	if (right < getSize() && elements[ right ].key > elements[ largest ].key)
		largest = right;

	if (largest != index){
		//Change id table
		exchangePosition(largest, index);

		//		HeapElement largerChild = elements.get(largest);
		//		HeapElement parent = elements.get(index);

		//		elements.set(index, largerChild);
		//		elements.set(largest, parent);

		heapify(largest);

	}
}


void MaxHeap2::build(){
	for (int i=(1+getSize())/2 - 1;i>=0;i--)
		heapify(i);
}

heapElement MaxHeap2::getMax(){
	if ( getSize() == 0){
		heapElement e;
		e.id = -1;
		e.key = -1;
		return e;
	}
	return elements[ 0 ];
}

heapElement MaxHeap2::extractMax(){
	if ( getSize() == 0){
		heapElement e;
		e.id = -1;
		e.key = -1;
		return e;
	}

	heapElement max = elements[ 0 ];
		exchangePosition(0, getSize()-1);
		elements.pop_back();


//		HeapElement lastElement = elements.remove(getSize()-1);
//		elements.set(0, lastElement);
		heapify(0);

		return max;
}

void MaxHeap2::increaseKey(int id, double newKey){
	int index = id2Index[ id ];
	if (index >= getSize() || index < 0) return;

	if (elements[ index ].key >= newKey) return;

	elements[ index ].key = newKey;

	int parent = (index+1)/2 - 1;
	while (index>0 && elements[ parent ].key < newKey){
		exchangePosition(parent, index);
		//HeapElement child = elements.get(index);
		//elements.set(index, elements.get(parent));
		//elements.set(parent, child);
		index = parent;
		parent = (index+1)/2 - 1;
	}
}

void MaxHeap2::updateKey(int id, double newKey){
	int index =  id2Index[ id ];

	if (index >= getSize() || index < 0) return;

	if (elements[ index ].key > newKey) {
			elements[ index ].key = newKey;
			heapify(index);
	}
		else increaseKey(id, newKey);
}

void MaxHeap2::changeKey(int id, double change){
	//printf("0 id%d\n", id);
	int index =  id2Index[ id ];

	//No element found
	if (index >= getSize() || index<0) return;

	//printf("1\n");
	if (change < 0 ){
		elements[ index ].key += change;
		heapify(index);
		//printf("2\n");
	}
	else{
		increaseKey(id, elements[ index ].key + change);
		//printf("3\n");
	}
}
void MaxHeap2::insert(heapElement e){

	int id = e.id;
	double key = e.key;
	if (id > this->maxId || id < 0){
		printf("Ivalid Id\n");
		return;
	}

	id2Index[ id ] = elements.size();
	elements.push_back(e);
	elements[ getSize() - 1 ].key = - numeric_limits<double>::max();

	increaseKey(id, key);
}
int MaxHeap2::getSize(){
	return elements.size();
}

bool MaxHeap2::isEmpty(){
	return (getSize() == 0);
}
MaxHeap2::~MaxHeap2() {
	// TODO Auto-generated destructor stub
	delete [] id2Index;
}
