/*
 * MaxHeap.cpp
 *
 *  Created on: Mar 6, 2010
 *      Author: seven
 */

#include "MaxHeap.h"

MaxHeap::MaxHeap(vector<heapElement> list) {
	// TODO Auto-generated constructor stub
	//elements =  new vector<heapElement>();
	//id2Index = new vector<int>();

	FOR(i, list.size()){
		elements.push_back( list[ i ] );
		id2Index.push_back( i );

	}
	//printf("\ne %d list %d id %d\n", elements.size(), list.size(), id2Index.size());
}

void MaxHeap::exchangePosition(int firstIndex, int secondIndex){
	int firstId = elements[ firstIndex ].id;
	int secondId = elements[ secondIndex ].id;
	swap( id2Index[ firstId ], id2Index[ secondId ]);
	swap( elements[ firstIndex ], elements[ secondIndex ]);
}

void MaxHeap::heapify(int index){
	if (index<0) return;

	int left = 2*index+1;
	int right = 2*index+2;
	int largest = index;

	if (left < getSize() && elements[ left ].key > elements[ largest ].key)
		largest = left;

	if (right < getSize() && elements[ right ].key > elements[ largest ].key)
		largest = right;

	if (largest != index){
		//Change id table
		exchangePosition(largest, index);

		//		HeapElement largerChild = elements.get(largest);
		//		HeapElement parent = elements.get(index);

		//		elements.set(index, largerChild);
		//		elements.set(largest, parent);

		heapify(largest);

	}
}


void MaxHeap::build(){
	for (int i=(1+getSize())/2 - 1;i>=0;i--)
		heapify(i);
}

heapElement MaxHeap::getMax(){
	if ( getSize() == 0){
		heapElement e;
		e.id = -1;
		e.key = -1;
		return e;
	}
	return elements[ 0 ];
}

heapElement MaxHeap::extractMax(){
	if ( getSize() == 0){
		heapElement e;
		e.id = -1;
		e.key = -1;
		return e;
	}

	heapElement max = elements[ 0 ];
		exchangePosition(0, getSize()-1);
		elements.pop_back();


//		HeapElement lastElement = elements.remove(getSize()-1);
//		elements.set(0, lastElement);
		heapify(0);

		return max;
}

void MaxHeap::increaseKey(int id, double newKey){
	int index = id2Index[ id ];
	if (index >= getSize() || index < 0) return;

	if (elements[ index ].key >= newKey) return;

	elements[ index ].key = newKey;

	int parent = (index+1)/2 - 1;
	while (index>0 && elements[ parent ].key < newKey){
		exchangePosition(parent, index);
		//HeapElement child = elements.get(index);
		//elements.set(index, elements.get(parent));
		//elements.set(parent, child);
		index = parent;
		parent = (index+1)/2 - 1;
	}
}

void MaxHeap::updateKey(int id, double newKey){
	int index =  id2Index[ id ];

	if (index >= getSize() || index < 0) return;

	if (elements[ index ].key > newKey) {
			elements[ index ].key = newKey;
			heapify(index);
	}
		else increaseKey(id, newKey);
}

void MaxHeap::changeKey(int id, double change){
	//printf("0 id%d\n", id);
	int index =  id2Index[ id ];

	//No element found
	if (index >= getSize() || index<0) return;

	//printf("1\n");
	if (change < 0 ){
		elements[ index ].key += change;
		heapify(index);
		//printf("2\n");
	}
	else{
		increaseKey(id, elements[ index ].key + change);
		//printf("3\n");
	}
}
void MaxHeap::insert(heapElement e){

	int id = e.id;
	double key = e.key;

	id2Index.push_back(id2Index.size());
	elements.push_back(e);
	elements[ getSize() - 1 ].key = - numeric_limits<double>::max();

	increaseKey(id, key);
}
int MaxHeap::getSize(){
	return elements.size();
}

MaxHeap::~MaxHeap() {
	// TODO Auto-generated destructor stub
	//delete elements();
	//elements.erase();
}
