/*
 * IDS.h
 *
 *  Created on: Mar 6, 2010
 *      Author: seven
 */
#include "common.h"
#include "AdjGraph.h"
#include "MaxHeap.h"
#include "MaxHeap2.h"
#include <windows.h>
#include <ctime>

#ifndef IDS_H_
#define IDS_H_

struct Node{
	int id;
	double key;
};

bool comp (Node, Node);
int lowerbound(AdjGraph&, double);
vector<int> pidsGreedyHighestDomination(AdjGraph&, double, double, int);
vector<int> pidsGreedyHighestDegree(AdjGraph&, double, double, int);
bool pidsCheck(AdjGraph&, double, double, int, vector<int>);
bool tpidsCheck(AdjGraph&, double, vector<int>);
vector<int> pidsImprovedHighestDomination(AdjGraph&, double, double, int);
vector<int> pidsInfiniteHighestDomination(AdjGraph&, double, double);
vector<int> tpidsGreedyHighestDomination(AdjGraph&, double);
vector<int> tpidsGreedyHighestDegree(AdjGraph&, double);
vector<int> tpidsDecay(AdjGraph&, double, vector<int>);
int* pidsGrow(AdjGraph&, double, int, vector<int>);
vector<int> pidsCommunityBaseHighestDomination(const char* directory, double rho, double fraction, int latency, double& t);
vector<int> pidsCommunityBaseHighestDegree(const char* directory, double rho, double fraction, int latency);
vector<int> pidsIndependentSet(AdjGraph& graph, double rho, double fraction, int latency);
vector<int> pidsIndependentSetx(AdjGraph& graph, double rho, double fraction, int latency);
vector<int> pidsRandom(AdjGraph& graph, double rho, double fraction, int latency);
vector<int> tpidsCommunityBaseHighestDomination(const char* directory, double rho);
vector<int> tpidsCommunityBaseHighestDegree(const char* directory, double rho);
vector<int> pidsDegreeDomination(AdjGraph& graph, double rho, double fraction, int latency);
vector<int> pidsMaxActiveNode(AdjGraph& graph, double rho, double fraction, int latency);
int pidsCoverage(AdjGraph& graph, double rho, int latency, vector<int> pids);
int tpidsCoverage(AdjGraph& graph, double rho, vector<int> tpids);
vector<int> pidsModifiedHighestDomination(AdjGraph& graph, double rho, double fraction, int latency);
vector<int> pidsMMHighestDomination(AdjGraph& graph, double rho, double fraction, int latency);
vector<int> pidsAddUp(AdjGraph& graph, double rho, double fraction, int latency, vector<int> initial);
vector<int> pidsCombination(AdjGraph& graph, double rho, double fraction, int latency, double cfactor);
vector<int> pidsMaxActiveEdge(AdjGraph& graph, double rho, double fraction, int latency);
double pidsComputeActive(AdjGraph& graph, double rho, double fraction, int latency, int *activeStep, int **live, bool *inQueue, bool **inLiveStack, int node);
vector<int> pidsMaxActiveNodePruned(AdjGraph& graph, double rho, double fraction, int latency);

vector<int> nostate_lazy(AdjGraph& graph, double rho, double fraction, int latency);
vector<int> nostate_nolazy(AdjGraph& graph, double rho, double fraction, int latency);


vector<int> pidsFixedOrder(AdjGraph& graph, double rho, double fraction, int latency, vector<int> order);
vector<int> pidsLazyUpdate(AdjGraph& graph, double rho, double fraction, int latency);
vector<int> pidsLazyUpdate_2(AdjGraph& graph, double rho, double fraction, int latency);
#endif /* IDS_H_ */
