/*
 * IDS.cpp
 *
 *  Created on: Mar 6, 2010
 *      Author: seven
 */

#include "IDS.h"
#include <queue>
#include <stack>
#include <time.h>

bool comp (Node i, Node j){
	return (i.key > j.key);
}

int lowerbound(AdjGraph& graph, double rho){
	int n = graph.order();
	vector<Node> nodes;

	FOR(u, n){
		Node newNode = {u, graph.getDegree(u)};
		nodes.push_back(newNode);
	}

	sort(nodes.begin(), nodes.end(), comp);
	int totalDegree = 0;

	FOR(u, n)
	totalDegree += graph.getDegree(u);

	int reqDegree = ceil(rho*totalDegree);

	int i;
	for (i = 0; i < n; ++i){
		reqDegree -= nodes[ i ].key;
		if (reqDegree < 0) break;
	}

	return i;
}

vector<int> pidsGreedyHighestDomination(AdjGraph& graph, double rho, double fraction, int latency){
	int n = graph.order();

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)

			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<heapElement> nodeList;
	for (int u = 0; u < n; ++u){
		heapElement e = {u, graph.getDegree(u) + 1 };
		nodeList.push_back(e);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		heapElement selectedNode = nodeHeap->extractMax();

		if ( selectedNode.key <= 0) break;

		int selectedID = selectedNode.id;
		pids.push_back(selectedID);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.pop();


			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//	printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			//	printf("die1");
			if (oldStep > latency){
				reqNum--;
				//	printf("size of neighbor \n");
				vector<int> inNeis = graph.neighbors(curNode);
				//	printf("size of neighbor %d\n", inNeis.size());
				for (int i = 0; i < inNeis.size(); i++)
					nodeHeap->changeKey(inNeis[ i ], -1);
			}
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];

				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;

				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						if ( activeStep[adjNode]>latency ) nodeHeap->changeKey(adjNode, -1);

						if ( !inQueue[ adjNode ] ){
							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		}
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete [] inQueue;

	return pids;
} //end pidsGreedHighestDomination
//================================================
vector<int> pidsModifiedHighestDomination(AdjGraph& graph, double rho, double fraction, int latency){
	char fname[100];
	sprintf(fname, "VirAdsRho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: \n" );
	fprintf(fo, "#VirAds\n");
	fprintf(fo, "#First column size of pids, the second the number of inactive node.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);

	int n = graph.order();

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<heapElement> nodeList;
	for (int u = 0; u < n; ++u){
		heapElement e = {u, graph.getDegree(u) + live[ latency ][ u ] };
		nodeList.push_back(e);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		heapElement selectedNode = nodeHeap->extractMax();


		if ( selectedNode.key <= 0) break;

		int selectedID = selectedNode.id;

		pids.push_back(selectedID);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			if ( oldStep > latency){
				reqNum--;
				//	printf("size of neighbor \n");
				vector<int> inNeis = graph.neighbors(curNode);
				//	printf("size of neighbor %d\n", inNeis.size());
				for (int i = 0; i < inNeis.size(); i++)
					nodeHeap->changeKey(inNeis[ i ], -1);
			}

			//	printf("die1");
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];


				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;
				if ( activeStep[adjNode]>latency && oldStep >= latency && activeStep[ curNode ] + 1 <= effectStep) nodeHeap->changeKey(adjNode, -1);
				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						//if ( activeStep[adjNode]>latency ) nodeHeap->changeKey(adjNode, -1);

						if ( !inQueue[ adjNode ] ){

							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
				if ( activeStep[adjNode]>latency && effectStep >= activeStep[adjNode])
					printf(" %d %d ",activeStep[adjNode], effectStep);

			}
		}
		fprintf(fo, "%d %d\n", pids.size(), reqNum);
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete [] inQueue;
	fclose(fo);
	return pids;
} //end pidsGreedHighestDomination
vector<int> pidsDegreeDomination(AdjGraph& graph, double rho, double fraction, int latency){
	int n = graph.order();

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<heapElement> nodeList;
	for (int u = 0; u < n; ++u){
		heapElement e = {u,graph.getDegree(u) + (graph.getDegree(u) + live[ latency ][ u ])/(2.0*n) };
		nodeList.push_back(e);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		//printf("\n%d",reqNum);
		heapElement selectedNode = nodeHeap->extractMax();
		int selectedID = selectedNode.id;

		if ( selectedNode.key < graph.getDegree(selectedID) + 0.9/(2.0*n)) continue;


		pids.push_back(selectedID);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			if ( oldStep > latency){
				reqNum--;
				//	printf("size of neighbor \n");
				vector<int> inNeis = graph.neighbors(curNode);
				//	printf("size of neighbor %d\n", inNeis.size());
				for (int i = 0; i < inNeis.size(); i++)
					nodeHeap->changeKey(inNeis[ i ], -1/(2.0*n));
			}

			//	printf("die1");
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];


				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;
				if ( activeStep[adjNode]>latency && oldStep >= latency && activeStep[ curNode ] + 1 <= effectStep)
					nodeHeap->changeKey(adjNode, -1/(2.0*n));
				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						//if ( activeStep[adjNode]>latency ) nodeHeap->changeKey(adjNode, -1);

						if ( !inQueue[ adjNode ] ){

							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
				if ( activeStep[adjNode]>latency && effectStep >= activeStep[adjNode])
					printf(" %d %d ",activeStep[adjNode], effectStep);

			}
		}
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete [] inQueue;

	return pids;
} //end pids highest degree + 1/priority

//Find the node that create maximum new active node
vector<int> pidsMaxActiveNode(AdjGraph& graph, double rho, double fraction, int latency){
	char fname[100];
	sprintf(fname, "state_nolazy_Rho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: \n" );
	fprintf(fo, "#MaxActiveNode\n");
	fprintf(fo, "#First column size of pids, the second the number of active node and the third is the running time.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	clock_t start = clock();
	int n = graph.order();
	vector<int> pool;
	pool.reserve(n);

	FOR (u, n)
	pool.push_back(u);

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;

	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}
	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		queue<int> nodeQueue;
		queue<int> oldStepQueue;
		//printf("%d\n", reqNum);
		//Select best node
		int maxPosition = -1;
		int maxActiveNode = -1;
		int maxActiveEdge = -1;
		FOR (u, pool.size()){
			int node = pool[ u ];
			int activeNode = 0;
			int activeEdge = 0;

			stack<int> activeStepStack;
			stack<int> liveStack;

			nodeQueue.push(node);
			oldStepQueue.push(activeStep[ node ]);

			activeStepStack.push(node);
			activeStepStack.push(activeStep[ node ]);
			activeStep[ node ] = 0;

			for (int i = 0; i < latency + 1; i++){
				liveStack.push(node);
				liveStack.push(i);
				liveStack.push(live[ i ][ node ]);
				live[ i ][ node ] = 0;
			}
			inQueue[ node ] = true;

			while( !nodeQueue.empty()){
				if (nodeQueue.size() == 0)
					printf("sea");
				int curNode = nodeQueue.front();
				nodeQueue.pop();

				int oldStep = oldStepQueue.front();
				oldStepQueue.pop();

				inQueue[ curNode ] = false;
				if ( oldStep > latency){
					activeNode++;
				}

				vector<int> outNeis = graph.neighbors(curNode);
				for (int i = 0; i < outNeis.size();i++){
					int adjNode = outNeis[ i ];
					if (activeStep[ adjNode ] == latency + 1)
						activeEdge++;

					int effectStep = oldStep;
					if ( effectStep > (activeStep[ adjNode ] -1) )
						effectStep = activeStep[ adjNode ] - 1;
					for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
						liveStack.push(adjNode);
						liveStack.push(step);
						liveStack.push(live[step][adjNode]);
						live[step][adjNode]--;
						if (live[step][adjNode] == 0){
							if ( !inQueue[ adjNode ] ){
								nodeQueue.push( adjNode );
								oldStepQueue.push( activeStep[ adjNode ] );
								inQueue[ adjNode ] = true;
							}

							activeStepStack.push(adjNode);
							activeStepStack.push(activeStep[ adjNode ]);

							activeStep[ adjNode ] = step;

							for (int j = step; j <= latency; j++){
								liveStack.push( adjNode );
								liveStack.push( j );
								liveStack.push( live[ j ][adjNode] );

								live[ j ][ adjNode ] = 0;
							}
							break;
						}
					}
				}
			}

			if (activeNode > maxActiveNode){
				maxActiveNode = activeNode;
				maxActiveEdge = activeEdge;
				maxPosition = u;
			}

			while (!activeStepStack.empty()){
				int step = activeStepStack.top();
				activeStepStack.pop();

				int node = activeStepStack.top();
				activeStepStack.pop();

				activeStep[ node ] = step;

			}

			while ( !liveStack.empty() ){
				int liveValue = liveStack.top();
				liveStack.pop();
				int step = liveStack.top();
				liveStack.pop();
				int node = liveStack.top();
				liveStack.pop();

				live[ step ][ node ] = liveValue;
			}
		}

		if (maxPosition == -1) break;

		int selectedID = pool[ maxPosition ];
		pool[ maxPosition ] = pool[ pool.size() - 1 ];
		pool.pop_back();

		pids.push_back(selectedID);

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			//printf("%d \n", reqNum);
			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			if ( oldStep > latency){
				reqNum--;
			}

			//	printf("die1");
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];
				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;

				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						//if ( activeStep[adjNode]>latency ) nodeHeap->changeKey(adjNode, -1);

						if ( !inQueue[ adjNode ] ){

							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		}
		fprintf(fo, "%d %f %f\n", pids.size(), (n*fraction - reqNum)/(1.0 * n), (double)(clock() - start)/(1.0 * CLOCKS_PER_SEC));
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete [] inQueue;
	fclose(fo);

	return pids;
} //end pids max number of live edge
vector<int> nostate_nolazy(AdjGraph& graph, double rho, double fraction, int latency){
	char fname[100];
	sprintf(fname, "nostate_nolazy_Rho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: \n" );
	fprintf(fo, "#MaxActiveNode\n");
	fprintf(fo, "#First column size of pids, the second the number of active node third is the running time.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	clock_t start = clock();

	int n = graph.order();
	vector<int> pool;
	pool.reserve(n);

	FOR (u, n)
	pool.push_back(u);

	vector<int> pids;

	int reqNum = ceil( fraction * n );
	int count = 0;
	//printf("%d\n", reqNum);
	//int a;
	while ( count < reqNum ){
		int maxPosition = -1;
		int maxActiveNode = -1;
		int maxActiveEdge = -1;
		FOR (u, pool.size()){
			int node = pool[ u ];
			pids.push_back(node);
			int activeNode = pidsCoverage(graph, rho, latency, pids);

			if (activeNode > maxActiveNode){
				maxActiveNode = activeNode;
				maxPosition = u;
			}
			pids.pop_back();
		}

		if (maxPosition == -1) break;

		int selectedID = pool[ maxPosition ];
		pool[ maxPosition ] = pool[ pool.size() - 1 ];
		pool.pop_back();

		pids.push_back(selectedID);
		count = maxActiveNode;

		fprintf(fo, "%d %f %f\n", pids.size(), count/(1.0 * n), (double)(clock() - start)/ (1.0 * CLOCKS_PER_SEC));
	}//end while selection

	fclose(fo);

	return pids;
} //end pids max number of live edge

//=======================================================================
vector<int> pidsMaxActiveNodePruned(AdjGraph& graph, double rho, double fraction, int latency){
	char fname[100];
	sprintf(fname, "state_lazy_Rho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: \n" );
	fprintf(fo, "#MaxActiveNodePruned\n");
	fprintf(fo, "#First column size of pids, the second the number of inactive node.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	clock_t start = clock();
	int n = graph.order();

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];
	bool **inLiveStack = new bool*[ latency + 1 ];
	inLiveStack[ 0 ] = new bool[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++){
		live[ t ] = live[ t - 1 ] + n;
		inLiveStack[ t ] = inLiveStack[ t - 1 ] + n;
	}

	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)
		{
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
			inLiveStack[ t ][ u ] = false;
		}
	}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	vector<heapElement> nodeList;

	for (int u = 0; u < n; ++u){
		double key = pidsComputeActive(graph, rho, fraction, latency, activeStep, live, inQueue, inLiveStack, u);
		heapElement e = {u, key };
		nodeList.push_back(e);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();
	int *update = new int[ n ];
	int iter = 0;
	FOR (i, n)
	update[ i ] = iter;

	while ( reqNum > 0 ){
		iter++;
		vector<int> updateList;
		if (iter % 1000 == 0 || reqNum < 1000)
			printf("%d \n", reqNum);

		while (true){
			heapElement node = nodeHeap->getMax();
			double key = pidsComputeActive(graph, rho, fraction, latency, activeStep, live, inQueue, inLiveStack, node.id);
			if (node.key !=key)
				nodeHeap->updateKey(node.id, key);
			else break;
		}
		heapElement selectedNode = nodeHeap->extractMax();
		int selectedID = selectedNode.id;

		pids.push_back(selectedID);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;

			if (update[ curNode ] != iter){
				updateList.push_back( curNode );
				update[ curNode ] = iter;
			}

			//vector<int> inNeis = graph.neighbors(curNode);
			//for (int i = 0; i < inNeis.size(); i++){
			//	if (update[ inNeis[ i ] ] != iter){
			//		updateList.push_back( inNeis[ i ] );
			//		update[ inNeis[ i ] ] = iter;
			//	}
			//}

			if ( oldStep > latency){
				reqNum--;
			}

			if(activeStep[ curNode ] < latency)
			{
				vector<int> outNeis = graph.neighbors(curNode);
				for (int i = 0; i < outNeis.size();i++){
					int adjNode = outNeis[ i ];

					int effectStep = oldStep;
					if ( effectStep > (activeStep[ adjNode ] -1) )
						effectStep = activeStep[ adjNode ] - 1;
					if ( activeStep[adjNode]>latency && oldStep >= latency && activeStep[ curNode ] + 1 <= effectStep) nodeHeap->changeKey(adjNode, -1);
					for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
						live[step][adjNode]--;
						if (live[step][adjNode] == 0){

							if ( !inQueue[ adjNode ] ){
								nodeQueue.push( adjNode );
								oldStepQueue.push( activeStep[ adjNode ] );
								inQueue[ adjNode ] = true;
							}
							activeStep[ adjNode ] = step;

							for (int j = step; j <= latency; j++)
								live[ j ][ adjNode ] = 0;
							break;
						}
					}
					//if ( activeStep[adjNode]>latency && effectStep >= activeStep[adjNode])
					//	printf(" %d %d ",activeStep[adjNode], effectStep);

				}
			}
		}
		FOR (i, updateList.size()){
			double key = pidsComputeActive(graph, rho, fraction, latency, activeStep, live, inQueue, inLiveStack, updateList[ i ]);
			nodeHeap->updateKey(updateList[ i ], key);
		}
		fprintf(fo, "%d %f %f\n", pids.size(), (n*fraction - reqNum)/(1.0 * n), (double) (clock() - start)/(1.0 * CLOCKS_PER_SEC));
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete [] inQueue;
	delete [] update;
	delete [] inLiveStack[0];
	delete [] inLiveStack;
	fclose(fo);
	return pids;
} //end pids max number of live edge

vector<int> nostate_lazy(AdjGraph& graph, double rho, double fraction, int latency){
	char fname[100];
	sprintf(fname, "nostate_lazy_Rho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: \n" );
	fprintf(fo, "#MaxActiveNodePruned\n");
	fprintf(fo, "#First column size of pids, the second the number of active node.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	clock_t start = clock();
	int n = graph.order();



	int reqNum = ceil( fraction * n );
	vector<heapElement> nodeList;
	vector<int> pids;

	for (int u = 0; u < n; ++u){
		pids.push_back(u);
		double key = pidsCoverage(graph, rho, latency, pids);
		heapElement e = {u, key };
		nodeList.push_back(e);
		pids.pop_back();
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();
	int *update = new int[ n ];
	int iter = 0;
	FOR (i, n)
	update[ i ] = iter;
	int count = 0;
	while ( count < reqNum){
		iter++;
		vector<int> updateList;
		if (iter % 1000 == 0 || reqNum < 1000)
			printf("%d \n", reqNum);

		while (true){
			heapElement node = nodeHeap->getMax();
			pids.push_back(node.id);
			double key = pidsCoverage(graph, rho, latency, pids);
			pids.pop_back();
			if (node.key !=key)
				nodeHeap->updateKey(node.id, key);
			else break;
		}
		heapElement selectedNode = nodeHeap->extractMax();
		int selectedID = selectedNode.id;

		pids.push_back(selectedID);
		count = pidsCoverage(graph, rho, latency, pids);
		fprintf(fo, "%d %f %f\n", pids.size(), count/(1.0 * n), (double)(clock() - start)/(1.0 * CLOCKS_PER_SEC));
	}//end while selection

	delete nodeHeap;
	fclose(fo);
	return pids;
} //end pids max number of live edge

//Compute the priority of a node = total active fraction of all affected node. If a node required 3 more active neighbor to become active,
//it active fraction is 1/3. Only compute node such as its active fraction changed.
double pidsComputeActive(AdjGraph& graph, double rho, double fraction, int latency, int *activeStep, int **live, bool *inQueue, bool **inLiveStack, int node){
	queue<int> nodeQueue;
	queue<int> oldStepQueue;


	int activeNode = 0;
	int activeEdge = 0;

	stack<int> activeStepStack; // trace of active level
	stack<int> liveStack;		// trace of change of live of each level

	nodeQueue.push(node);
	oldStepQueue.push(activeStep[ node ]);

	activeStepStack.push(node);
	activeStepStack.push(activeStep[ node ]);
	activeStep[ node ] = 0;

	for (int i = 0; i < latency + 1; i++){
		if (!inLiveStack[ i ][ node ])
		{
			liveStack.push(node);
			liveStack.push(i);
			liveStack.push(live[ i ][ node ]);
			inLiveStack[ i ][ node ] = true;
		}
		live[ i ][ node ] = 0;
	}
	inQueue[ node ] = true;

	double active_fraction = 0;

	while( !nodeQueue.empty()){
		if (nodeQueue.size() == 0)
			printf("sea");

		int curNode = nodeQueue.front();
		nodeQueue.pop();

		int oldStep = oldStepQueue.front();
		oldStepQueue.pop();

		inQueue[ curNode ] = false;
		if ( oldStep > latency){
			activeNode++;
		}


		if(activeStep[ curNode ] < latency)
		{
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){

				int adjNode = outNeis[ i ];
				if (activeStep[ adjNode ] == latency + 1)
					activeEdge++;

				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;

				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					if (!inLiveStack[ step ][ adjNode ])
					{
						liveStack.push(adjNode);
						liveStack.push(step);
						liveStack.push(live[step][adjNode]);
						inLiveStack[ step ][ adjNode ] = true;
					}
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						if ( !inQueue[ adjNode ] ){
							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}

						activeStepStack.push(adjNode);
						activeStepStack.push(activeStep[ adjNode ]);

						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++){
							if (!inLiveStack[ j ][ adjNode ])
							{
								liveStack.push( adjNode );
								liveStack.push( j );
								liveStack.push( live[ j ][adjNode] );
								inLiveStack[ j ][ adjNode ] = true;
							}
							live[ j ][ adjNode ] = 0;
						}
						break;
					}
				}
			}
		}
	}
	while (!activeStepStack.empty()){
		int step = activeStepStack.top();
		activeStepStack.pop();

		int node = activeStepStack.top();
		activeStepStack.pop();

		activeStep[ node ] = step;

	}

	while ( !liveStack.empty() ){
		int liveValue = liveStack.top();
		liveStack.pop();
		int step = liveStack.top();
		liveStack.pop();
		int node = liveStack.top();
		liveStack.pop();
		inLiveStack[ step ][ node ] = false;

		if (step == latency && liveValue != 0)
			active_fraction += (liveValue - live[ step ][ node ])/(1.0 * liveValue);
		live[ step ][ node ] = liveValue;
	}

	//return (activeNode + activeEdge);
	return activeNode;
	//return active_fraction;
} //End computeActive
//==========================================
vector<int> pidsMaxActiveEdge(AdjGraph& graph, double rho, double fraction, int latency){
	char fname[50];
	sprintf(fname, "VirAdsRho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: \n" );
	fprintf(fo, "#VirAds\n");
	fprintf(fo, "#First column size of pids, the second the number of inactive node.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);
	int n = graph.order();
	vector<int> pool;
	pool.reserve(n);

	FOR (u, n)
	pool.push_back(u);

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;

	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}
	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		queue<int> nodeQueue;
		queue<int> oldStepQueue;
		//printf("%d\n", reqNum);
		//Select best node
		int maxPosition = -1;
		int maxActiveNode = -1;
		int maxActiveEdge = -1;
		FOR (u, pool.size()){
			int node = pool[ u ];
			int activeNode = 0;
			int activeEdge = 0;

			stack<int> activeStepStack;
			stack<int> liveStack;

			nodeQueue.push(node);
			oldStepQueue.push(activeStep[ node ]);

			activeStepStack.push(node);
			activeStepStack.push(activeStep[ node ]);
			activeStep[ node ] = 0;

			for (int i = 0; i < latency + 1; i++){
				liveStack.push(node);
				liveStack.push(i);
				liveStack.push(live[ i ][ node ]);
				live[ i ][ node ] = 0;
			}
			inQueue[ node ] = true;

			while( !nodeQueue.empty()){
				if (nodeQueue.size() == 0)
					printf("sea");
				int curNode = nodeQueue.front();
				nodeQueue.pop();

				int oldStep = oldStepQueue.front();
				oldStepQueue.pop();

				inQueue[ curNode ] = false;
				if ( oldStep > latency){
					activeNode++;
				}

				vector<int> outNeis = graph.neighbors(curNode);
				for (int i = 0; i < outNeis.size();i++){
					int adjNode = outNeis[ i ];
					if (activeStep[ adjNode ] == latency + 1)
						activeEdge++;

					int effectStep = oldStep;
					if ( effectStep > (activeStep[ adjNode ] -1) )
						effectStep = activeStep[ adjNode ] - 1;
					for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
						liveStack.push(adjNode);
						liveStack.push(step);
						liveStack.push(live[step][adjNode]);
						live[step][adjNode]--;
						if (live[step][adjNode] == 0){
							if ( !inQueue[ adjNode ] ){
								nodeQueue.push( adjNode );
								oldStepQueue.push( activeStep[ adjNode ] );
								inQueue[ adjNode ] = true;
							}

							activeStepStack.push(adjNode);
							activeStepStack.push(activeStep[ adjNode ]);

							activeStep[ adjNode ] = step;

							for (int j = step; j <= latency; j++){
								liveStack.push( adjNode );
								liveStack.push( j );
								liveStack.push( live[ j ][adjNode] );

								live[ j ][ adjNode ] = 0;
							}
							break;
						}
					}
				}
			}

			if (activeEdge == 0 && activeNode == 0){
				pool[ u ] = pool[ pool.size() -  1 ];
				pool.pop_back();
				u--;
			}
			else if ((activeEdge > maxActiveEdge) || ( activeNode > maxActiveNode && activeEdge == maxActiveEdge)){
				maxActiveNode = activeNode;
				maxActiveEdge = activeEdge;
				maxPosition = u;
			}

			while (!activeStepStack.empty()){
				int step = activeStepStack.top();
				activeStepStack.pop();

				int node = activeStepStack.top();
				activeStepStack.pop();

				activeStep[ node ] = step;

			}

			while ( !liveStack.empty() ){
				int liveValue = liveStack.top();
				liveStack.pop();
				int step = liveStack.top();
				liveStack.pop();
				int node = liveStack.top();
				liveStack.pop();

				live[ step ][ node ] = liveValue;
			}
		}

		if (maxPosition == -1) break;

		int selectedID = pool[ maxPosition ];
		pool[ maxPosition ] = pool[ pool.size() - 1 ];
		pool.pop_back();

		pids.push_back(selectedID);

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			if ( oldStep > latency){
				reqNum--;
			}

			//	printf("die1");
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];
				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;

				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						//if ( activeStep[adjNode]>latency ) nodeHeap->changeKey(adjNode, -1);

						if ( !inQueue[ adjNode ] ){

							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		}
		fprintf(fo, "%d %d\n", pids.size(), reqNum);
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete [] inQueue;
	fclose(fo);
	return pids;
} //end pids max number of live edge
//Priority is computed based on both degree and alive neighbor
vector<int> pidsCombination(AdjGraph& graph, double rho, double fraction, int latency, double cfactor){
	int n = graph.order();

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;
	double *factor = new double[ n ];
	for (int  u = 0; u < n ; ++u )
		factor[ u ] = 1 + cfactor * graph.getDegree(u);

	vector<heapElement> nodeList;
	for (int u = 0; u < n; ++u){
		heapElement e = {u, (graph.getDegree(u) + live[ latency ][ u ]) * factor[ u ]};
		nodeList.push_back(e);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		heapElement selectedNode = nodeHeap->extractMax();


		if ( selectedNode.key <= 0) break;

		int selectedID = selectedNode.id;
		pids.push_back(selectedID);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			if ( oldStep > latency){
				reqNum--;
				//	printf("size of neighbor \n");
				vector<int> inNeis = graph.neighbors(curNode);
				//	printf("size of neighbor %d\n", inNeis.size());
				for (int i = 0; i < inNeis.size(); i++)
					nodeHeap->changeKey(inNeis[ i ], -factor[ inNeis[ i ] ]);
			}

			//	printf("die1");
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];


				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;
				if ( activeStep[adjNode]>latency && oldStep >= latency && activeStep[ curNode ] + 1 <= effectStep)
					nodeHeap->changeKey(adjNode, -factor[ adjNode ]);

				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						//if ( activeStep[adjNode]>latency ) nodeHeap->changeKey(adjNode, -1);

						if ( !inQueue[ adjNode ] ){

							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
				if ( activeStep[adjNode]>latency && effectStep >= activeStep[adjNode])
					printf(" %d %d ",activeStep[adjNode], effectStep);

			}
		}
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete [] inQueue;
	delete [] factor;

	return pids;
} //end pidsCombineation
//============================================================================================
//================================================
vector<int> pidsMMHighestDomination(AdjGraph& graph, double rho, double fraction, int latency){
	int n = graph.order();

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)

			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<heapElement> nodeList;
	for (int u = 0; u < n; ++u){
		heapElement e = {u, graph.getDegree(u) + ceil(rho*graph.getDegree(u)) + graph.getDegree(u)/(n*1.0)};
		//heapElement e = {u, graph.getDegree(u) + 1};
		nodeList.push_back(e);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		heapElement selectedNode = nodeHeap->extractMax();

		if ( selectedNode.key < 1) break;

		int selectedID = selectedNode.id;
		pids.push_back(selectedID);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.pop();


			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//	printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			//	printf("die1");
			if (oldStep > latency){
				reqNum--;
				//	printf("size of neighbor \n");
				vector<int> inNeis = graph.neighbors(curNode);
				//	printf("size of neighbor %d\n", inNeis.size());
				for (int i = 0; i < inNeis.size(); i++)
					nodeHeap->changeKey(inNeis[ i ], -1);
			}
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];

				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;
				if ( activeStep[adjNode]>latency && oldStep >= latency && activeStep[ curNode ] + 1 <= effectStep) nodeHeap->changeKey(adjNode, -1);
				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						//if ( activeStep[adjNode]>latency ) nodeHeap->changeKey(adjNode, -1);

						if ( !inQueue[ adjNode ] ){
							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		}
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete [] inQueue;

	return pids;
} //end pidsGreedHighestDomination


//==========================================================================================================
vector<int> pidsIndependentSetx(AdjGraph& graph, double rho, double fraction, int latency){
	int n = graph.order();

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)

			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<heapElement> nodeList;
	for (int u = 0; u < n; ++u){
		heapElement e = {u, graph.getDegree(u) + 1 };
		nodeList.push_back(e);
	}

	MaxHeap2 *nodeHeap = new MaxHeap2(nodeList, n);
	nodeHeap->build();

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );

	int *is = new int[ n ];
	FOR(i, n)
	is[ i ] = -1;
	int iteration = -1;

	while ( reqNum > 0 ){
		//Select independent set
		iteration++;
		//printf("ReqNum = %d, iteration = %d\n", reqNum, iteration);
		vector<int> nodeQueue;
		vector<int> oldStepQueue;
		vector<heapElement> newNodeList;
		//printf("1");
		while(true){
			//printf("1a");
			if (nodeHeap->getSize() ==  0)
				break;
			//printf("2");
			heapElement checkNode = nodeHeap->extractMax();
			if ( checkNode.key <= 0) break;
			//printf("3");
			//printf("\n%d id\n", checkNode.id);
			vector<int> neis = graph.neighbors( checkNode.id );
			//printf("3a");
			bool valid = true;
			FOR( i, neis.size() )
			if ( is[ neis[ i ]] == iteration ) valid = false;
			//printf("4");
			if ( valid ){
				//	printf("Node %d is selected\n", checkNode.id);
				is[ checkNode.id ] = iteration;
				//printf("5");
				int selectedID = checkNode.id;
				pids.push_back(selectedID);

				nodeQueue.push_back( selectedID );
				oldStepQueue.push_back( activeStep[ selectedID ]);
				activeStep[ selectedID ] = 0;
				for (int i = 0; i < latency + 1; i++)
					live[ i ][ selectedID ] = 0;
				inQueue[ selectedID ] = true;
			}else{
				newNodeList.push_back( checkNode );
				//printf("6");
			}
		} //Finish selecting IS
		//printf("7");
		//printf("%d nodes are selected\n", nodeQueue.size());
		//Reform remained nodes
		delete nodeHeap;
		nodeHeap = new MaxHeap2( newNodeList, n );
		nodeHeap->build();
		//printf("8");
		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.erase(nodeQueue.begin());
			//printf("9");

			int oldStep = oldStepQueue.front();
			oldStepQueue.erase( oldStepQueue.begin() );

			//	printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);
			//printf("x");
			inQueue[ curNode ] = false;
			//	printf("die1");
			if (oldStep > latency){
				reqNum--;
				//	printf("size of neighbor \n");
				vector<int> inNeis = graph.neighbors(curNode);
				//	printf("size of neighbor %d\n", inNeis.size());
				for (int i = 0; i < inNeis.size(); i++)
					nodeHeap->changeKey(inNeis[ i ], -1);
			}
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];
				//printf("y");
				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;

				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						if ( activeStep[adjNode]>latency ) nodeHeap->changeKey(adjNode, -1);

						if ( !inQueue[ adjNode ] ){
							nodeQueue.push_back( adjNode );
							oldStepQueue.push_back( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;
						//printf("z");
						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		}
	}//end while selection

	delete [] is;
	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete [] inQueue;

	return pids;
} //end pidsIndependentSetx
//===============================================================================
vector<int> pidsIndependentSet(AdjGraph& graph, double rho, double fraction, int latency){
	int n = graph.order();

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)

			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<heapElement> nodeList;
	for (int u = 0; u < n; ++u){
		heapElement e = {u, graph.getDegree(u) + 1 };
		nodeList.push_back(e);
	}

	MaxHeap2 *nodeHeap = new MaxHeap2(nodeList, n);
	nodeHeap->build();
	MaxHeap2 *newHeap = new MaxHeap2(n);
	MaxHeap2 *intermidiateHeap;


	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );

	int *is = new int[ n ];
	FOR(i, n)
	is[ i ] = -1;
	int iteration = -1;

	while ( reqNum > 0 ){
		//Select independent set
		iteration++;
		while(!nodeHeap->isEmpty()){
			vector<int> nodeQueue;
			vector<int> oldStepQueue;

			heapElement checkNode = nodeHeap->extractMax();
			if ( checkNode.key <= 0) break;

			vector<int> neis = graph.neighbors( checkNode.id );
			bool valid = true;
			FOR( i, neis.size() )
			if ( is[ neis[ i ]] == iteration ) valid = false;

			if ( valid ){
				is[ checkNode.id ] = iteration;
				int selectedID = checkNode.id;
				pids.push_back(selectedID);
				nodeQueue.push_back( selectedID );
				oldStepQueue.push_back( activeStep[ selectedID ]);
				activeStep[ selectedID ] = 0;
				for (int i = 0; i < latency + 1; i++)
					live[ i ][ selectedID ] = 0;
				inQueue[ selectedID ] = true;
			}else{
				newHeap->insert( checkNode );
			}

			while(nodeQueue.size()!=0){
				int curNode = nodeQueue.front();
				nodeQueue.erase(nodeQueue.begin());
				//printf("9");

				int oldStep = oldStepQueue.front();
				oldStepQueue.erase( oldStepQueue.begin() );

				//	printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);
				//printf("x");
				inQueue[ curNode ] = false;
				//	printf("die1");
				if (oldStep > latency){
					reqNum--;
					//	printf("size of neighbor \n");
					vector<int> inNeis = graph.neighbors(curNode);
					//	printf("size of neighbor %d\n", inNeis.size());
					for (int i = 0; i < inNeis.size(); i++){
						nodeHeap->changeKey(inNeis[ i ], -1);
						newHeap->changeKey(inNeis[ i ], -1);
					}
				}
				//	printf("die");
				vector<int> outNeis = graph.neighbors(curNode);
				for (int i = 0; i < outNeis.size();i++){
					int adjNode = outNeis[ i ];
					//printf("y");
					int effectStep = oldStep;
					if ( effectStep > (activeStep[ adjNode ] -1) )
						effectStep = activeStep[ adjNode ] - 1;

					for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
						live[step][adjNode]--;
						if (live[step][adjNode] == 0){
							//if (activeStep[adjNode]<=step) System.out.println("errr");

							if ( activeStep[adjNode]>latency ){
								nodeHeap->changeKey(adjNode, -1);
								newHeap->changeKey(adjNode, -1);
							}

							if ( !inQueue[ adjNode ] ){
								nodeQueue.push_back( adjNode );
								oldStepQueue.push_back( activeStep[ adjNode ] );
								inQueue[ adjNode ] = true;
							}
							activeStep[ adjNode ] = step;
							//printf("z");
							for (int j = step; j <= latency; j++)
								live[ j ][ adjNode ] = 0;
							break;
						}
					}
				}
			}
		}
		intermidiateHeap = nodeHeap;
		nodeHeap = newHeap;
		delete intermidiateHeap;
		newHeap = new MaxHeap2(n);
		///end round
	}//end while selection

	delete [] is;
	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete newHeap;
	delete [] inQueue;

	return pids;
} //end pidsIndependentSet
//======================================================================================
//Start from the highest degree vertices
vector<int> pidsGreedyHighestDegree(AdjGraph& graph, double rho, double fraction, int latency){
	char fname[100];
	sprintf(fname, "MaxDegreeRho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: \n");
	fprintf(fo, "#MaxDegree\n");
	fprintf(fo, "#First column size of pids, the second the number of inactive node.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);

	int n = graph.order();
	vector<Node> nodes;
	nodes.reserve(n);
	int *key = new int[n];

	FOR(u, n){
		Node newNode = {u, graph.getDegree(u) + 1};
		key [ u ] = graph.getDegree(u) + 1;
		nodes.push_back(newNode);
	}

	sort(nodes.begin(), nodes.end(), comp);

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];
	bool **inLiveStack = new bool*[ latency + 1 ];
	inLiveStack[ 0 ] = new bool[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
	{
		live[ t ] = live[ t - 1 ] + n;
		inLiveStack[ t ] = inLiveStack[ t - 1 ] + n;
	}
	for(int t = 0; t < latency + 1; t++)
		for (int u = 0; u < n; u++)
		{
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
			inLiveStack[ t ][ u ] = false;
		}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );

	int index = 0;
	while ( reqNum > 0 ){

		if ( index == n ) break;

		//Only selected useful vertices
		while ( pidsComputeActive(graph, rho, fraction, latency, activeStep, live, inQueue, inLiveStack, nodes[ index ].id ) == 0)
			index++;

		nodes[ index ].key = 0;
		Node selectedNode = nodes[ index ];


		int selectedID = selectedNode.id;

		pids.push_back(selectedID);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){

			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			inQueue[ curNode ] = false;
			if (oldStep > latency){
				reqNum--;
				//vector<int> inNeis = graph.neighbors(curNode);
				//for (int i = 0; i < inNeis.size(); i++)
				//	key[ inNeis[ i ] ]--;
			}
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size(); i++){
				int adjNode = outNeis[ i ];

				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;
				//int step;
				for (int step = activeStep[ curNode ] + 1; step <= effectStep; ++step){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if ( activeStep[adjNode]>latency ) key[ adjNode ]--;

						if ( !inQueue[ adjNode ] ){
							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;
						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		} //end of queue
		index++;
		fprintf(fo, "%d %d %d\n", pids.size(), n- reqNum, reqNum);
	}//end while selection


	delete [] key;
	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete [] inQueue;
	delete [] inLiveStack[0];
	delete [] inLiveStack;
	fclose(fo);

	return pids;
} //end of pidsGreedyHighestDegree
//======================================================================================

//Start from the highest degree vertices
vector<int> pidsAddUp(AdjGraph& graph, double rho, double fraction, int latency, vector<int> initial){
	int n = graph.order();
	vector<Node> nodes;
	nodes.reserve(n);

	int *key = new int[n];
	FOR(u, n){
		Node newNode = {u, graph.getDegree(u) + 1};
		key [ u ] = graph.getDegree(u) + 1;
		nodes.push_back(newNode);
	}

	sort(nodes.begin(), nodes.end(), comp);
	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];
	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++)
		for (int u = 0; u < n; u++)
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;
	vector<int> pids;
	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;
	int reqNum = ceil( fraction * n );
	queue<int> nodeQueue;
	queue<int> oldStepQueue;
	FOR(i, initial.size()){
		int node = initial[i];
		nodeQueue.push(node);
		oldStepQueue.push( activeStep[ node ]);
		activeStep[ node ] = 0;
		for (int j = 0; j < latency + 1; j++)
			live[ j ][node ] = 0;
		pids.push_back(node);
		key[node] = 0;
	}
	printf("size of queue %d", nodeQueue.size());
	int index = 0;
	while ( reqNum > 0 ){
		printf("\n2");
		while(nodeQueue.size()!=0){
			printf("\n3");
			int curNode = nodeQueue.front();
			nodeQueue.pop();
			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();
			inQueue[ curNode ] = false;
			printf("\n4");
			if (oldStep > latency){
				reqNum--;
				vector<int> inNeis = graph.neighbors(curNode);
				for (int i = 0; i < inNeis.size(); i++)
					key[ inNeis[ i ] ]--;
				printf("\n5");
			}
			printf("\n6");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size(); i++){
				int adjNode = outNeis[ i ];
				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;
				//int step;
				printf("\n7");
				printf("\nsize %d", nodeQueue.size());
				for (int step = activeStep[ curNode ] + 1; step <= effectStep; ++step){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						if ( activeStep[adjNode]>latency ) key[ adjNode ]--;
						if ( !inQueue[ adjNode ] ){
							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						printf("\n8");
						activeStep[ adjNode ] = step;
						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		} //end of queue
		if ( index == n ) break;
		//Only selected useful vertices
		while ( key [ nodes[ index ].id ] <= 0)
			index++;
		nodes[ index ].key = 0;
		Node selectedNode = nodes[ index ];
		int selectedID = selectedNode.id;
		pids.push_back(selectedID);
		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;
		index++;
	}//end while selection

	delete [] key;
	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete [] inQueue;

	return pids;
} //end of addup
vector<int> pidsRandom(AdjGraph& graph, double rho, double fraction, int latency){

	int n = graph.order();
	vector<int> pool;
	pool.reserve(n);

	int *key = new int[n];

	FOR(u, n){
		key [ u ] = graph.getDegree(u) + 1;
		pool.push_back(u);
	}

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];
	bool **inLiveStack = new bool*[ latency + 1 ];
	inLiveStack[ 0 ] = new bool[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
	{
		live[ t ] = live[ t - 1 ] + n;
		inLiveStack[ t ] = inLiveStack[ t - 1 ] + n;
	}
	for(int t = 0; t < latency + 1; t++)
		for (int u = 0; u < n; u++)
		{
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
			inLiveStack[ t ][ u ] = false;
		}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	srand(10);
	int index = 0;
	while ( reqNum > 0 ){

		int random_index;
		random_index = (rand()/(RAND_MAX * 1.0) * (pool.size()-1)) ;
		//printf("random_index %d %d\n", random_index, RAND_MAX);
		int selectedID = pool[ random_index ];
		pool[ random_index ] = pool[ pool.size() - 1 ];
		pool.pop_back();

		if (pidsComputeActive(graph, rho, fraction, latency, activeStep, live, inQueue, inLiveStack, selectedID ) == 0)
			continue;

		pids.push_back(selectedID);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){

			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			inQueue[ curNode ] = false;
			if (oldStep > latency){
				reqNum--;
				//		vector<int> inNeis = graph.neighbors(curNode);
				//		for (int i = 0; i < inNeis.size(); i++)
				//			key[ inNeis[ i ] ]--;
			}
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size(); i++){
				int adjNode = outNeis[ i ];

				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;
				//int step;
				for (int step = activeStep[ curNode ] + 1; step <= effectStep; ++step){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//	if ( activeStep[adjNode]>latency ) key[ adjNode ]--;

						if ( !inQueue[ adjNode ] ){
							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;
						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		} //end of queue
		index++;
	}//end while selection

	delete [] key;
	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete [] inQueue;
	delete [] inLiveStack[0];
	delete [] inLiveStack;

	return pids;
} //end of pidsRandom
//========================================================
vector<int> pidsCommunityBaseHighestDomination(const char* directory, double rho, double fraction, int latency, double& t){
	t = 0;
	clock_t start, stop;
	vector<int> pids;

	std::string     strPattern;              // Pattern
	HANDLE          hFile;                   // Handle to file
	WIN32_FIND_DATA FileInformation;         // File information


	strPattern = string(directory) + "\\*.*";

	hFile = ::FindFirstFile(strPattern.c_str(), &FileInformation);
	vector<string> files;
	if(hFile != INVALID_HANDLE_VALUE) {
		do {
			if(FileInformation.cFileName[0] != '.')
			{
				files.push_back(FileInformation.cFileName);
			}
		} while(::FindNextFile(hFile, &FileInformation) == TRUE);
	}

	// Close handle
	::FindClose(hFile);

	FILE *fo;
	char outName[100];

	//double fraction;

	//int percent;
	//int result[11][6];
	sprintf(outName, "HistogramHDPids%sRho%0.1fFraction%0.1flatency%d.txt", files[ 0 ].c_str(),rho, fraction, latency );
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "Dataset: %s\n", files[ 0 ].c_str());
	fprintf(fo, "Histogram Pids on communities with rho = %0.1f, fraction = %0.1f and latency = %d.\n", rho, fraction, latency);
	fprintf(fo, "Highest domination algorithm.\n");


	AdjGraph *graph;
	FOR (i, files.size() ){
		string file = string(directory) + "\\" + files[ i ];
		printf("%s\n", file.c_str());
		graph = new AdjGraph( file.c_str(), false);
		printf("n = %d, edges = %d", graph->order(), graph->size());

		if (graph->size()>0){
			start = clock();
			//printf("n %d e %d\n", graph->order(), graph->numberOfEdge());

			vector<int> subPids = pidsModifiedHighestDomination(*graph, rho, fraction, latency);
			FOR (u, subPids.size() )
			pids.push_back( graph->getName(subPids[ u ]));
			stop = clock();
			t += (stop-start);
			fprintf(fo, "%d \n", subPids.size());
		}
		delete graph;
	}
	fclose(fo);
	t = t/(1.0*CLOCKS_PER_SEC);
	return pids;
}//end of pidsCommunityBase
vector<int> pidsCommunityBaseHighestDegree(const char* directory, double rho, double fraction, int latency){
	vector<int> pids;
	std::string     strPattern;              // Pattern
	HANDLE          hFile;                   // Handle to file
	WIN32_FIND_DATA FileInformation;         // File information


	strPattern = string(directory) + "\\*.*";

	hFile = ::FindFirstFile(strPattern.c_str(), &FileInformation);
	vector<string> files;
	if(hFile != INVALID_HANDLE_VALUE) {
		do {
			if(FileInformation.cFileName[0] != '.')
			{
				files.push_back(FileInformation.cFileName);
			}
		} while(::FindNextFile(hFile, &FileInformation) == TRUE);
	}

	// Close handle
	::FindClose(hFile);

	FILE *fo;
	char outName[100];
	//double fraction;
	//int percent;
	//int result[11][6];
	sprintf(outName, "HistogramHDEPids%sRho%0.1fFraction%0.1flatency%d.txt", files[ 0 ].c_str(),rho, fraction, latency );
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
	}
	fprintf(fo, "Dataset: %s\n", files[ 0 ].c_str());
	fprintf(fo, "Histogram Pids on communities with rho = %0.1f, fraction = %0.1f and latency = %d.\n", rho, fraction, latency);
	fprintf(fo, "Highest Degree algorithm.\n");
	AdjGraph *graph;
	FOR (i, files.size() ){
		string file = string(directory) + "\\" + files[ i ];
		//printf("%s\n", file.c_str());
		graph = new AdjGraph( file.c_str(), false);
		if (graph->size()>0){
			printf("%s\n", files[ i ].c_str());

			vector<int> subPids = pidsGreedyHighestDegree(*graph, rho, fraction, latency);
			FOR (u, subPids.size() )
			pids.push_back( graph->getName(subPids[ u ]));
			fprintf(fo, "%d \n", subPids.size());
		}
		delete graph;
	}
	fclose(fo);
	return pids;
}//end of pidsCommunityBase
///////////////////////////////////////////////////////////////////////////////////
vector<int> pidsInfiniteHighestDomination(AdjGraph& graph, double rho, double fraction){
	int n = graph.order();
	int reqNum = ceil(fraction*n);
	//int curNum = 0;

	//Track the status of each node at each level
	int *live = new int[n];
	for (int i=0;i<n;i++)
		live[ i ] = ceil(rho*graph.getDegree(i));

	vector<heapElement> nodeList;
	for (int i = 0; i < n; ++i){
		heapElement newNode = {i, graph.getDegree(i)+1};
		nodeList.push_back(newNode);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();

	vector<int> pids;

	bool *inQueue = new bool[n];
	for (int  i = 0; i < n; ++i)
		inQueue[ i ] = false;

	int index = 0;
	while (reqNum > 0){
		//		System.out.println(index++);
		heapElement selectedNode = nodeHeap->extractMax();

		if (selectedNode.key <= 0) break;

		int selectedID = selectedNode.id;
		pids.push_back(selectedID);

		vector<int> nodeQueue;

		nodeQueue.push_back(selectedID);
		reqNum--;
		live[ selectedID ] = 0;

		while( nodeQueue.size()!=0 ){
			int node = nodeQueue.front();
			nodeQueue.erase(nodeQueue.begin());
			inQueue[node] = false;

			vector<int> inNeis = graph.neighbors(node);
			for (int i = 0; i < inNeis.size(); i++)
				nodeHeap->changeKey(inNeis[ i ], -1);

			vector<int> outNeis = graph.neighbors(node);
			for (int i=0;i<outNeis.size();i++){
				int adjNode = outNeis[ i ];

				if (live[ adjNode ] > 0){
					live[ adjNode ]--;

					if (live[ adjNode ] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						nodeHeap->updateKey(adjNode, 0);
						reqNum--;

						if (!inQueue[adjNode]){
							nodeQueue.push_back( adjNode );
						}
					}
				}
			}
		}
	}//end while selection
	delete [] live;
	delete nodeHeap;
	delete [] inQueue;

	return pids;
} //end of infinite pids
/////////////////////////////////////////////////////////////////////////////////////////////////////
bool pidsCheck(AdjGraph& graph, double rho, double fraction, int latency, vector<int> pids){
	int n = graph.order();
	int coverage = pidsCoverage(graph, rho, latency, pids);
	return ( coverage >= fraction*n );
}// End of chek pids
//============================================================
//Compute coverage
int pidsCoverage(AdjGraph& graph, double rho, int latency, vector<int> pids){
	int n = graph.order();
	int coverage = 0;
	int *sequence = new int[latency + 1];
	int *live = new int[n];
	for (int i = 0; i < n; ++i){
		live[i] = ceil(rho*graph.getDegree(i));
	}

	queue<int> q;
	//bool *inqueue = new bool[n];

	for (int i = 0; i < pids.size(); ++i){
		if (live[ pids[ i ] ] != 0)
			coverage++;
		live[ pids[ i ] ] = 0;
		q.push(pids[ i ]);
	}
	sequence[0] = coverage;
	int levelSize;
	//Propagate latency hops
	for (int i = 0; i < latency; ++i){
		levelSize = q.size();
		for (int j = 0; j < levelSize;j++){
			int node = q.front();
			q.pop();
			vector<int> neis = graph.neighbors(node);
			for (int k=0; k< neis.size();k++){
				int adjNode = neis[ k ];
				if (live[ adjNode ] > 0 ){
					live[ adjNode ]--;
					if (live[adjNode] == 0){
						coverage++;
						q.push(adjNode);
					}
				}
			}
		}
		sequence[i+1] = coverage;
	}
	delete [] live;
	delete [] sequence;
	return coverage;
}// End of chek pids

////////////////////////////////////////////////////////////////
int* pidsGrow(AdjGraph& graph, double rho, int latency, vector<int> pids){
	int n = graph.order();
	int coverage = 0;
	int *sequence = new int[latency + 1];
	int *live = new int[n];
	for (int i = 0; i < n; ++i){
		live[i] = ceil(rho*graph.getDegree(i));
	}

	queue<int> q;
	//bool *inqueue = new bool[n];

	for (int i = 0; i < pids.size(); ++i){
		live[ pids[ i ] ] = 0;
		q.push(pids[ i ]);
		coverage++;
	}
	sequence[0] = coverage;
	int levelSize;
	//Propagate latency hops
	for (int i = 0; i < latency; ++i){
		levelSize = q.size();
		for (int j = 0; j < levelSize;j++){
			int node = q.front();
			q.pop();
			vector<int> neis = graph.neighbors(node);
			for (int k=0; k< neis.size();k++){
				int adjNode = neis[ k ];
				if (live[ adjNode ] > 0 ){
					live[ adjNode ]--;
					if (live[adjNode] == 0){
						coverage++;
						q.push(adjNode);
					}
				}
			}
		}
		sequence[i+1] = coverage;
	}
	delete [] live;
	return sequence;
} //end of growth function

///////////////////////////////////////////////////////
//priority = 1 + sum of 1/aNv of neighbors
vector<int> pidsImprovedHighestDomination(AdjGraph& graph, double rho, double fraction, int latency){
	int n = graph.order();

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++)
		for (int u = 0; u < n; u++)
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<heapElement> nodeList;
	for (int u = 0; u < n; ++u){
		double key = 0;
		if (live[latency][ u ] > 0) key++;

		vector<int> outNeis = graph.neighbors(u);
		FOR(i, outNeis.size())
		if (live[ latency ][ outNeis[ i ]] > 0)
			key += 1.0/(live[ latency ][ outNeis[ i ]]);

		heapElement e = {u, key};
		nodeList.push_back(e);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		heapElement selectedNode = nodeHeap->extractMax();

		if ( selectedNode.key <= 0) break;

		int selectedID = selectedNode.id;
		pids.push_back(selectedID);

		//update neighbors' priority
		if ( activeStep[ selectedID ] > latency){
			vector<int> inNeis = graph.neighbors(selectedID);
			FOR(i, inNeis.size())
			nodeHeap->changeKey( inNeis[ i ], -1.0/live[ latency ][ selectedID ]);
		}

		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//	printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			//	printf("die1");
			if (oldStep > latency){
				reqNum--;
				//	printf("size of neighbor \n");
				//vector<int> inNeis = graph.neighbors(curNode);
				//	printf("size of neighbor %d\n", inNeis.size());
				//for (int i = 0; i < inNeis.size(); i++)
				//	nodeHeap->changeKey(inNeis[ i ], -1);
			}
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];

				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;

				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						if ( activeStep[adjNode]>latency ) {
							nodeHeap->changeKey(adjNode, -1);
							vector<int> neighborNeighbors = graph.neighbors( adjNode );
							for (int k = 0; k < neighborNeighbors.size(); ++k)
								nodeHeap->changeKey(neighborNeighbors[ k ], -1.0);
						}

						if ( !inQueue[ adjNode ] ){
							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}

				//Node is still alive
				if ( activeStep[adjNode]>latency && oldStep >= latency && activeStep[ curNode ] + 1 <= effectStep) {
					//nodeHeap->changeKey(adjNode, -1);
					vector<int> neighborNeighbors = graph.neighbors( adjNode );
					for (int k = 0; k < neighborNeighbors.size(); ++k)
						nodeHeap->changeKey(neighborNeighbors[ k ], 1.0/live[ latency ][ adjNode ] - 1.0/(live[ latency ][ adjNode ] + 1));
				}
			}
		}
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete [] inQueue;

	return pids;
} //end pidsImprovedHighestDomination
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
///////////////////////////////////////////////////////
/*vector<int> pidsFactionAllRound(AdjGraph& graph, double rho, double fraction, int latency){
	int n = graph.order();

	double factor[latency+1];
	FOR (i, latency + 1)
		factor = 1.0/latency;

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;
	for(int t = 0; t < latency + 1; t++)
		for (int u = 0; u < n; u++)
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<heapElement> nodeList;
	for (int u = 0; u < n; ++u){
		double key = 0;
		if (live[latency][ u ] > 0) key++;

		vector<int> outNeis = graph.neighbors(u);
		FOR(i, outNeis.size())

		if (live[ latency ][ outNeis[ i ]] > 0)
			key += 1.0/(live[ latency ][ outNeis[ i ]]);

		heapElement e = {u, key};
		nodeList.push_back(e);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodeList);
	nodeHeap->build();

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		heapElement selectedNode = nodeHeap->extractMax();

		if ( selectedNode.key <= 0) break;

		int selectedID = selectedNode.id;
		pids.push_back(selectedID);

		//update neighbors' priority
		if ( activeStep[ selectedID ] > latency){
			vector<int> inNeis = graph.neighbors(selectedID);
			FOR(i, inNeis.size())
			nodeHeap->changeKey( inNeis[ i ], -1.0/live[ latency ][ selectedID ]);
		}

		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//	printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			//	printf("die1");
			if (oldStep > latency){
				reqNum--;
				//	printf("size of neighbor \n");
				//vector<int> inNeis = graph.neighbors(curNode);
				//	printf("size of neighbor %d\n", inNeis.size());
				//for (int i = 0; i < inNeis.size(); i++)
				//	nodeHeap->changeKey(inNeis[ i ], -1);
			}
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];

				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;

				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						if ( activeStep[adjNode]>latency ) {
							nodeHeap->changeKey(adjNode, -1);
							vector<int> neighborNeighbors = graph.neighbors( adjNode );
							for (int k = 0; k < neighborNeighbors.size(); ++k)
								nodeHeap->changeKey(neighborNeighbors[ k ], -1.0);


						}

						if ( !inQueue[ adjNode ] ){
							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}

				//Node is still alive
				if ( activeStep[adjNode]>latency && oldStep >= latency && activeStep[ curNode ] + 1 <= effectStep) {
					//nodeHeap->changeKey(adjNode, -1);
					vector<int> neighborNeighbors = graph.neighbors( adjNode );
					for (int k = 0; k < neighborNeighbors.size(); ++k)
						nodeHeap->changeKey(neighborNeighbors[ k ], 1.0/live[ latency ][ adjNode ] - 1.0/(live[ latency ][ adjNode ] + 1));
				}
			}
		}
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete nodeHeap;
	delete [] inQueue;

	return pids;
} //end pidsImprovedHighestDomination
 */
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//Tpids
vector<int> tpidsGreedyHighestDomination(AdjGraph& graph, double rho){
	int n = graph.order();

	//Number of lacking dominations
	int *live = new int[ n ];
	//int num = 0;
	FOR (u, n)
	live[ u ] = ceil( rho*graph.getDegree ( u ) );

	vector<heapElement> nodes;
	nodes.reserve(n);

	vector<int> selectedNodes;

	//initial priority = outdegree + itself
	FOR (u, n){
		heapElement e = { u, graph.getDegree(u) };
		nodes.push_back(e);
	}

	MaxHeap *nodeHeap = new MaxHeap(nodes);
	nodeHeap->build();

	while (true){
		heapElement selection = nodeHeap->extractMax();

		if ( selection.key <= 0 ) break;
		selectedNodes.push_back( selection.id );

		vector<int> outNeighbors = graph.neighbors( selection.id );
		FOR ( j, outNeighbors.size() ){
			int adjNode = outNeighbors[ j ];
			//Update live of neighbor nodes
			if (live[ adjNode ]>0){
				live[ adjNode ]--;

				//Update priority of its neighbors' neighbors
				if(live[adjNode] == 0){
					//Minus itself
					//nodeHeap->changeKey(adjNode, -1);

					vector<int> neighborNeighbors = graph.neighbors( adjNode );
					FOR (k, neighborNeighbors.size() )
					nodeHeap->changeKey(neighborNeighbors[ k ], -1);
				}
			}
		}
	}

	delete nodeHeap;
	delete [] live;

	return selectedNodes;
}// End of tpidsGreedyHighestDomination
/////////////////////////////////////////////////////////////////////////////
vector<int> tpidsGreedyHighestDegree(AdjGraph& graph, double rho){

	int n = graph.order();
	vector<Node> nodes;
	nodes.reserve(n);
	int *key = new int[ n ];

	FOR(u, n){
		key [ u ] = graph.getDegree(u);
		Node newNode = {u, key[ u ]};
		nodes.push_back(newNode);
	}

	sort(nodes.begin(), nodes.end(), comp);

	//Track the status of each node at each level
	int *live = new int[ n ];
	FOR (u, n)
	live[ u ] = ceil(rho*graph.getDegree(u));

	vector<int> pids;

	FOR (index, n){
		//Only selected useful vertices
		if ( key [ nodes[ index ].id ] == 0)
			continue;

		Node selection = nodes[ index ];


		pids.push_back(selection.id);

		vector<int> outNeighbors = graph.neighbors( selection.id );
		FOR ( j, outNeighbors.size() ){
			int adjNode = outNeighbors[ j ];
			//Update live of neighbor nodes
			if (live[ adjNode ]>0){
				live[ adjNode ]--;

				//Update priority of its neighbors' neighbors
				if(live[adjNode] == 0){
					//Minus itself
					//nodeHeap->changeKey(adjNode, -1);

					vector<int> neighborNeighbors = graph.neighbors( adjNode );
					FOR (k, neighborNeighbors.size() )
					key [ neighborNeighbors[ k ] ]--;
				}
			}
		}
	}//end while selection

	delete [] key;
	delete [] live;

	return pids;
} //end of tpidsGreedyHighestDegree
///////////////////////////////////////////////////////////////////////////
bool tpidsCheck(AdjGraph& graph, double rho, vector<int> tpids){

	int n = graph.order();
	bool *active = new bool[ n ];

	FOR (i, n)
	active[i] = false;

	FOR ( i, tpids.size() )
	active[ tpids[ i ] ] = true;

	bool result = true;
	FOR (u, n){
		vector<int> inNeis = graph.neighbors(u);
		int activeNeis = 0;
		FOR ( k, inNeis.size() ){
			if ( active[ inNeis[ k ] ]) activeNeis++;
		}
		result = result && (activeNeis >= ceil(rho*inNeis.size()));
	}

	delete [] active;

	return result;
}// End of check tpids
////////////////////////////////////////////////////////////////////////////
int tpidsCoverage(AdjGraph& graph, double rho, vector<int> tpids){

	int n = graph.order();
	bool *active = new bool[ n ];

	FOR (i, n)
	active[i] = false;

	FOR ( i, tpids.size() )
	active[ tpids[ i ] ] = true;

	int coverage = 0;
	FOR (u, n){
		vector<int> inNeis = graph.neighbors(u);
		int activeNeis = 0;
		FOR ( k, inNeis.size() ){
			if ( active[ inNeis[ k ] ]) activeNeis++;
		}
		if (activeNeis >= ceil(rho*inNeis.size())) coverage++;
	}

	delete [] active;

	return coverage;
}// End of check tpids
////////////////////////////////////////////////////////////////////////////

vector<int> tpidsDecay(AdjGraph& graph, double rho, vector<int> oldSet){
	int n = graph.order();

	int *active = new int[ n ];
	FOR (u, n)
	active[ u ] = false;

	FOR( u, oldSet.size())
	active[ oldSet[ u ] ] = true;

	vector<int> newSet;

	FOR ( i, oldSet.size() ){
		int u = oldSet[ i ];
		vector<int> inNeis = graph.neighbors(u);
		int activeNeis = 0;
		FOR ( k, inNeis.size() ){
			if ( active[ inNeis[ k ] ]) activeNeis++;
		}
		if (activeNeis >= ceil(rho*inNeis.size()))
			newSet.push_back( u );
	}

	delete [] active;

	return newSet;

}//end of tpidsDecay
vector<int> tpidsCommunityBaseHighestDomination(const char* directory, double rho){
	vector<int> pids;
	std::string     strPattern;              // Pattern
	HANDLE          hFile;                   // Handle to file
	WIN32_FIND_DATA FileInformation;         // File information


	strPattern = string(directory) + "\\*.*";

	hFile = ::FindFirstFile(strPattern.c_str(), &FileInformation);
	vector<string> files;
	if(hFile != INVALID_HANDLE_VALUE) {
		do {
			if(FileInformation.cFileName[0] != '.')
			{
				files.push_back(FileInformation.cFileName);
			}
		} while(::FindNextFile(hFile, &FileInformation) == TRUE);
	}

	// Close handle
	::FindClose(hFile);

	FILE *fo;
	char outName[100];

	//double fraction;

	//int percent;
	//int result[11][6];
	sprintf(outName, "HistogramHDTpids%sRho%0.1f.txt", files[ 0 ].c_str(),rho);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "Dataset: %s\n", files[ 0 ].c_str());
	fprintf(fo, "Histogram Total pids on communities with rho = %0.1f .\n", rho);
	fprintf(fo, "Highest domination algorithm.\n");


	AdjGraph *graph;
	FOR (i, files.size() ){
		string file = string(directory) + "\\" + files[ i ];
		//printf("%s\n", file.c_str());
		graph = new AdjGraph( file.c_str(), false);
		//printf("n = %d, edges = %d", graph->order(), graph->numberOfEdge());

		if (graph->size()>0){
			vector<int> subPids = tpidsGreedyHighestDomination(*graph, rho);
			FOR (u, subPids.size() )
			pids.push_back(graph->getName( subPids[ u ]));
			fprintf(fo, "%d \n", subPids.size());
		}
		delete graph;
	}
	fclose(fo);
	return pids;
}//end of pidsCommunityBase
vector<int> tpidsCommunityBaseHighestDegree(const char* directory, double rho){
	vector<int> pids;
	std::string     strPattern;              // Pattern
	HANDLE          hFile;                   // Handle to file
	WIN32_FIND_DATA FileInformation;         // File information


	strPattern = string(directory) + "\\*.*";

	hFile = ::FindFirstFile(strPattern.c_str(), &FileInformation);
	vector<string> files;
	if(hFile != INVALID_HANDLE_VALUE) {
		do {
			if(FileInformation.cFileName[0] != '.')
			{
				files.push_back(FileInformation.cFileName);
			}
		} while(::FindNextFile(hFile, &FileInformation) == TRUE);
	}

	// Close handle
	::FindClose(hFile);

	FILE *fo;
	char outName[100];

	//double fraction;

	//int percent;
	//int result[11][6];
	sprintf(outName, "HistogramHDETpids%sRho%0.1f.txt", files[ 0 ].c_str(),rho);
	fo = fopen(outName, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "Dataset: %s\n", files[ 0 ].c_str());
	fprintf(fo, "Histogram Total pids on communities with rho = %0.1f .\n", rho);
	fprintf(fo, "Highest degree algorithm.\n");


	AdjGraph *graph;
	FOR (i, files.size() ){
		string file = string(directory) + "\\" + files[ i ];
		//printf("%s\n", file.c_str());
		graph = new AdjGraph( file.c_str(), false);
		//printf("n = %d, edges = %d", graph->order(), graph->numberOfEdge());

		if (graph->size()>0){
			vector<int> subPids = tpidsGreedyHighestDegree(*graph, rho);
			FOR (u, subPids.size() )
			pids.push_back( graph->getName( subPids[ u ] ) );
			fprintf(fo, "%d \n", subPids.size());
		}
		delete graph;
	}
	fclose(fo);
	return pids;
}//end of pidsCommunityBase

/*
void countingSort(vector<Node>& Array)
{
	int Min, Max;
	Min = Max  = Array[0].degree;
	for(int i = 1; i < Array.size(); i ++)//detrmin the max and min in the array
	{
		if(Array[i].degree < Min)
			Min = Array[i].degree;

		if(Array[i] > Max)
			Max = Array[i].degree;
	}
	int Range = Max - Min + 1; //the range is useful to minmize the memory useage

	vector<int> Count; //Count Array Hold The Number Of Each Number
	Count.resize(Range);

	for(int i = 0; i < Range; i ++)
		Count[i] = 0;

	for(int i = 0; i < Array.size(); i ++)
		Count[Array[i].degree - Min] ++;

	int Index = 0;
	for(int i = Min; i <= Max; i ++)//Fill Array in sorted Order
		for(int j = 0; j < Count[i - Min]; j ++)
			Array[Index ++] = i;
} // end of counting sort
 */
//======================================================================================
/*
 * Select node with the given order
 *
 */
//Start from the highest degree vertices
vector<int> pidsFixedOrder(AdjGraph& graph, double rho, double fraction, int latency, vector<int> order){
	char fname[100];
	sprintf(fname, "MaxDegreeRho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;
	}
	fprintf(fo, "#Dataset: \n");
	fprintf(fo, "#MaxDegree\n");
	fprintf(fo, "#First column size of pids, the second the number of inactive node.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);

	int n = graph.order();

	int *key = new int[n];

	FOR(u, n){
		key [ u ] = graph.getDegree(u) + 1;
	}

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];
	bool **inLiveStack = new bool*[ latency + 1 ];
	inLiveStack[ 0 ] = new bool[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
	{
		live[ t ] = live[ t - 1 ] + n;
		inLiveStack[ t ] = inLiveStack[ t - 1 ] + n;
	}

	for(int t = 0; t < latency + 1; t++)
		for (int u = 0; u < n; u++)
		{
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
			inLiveStack[ t ][ u ] = false;
		}

	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );

	int index = 0;
	while ( reqNum > 0 ){

		if ( index == n ) break;

		//Only selected useful vertices
		while ( pidsComputeActive(graph, rho, fraction, latency, activeStep, live, inQueue, inLiveStack, order[ index ] ) == 0)
			index++;

		int selectedID = order[ index ];

		pids.push_back(selectedID);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){

			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			inQueue[ curNode ] = false;
			if (oldStep > latency){
				reqNum--;
			}
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size(); i++){
				int adjNode = outNeis[ i ];

				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;
				//int step;
				for (int step = activeStep[ curNode ] + 1; step <= effectStep; ++step){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if ( activeStep[adjNode]>latency ) key[ adjNode ]--;

						if ( !inQueue[ adjNode ] ){
							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;
						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		} //end of queue
		index++;
		fprintf(fo, "%d %d \n", pids.size(), reqNum);
	}//end while selection

	delete [] key;
	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete [] inQueue;
	delete [] inLiveStack[0];
	delete [] inLiveStack;
	fclose(fo);

	return pids;
} //end of pidsGreedyHighestDegree
//======================================================================================

vector<int> pidsLazyUpdate(AdjGraph& graph, double rho, double fraction, int latency){
	char fname[200];
	sprintf(fname, "MaxActiveNodeOriginRho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: \n" );
	fprintf(fo, "#MaxActiveNode\n");
	fprintf(fo, "#First column size of pids, the second the number of inactive node.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);

	int n = graph.order();

	vector<Node> nodes;

	FOR(u, n){
		Node newNode = {u, n};
		nodes.push_back(newNode);
	}
	vector<int> pids;

	cout << "start lazy update" << endl;
	while ( true ){
		int cur = pidsCoverage(graph, rho, latency, pids);
		//printf("%d %d\n", pids.size(), cur);
		fprintf(fo, "%d %d\n", pids.size(), cur);
		if (cur == n) break;

		sort(nodes.begin(), nodes.end(), comp);
		int maxPosition = -1;
		int maxActiveNode = -1;

		FOR(i, nodes.size()) {
			cout << i << " " << cur << endl;
			if (nodes[i].key < maxActiveNode) break;
			pids.push_back(nodes[i].id);
			int increase = pidsCoverage(graph, rho, latency, pids) - cur;
			nodes[i].key = increase;
			if (increase > maxActiveNode){
				maxActiveNode = increase;
				maxPosition = i;
			}
			pids.pop_back();
		}
		if (maxPosition == -1) break;

		int selectedID = nodes[ maxPosition ].id;
		nodes[ maxPosition ] = nodes[ nodes.size() - 1 ];
		nodes.pop_back();

		pids.push_back(selectedID);


	}//end while selection

	fclose(fo);

	return pids;
} //end pids max number of live edge


vector<int> pidsLazyUpdate_2(AdjGraph& graph, double rho, double fraction, int latency){
	char fname[100];
	sprintf(fname, "MaxActiveNodeOriginRho%0.1fFraction%0.1fLatency%d.txt", rho, fraction, latency);
	FILE *fo = fopen(fname, "w");
	if (!fo){
		cerr <<"Error: File access denied."<<endl;

	}
	fprintf(fo, "#Dataset: \n" );
	fprintf(fo, "#MaxActiveNode\n");
	fprintf(fo, "#First column size of pids, the second the number of inactive node.\n");
	fprintf(fo, "#Number of nodes: %d, number of edge %d, rho = %f fraction = %f\n", graph.order(), graph.size(), rho, fraction);

	int n = graph.order();

	vector<Node> nodes;

	FOR(u, n){
		Node newNode = {u, n};
		nodes.push_back(newNode);
	}

	//Track the status of each node at each level
	int **live = new int*[ latency + 1 ];
	live[ 0 ] = new int[ (latency + 1)*n];

	for(int t = 1; t < latency + 1; t++)
		live[ t ] = live[ t - 1 ] + n;

	for(int t = 0; t < latency + 1; t++){
		for (int u = 0; u < n; u++)
			live[ t ][ u ] = (int)ceil(rho*graph.getDegree(u));
	}
	//The current level of each node
	int *activeStep = new int[ n ];
	for (int u = 0; u < n; u++)
		activeStep[ u ] = latency + 1;

	vector<int> pids;

	bool *inQueue = new bool[ n ];
	for (int i = 0; i < n; i++)
		inQueue[i] = false;

	int reqNum = ceil( fraction * n );
	//printf("%d\n", reqNum);
	//int a;
	while ( reqNum > 0 ){
		int cur = pidsCoverage(graph, rho, latency, pids);
		//printf("%d %d\n", pids.size(), cur);
		fprintf(fo, "%d %d\n", pids.size(), cur);
		if (cur == n) break;

		sort(nodes.begin(), nodes.end(), comp);

		queue<int> nodeQueue;
		queue<int> oldStepQueue;
		//printf("%d\n", reqNum);
		//Select best node
		int maxPosition = -1;
		int maxActiveNode = -1;
		int maxActiveEdge = -1;

		FOR (u, nodes.size()){
			if (u%100 == 0) cout << u << " " << cur << endl;

			if (nodes[u].key < maxActiveNode) break;

			int node = nodes[ u ].id;
			int activeNode = 0;
			int activeEdge = 0;

			stack<int> activeStepStack;
			stack<int> liveStack;

			nodeQueue.push(node);
			oldStepQueue.push(activeStep[ node ]);

			activeStepStack.push(node);
			activeStepStack.push(activeStep[ node ]);
			activeStep[ node ] = 0;

			for (int i = 0; i < latency + 1; i++){
				liveStack.push(node);
				liveStack.push(i);
				liveStack.push(live[ i ][ node ]);
				live[ i ][ node ] = 0;
			}
			inQueue[ node ] = true;

			while( !nodeQueue.empty()){
				if (nodeQueue.size() == 0)
					printf("sea");
				int curNode = nodeQueue.front();
				nodeQueue.pop();

				int oldStep = oldStepQueue.front();
				oldStepQueue.pop();

				inQueue[ curNode ] = false;
				if ( oldStep > latency){
					activeNode++;
				}

				vector<int> outNeis = graph.neighbors(curNode);
				for (int i = 0; i < outNeis.size();i++){
					int adjNode = outNeis[ i ];
					if (activeStep[ adjNode ] == latency + 1)
						activeEdge++;

					int effectStep = oldStep;
					if ( effectStep > (activeStep[ adjNode ] -1) )
						effectStep = activeStep[ adjNode ] - 1;
					for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
						liveStack.push(adjNode);
						liveStack.push(step);
						liveStack.push(live[step][adjNode]);
						live[step][adjNode]--;
						if (live[step][adjNode] == 0){
							if ( !inQueue[ adjNode ] ){
								nodeQueue.push( adjNode );
								oldStepQueue.push( activeStep[ adjNode ] );
								inQueue[ adjNode ] = true;
							}

							activeStepStack.push(adjNode);
							activeStepStack.push(activeStep[ adjNode ]);

							activeStep[ adjNode ] = step;

							for (int j = step; j <= latency; j++){
								liveStack.push( adjNode );
								liveStack.push( j );
								liveStack.push( live[ j ][adjNode] );

								live[ j ][ adjNode ] = 0;
							}
							break;
						}
					}
				}
			}
			nodes[u].key = activeNode;
			if (activeNode > maxActiveNode){
				maxActiveNode = activeNode;
				maxActiveEdge = activeEdge;
				maxPosition = u;
			}

			while (!activeStepStack.empty()){
				int step = activeStepStack.top();
				activeStepStack.pop();

				int node = activeStepStack.top();
				activeStepStack.pop();

				activeStep[ node ] = step;

			}

			while ( !liveStack.empty() ){
				int liveValue = liveStack.top();
				liveStack.pop();
				int step = liveStack.top();
				liveStack.pop();
				int node = liveStack.top();
				liveStack.pop();

				live[ step ][ node ] = liveValue;
			}
		}

		if (maxPosition == -1) break;

		int selectedID = nodes[ maxPosition ].id;
		nodes[ maxPosition ] = nodes[ nodes.size() - 1 ];
		nodes.pop_back();

		pids.push_back(selectedID);

		nodeQueue.push( selectedID );
		oldStepQueue.push( activeStep[ selectedID ]);
		activeStep[ selectedID ] = 0;
		for (int i = 0; i < latency + 1; i++)
			live[ i ][ selectedID ] = 0;
		inQueue[ selectedID ] = true;

		while(nodeQueue.size()!=0){
			//printf("%d \n", reqNum);
			int curNode = nodeQueue.front();
			nodeQueue.pop();

			int oldStep = oldStepQueue.front();
			oldStepQueue.pop();

			//printf("queue size %d and %d node id %d\n", nodeQueue.size(), oldStepQueue.size(), node);

			inQueue[ curNode ] = false;
			if ( oldStep > latency){
				reqNum--;
			}

			//	printf("die1");
			//	printf("die");
			vector<int> outNeis = graph.neighbors(curNode);
			for (int i = 0; i < outNeis.size();i++){
				int adjNode = outNeis[ i ];
				int effectStep = oldStep;
				if ( effectStep > (activeStep[ adjNode ] -1) )
					effectStep = activeStep[ adjNode ] - 1;

				for (int step = activeStep[ curNode ] + 1; step <= effectStep; step++){
					live[step][adjNode]--;
					if (live[step][adjNode] == 0){
						//if (activeStep[adjNode]<=step) System.out.println("errr");

						//if ( activeStep[adjNode]>latency ) nodeHeap->changeKey(adjNode, -1);

						if ( !inQueue[ adjNode ] ){

							nodeQueue.push( adjNode );
							oldStepQueue.push( activeStep[ adjNode ] );
							inQueue[ adjNode ] = true;
						}
						activeStep[ adjNode ] = step;

						for (int j = step; j <= latency; j++)
							live[ j ][ adjNode ] = 0;
						break;
					}
				}
			}
		}
		fprintf(fo, "%d %d\n", pids.size(), reqNum);
	}//end while selection

	delete [] live[0];
	delete [] live;
	delete [] activeStep;
	delete [] inQueue;
	fclose(fo);

	return pids;
} //end pids max number of live edge
//=======================================================================
