/*
 * ICM.h
 *
 *  Created on: Jul 25, 2010
 *      Author: seven
 */
#include "AdjGraph.h"
#include "common.h"
#include "Measure.h"
#include "BoostGraph.h"
#include "Util.h"

#ifndef ICM_H_
#define ICM_H_



int getCoverage(AdjGraph& graph, double probability, int latency, int* pids, int pidsSize);
double icmExpectedInfluence(AdjGraph& graph, vector<int> seeds, int round);
vector<int> icmTopGreedy(AdjGraph& graph, int k, int round);
vector<int> icmTopIMeter(AdjGraph& graph, int k, int len, int round);
vector<int> icmTopRW(AdjGraph& graph, int k, int len, int numberRW);
vector<int> icmTopFusedWalk(AdjGraph& graph, int k, int len, int round);
vector<int> icmTopFuseWalkDiscount(AdjGraph& graph, int k, int len, int round);

double icmExpectedInfluence(Graph& g, vector<Vertex> seeds, int round);
vector<Vertex> icmTopGreedy(Graph& g, int k, int round);
vector<Vertex> icmTopFusedWalk(Graph& g, int k, int len, int round);
vector<Vertex> icmTopIMeter(Graph& g, int k, int len, int round);
vector<Vertex> icmTopRW(Graph& g, int k, int len, int numRW);
vector<Vertex> icmTopLazyGreedy(Graph& g, int k, int round);
vector<Vertex> localSwap(Graph& g, vector<Vertex> origin, int round);
vector<Vertex> icmTopIMeterSwap(Graph& g, int k, int len, int round);
vector<Vertex> icmTopLazyGreedySwap(Graph& g, int k, int round);
vector<Vertex> icmUpperBound(Graph& g, int k, int round);
#endif
