/*
* Experiments.cpp
*
*  Created on: Jul 6, 2011
*      Author: dung
*/

#include "Experiments.h"
#include <algorithm>
#include <time.h>
#include "Util.h"


void icmGreedyVsImeterVsRW(AdjGraph& graph, string dataName) {
	FILE *fo;
	char outName[40];
	int round = 100;
	int len = 4;
	int numRW = 4*graph.order();
	int maxK = 50;
	int increasement = 1;

	sprintf(outName, "Topk%s.txt", dataName.c_str());
	fo = fopen(outName, "w");

	if (!fo) {
		cerr << "Error: File access denied!" << endl;
		return;
	}

	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#%d vertices and %d nodes \n", graph.order(), graph.size());
	fprintf(fo, "#Number of round: %d , number of RW %d, length of RW %d", round, numRW, len);
	fprintf(fo, "#Columns: number of selected nodes || Value of greedy algorithm || Value of RW || Value of Imeter \n");

	if (maxK > graph.order()) maxK = graph.order();

	vector<int> greedy = icmTopGreedy(graph, maxK, round);
	vector<int> rw = icmTopRW(graph, maxK, len, numRW);
	vector<int> imeter = icmTopIMeter(graph, maxK, len, round);

	for (int k=1; k<=maxK; k++){
		vector<int> subgreedy;
		vector<int> subrw;
		vector<int> subImeter;

		FOR (i, k) {
			subgreedy.push_back(greedy[i]);
			subrw.push_back(rw[i]);
			subImeter.push_back(imeter[i]);
		}

		double expGreedy = icmExpectedInfluence(graph, subgreedy, round);
		double expRW = icmExpectedInfluence(graph, subrw, round);
		double expImeter = icmExpectedInfluence(graph, subImeter, round);

		fprintf(fo, "%d\t%f\t%f\t%f \n", k, expGreedy, expRW, expImeter);
		fflush(fo);
	}
	fclose(fo);
}

void exprIcmFusedWalk(AdjGraph& graph, string dataName) {
	FILE *fo;
	char outName[40];
	int round = 1000;
	int len = 4;
	int numRW = 4*graph.order();
	int maxK = 50;
	int increasement = 1;

	sprintf(outName, "TopkFusedWalk%s.txt", dataName.c_str());
	fo = fopen(outName, "w");

	if (!fo) {
		cerr << "Error: File access denied!" << endl;
		return;
	}

	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#%d vertices and %d nodes \n", graph.order(), graph.size());
	fprintf(fo, "#Number of round: %d , number of RW %d, length of RW %d", round, numRW, len);
	fprintf(fo, "#Columns: number of selected nodes || Value of Fused Walk \n");

	if (maxK > graph.order()) maxK = graph.order();

	vector<int> fusedWalk = icmTopFusedWalk(graph, maxK, len, graph.order());

	for (int k=1; k<=maxK; k++){
		vector<int> subFusedWalk;

		FOR (i, k) {
			subFusedWalk.push_back(fusedWalk[i]);
		}

		double expFusedWalk = icmExpectedInfluence(graph, subFusedWalk, round);

		fprintf(fo, "%d\t%f \n", k, expFusedWalk);
		fflush(fo);
	}
	fclose(fo);
}

void exprIcmImeter(AdjGraph& graph, string dataName) {
	FILE *fo;
	char outName[40];
	int round = 1000;
	int len = 4;
	int numRW = 4*graph.order();
	int maxK = 50;
	int increasement = 1;

	sprintf(outName, "TopkImeter%s.txt", dataName.c_str());
	fo = fopen(outName, "w");

	if (!fo) {
		cerr << "Error: File access denied!" << endl;
		return;
	}

	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#%d vertices and %d nodes \n", graph.order(), graph.size());
	fprintf(fo, "#Number of round: %d , number of RW %d, length of RW %d", round, numRW, len);
	fprintf(fo, "#Columns: number of selected nodes || Value of Fused Walk \n");

	if (maxK > graph.order()) maxK = graph.order();

	vector<int> rw = icmTopRW(graph, maxK, len, numRW);

	for (int k=1; k<=maxK; k++){
		vector<int> subrw;

		FOR (i, k) {
			subrw.push_back(rw[i]);
		}

		double expFusedWalk = icmExpectedInfluence(graph, subrw, round);

		fprintf(fo, "%d\t%f \n", k, expFusedWalk);
		fflush(fo);
	}
	fclose(fo);
}

void exprIcmRW(AdjGraph& graph, string dataName) {
	FILE *fo;
	char outName[40];
	int round = 1000;
	int len = 4;
	int numRW = 4*graph.order();
	int maxK = 50;
	int increasement = 1;

	sprintf(outName, "TopkRW%s.txt", dataName.c_str());
	fo = fopen(outName, "w");

	if (!fo) {
		cerr << "Error: File access denied!" << endl;
		return;
	}

	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#%d vertices and %d nodes \n", graph.order(), graph.size());
	fprintf(fo, "#Number of round: %d , number of RW %d, length of RW %d", round, numRW, len);
	fprintf(fo, "#Columns: number of selected nodes || Value of Fused Walk \n");

	if (maxK > graph.order()) maxK = graph.order();

	vector<int> rw = icmTopIMeter(graph, maxK, len, round);

	for (int k=1; k<=maxK; k++){
		vector<int> subrw;

		FOR (i, k) {
			subrw.push_back(rw[i]);
		}

		double expFusedWalk = icmExpectedInfluence(graph, subrw, round);

		fprintf(fo, "%d\t%f \n", k, expFusedWalk);
		fflush(fo);
	}
	fclose(fo);
}


void exprIcm( vector<int> (*f)(AdjGraph&, int, int, int), AdjGraph& graph, string dataName, string method) {
	FILE *fo;
	char outName[40];
	int round = 1000;
	int len = 10;
	int numRW = 4*graph.order();
	int maxK = 50;
	int increasement = 1;

	sprintf(outName, "Topk%s%s.txt", dataName.c_str(), method.c_str());
	fo = fopen(outName, "w");

	if (!fo) {
		cerr << "Error: File access denied!" << endl;
		return;
	}

	fprintf(fo, "#Dataset: %s\n", dataName.c_str());
	fprintf(fo, "#Method: %s\n", method.c_str());
	fprintf(fo, "#%d vertices and %d nodes \n", graph.order(), graph.size());
	fprintf(fo, "#Round = %d , numRW = %d, len = %d \n", round, numRW, len);
	fprintf(fo, "#Columns: number of selected nodes || Influence Spread \n");

	if (maxK > graph.order()) maxK = graph.order();

	vector<int> seed = f(graph, maxK, len, round);

	for (int k=1; k<=maxK; k++){
		vector<int> subSeed;

		FOR (i, k) {
			subSeed.push_back(seed[i]);
		}

		double expectedInfluence = icmExpectedInfluence(graph, subSeed, round);

		fprintf(fo, "%d\t%f \n", k, expectedInfluence);
		fflush(fo);
	}
	fclose(fo);
}

void exprIcmGreedyVsImeterVsRW(string file, string dataName) {
	/*
	AdjGraph *graph = new AdjGraph(file.c_str(), false, RANDOM_WEIGHT);
	cout << graph->order()<< " - " << graph->size() << endl;
	string graphType = "Random";

	exprIcm(icmTopFuseWalkDiscount, *graph, dataName + graphType, "FusedWalkDiscount");
	exprIcm(icmTopFusedWalk, *graph, dataName + graphType, "FusedWalk");
	exprIcmRW(*graph, dataName + graphType);

	delete graph;

	graph = new AdjGraph(file.c_str(), false, UNIFORM_WEIGHT);
	//icmGreedyVsImeterVsRW(*graph, dataName + "Uniform");
	//exprIcmFusedWalk(*graph, dataName + "Uniform");
	//exprIcmRW(*graph, dataName + "Uniform");
	//exprIcmImeter(*graph, dataName + "Uniform");
	//exprIcm(icmTopFuseWalkDiscount, *graph, dataName + "Uniform", "FusedWalkDiscount");
	delete graph;
	*/

	AdjGraph *graph = new AdjGraph(file.c_str(), false);
	cout << graph->order()<< " - " << graph->size() << endl;
	Graph g = convert(*graph, UNIFORM, 1);
	icmTopFusedWalk(g, 50, 10, 1000);
	//icmTopIMeter(g, 50, 10, 10000);
	//icmTopRW(g, 50, 10, 4*num_vertices(g));
	//icmTopGreedy(g, 50, 100);
	//icmTopLazyGreedy(g, 50, 10000);
	//icmTopIMeterSwap(g, 50, 10, 1000);
	icmTopLazyGreedySwap(g, 50, 10000);
	//icmUpperBound(g, 50, 10000);
	delete graph;
}



void effector(string file, string dataName) {

	AdjGraph *graph = new AdjGraph(file.c_str(), false);
	cout << graph->order()<< " - " << graph->size() << endl;
	Graph g = convert(*graph, UNIFORM, 1);

	//Generate target
	int len = 10;
	int numRW = 4*num_vertices(g);
	int round = 1000;
	int k = 14;
	vector<double> ini;

	vector<Vertex> rwOrder = hitCountSort(g, len, numRW, ini);
	vector<Vertex> seeds, target;

	printf("\n Seed nodes: \n");
	FOR (i, 4) {
		seeds.push_back( rwOrder[ 190*i  + 4 ] );
		cout<< rwOrder[ 190*i + 4  ] << " ";
	}
	//seeds.push_back(26);
	target = generateTarget(g, seeds);
	cout << endl << "Target size "<< target.size() << endl;
	//FOR (i, target.size()) {
	//	cout << target[i] << " ";
	//}
	effectorTopkImeter(g, k, target, len, round);
	//effectorTopkFusedWalk(g, k, target, len, round);
	effectorTopkGreedySort(g, k, target, len, round);

	//icmUpperBound(g, 50, 10000);
	delete graph;
}

void effectorOneNode(string file, string dataName) {
	AdjGraph *graph = new AdjGraph(file.c_str(), false);
	cout << graph->order()<< " - " << graph->size() << endl;
	Graph g = convert(*graph, UNIFORM, 1);

	//Generate target
	int n = num_vertices(g);
	int len = 10;
	int numRW = 4*num_vertices(g);
	int round = 1000;
	int k = 10;
	int N = 1000000;
	vector<double> ini;

	FILE *fo, *fstat;
	char outName[100];
	char outNameStat[100];
	sprintf(outName, "EffectorImeterOneNode_%d_%d_%d.txt", num_vertices(g), num_edges(g), round);
	fo = fopen(outName, "w");
	fprintf(fo, "#%d vertices %d edges \n", num_vertices(g), num_edges(g));
	fprintf(fo, "#Imeter One node k = %d len = %d round = %d N = %d\n", k, len, round, N);
	fprintf(fo, "#k || Detected || Time \n");

	//sprintf(outNameStat, "EffectorImeterOneNodeStat_%d_%d_%d.txt", num_vertices(g), num_edges(g), round);
	//fstat = fopen(outNameStat, "w");
	//fprintf(fstat, "#%d vertices %d edges \n", num_vertices(g), num_edges(g));
	//fprintf(fstat, "#Imeter One node k = %d len = %d round = %d N = %d\n", k, len, round, N);
	//fprintf(fstat, "#k || Detected || Time \n");

	Sleep(1000);
	srand(time(NULL));
	int numA = 1;
	double *detected = new double[k];
	FOR (i, k)
		detected[i] = 0;
	int count = 0;

	while(count<500){
		vector<Vertex> seeds, target;
		FOR(j, numA) {
			int u = (int) rand()/(1.0*RAND_MAX) * n;
			seeds.push_back(vertex(u, g));
		}
		//cout<< "here";
		target = generateTarget(g, seeds);
		if (target.size() < 10 ) continue;
		count++;
		cout<< count << endl;
		vector<Vertex>  suspect = iMeterOrder(g,len, round, target);
		//cout<< "here";
		int j = 0;
		for (j = 0; j<k; j++) {
			if (g[seeds[0]].index == g[suspect[j]].index)
				break;
		}
		/*
		fprintf(fstat,"%d\t", target.size());
		FOR (t, j-1) {
		fprintf(fstat,"%d\t", 0);

		}
		*/
		for (int t = j; t<k; t++) {
			//fprintf(fstat,"%d\t", 1);
			detected[t]++;
		}
		//fprintf(fstat,"\n");
	}

	FOR (i, k) {
		detected[i] = (1.0*detected[i])/count;
		fprintf(fo, "%d\t%f\n", i, detected[i]);
	}
	fprintf(fo, "count = %d\n", count);
	fclose(fo);
	//fclose(fstat);
	delete []  detected;
	delete graph;
}

void effectorNodes(string file, string dataName) {
	AdjGraph *graph = new AdjGraph(file.c_str(), false);
	cout << graph->order()<< " - " << graph->size() << endl;
	Graph g = convert(*graph, UNIFORM, 1);

	//Generate target
	int n = num_vertices(g);
	int len = 10;
	int numRW = 4*num_vertices(g);
	int round = 100;
	int numA = 10;
	int k = 30;
	int N = 500;
	int lowerSize = 200;
	vector<double> ini;
	int percent = 5;
	vector<Vertex> top;
	vector<Node> nodes;
	nodes.reserve(n);

	FOR (u, n) {
		Vertex v = vertex(u, g);
		top.push_back(v);
		Node newNode = {u, icmExpectedInfluence(g, top, round) };
		nodes.push_back(newNode);
		top.pop_back();
	}
	sort(nodes.begin(), nodes.end(), comp);

	for (numA=1; numA<11; numA += 9) {
		for (percent = 5; percent < 30; percent += 5) {
			int max = (int) (percent*n/100);

			FILE *fo;
			char outName[200];
			//char outNameStat[100];
			sprintf(outName, "EffectorImeterOneNode_%d_%d_%d_%d_%d_%d_%d.txt", num_vertices(g), num_edges(g), round, k, numA, lowerSize, percent);
			fo = fopen(outName, "w");
			fprintf(fo, "#%d vertices %d edges \n", num_vertices(g), num_edges(g));
			fprintf(fo, "#Imeter One node k = %d len = %d round = %d N = %d lowerSize = %d numA = %d percent = %d\n", k, len, round, N, lowerSize, numA, percent);
			fprintf(fo, "#k || Detected || Time \n");

			//sprintf(outNameStat, "EffectorImeterOneNodeStat_%d_%d_%d.txt", num_vertices(g), num_edges(g), round);
			//fstat = fopen(outNameStat, "w");
			//fprintf(fstat, "#%d vertices %d edges \n", num_vertices(g), num_edges(g));
			//fprintf(fstat, "#Imeter One node k = %d len = %d round = %d N = %d\n", k, len, round, N);
			//fprintf(fstat, "#k || Detected || Time \n");

			Sleep(1000);
			srand(time(NULL));

			double *detected = new double[k];
			FOR (i, k)
				detected[i] = 0;
			int count = 1;

			while(count< N+1){
				vector<Vertex> seeds, target;
				FOR(j, numA) {
					int u = (int) (rand() * max/(1.0*RAND_MAX));
					seeds.push_back(vertex(nodes[u].id, g));
					//cout<< u << endl;
				}
				//cout<< "here";
				target = generateTarget(g, seeds);
				//if (target.size() < lowerSize ) continue;
				count++;
				cout<< count << endl;
				vector<Vertex>  suspect = iMeterOrder(g,len, round, target);
				//cout<< "here";
				FOR (q, numA) {
					int j = 0;
					for (j = 0; j<k; j++) {
						if (g[seeds[q]].index == g[suspect[j]].index)
							break;
					}
					for (int t = j; t<k; t++) {
						detected[t]++;
					}
				}
			}

			FOR (i, k) {
				detected[i] = (1.0*detected[i])/count;
				fprintf(fo, "%d\t%f\n", i, detected[i]);
			}
			fprintf(fo, "count = %d\n", count);
			fclose(fo);
			delete []  detected;
		}
	}
	delete graph;
}

void effectorNodesGreedy(string file, string dataName) {
	AdjGraph *graph = new AdjGraph(file.c_str(), false);
	cout << graph->order()<< " - " << graph->size() << endl;
	Graph g = convert(*graph, UNIFORM, 1);

	//Generate target
	int n = num_vertices(g);
	int len = 10;
	int numRW = 4*num_vertices(g);
	int round = 1000;
	int numA = 1;
	int k = 30;
	int N = 500;
	int lowerSize = 200;
	vector<double> ini;
	int percent = 5;
	vector<Vertex> top;
	vector<Node> nodes;
	nodes.reserve(n);

	FOR (u, n) {
		Vertex v = vertex(u, g);
		top.push_back(v);
		Node newNode = {u, icmExpectedInfluence(g, top, round) };
		nodes.push_back(newNode);
		top.pop_back();
	}
	sort(nodes.begin(), nodes.end(), comp);

	for (numA=1; numA<11; numA += 9) {
		for (percent = 5; percent < 30; percent += 5) {
			int max = (int) (percent*n/100);


			FILE *fo;
			char outName[200];
			//char outNameStat[100];
			sprintf(outName, "EffectorGreedy_%d_%d_%d_%d_%d_%d_%d.txt", num_vertices(g), num_edges(g), round, k, numA, lowerSize, percent);
			fo = fopen(outName, "w");
			fprintf(fo, "#%d vertices %d edges \n", num_vertices(g), num_edges(g));
			fprintf(fo, "#Greedy node k = %d len = %d round = %d N = %d lowerSize = %d numA = %d percent = %d\n", k, len, round, N, lowerSize, numA, percent);
			fprintf(fo, "#k || Detected || Time \n");




			Sleep(1000);
			srand(time(NULL));

			double *detected = new double[k];
			FOR (i, k)
				detected[i] = 0;
			int count = 1;

			while(count< N+1){
				vector<Vertex> seeds, target;
				FOR(j, numA) {
					int u = (int) (rand() * max/(1.0*RAND_MAX));
					seeds.push_back(vertex(nodes[u].id, g));
					//cout<< u << endl;
				}
				//cout<< "here";
				target = generateTarget(g, seeds);
				if (k>target.size()) continue;
				//if (target.size() < lowerSize ) continue;
				count++;
				cout<< count << endl;
				vector<Vertex>  suspect = effectorTopLazyGreedy(g, k, target, target, round);
				FOR (q, numA) {
					int j = 0;
					for (j = 0; j<k; j++) {
						if (g[seeds[q]].index == g[suspect[j]].index)
							break;
					}
					//cout<< "j " << j << " j " << endl;
					for (int t = j; t<k; t++) {
						//fprintf(fstat,"%d\t", 1);
						detected[t]++;
					}
				}
				//fprintf(fstat,"\n");
			}

			FOR (i, k) {
				detected[i] = (1.0*detected[i])/count;
				fprintf(fo, "%d\t%f\n", i, detected[i]);
			}
			fprintf(fo, "count = %d\n", count);
			fclose(fo);
			delete []  detected;
		}
	}
	delete graph;
}

void effectorNodesEffector(string file, string dataName) {
	AdjGraph *graph = new AdjGraph(file.c_str(), false);
	cout << graph->order()<< " - " << graph->size() << endl;
	Graph g = convert(*graph, UNIFORM, 1);

	//Generate target
	int n = num_vertices(g);
	int len = 10;
	int numRW = 4*num_vertices(g);
	int round = 1000;
	int numA = 3;
	int k = 3;
	int N = 500;
	int lowerSize = 200;
	vector<double> ini;
	int percent = 5;
	vector<Vertex> top;
	vector<Node> nodes;
	nodes.reserve(n);

	FOR (u, n) {
		Vertex v = vertex(u, g);
		top.push_back(v);
		Node newNode = {u, icmExpectedInfluence(g, top, round) };
		nodes.push_back(newNode);
		top.pop_back();
	}
	sort(nodes.begin(), nodes.end(), comp);
	//FILE *orderlist;
	//char influentOrder[200];
	//sprintf(influentOrder, "Order_%d_%d.txt", num_vertices(g), num_edges(g));
	//orderlist = fopen(influentOrder, "wb");
	//if (!orderlist) {
	//		cerr <<"Error: File access denied."<<endl;
	//		return;
	//	}
	//FOR (i, num_vertices(g) )
	// fwrite((void *)&nodes[i].id, 	sizeof(int), 1, orderlist);
	//fclose(orderlist);

	for (numA=3; numA<11; numA += 9) {
		for (percent = 5; percent < 10; percent += 5) {
			//int max = (int) (percent*n/100);
			int max = n/2;


			FILE *fo;
			char outName[200];
			//char outNameStat[100];
			sprintf(outName, "EffectorEffector_%d_%d_%d_%d_%d_%d_%d.txt", num_vertices(g), num_edges(g), round, k, numA, lowerSize, percent);
			fo = fopen(outName, "w");
			fprintf(fo, "#%d vertices %d edges \n", num_vertices(g), num_edges(g));
			fprintf(fo, "#Effector node k = %d len = %d round = %d N = %d lowerSize = %d numA = %d percent = %d\n", k, len, round, N, lowerSize, numA, percent);
			fprintf(fo, "#k || Detected || Time \n");

			Sleep(1000);
			srand(time(NULL));

			double *detected = new double[k];
			FOR (i, k)
				detected[i] = 0;
			int count = 1;

			while(count< N+1){
				vector<Vertex> seeds, target;
				FOR(j, numA) {
					int u = (int) (rand() * max/(1.0*RAND_MAX));
					seeds.push_back(vertex(nodes[u].id, g));
					//cout<< u << endl;
				}
				//cout<< "here";
				target = generateTarget(g, seeds);

				//if (target.size() < lowerSize ) continue;
				count++;
				cout<< count << endl;
				vector<Vertex>  suspect = effectorTopkGreedySort(g, k, target, len, round);

				FOR (q, numA) {
					int j = 0;
					for (j = 0; j<k; j++) {
						if (g[seeds[q]].index == g[suspect[j]].index)
							break;
					}
					for (int t = j; t<k; t++) {
						detected[t]++;
					}
				}
			}

			FOR (i, k) {
				detected[i] = (1.0*detected[i])/count;
				fprintf(fo, "%d\t%f\n", i, detected[i]);
			}
			fprintf(fo, "count = %d\n", count);
			fclose(fo);
			delete []  detected;
		}
	}
	delete graph;
}

void optimalTestGreedy(string file, string dataName) {
	AdjGraph *graph = new AdjGraph(file.c_str(), false);
	cout << graph->order()<< " - " << graph->size() << endl;
	Graph g = convert(*graph, UNIFORM, 1);

	//Generate target
	int n = num_vertices(g);
	int len = 10;
	//int numRW = 4*num_vertices(g);
	int round = 1000;
	int maxNumA = 10;
	int k = 3;
	int N = 1000;
	int lowerSize = 200;
	vector<double> ini;
	int percent = 5;
	vector<Vertex> top;
	vector<Node> nodes;
	nodes.reserve(n);

	FOR (u, n) {
		Vertex v = vertex(u, g);
		top.push_back(v);
		Node newNode = {u, icmExpectedInfluence(g, top, round) };
		nodes.push_back(newNode);
		top.pop_back();
	}
	sort(nodes.begin(), nodes.end(), comp);


	FILE *fo;
	char outName[200];
	//char outNameStat[100];
	sprintf(outName, "EffectorOptGreedy_%d_%d_%d_%d_%d_%d_%d.txt", num_vertices(g), num_edges(g), round, k, maxNumA, lowerSize, percent);
	fo = fopen(outName, "w");
	fprintf(fo, "#%d vertices %d edges \n", num_vertices(g), num_edges(g));
	fprintf(fo, "#Effector node k = %d len = %d round = %d N = %d lowerSize = %d numA = %d percent = %d\n", k, len, round, N, lowerSize, maxNumA, percent);
	fprintf(fo, "#k || Detected || Time \n");

	for (int numA = 1; numA <= maxNumA; numA += 1) {
		double detected = 0;
		int count = 1;

		while(count< N+1){
			vector<Vertex> seeds, target;
			vector<int> selectedIndex = rand_comb(numA, n/2);
			FOR (i, numA) {
				seeds.push_back(vertex(nodes[selectedIndex[i]].id, g));
			}
			target = generateTarget(g, seeds);
			count++;
			if (count % 100 == 0) cout<< count << endl;
			vector<Vertex>  suspect = effectorOptimalGreedy(g, numA, target, target, round);

			FOR (q, numA) {
				int j = 0;
				for (j = 0; j<numA; j++) {
					if (g[seeds[q]].index == g[suspect[j]].index)  {
						detected++;
						break;
					}
				}
			}
		}
		fprintf(fo, "%d\t%f\n", numA, detected/count);
		fflush(fo);
	}

	fclose(fo);
	delete graph;
}

void optimalTestDistance(string file, string dataName) {
	AdjGraph *graph = new AdjGraph(file.c_str(), false);
	cout << graph->order()<< " - " << graph->size() << endl;
	Graph g = convert(*graph, UNIFORM, 1);

	//Generate target
	int n = num_vertices(g);
	int len = 10;
	int numRW = 4*num_vertices(g);
	int round = 1000;
	int maxNumA = 10;
	int k = 3;
	int N = 1000;
	int lowerSize = 200;
	vector<double> ini;
	int percent = 5;
	vector<Vertex> top;
	vector<Node> nodes;
	nodes.reserve(n);
	FOR (u, n) {
		Vertex v = vertex(u, g);
		top.push_back(v);
		Node newNode = {u, icmExpectedInfluence(g, top, round) };
		nodes.push_back(newNode);
		top.pop_back();
	}
	sort(nodes.begin(), nodes.end(), comp);
	FILE *fo;
	char outName[200];
	//char outNameStat[100];
	sprintf(outName, "EffectorOptDistance_%d_%d_%d_%d_%d_%d_%d.txt", num_vertices(g), num_edges(g), round, k, maxNumA, lowerSize, percent);
	fo = fopen(outName, "w");
	fprintf(fo, "#%d vertices %d edges \n", num_vertices(g), num_edges(g));
	fprintf(fo, "#Effector node k = %d len = %d round = %d N = %d lowerSize = %d numA = %d percent = %d\n", k, len, round, N, lowerSize, maxNumA, percent);
	fprintf(fo, "#k || Detected || Time \n");
	for (int numA=1; numA <= maxNumA; numA += 1) {
		Sleep(1000);
		srand(time(NULL));

		double detected = 0;
		int count = 1;

		while(count< N+1){
			vector<Vertex> seeds, target;
			vector<int> selectedIndex = rand_comb(numA, n/2);
			FOR (i, numA) {
				seeds.push_back(vertex(nodes[selectedIndex[i]].id, g));
			}
			//cout<< "here";
			target = generateTarget(g, seeds);

			//if (target.size() < lowerSize ) continue;
			count++;
			if (count % 100 == 0) cout<< count << endl;
			vector<Vertex>  suspect = effectorOptimalDistance(g, numA, target, target, round);

			FOR (q, numA) {
				int j = 0;
				for (j = 0; j<numA; j++) {
					if (g[seeds[q]].index == g[suspect[j]].index)  {
						detected++;
						break;
					}
				}
			}
		}

		fprintf(fo, "%d\t%f\n", numA, detected/count);
		fflush(fo);
	}
	fclose(fo);
	delete graph;
}

void optimalTestSort(string file, string dataName) {
	AdjGraph *graph = new AdjGraph(file.c_str(), false);
	cout << graph->order()<< " - " << graph->size() << endl;
	Graph g = convert(*graph, UNIFORM, 1);

	//Generate target
	int n = num_vertices(g);
	int len = 10;
	int numRW = 4*num_vertices(g);
	int round = 1000;
	int maxNumA = 10;
	int k = 3;
	int N = 1000;
	int lowerSize = 200;
	vector<double> ini;
	int percent = 5;
	vector<Vertex> top;
	vector<Node> nodes;
	nodes.reserve(n);
	FOR (u, n) {
		Vertex v = vertex(u, g);
		top.push_back(v);
		Node newNode = {u, icmExpectedInfluence(g, top, round) };
		nodes.push_back(newNode);
		top.pop_back();
	}
	sort(nodes.begin(), nodes.end(), comp);
	FILE *fo;
	char outName[200];
	//char outNameStat[100];
	sprintf(outName, "EffectorSort_%d_%d_%d_%d_%d_%d_%d.txt", num_vertices(g), num_edges(g), round, k, maxNumA, lowerSize, percent);
	fo = fopen(outName, "w");
	fprintf(fo, "#%d vertices %d edges \n", num_vertices(g), num_edges(g));
	fprintf(fo, "#Effector node k = %d len = %d round = %d N = %d lowerSize = %d numA = %d percent = %d\n", k, len, round, N, lowerSize, maxNumA, percent);
	fprintf(fo, "#k || Min distance | Max expected | Max Product \n");
	for (int numA=1; numA <= maxNumA; numA += 1) {
		Sleep(1000);
		srand(time(NULL));

		double detected1 = 0;
		double detected2 = 0;
		double detected3 = 0;
		int count = 1;

		while(count< N+1){
			vector<Vertex> seeds, target;
			vector<int> selectedIndex = rand_comb(numA, n/2);
			FOR (i, numA) {
				seeds.push_back(vertex(nodes[selectedIndex[i]].id, g));
			}
			//cout<< "here";
			target = generateTarget(g, seeds);

			//if (target.size() < lowerSize ) continue;
			count++;
			if (count % 100 == 0) cout<< count << endl;
			vector<Vertex>  suspect1 = effectorTopkGreedySort(g, numA, target, len, round);
			vector<Vertex>  suspect2 = effectorMaxExpectedSort (g, numA, target, target, round);
			vector<Vertex>  suspect3 = effectorMaxProductSort (g, numA, target, target, round, 0.05, 0.05);
			FOR (q, numA) {
				int j = 0;
				for (j = 0; j<numA; j++) {
					if (g[seeds[q]].index == g[suspect1[j]].index)  {
						detected1++;
						break;
					}
				}
				for (j = 0; j<numA; j++) {
					if (g[seeds[q]].index == g[suspect2[j]].index)  {
						detected2++;
						break;
					}
				}
				for (j = 0; j<numA; j++) {
					if (g[seeds[q]].index == g[suspect3[j]].index)  {
						detected3++;
						break;
					}
				}
			}
		}

		fprintf(fo, "%d\t%f\t%f\t%f\n", numA, detected1/count, detected2/count, detected3/count);
		fflush(fo);
	}
	fclose(fo);
	delete graph;
}
