/*
 * Effector.h
 *
 *  Created on: Jul 28, 2011
 *      Author: dung
 */
#include "AdjGraph.h"
#include "common.h"
#include "Measure.h"
#include "BoostGraph.h"
#ifndef EFFECTOR_H_
#define EFFECTOR_H_
vector<Vertex> generateTarget(Graph& g, vector<Vertex> seeds);
vector<Vertex> effectorTopkImeter(Graph& g,  int k, vector<Vertex> target, int len, int round);
vector<Vertex> effectorTopkFusedWalk(Graph& g,  int k, vector<Vertex> target, int len, int round);
vector<Vertex> effectorTopkGreedySort(Graph& g,  int k, vector<Vertex> target, int len, int round);
vector<Vertex> effectorTopLazyGreedy(Graph& g, int k, vector<Vertex> source, vector<Vertex> target, int round);

vector<Vertex> effectorOptimalDistance(Graph& g, int k, vector<Vertex> source, vector<Vertex> target, int round);
vector<Vertex> effectorOptimalGreedy(Graph& g, int k, vector<Vertex> source, vector<Vertex> target, int round);
vector<Vertex> effectorMaxExpectedSort(Graph& g, int k, vector<Vertex> source, vector<Vertex> target, int round);
vector<Vertex> effectorMaxProductSort(Graph& g, int k, vector<Vertex> source, vector<Vertex> target, int round, double inside_threshold, double outside_threshold);
#endif /* EFFECTOR_H_ */
