/*
 * BoostGraph.h
 *
 *  Created on: Jul 17, 2011
 *      Author: dung
 */

#include <boost/graph/adjacency_list.hpp>
#include <boost/graph/topological_sort.hpp>
#include <boost/graph/graph_traits.hpp>
#include <string>
#include "AdjGraph.h"
#include <vector>
#include "common.h"
#include <queue>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

using namespace boost;
using namespace std;

#ifndef BOOSTGRAPH_H_
#define BOOSTGRAPH_H_

#define UNIFORM 0
#define RANDOM 1

struct vertex_type {
	int index;
	int name;
	double in_total;
};

struct edge_type {
	float weight;
};

typedef property<edge_weight_t, float> EdgeProperty;
typedef adjacency_list<vecS, vecS, bidirectionalS, vertex_type, edge_type> Graph;
typedef graph_traits<Graph>::vertex_descriptor Vertex;
typedef graph_traits<Graph>::edge_descriptor Edge;
typedef graph_traits<Graph>::out_edge_iterator out_edge_iterator;
typedef graph_traits<Graph>::in_edge_iterator in_edge_iterator;
typedef graph_traits<Graph>::vertex_iterator vertex_iterator;

Graph convert(AdjGraph& adjG, int type, double maxPro);
#endif /* BOOSTGRAPH_H_ */
